'use strict';

var obsidian = require('obsidian');
var view = require('@codemirror/view');
var language = require('@codemirror/language');

function _mergeNamespaces(n, m) {
	m.forEach(function (e) {
		e && typeof e !== 'string' && !Array.isArray(e) && Object.keys(e).forEach(function (k) {
			if (k !== 'default' && !(k in n)) {
				var d = Object.getOwnPropertyDescriptor(e, k);
				Object.defineProperty(n, k, d.get ? d : {
					enumerable: true,
					get: function () { return e[k]; }
				});
			}
		});
	});
	return Object.freeze(n);
}

var commonjsGlobal = typeof globalThis !== 'undefined' ? globalThis : typeof window !== 'undefined' ? window : typeof global !== 'undefined' ? global : typeof self !== 'undefined' ? self : {};

function commonjsRequire (path) {
	throw new Error('Could not dynamically require "' + path + '". Please configure the dynamicRequireTargets or/and ignoreDynamicRequires option of @rollup/plugin-commonjs appropriately for this require call to work.');
}

var luxon = {};

Object.defineProperty(luxon, '__esModule', { value: true });

function _defineProperties(target, props) {
  for (var i = 0; i < props.length; i++) {
    var descriptor = props[i];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor) descriptor.writable = true;
    Object.defineProperty(target, descriptor.key, descriptor);
  }
}

function _createClass(Constructor, protoProps, staticProps) {
  if (protoProps) _defineProperties(Constructor.prototype, protoProps);
  if (staticProps) _defineProperties(Constructor, staticProps);
  return Constructor;
}

function _extends() {
  _extends = Object.assign || function (target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i];

      for (var key in source) {
        if (Object.prototype.hasOwnProperty.call(source, key)) {
          target[key] = source[key];
        }
      }
    }

    return target;
  };

  return _extends.apply(this, arguments);
}

function _inheritsLoose(subClass, superClass) {
  subClass.prototype = Object.create(superClass.prototype);
  subClass.prototype.constructor = subClass;

  _setPrototypeOf(subClass, superClass);
}

function _getPrototypeOf(o) {
  _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
    return o.__proto__ || Object.getPrototypeOf(o);
  };
  return _getPrototypeOf(o);
}

function _setPrototypeOf(o, p) {
  _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
    o.__proto__ = p;
    return o;
  };

  return _setPrototypeOf(o, p);
}

function _isNativeReflectConstruct() {
  if (typeof Reflect === "undefined" || !Reflect.construct) return false;
  if (Reflect.construct.sham) return false;
  if (typeof Proxy === "function") return true;

  try {
    Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {}));
    return true;
  } catch (e) {
    return false;
  }
}

function _construct(Parent, args, Class) {
  if (_isNativeReflectConstruct()) {
    _construct = Reflect.construct;
  } else {
    _construct = function _construct(Parent, args, Class) {
      var a = [null];
      a.push.apply(a, args);
      var Constructor = Function.bind.apply(Parent, a);
      var instance = new Constructor();
      if (Class) _setPrototypeOf(instance, Class.prototype);
      return instance;
    };
  }

  return _construct.apply(null, arguments);
}

function _isNativeFunction(fn) {
  return Function.toString.call(fn).indexOf("[native code]") !== -1;
}

function _wrapNativeSuper(Class) {
  var _cache = typeof Map === "function" ? new Map() : undefined;

  _wrapNativeSuper = function _wrapNativeSuper(Class) {
    if (Class === null || !_isNativeFunction(Class)) return Class;

    if (typeof Class !== "function") {
      throw new TypeError("Super expression must either be null or a function");
    }

    if (typeof _cache !== "undefined") {
      if (_cache.has(Class)) return _cache.get(Class);

      _cache.set(Class, Wrapper);
    }

    function Wrapper() {
      return _construct(Class, arguments, _getPrototypeOf(this).constructor);
    }

    Wrapper.prototype = Object.create(Class.prototype, {
      constructor: {
        value: Wrapper,
        enumerable: false,
        writable: true,
        configurable: true
      }
    });
    return _setPrototypeOf(Wrapper, Class);
  };

  return _wrapNativeSuper(Class);
}

function _objectWithoutPropertiesLoose(source, excluded) {
  if (source == null) return {};
  var target = {};
  var sourceKeys = Object.keys(source);
  var key, i;

  for (i = 0; i < sourceKeys.length; i++) {
    key = sourceKeys[i];
    if (excluded.indexOf(key) >= 0) continue;
    target[key] = source[key];
  }

  return target;
}

function _unsupportedIterableToArray(o, minLen) {
  if (!o) return;
  if (typeof o === "string") return _arrayLikeToArray(o, minLen);
  var n = Object.prototype.toString.call(o).slice(8, -1);
  if (n === "Object" && o.constructor) n = o.constructor.name;
  if (n === "Map" || n === "Set") return Array.from(o);
  if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen);
}

function _arrayLikeToArray(arr, len) {
  if (len == null || len > arr.length) len = arr.length;

  for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i];

  return arr2;
}

function _createForOfIteratorHelperLoose(o, allowArrayLike) {
  var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"];
  if (it) return (it = it.call(o)).next.bind(it);

  if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") {
    if (it) o = it;
    var i = 0;
    return function () {
      if (i >= o.length) return {
        done: true
      };
      return {
        done: false,
        value: o[i++]
      };
    };
  }

  throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
}

// these aren't really private, but nor are they really useful to document

/**
 * @private
 */
var LuxonError = /*#__PURE__*/function (_Error) {
  _inheritsLoose(LuxonError, _Error);

  function LuxonError() {
    return _Error.apply(this, arguments) || this;
  }

  return LuxonError;
}( /*#__PURE__*/_wrapNativeSuper(Error));
/**
 * @private
 */


var InvalidDateTimeError = /*#__PURE__*/function (_LuxonError) {
  _inheritsLoose(InvalidDateTimeError, _LuxonError);

  function InvalidDateTimeError(reason) {
    return _LuxonError.call(this, "Invalid DateTime: " + reason.toMessage()) || this;
  }

  return InvalidDateTimeError;
}(LuxonError);
/**
 * @private
 */

var InvalidIntervalError = /*#__PURE__*/function (_LuxonError2) {
  _inheritsLoose(InvalidIntervalError, _LuxonError2);

  function InvalidIntervalError(reason) {
    return _LuxonError2.call(this, "Invalid Interval: " + reason.toMessage()) || this;
  }

  return InvalidIntervalError;
}(LuxonError);
/**
 * @private
 */

var InvalidDurationError = /*#__PURE__*/function (_LuxonError3) {
  _inheritsLoose(InvalidDurationError, _LuxonError3);

  function InvalidDurationError(reason) {
    return _LuxonError3.call(this, "Invalid Duration: " + reason.toMessage()) || this;
  }

  return InvalidDurationError;
}(LuxonError);
/**
 * @private
 */

var ConflictingSpecificationError = /*#__PURE__*/function (_LuxonError4) {
  _inheritsLoose(ConflictingSpecificationError, _LuxonError4);

  function ConflictingSpecificationError() {
    return _LuxonError4.apply(this, arguments) || this;
  }

  return ConflictingSpecificationError;
}(LuxonError);
/**
 * @private
 */

var InvalidUnitError = /*#__PURE__*/function (_LuxonError5) {
  _inheritsLoose(InvalidUnitError, _LuxonError5);

  function InvalidUnitError(unit) {
    return _LuxonError5.call(this, "Invalid unit " + unit) || this;
  }

  return InvalidUnitError;
}(LuxonError);
/**
 * @private
 */

var InvalidArgumentError = /*#__PURE__*/function (_LuxonError6) {
  _inheritsLoose(InvalidArgumentError, _LuxonError6);

  function InvalidArgumentError() {
    return _LuxonError6.apply(this, arguments) || this;
  }

  return InvalidArgumentError;
}(LuxonError);
/**
 * @private
 */

var ZoneIsAbstractError = /*#__PURE__*/function (_LuxonError7) {
  _inheritsLoose(ZoneIsAbstractError, _LuxonError7);

  function ZoneIsAbstractError() {
    return _LuxonError7.call(this, "Zone is an abstract class") || this;
  }

  return ZoneIsAbstractError;
}(LuxonError);

/**
 * @private
 */
var n$1 = "numeric",
    s$2 = "short",
    l$2 = "long";
var DATE_SHORT = {
  year: n$1,
  month: n$1,
  day: n$1
};
var DATE_MED = {
  year: n$1,
  month: s$2,
  day: n$1
};
var DATE_MED_WITH_WEEKDAY = {
  year: n$1,
  month: s$2,
  day: n$1,
  weekday: s$2
};
var DATE_FULL = {
  year: n$1,
  month: l$2,
  day: n$1
};
var DATE_HUGE = {
  year: n$1,
  month: l$2,
  day: n$1,
  weekday: l$2
};
var TIME_SIMPLE = {
  hour: n$1,
  minute: n$1
};
var TIME_WITH_SECONDS = {
  hour: n$1,
  minute: n$1,
  second: n$1
};
var TIME_WITH_SHORT_OFFSET = {
  hour: n$1,
  minute: n$1,
  second: n$1,
  timeZoneName: s$2
};
var TIME_WITH_LONG_OFFSET = {
  hour: n$1,
  minute: n$1,
  second: n$1,
  timeZoneName: l$2
};
var TIME_24_SIMPLE = {
  hour: n$1,
  minute: n$1,
  hourCycle: "h23"
};
var TIME_24_WITH_SECONDS = {
  hour: n$1,
  minute: n$1,
  second: n$1,
  hourCycle: "h23"
};
var TIME_24_WITH_SHORT_OFFSET = {
  hour: n$1,
  minute: n$1,
  second: n$1,
  hourCycle: "h23",
  timeZoneName: s$2
};
var TIME_24_WITH_LONG_OFFSET = {
  hour: n$1,
  minute: n$1,
  second: n$1,
  hourCycle: "h23",
  timeZoneName: l$2
};
var DATETIME_SHORT = {
  year: n$1,
  month: n$1,
  day: n$1,
  hour: n$1,
  minute: n$1
};
var DATETIME_SHORT_WITH_SECONDS = {
  year: n$1,
  month: n$1,
  day: n$1,
  hour: n$1,
  minute: n$1,
  second: n$1
};
var DATETIME_MED = {
  year: n$1,
  month: s$2,
  day: n$1,
  hour: n$1,
  minute: n$1
};
var DATETIME_MED_WITH_SECONDS = {
  year: n$1,
  month: s$2,
  day: n$1,
  hour: n$1,
  minute: n$1,
  second: n$1
};
var DATETIME_MED_WITH_WEEKDAY = {
  year: n$1,
  month: s$2,
  day: n$1,
  weekday: s$2,
  hour: n$1,
  minute: n$1
};
var DATETIME_FULL = {
  year: n$1,
  month: l$2,
  day: n$1,
  hour: n$1,
  minute: n$1,
  timeZoneName: s$2
};
var DATETIME_FULL_WITH_SECONDS = {
  year: n$1,
  month: l$2,
  day: n$1,
  hour: n$1,
  minute: n$1,
  second: n$1,
  timeZoneName: s$2
};
var DATETIME_HUGE = {
  year: n$1,
  month: l$2,
  day: n$1,
  weekday: l$2,
  hour: n$1,
  minute: n$1,
  timeZoneName: l$2
};
var DATETIME_HUGE_WITH_SECONDS = {
  year: n$1,
  month: l$2,
  day: n$1,
  weekday: l$2,
  hour: n$1,
  minute: n$1,
  second: n$1,
  timeZoneName: l$2
};

/**
 * @private
 */
// TYPES

function isUndefined(o) {
  return typeof o === "undefined";
}
function isNumber(o) {
  return typeof o === "number";
}
function isInteger(o) {
  return typeof o === "number" && o % 1 === 0;
}
function isString(o) {
  return typeof o === "string";
}
function isDate(o) {
  return Object.prototype.toString.call(o) === "[object Date]";
} // CAPABILITIES

function hasRelative() {
  try {
    return typeof Intl !== "undefined" && !!Intl.RelativeTimeFormat;
  } catch (e) {
    return false;
  }
} // OBJECTS AND ARRAYS

function maybeArray(thing) {
  return Array.isArray(thing) ? thing : [thing];
}
function bestBy(arr, by, compare) {
  if (arr.length === 0) {
    return undefined;
  }

  return arr.reduce(function (best, next) {
    var pair = [by(next), next];

    if (!best) {
      return pair;
    } else if (compare(best[0], pair[0]) === best[0]) {
      return best;
    } else {
      return pair;
    }
  }, null)[1];
}
function pick(obj, keys) {
  return keys.reduce(function (a, k) {
    a[k] = obj[k];
    return a;
  }, {});
}
function hasOwnProperty(obj, prop) {
  return Object.prototype.hasOwnProperty.call(obj, prop);
} // NUMBERS AND STRINGS

function integerBetween(thing, bottom, top) {
  return isInteger(thing) && thing >= bottom && thing <= top;
} // x % n but takes the sign of n instead of x

function floorMod(x, n) {
  return x - n * Math.floor(x / n);
}
function padStart(input, n) {
  if (n === void 0) {
    n = 2;
  }

  var isNeg = input < 0;
  var padded;

  if (isNeg) {
    padded = "-" + ("" + -input).padStart(n, "0");
  } else {
    padded = ("" + input).padStart(n, "0");
  }

  return padded;
}
function parseInteger(string) {
  if (isUndefined(string) || string === null || string === "") {
    return undefined;
  } else {
    return parseInt(string, 10);
  }
}
function parseFloating(string) {
  if (isUndefined(string) || string === null || string === "") {
    return undefined;
  } else {
    return parseFloat(string);
  }
}
function parseMillis(fraction) {
  // Return undefined (instead of 0) in these cases, where fraction is not set
  if (isUndefined(fraction) || fraction === null || fraction === "") {
    return undefined;
  } else {
    var f = parseFloat("0." + fraction) * 1000;
    return Math.floor(f);
  }
}
function roundTo(number, digits, towardZero) {
  if (towardZero === void 0) {
    towardZero = false;
  }

  var factor = Math.pow(10, digits),
      rounder = towardZero ? Math.trunc : Math.round;
  return rounder(number * factor) / factor;
} // DATE BASICS

function isLeapYear(year) {
  return year % 4 === 0 && (year % 100 !== 0 || year % 400 === 0);
}
function daysInYear(year) {
  return isLeapYear(year) ? 366 : 365;
}
function daysInMonth(year, month) {
  var modMonth = floorMod(month - 1, 12) + 1,
      modYear = year + (month - modMonth) / 12;

  if (modMonth === 2) {
    return isLeapYear(modYear) ? 29 : 28;
  } else {
    return [31, null, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31][modMonth - 1];
  }
} // covert a calendar object to a local timestamp (epoch, but with the offset baked in)

function objToLocalTS(obj) {
  var d = Date.UTC(obj.year, obj.month - 1, obj.day, obj.hour, obj.minute, obj.second, obj.millisecond); // for legacy reasons, years between 0 and 99 are interpreted as 19XX; revert that

  if (obj.year < 100 && obj.year >= 0) {
    d = new Date(d);
    d.setUTCFullYear(d.getUTCFullYear() - 1900);
  }

  return +d;
}
function weeksInWeekYear(weekYear) {
  var p1 = (weekYear + Math.floor(weekYear / 4) - Math.floor(weekYear / 100) + Math.floor(weekYear / 400)) % 7,
      last = weekYear - 1,
      p2 = (last + Math.floor(last / 4) - Math.floor(last / 100) + Math.floor(last / 400)) % 7;
  return p1 === 4 || p2 === 3 ? 53 : 52;
}
function untruncateYear(year) {
  if (year > 99) {
    return year;
  } else return year > 60 ? 1900 + year : 2000 + year;
} // PARSING

function parseZoneInfo(ts, offsetFormat, locale, timeZone) {
  if (timeZone === void 0) {
    timeZone = null;
  }

  var date = new Date(ts),
      intlOpts = {
    hourCycle: "h23",
    year: "numeric",
    month: "2-digit",
    day: "2-digit",
    hour: "2-digit",
    minute: "2-digit"
  };

  if (timeZone) {
    intlOpts.timeZone = timeZone;
  }

  var modified = _extends({
    timeZoneName: offsetFormat
  }, intlOpts);

  var parsed = new Intl.DateTimeFormat(locale, modified).formatToParts(date).find(function (m) {
    return m.type.toLowerCase() === "timezonename";
  });
  return parsed ? parsed.value : null;
} // signedOffset('-5', '30') -> -330

function signedOffset(offHourStr, offMinuteStr) {
  var offHour = parseInt(offHourStr, 10); // don't || this because we want to preserve -0

  if (Number.isNaN(offHour)) {
    offHour = 0;
  }

  var offMin = parseInt(offMinuteStr, 10) || 0,
      offMinSigned = offHour < 0 || Object.is(offHour, -0) ? -offMin : offMin;
  return offHour * 60 + offMinSigned;
} // COERCION

function asNumber(value) {
  var numericValue = Number(value);
  if (typeof value === "boolean" || value === "" || Number.isNaN(numericValue)) throw new InvalidArgumentError("Invalid unit value " + value);
  return numericValue;
}
function normalizeObject(obj, normalizer) {
  var normalized = {};

  for (var u in obj) {
    if (hasOwnProperty(obj, u)) {
      var v = obj[u];
      if (v === undefined || v === null) continue;
      normalized[normalizer(u)] = asNumber(v);
    }
  }

  return normalized;
}
function formatOffset(offset, format) {
  var hours = Math.trunc(Math.abs(offset / 60)),
      minutes = Math.trunc(Math.abs(offset % 60)),
      sign = offset >= 0 ? "+" : "-";

  switch (format) {
    case "short":
      return "" + sign + padStart(hours, 2) + ":" + padStart(minutes, 2);

    case "narrow":
      return "" + sign + hours + (minutes > 0 ? ":" + minutes : "");

    case "techie":
      return "" + sign + padStart(hours, 2) + padStart(minutes, 2);

    default:
      throw new RangeError("Value format " + format + " is out of range for property format");
  }
}
function timeObject(obj) {
  return pick(obj, ["hour", "minute", "second", "millisecond"]);
}
var ianaRegex = /[A-Za-z_+-]{1,256}(?::?\/[A-Za-z0-9_+-]{1,256}(?:\/[A-Za-z0-9_+-]{1,256})?)?/;

/**
 * @private
 */


var monthsLong = ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"];
var monthsShort = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
var monthsNarrow = ["J", "F", "M", "A", "M", "J", "J", "A", "S", "O", "N", "D"];
function months(length) {
  switch (length) {
    case "narrow":
      return [].concat(monthsNarrow);

    case "short":
      return [].concat(monthsShort);

    case "long":
      return [].concat(monthsLong);

    case "numeric":
      return ["1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12"];

    case "2-digit":
      return ["01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12"];

    default:
      return null;
  }
}
var weekdaysLong = ["Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday"];
var weekdaysShort = ["Mon", "Tue", "Wed", "Thu", "Fri", "Sat", "Sun"];
var weekdaysNarrow = ["M", "T", "W", "T", "F", "S", "S"];
function weekdays(length) {
  switch (length) {
    case "narrow":
      return [].concat(weekdaysNarrow);

    case "short":
      return [].concat(weekdaysShort);

    case "long":
      return [].concat(weekdaysLong);

    case "numeric":
      return ["1", "2", "3", "4", "5", "6", "7"];

    default:
      return null;
  }
}
var meridiems = ["AM", "PM"];
var erasLong = ["Before Christ", "Anno Domini"];
var erasShort = ["BC", "AD"];
var erasNarrow = ["B", "A"];
function eras(length) {
  switch (length) {
    case "narrow":
      return [].concat(erasNarrow);

    case "short":
      return [].concat(erasShort);

    case "long":
      return [].concat(erasLong);

    default:
      return null;
  }
}
function meridiemForDateTime(dt) {
  return meridiems[dt.hour < 12 ? 0 : 1];
}
function weekdayForDateTime(dt, length) {
  return weekdays(length)[dt.weekday - 1];
}
function monthForDateTime(dt, length) {
  return months(length)[dt.month - 1];
}
function eraForDateTime(dt, length) {
  return eras(length)[dt.year < 0 ? 0 : 1];
}
function formatRelativeTime(unit, count, numeric, narrow) {
  if (numeric === void 0) {
    numeric = "always";
  }

  if (narrow === void 0) {
    narrow = false;
  }

  var units = {
    years: ["year", "yr."],
    quarters: ["quarter", "qtr."],
    months: ["month", "mo."],
    weeks: ["week", "wk."],
    days: ["day", "day", "days"],
    hours: ["hour", "hr."],
    minutes: ["minute", "min."],
    seconds: ["second", "sec."]
  };
  var lastable = ["hours", "minutes", "seconds"].indexOf(unit) === -1;

  if (numeric === "auto" && lastable) {
    var isDay = unit === "days";

    switch (count) {
      case 1:
        return isDay ? "tomorrow" : "next " + units[unit][0];

      case -1:
        return isDay ? "yesterday" : "last " + units[unit][0];

      case 0:
        return isDay ? "today" : "this " + units[unit][0];

    }
  }

  var isInPast = Object.is(count, -0) || count < 0,
      fmtValue = Math.abs(count),
      singular = fmtValue === 1,
      lilUnits = units[unit],
      fmtUnit = narrow ? singular ? lilUnits[1] : lilUnits[2] || lilUnits[1] : singular ? units[unit][0] : unit;
  return isInPast ? fmtValue + " " + fmtUnit + " ago" : "in " + fmtValue + " " + fmtUnit;
}

function stringifyTokens(splits, tokenToString) {
  var s = "";

  for (var _iterator = _createForOfIteratorHelperLoose(splits), _step; !(_step = _iterator()).done;) {
    var token = _step.value;

    if (token.literal) {
      s += token.val;
    } else {
      s += tokenToString(token.val);
    }
  }

  return s;
}

var _macroTokenToFormatOpts = {
  D: DATE_SHORT,
  DD: DATE_MED,
  DDD: DATE_FULL,
  DDDD: DATE_HUGE,
  t: TIME_SIMPLE,
  tt: TIME_WITH_SECONDS,
  ttt: TIME_WITH_SHORT_OFFSET,
  tttt: TIME_WITH_LONG_OFFSET,
  T: TIME_24_SIMPLE,
  TT: TIME_24_WITH_SECONDS,
  TTT: TIME_24_WITH_SHORT_OFFSET,
  TTTT: TIME_24_WITH_LONG_OFFSET,
  f: DATETIME_SHORT,
  ff: DATETIME_MED,
  fff: DATETIME_FULL,
  ffff: DATETIME_HUGE,
  F: DATETIME_SHORT_WITH_SECONDS,
  FF: DATETIME_MED_WITH_SECONDS,
  FFF: DATETIME_FULL_WITH_SECONDS,
  FFFF: DATETIME_HUGE_WITH_SECONDS
};
/**
 * @private
 */

var Formatter = /*#__PURE__*/function () {
  Formatter.create = function create(locale, opts) {
    if (opts === void 0) {
      opts = {};
    }

    return new Formatter(locale, opts);
  };

  Formatter.parseFormat = function parseFormat(fmt) {
    var current = null,
        currentFull = "",
        bracketed = false;
    var splits = [];

    for (var i = 0; i < fmt.length; i++) {
      var c = fmt.charAt(i);

      if (c === "'") {
        if (currentFull.length > 0) {
          splits.push({
            literal: bracketed,
            val: currentFull
          });
        }

        current = null;
        currentFull = "";
        bracketed = !bracketed;
      } else if (bracketed) {
        currentFull += c;
      } else if (c === current) {
        currentFull += c;
      } else {
        if (currentFull.length > 0) {
          splits.push({
            literal: false,
            val: currentFull
          });
        }

        currentFull = c;
        current = c;
      }
    }

    if (currentFull.length > 0) {
      splits.push({
        literal: bracketed,
        val: currentFull
      });
    }

    return splits;
  };

  Formatter.macroTokenToFormatOpts = function macroTokenToFormatOpts(token) {
    return _macroTokenToFormatOpts[token];
  };

  function Formatter(locale, formatOpts) {
    this.opts = formatOpts;
    this.loc = locale;
    this.systemLoc = null;
  }

  var _proto = Formatter.prototype;

  _proto.formatWithSystemDefault = function formatWithSystemDefault(dt, opts) {
    if (this.systemLoc === null) {
      this.systemLoc = this.loc.redefaultToSystem();
    }

    var df = this.systemLoc.dtFormatter(dt, _extends({}, this.opts, opts));
    return df.format();
  };

  _proto.formatDateTime = function formatDateTime(dt, opts) {
    if (opts === void 0) {
      opts = {};
    }

    var df = this.loc.dtFormatter(dt, _extends({}, this.opts, opts));
    return df.format();
  };

  _proto.formatDateTimeParts = function formatDateTimeParts(dt, opts) {
    if (opts === void 0) {
      opts = {};
    }

    var df = this.loc.dtFormatter(dt, _extends({}, this.opts, opts));
    return df.formatToParts();
  };

  _proto.resolvedOptions = function resolvedOptions(dt, opts) {
    if (opts === void 0) {
      opts = {};
    }

    var df = this.loc.dtFormatter(dt, _extends({}, this.opts, opts));
    return df.resolvedOptions();
  };

  _proto.num = function num(n, p) {
    if (p === void 0) {
      p = 0;
    }

    // we get some perf out of doing this here, annoyingly
    if (this.opts.forceSimple) {
      return padStart(n, p);
    }

    var opts = _extends({}, this.opts);

    if (p > 0) {
      opts.padTo = p;
    }

    return this.loc.numberFormatter(opts).format(n);
  };

  _proto.formatDateTimeFromString = function formatDateTimeFromString(dt, fmt) {
    var _this = this;

    var knownEnglish = this.loc.listingMode() === "en",
        useDateTimeFormatter = this.loc.outputCalendar && this.loc.outputCalendar !== "gregory",
        string = function string(opts, extract) {
      return _this.loc.extract(dt, opts, extract);
    },
        formatOffset = function formatOffset(opts) {
      if (dt.isOffsetFixed && dt.offset === 0 && opts.allowZ) {
        return "Z";
      }

      return dt.isValid ? dt.zone.formatOffset(dt.ts, opts.format) : "";
    },
        meridiem = function meridiem() {
      return knownEnglish ? meridiemForDateTime(dt) : string({
        hour: "numeric",
        hourCycle: "h12"
      }, "dayperiod");
    },
        month = function month(length, standalone) {
      return knownEnglish ? monthForDateTime(dt, length) : string(standalone ? {
        month: length
      } : {
        month: length,
        day: "numeric"
      }, "month");
    },
        weekday = function weekday(length, standalone) {
      return knownEnglish ? weekdayForDateTime(dt, length) : string(standalone ? {
        weekday: length
      } : {
        weekday: length,
        month: "long",
        day: "numeric"
      }, "weekday");
    },
        maybeMacro = function maybeMacro(token) {
      var formatOpts = Formatter.macroTokenToFormatOpts(token);

      if (formatOpts) {
        return _this.formatWithSystemDefault(dt, formatOpts);
      } else {
        return token;
      }
    },
        era = function era(length) {
      return knownEnglish ? eraForDateTime(dt, length) : string({
        era: length
      }, "era");
    },
        tokenToString = function tokenToString(token) {
      // Where possible: http://cldr.unicode.org/translation/date-time-1/date-time#TOC-Standalone-vs.-Format-Styles
      switch (token) {
        // ms
        case "S":
          return _this.num(dt.millisecond);

        case "u": // falls through

        case "SSS":
          return _this.num(dt.millisecond, 3);
        // seconds

        case "s":
          return _this.num(dt.second);

        case "ss":
          return _this.num(dt.second, 2);
        // fractional seconds

        case "uu":
          return _this.num(Math.floor(dt.millisecond / 10), 2);

        case "uuu":
          return _this.num(Math.floor(dt.millisecond / 100));
        // minutes

        case "m":
          return _this.num(dt.minute);

        case "mm":
          return _this.num(dt.minute, 2);
        // hours

        case "h":
          return _this.num(dt.hour % 12 === 0 ? 12 : dt.hour % 12);

        case "hh":
          return _this.num(dt.hour % 12 === 0 ? 12 : dt.hour % 12, 2);

        case "H":
          return _this.num(dt.hour);

        case "HH":
          return _this.num(dt.hour, 2);
        // offset

        case "Z":
          // like +6
          return formatOffset({
            format: "narrow",
            allowZ: _this.opts.allowZ
          });

        case "ZZ":
          // like +06:00
          return formatOffset({
            format: "short",
            allowZ: _this.opts.allowZ
          });

        case "ZZZ":
          // like +0600
          return formatOffset({
            format: "techie",
            allowZ: _this.opts.allowZ
          });

        case "ZZZZ":
          // like EST
          return dt.zone.offsetName(dt.ts, {
            format: "short",
            locale: _this.loc.locale
          });

        case "ZZZZZ":
          // like Eastern Standard Time
          return dt.zone.offsetName(dt.ts, {
            format: "long",
            locale: _this.loc.locale
          });
        // zone

        case "z":
          // like America/New_York
          return dt.zoneName;
        // meridiems

        case "a":
          return meridiem();
        // dates

        case "d":
          return useDateTimeFormatter ? string({
            day: "numeric"
          }, "day") : _this.num(dt.day);

        case "dd":
          return useDateTimeFormatter ? string({
            day: "2-digit"
          }, "day") : _this.num(dt.day, 2);
        // weekdays - standalone

        case "c":
          // like 1
          return _this.num(dt.weekday);

        case "ccc":
          // like 'Tues'
          return weekday("short", true);

        case "cccc":
          // like 'Tuesday'
          return weekday("long", true);

        case "ccccc":
          // like 'T'
          return weekday("narrow", true);
        // weekdays - format

        case "E":
          // like 1
          return _this.num(dt.weekday);

        case "EEE":
          // like 'Tues'
          return weekday("short", false);

        case "EEEE":
          // like 'Tuesday'
          return weekday("long", false);

        case "EEEEE":
          // like 'T'
          return weekday("narrow", false);
        // months - standalone

        case "L":
          // like 1
          return useDateTimeFormatter ? string({
            month: "numeric",
            day: "numeric"
          }, "month") : _this.num(dt.month);

        case "LL":
          // like 01, doesn't seem to work
          return useDateTimeFormatter ? string({
            month: "2-digit",
            day: "numeric"
          }, "month") : _this.num(dt.month, 2);

        case "LLL":
          // like Jan
          return month("short", true);

        case "LLLL":
          // like January
          return month("long", true);

        case "LLLLL":
          // like J
          return month("narrow", true);
        // months - format

        case "M":
          // like 1
          return useDateTimeFormatter ? string({
            month: "numeric"
          }, "month") : _this.num(dt.month);

        case "MM":
          // like 01
          return useDateTimeFormatter ? string({
            month: "2-digit"
          }, "month") : _this.num(dt.month, 2);

        case "MMM":
          // like Jan
          return month("short", false);

        case "MMMM":
          // like January
          return month("long", false);

        case "MMMMM":
          // like J
          return month("narrow", false);
        // years

        case "y":
          // like 2014
          return useDateTimeFormatter ? string({
            year: "numeric"
          }, "year") : _this.num(dt.year);

        case "yy":
          // like 14
          return useDateTimeFormatter ? string({
            year: "2-digit"
          }, "year") : _this.num(dt.year.toString().slice(-2), 2);

        case "yyyy":
          // like 0012
          return useDateTimeFormatter ? string({
            year: "numeric"
          }, "year") : _this.num(dt.year, 4);

        case "yyyyyy":
          // like 000012
          return useDateTimeFormatter ? string({
            year: "numeric"
          }, "year") : _this.num(dt.year, 6);
        // eras

        case "G":
          // like AD
          return era("short");

        case "GG":
          // like Anno Domini
          return era("long");

        case "GGGGG":
          return era("narrow");

        case "kk":
          return _this.num(dt.weekYear.toString().slice(-2), 2);

        case "kkkk":
          return _this.num(dt.weekYear, 4);

        case "W":
          return _this.num(dt.weekNumber);

        case "WW":
          return _this.num(dt.weekNumber, 2);

        case "o":
          return _this.num(dt.ordinal);

        case "ooo":
          return _this.num(dt.ordinal, 3);

        case "q":
          // like 1
          return _this.num(dt.quarter);

        case "qq":
          // like 01
          return _this.num(dt.quarter, 2);

        case "X":
          return _this.num(Math.floor(dt.ts / 1000));

        case "x":
          return _this.num(dt.ts);

        default:
          return maybeMacro(token);
      }
    };

    return stringifyTokens(Formatter.parseFormat(fmt), tokenToString);
  };

  _proto.formatDurationFromString = function formatDurationFromString(dur, fmt) {
    var _this2 = this;

    var tokenToField = function tokenToField(token) {
      switch (token[0]) {
        case "S":
          return "millisecond";

        case "s":
          return "second";

        case "m":
          return "minute";

        case "h":
          return "hour";

        case "d":
          return "day";

        case "w":
          return "week";

        case "M":
          return "month";

        case "y":
          return "year";

        default:
          return null;
      }
    },
        tokenToString = function tokenToString(lildur) {
      return function (token) {
        var mapped = tokenToField(token);

        if (mapped) {
          return _this2.num(lildur.get(mapped), token.length);
        } else {
          return token;
        }
      };
    },
        tokens = Formatter.parseFormat(fmt),
        realTokens = tokens.reduce(function (found, _ref) {
      var literal = _ref.literal,
          val = _ref.val;
      return literal ? found : found.concat(val);
    }, []),
        collapsed = dur.shiftTo.apply(dur, realTokens.map(tokenToField).filter(function (t) {
      return t;
    }));

    return stringifyTokens(tokens, tokenToString(collapsed));
  };

  return Formatter;
}();

var Invalid = /*#__PURE__*/function () {
  function Invalid(reason, explanation) {
    this.reason = reason;
    this.explanation = explanation;
  }

  var _proto = Invalid.prototype;

  _proto.toMessage = function toMessage() {
    if (this.explanation) {
      return this.reason + ": " + this.explanation;
    } else {
      return this.reason;
    }
  };

  return Invalid;
}();

/**
 * @interface
 */

var Zone = /*#__PURE__*/function () {
  function Zone() {}

  var _proto = Zone.prototype;

  /**
   * Returns the offset's common name (such as EST) at the specified timestamp
   * @abstract
   * @param {number} ts - Epoch milliseconds for which to get the name
   * @param {Object} opts - Options to affect the format
   * @param {string} opts.format - What style of offset to return. Accepts 'long' or 'short'.
   * @param {string} opts.locale - What locale to return the offset name in.
   * @return {string}
   */
  _proto.offsetName = function offsetName(ts, opts) {
    throw new ZoneIsAbstractError();
  }
  /**
   * Returns the offset's value as a string
   * @abstract
   * @param {number} ts - Epoch milliseconds for which to get the offset
   * @param {string} format - What style of offset to return.
   *                          Accepts 'narrow', 'short', or 'techie'. Returning '+6', '+06:00', or '+0600' respectively
   * @return {string}
   */
  ;

  _proto.formatOffset = function formatOffset(ts, format) {
    throw new ZoneIsAbstractError();
  }
  /**
   * Return the offset in minutes for this zone at the specified timestamp.
   * @abstract
   * @param {number} ts - Epoch milliseconds for which to compute the offset
   * @return {number}
   */
  ;

  _proto.offset = function offset(ts) {
    throw new ZoneIsAbstractError();
  }
  /**
   * Return whether this Zone is equal to another zone
   * @abstract
   * @param {Zone} otherZone - the zone to compare
   * @return {boolean}
   */
  ;

  _proto.equals = function equals(otherZone) {
    throw new ZoneIsAbstractError();
  }
  /**
   * Return whether this Zone is valid.
   * @abstract
   * @type {boolean}
   */
  ;

  _createClass(Zone, [{
    key: "type",
    get:
    /**
     * The type of zone
     * @abstract
     * @type {string}
     */
    function get() {
      throw new ZoneIsAbstractError();
    }
    /**
     * The name of this zone.
     * @abstract
     * @type {string}
     */

  }, {
    key: "name",
    get: function get() {
      throw new ZoneIsAbstractError();
    }
  }, {
    key: "ianaName",
    get: function get() {
      return this.name;
    }
    /**
     * Returns whether the offset is known to be fixed for the whole year.
     * @abstract
     * @type {boolean}
     */

  }, {
    key: "isUniversal",
    get: function get() {
      throw new ZoneIsAbstractError();
    }
  }, {
    key: "isValid",
    get: function get() {
      throw new ZoneIsAbstractError();
    }
  }]);

  return Zone;
}();

var singleton$1 = null;
/**
 * Represents the local zone for this JavaScript environment.
 * @implements {Zone}
 */

var SystemZone = /*#__PURE__*/function (_Zone) {
  _inheritsLoose(SystemZone, _Zone);

  function SystemZone() {
    return _Zone.apply(this, arguments) || this;
  }

  var _proto = SystemZone.prototype;

  /** @override **/
  _proto.offsetName = function offsetName(ts, _ref) {
    var format = _ref.format,
        locale = _ref.locale;
    return parseZoneInfo(ts, format, locale);
  }
  /** @override **/
  ;

  _proto.formatOffset = function formatOffset$1(ts, format) {
    return formatOffset(this.offset(ts), format);
  }
  /** @override **/
  ;

  _proto.offset = function offset(ts) {
    return -new Date(ts).getTimezoneOffset();
  }
  /** @override **/
  ;

  _proto.equals = function equals(otherZone) {
    return otherZone.type === "system";
  }
  /** @override **/
  ;

  _createClass(SystemZone, [{
    key: "type",
    get:
    /** @override **/
    function get() {
      return "system";
    }
    /** @override **/

  }, {
    key: "name",
    get: function get() {
      return new Intl.DateTimeFormat().resolvedOptions().timeZone;
    }
    /** @override **/

  }, {
    key: "isUniversal",
    get: function get() {
      return false;
    }
  }, {
    key: "isValid",
    get: function get() {
      return true;
    }
  }], [{
    key: "instance",
    get:
    /**
     * Get a singleton instance of the local zone
     * @return {SystemZone}
     */
    function get() {
      if (singleton$1 === null) {
        singleton$1 = new SystemZone();
      }

      return singleton$1;
    }
  }]);

  return SystemZone;
}(Zone);

var dtfCache = {};

function makeDTF(zone) {
  if (!dtfCache[zone]) {
    dtfCache[zone] = new Intl.DateTimeFormat("en-US", {
      hour12: false,
      timeZone: zone,
      year: "numeric",
      month: "2-digit",
      day: "2-digit",
      hour: "2-digit",
      minute: "2-digit",
      second: "2-digit",
      era: "short"
    });
  }

  return dtfCache[zone];
}

var typeToPos = {
  year: 0,
  month: 1,
  day: 2,
  era: 3,
  hour: 4,
  minute: 5,
  second: 6
};

function hackyOffset(dtf, date) {
  var formatted = dtf.format(date).replace(/\u200E/g, ""),
      parsed = /(\d+)\/(\d+)\/(\d+) (AD|BC),? (\d+):(\d+):(\d+)/.exec(formatted),
      fMonth = parsed[1],
      fDay = parsed[2],
      fYear = parsed[3],
      fadOrBc = parsed[4],
      fHour = parsed[5],
      fMinute = parsed[6],
      fSecond = parsed[7];
  return [fYear, fMonth, fDay, fadOrBc, fHour, fMinute, fSecond];
}

function partsOffset(dtf, date) {
  var formatted = dtf.formatToParts(date);
  var filled = [];

  for (var i = 0; i < formatted.length; i++) {
    var _formatted$i = formatted[i],
        type = _formatted$i.type,
        value = _formatted$i.value;
    var pos = typeToPos[type];

    if (type === "era") {
      filled[pos] = value;
    } else if (!isUndefined(pos)) {
      filled[pos] = parseInt(value, 10);
    }
  }

  return filled;
}

var ianaZoneCache = {};
/**
 * A zone identified by an IANA identifier, like America/New_York
 * @implements {Zone}
 */

var IANAZone = /*#__PURE__*/function (_Zone) {
  _inheritsLoose(IANAZone, _Zone);

  /**
   * @param {string} name - Zone name
   * @return {IANAZone}
   */
  IANAZone.create = function create(name) {
    if (!ianaZoneCache[name]) {
      ianaZoneCache[name] = new IANAZone(name);
    }

    return ianaZoneCache[name];
  }
  /**
   * Reset local caches. Should only be necessary in testing scenarios.
   * @return {void}
   */
  ;

  IANAZone.resetCache = function resetCache() {
    ianaZoneCache = {};
    dtfCache = {};
  }
  /**
   * Returns whether the provided string is a valid specifier. This only checks the string's format, not that the specifier identifies a known zone; see isValidZone for that.
   * @param {string} s - The string to check validity on
   * @example IANAZone.isValidSpecifier("America/New_York") //=> true
   * @example IANAZone.isValidSpecifier("Sport~~blorp") //=> false
   * @deprecated This method returns false for some valid IANA names. Use isValidZone instead.
   * @return {boolean}
   */
  ;

  IANAZone.isValidSpecifier = function isValidSpecifier(s) {
    return this.isValidZone(s);
  }
  /**
   * Returns whether the provided string identifies a real zone
   * @param {string} zone - The string to check
   * @example IANAZone.isValidZone("America/New_York") //=> true
   * @example IANAZone.isValidZone("Fantasia/Castle") //=> false
   * @example IANAZone.isValidZone("Sport~~blorp") //=> false
   * @return {boolean}
   */
  ;

  IANAZone.isValidZone = function isValidZone(zone) {
    if (!zone) {
      return false;
    }

    try {
      new Intl.DateTimeFormat("en-US", {
        timeZone: zone
      }).format();
      return true;
    } catch (e) {
      return false;
    }
  };

  function IANAZone(name) {
    var _this;

    _this = _Zone.call(this) || this;
    /** @private **/

    _this.zoneName = name;
    /** @private **/

    _this.valid = IANAZone.isValidZone(name);
    return _this;
  }
  /** @override **/


  var _proto = IANAZone.prototype;

  /** @override **/
  _proto.offsetName = function offsetName(ts, _ref) {
    var format = _ref.format,
        locale = _ref.locale;
    return parseZoneInfo(ts, format, locale, this.name);
  }
  /** @override **/
  ;

  _proto.formatOffset = function formatOffset$1(ts, format) {
    return formatOffset(this.offset(ts), format);
  }
  /** @override **/
  ;

  _proto.offset = function offset(ts) {
    var date = new Date(ts);
    if (isNaN(date)) return NaN;
    var dtf = makeDTF(this.name);

    var _ref2 = dtf.formatToParts ? partsOffset(dtf, date) : hackyOffset(dtf, date),
        year = _ref2[0],
        month = _ref2[1],
        day = _ref2[2],
        adOrBc = _ref2[3],
        hour = _ref2[4],
        minute = _ref2[5],
        second = _ref2[6];

    if (adOrBc === "BC") {
      year = -Math.abs(year) + 1;
    } // because we're using hour12 and https://bugs.chromium.org/p/chromium/issues/detail?id=1025564&can=2&q=%2224%3A00%22%20datetimeformat


    var adjustedHour = hour === 24 ? 0 : hour;
    var asUTC = objToLocalTS({
      year: year,
      month: month,
      day: day,
      hour: adjustedHour,
      minute: minute,
      second: second,
      millisecond: 0
    });
    var asTS = +date;
    var over = asTS % 1000;
    asTS -= over >= 0 ? over : 1000 + over;
    return (asUTC - asTS) / (60 * 1000);
  }
  /** @override **/
  ;

  _proto.equals = function equals(otherZone) {
    return otherZone.type === "iana" && otherZone.name === this.name;
  }
  /** @override **/
  ;

  _createClass(IANAZone, [{
    key: "type",
    get: function get() {
      return "iana";
    }
    /** @override **/

  }, {
    key: "name",
    get: function get() {
      return this.zoneName;
    }
    /** @override **/

  }, {
    key: "isUniversal",
    get: function get() {
      return false;
    }
  }, {
    key: "isValid",
    get: function get() {
      return this.valid;
    }
  }]);

  return IANAZone;
}(Zone);

var singleton = null;
/**
 * A zone with a fixed offset (meaning no DST)
 * @implements {Zone}
 */

var FixedOffsetZone = /*#__PURE__*/function (_Zone) {
  _inheritsLoose(FixedOffsetZone, _Zone);

  /**
   * Get an instance with a specified offset
   * @param {number} offset - The offset in minutes
   * @return {FixedOffsetZone}
   */
  FixedOffsetZone.instance = function instance(offset) {
    return offset === 0 ? FixedOffsetZone.utcInstance : new FixedOffsetZone(offset);
  }
  /**
   * Get an instance of FixedOffsetZone from a UTC offset string, like "UTC+6"
   * @param {string} s - The offset string to parse
   * @example FixedOffsetZone.parseSpecifier("UTC+6")
   * @example FixedOffsetZone.parseSpecifier("UTC+06")
   * @example FixedOffsetZone.parseSpecifier("UTC-6:00")
   * @return {FixedOffsetZone}
   */
  ;

  FixedOffsetZone.parseSpecifier = function parseSpecifier(s) {
    if (s) {
      var r = s.match(/^utc(?:([+-]\d{1,2})(?::(\d{2}))?)?$/i);

      if (r) {
        return new FixedOffsetZone(signedOffset(r[1], r[2]));
      }
    }

    return null;
  };

  function FixedOffsetZone(offset) {
    var _this;

    _this = _Zone.call(this) || this;
    /** @private **/

    _this.fixed = offset;
    return _this;
  }
  /** @override **/


  var _proto = FixedOffsetZone.prototype;

  /** @override **/
  _proto.offsetName = function offsetName() {
    return this.name;
  }
  /** @override **/
  ;

  _proto.formatOffset = function formatOffset$1(ts, format) {
    return formatOffset(this.fixed, format);
  }
  /** @override **/
  ;

  /** @override **/
  _proto.offset = function offset() {
    return this.fixed;
  }
  /** @override **/
  ;

  _proto.equals = function equals(otherZone) {
    return otherZone.type === "fixed" && otherZone.fixed === this.fixed;
  }
  /** @override **/
  ;

  _createClass(FixedOffsetZone, [{
    key: "type",
    get: function get() {
      return "fixed";
    }
    /** @override **/

  }, {
    key: "name",
    get: function get() {
      return this.fixed === 0 ? "UTC" : "UTC" + formatOffset(this.fixed, "narrow");
    }
  }, {
    key: "ianaName",
    get: function get() {
      if (this.fixed === 0) {
        return "Etc/UTC";
      } else {
        return "Etc/GMT" + formatOffset(-this.fixed, "narrow");
      }
    }
  }, {
    key: "isUniversal",
    get: function get() {
      return true;
    }
  }, {
    key: "isValid",
    get: function get() {
      return true;
    }
  }], [{
    key: "utcInstance",
    get:
    /**
     * Get a singleton instance of UTC
     * @return {FixedOffsetZone}
     */
    function get() {
      if (singleton === null) {
        singleton = new FixedOffsetZone(0);
      }

      return singleton;
    }
  }]);

  return FixedOffsetZone;
}(Zone);

/**
 * A zone that failed to parse. You should never need to instantiate this.
 * @implements {Zone}
 */

var InvalidZone = /*#__PURE__*/function (_Zone) {
  _inheritsLoose(InvalidZone, _Zone);

  function InvalidZone(zoneName) {
    var _this;

    _this = _Zone.call(this) || this;
    /**  @private */

    _this.zoneName = zoneName;
    return _this;
  }
  /** @override **/


  var _proto = InvalidZone.prototype;

  /** @override **/
  _proto.offsetName = function offsetName() {
    return null;
  }
  /** @override **/
  ;

  _proto.formatOffset = function formatOffset() {
    return "";
  }
  /** @override **/
  ;

  _proto.offset = function offset() {
    return NaN;
  }
  /** @override **/
  ;

  _proto.equals = function equals() {
    return false;
  }
  /** @override **/
  ;

  _createClass(InvalidZone, [{
    key: "type",
    get: function get() {
      return "invalid";
    }
    /** @override **/

  }, {
    key: "name",
    get: function get() {
      return this.zoneName;
    }
    /** @override **/

  }, {
    key: "isUniversal",
    get: function get() {
      return false;
    }
  }, {
    key: "isValid",
    get: function get() {
      return false;
    }
  }]);

  return InvalidZone;
}(Zone);

/**
 * @private
 */
function normalizeZone(input, defaultZone) {

  if (isUndefined(input) || input === null) {
    return defaultZone;
  } else if (input instanceof Zone) {
    return input;
  } else if (isString(input)) {
    var lowered = input.toLowerCase();
    if (lowered === "local" || lowered === "system") return defaultZone;else if (lowered === "utc" || lowered === "gmt") return FixedOffsetZone.utcInstance;else return FixedOffsetZone.parseSpecifier(lowered) || IANAZone.create(input);
  } else if (isNumber(input)) {
    return FixedOffsetZone.instance(input);
  } else if (typeof input === "object" && input.offset && typeof input.offset === "number") {
    // This is dumb, but the instanceof check above doesn't seem to really work
    // so we're duck checking it
    return input;
  } else {
    return new InvalidZone(input);
  }
}

var now = function now() {
  return Date.now();
},
    defaultZone = "system",
    defaultLocale = null,
    defaultNumberingSystem = null,
    defaultOutputCalendar = null,
    throwOnInvalid;
/**
 * Settings contains static getters and setters that control Luxon's overall behavior. Luxon is a simple library with few options, but the ones it does have live here.
 */


var Settings = /*#__PURE__*/function () {
  function Settings() {}

  /**
   * Reset Luxon's global caches. Should only be necessary in testing scenarios.
   * @return {void}
   */
  Settings.resetCaches = function resetCaches() {
    Locale.resetCache();
    IANAZone.resetCache();
  };

  _createClass(Settings, null, [{
    key: "now",
    get:
    /**
     * Get the callback for returning the current timestamp.
     * @type {function}
     */
    function get() {
      return now;
    }
    /**
     * Set the callback for returning the current timestamp.
     * The function should return a number, which will be interpreted as an Epoch millisecond count
     * @type {function}
     * @example Settings.now = () => Date.now() + 3000 // pretend it is 3 seconds in the future
     * @example Settings.now = () => 0 // always pretend it's Jan 1, 1970 at midnight in UTC time
     */
    ,
    set: function set(n) {
      now = n;
    }
    /**
     * Set the default time zone to create DateTimes in. Does not affect existing instances.
     * Use the value "system" to reset this value to the system's time zone.
     * @type {string}
     */

  }, {
    key: "defaultZone",
    get:
    /**
     * Get the default time zone object currently used to create DateTimes. Does not affect existing instances.
     * The default value is the system's time zone (the one set on the machine that runs this code).
     * @type {Zone}
     */
    function get() {
      return normalizeZone(defaultZone, SystemZone.instance);
    }
    /**
     * Get the default locale to create DateTimes with. Does not affect existing instances.
     * @type {string}
     */
    ,
    set: function set(zone) {
      defaultZone = zone;
    }
  }, {
    key: "defaultLocale",
    get: function get() {
      return defaultLocale;
    }
    /**
     * Set the default locale to create DateTimes with. Does not affect existing instances.
     * @type {string}
     */
    ,
    set: function set(locale) {
      defaultLocale = locale;
    }
    /**
     * Get the default numbering system to create DateTimes with. Does not affect existing instances.
     * @type {string}
     */

  }, {
    key: "defaultNumberingSystem",
    get: function get() {
      return defaultNumberingSystem;
    }
    /**
     * Set the default numbering system to create DateTimes with. Does not affect existing instances.
     * @type {string}
     */
    ,
    set: function set(numberingSystem) {
      defaultNumberingSystem = numberingSystem;
    }
    /**
     * Get the default output calendar to create DateTimes with. Does not affect existing instances.
     * @type {string}
     */

  }, {
    key: "defaultOutputCalendar",
    get: function get() {
      return defaultOutputCalendar;
    }
    /**
     * Set the default output calendar to create DateTimes with. Does not affect existing instances.
     * @type {string}
     */
    ,
    set: function set(outputCalendar) {
      defaultOutputCalendar = outputCalendar;
    }
    /**
     * Get whether Luxon will throw when it encounters invalid DateTimes, Durations, or Intervals
     * @type {boolean}
     */

  }, {
    key: "throwOnInvalid",
    get: function get() {
      return throwOnInvalid;
    }
    /**
     * Set whether Luxon will throw when it encounters invalid DateTimes, Durations, or Intervals
     * @type {boolean}
     */
    ,
    set: function set(t) {
      throwOnInvalid = t;
    }
  }]);

  return Settings;
}();

var _excluded = ["base"],
    _excluded2 = ["padTo", "floor"];

var intlLFCache = {};

function getCachedLF(locString, opts) {
  if (opts === void 0) {
    opts = {};
  }

  var key = JSON.stringify([locString, opts]);
  var dtf = intlLFCache[key];

  if (!dtf) {
    dtf = new Intl.ListFormat(locString, opts);
    intlLFCache[key] = dtf;
  }

  return dtf;
}

var intlDTCache = {};

function getCachedDTF(locString, opts) {
  if (opts === void 0) {
    opts = {};
  }

  var key = JSON.stringify([locString, opts]);
  var dtf = intlDTCache[key];

  if (!dtf) {
    dtf = new Intl.DateTimeFormat(locString, opts);
    intlDTCache[key] = dtf;
  }

  return dtf;
}

var intlNumCache = {};

function getCachedINF(locString, opts) {
  if (opts === void 0) {
    opts = {};
  }

  var key = JSON.stringify([locString, opts]);
  var inf = intlNumCache[key];

  if (!inf) {
    inf = new Intl.NumberFormat(locString, opts);
    intlNumCache[key] = inf;
  }

  return inf;
}

var intlRelCache = {};

function getCachedRTF(locString, opts) {
  if (opts === void 0) {
    opts = {};
  }

  var _opts = opts;
      _opts.base;
      var cacheKeyOpts = _objectWithoutPropertiesLoose(_opts, _excluded); // exclude `base` from the options


  var key = JSON.stringify([locString, cacheKeyOpts]);
  var inf = intlRelCache[key];

  if (!inf) {
    inf = new Intl.RelativeTimeFormat(locString, opts);
    intlRelCache[key] = inf;
  }

  return inf;
}

var sysLocaleCache = null;

function systemLocale() {
  if (sysLocaleCache) {
    return sysLocaleCache;
  } else {
    sysLocaleCache = new Intl.DateTimeFormat().resolvedOptions().locale;
    return sysLocaleCache;
  }
}

function parseLocaleString(localeStr) {
  // I really want to avoid writing a BCP 47 parser
  // see, e.g. https://github.com/wooorm/bcp-47
  // Instead, we'll do this:
  // a) if the string has no -u extensions, just leave it alone
  // b) if it does, use Intl to resolve everything
  // c) if Intl fails, try again without the -u
  var uIndex = localeStr.indexOf("-u-");

  if (uIndex === -1) {
    return [localeStr];
  } else {
    var options;
    var smaller = localeStr.substring(0, uIndex);

    try {
      options = getCachedDTF(localeStr).resolvedOptions();
    } catch (e) {
      options = getCachedDTF(smaller).resolvedOptions();
    }

    var _options = options,
        numberingSystem = _options.numberingSystem,
        calendar = _options.calendar; // return the smaller one so that we can append the calendar and numbering overrides to it

    return [smaller, numberingSystem, calendar];
  }
}

function intlConfigString(localeStr, numberingSystem, outputCalendar) {
  if (outputCalendar || numberingSystem) {
    localeStr += "-u";

    if (outputCalendar) {
      localeStr += "-ca-" + outputCalendar;
    }

    if (numberingSystem) {
      localeStr += "-nu-" + numberingSystem;
    }

    return localeStr;
  } else {
    return localeStr;
  }
}

function mapMonths(f) {
  var ms = [];

  for (var i = 1; i <= 12; i++) {
    var dt = DateTime.utc(2016, i, 1);
    ms.push(f(dt));
  }

  return ms;
}

function mapWeekdays(f) {
  var ms = [];

  for (var i = 1; i <= 7; i++) {
    var dt = DateTime.utc(2016, 11, 13 + i);
    ms.push(f(dt));
  }

  return ms;
}

function listStuff(loc, length, defaultOK, englishFn, intlFn) {
  var mode = loc.listingMode(defaultOK);

  if (mode === "error") {
    return null;
  } else if (mode === "en") {
    return englishFn(length);
  } else {
    return intlFn(length);
  }
}

function supportsFastNumbers(loc) {
  if (loc.numberingSystem && loc.numberingSystem !== "latn") {
    return false;
  } else {
    return loc.numberingSystem === "latn" || !loc.locale || loc.locale.startsWith("en") || new Intl.DateTimeFormat(loc.intl).resolvedOptions().numberingSystem === "latn";
  }
}
/**
 * @private
 */


var PolyNumberFormatter = /*#__PURE__*/function () {
  function PolyNumberFormatter(intl, forceSimple, opts) {
    this.padTo = opts.padTo || 0;
    this.floor = opts.floor || false;

    opts.padTo;
        opts.floor;
        var otherOpts = _objectWithoutPropertiesLoose(opts, _excluded2);

    if (!forceSimple || Object.keys(otherOpts).length > 0) {
      var intlOpts = _extends({
        useGrouping: false
      }, opts);

      if (opts.padTo > 0) intlOpts.minimumIntegerDigits = opts.padTo;
      this.inf = getCachedINF(intl, intlOpts);
    }
  }

  var _proto = PolyNumberFormatter.prototype;

  _proto.format = function format(i) {
    if (this.inf) {
      var fixed = this.floor ? Math.floor(i) : i;
      return this.inf.format(fixed);
    } else {
      // to match the browser's numberformatter defaults
      var _fixed = this.floor ? Math.floor(i) : roundTo(i, 3);

      return padStart(_fixed, this.padTo);
    }
  };

  return PolyNumberFormatter;
}();
/**
 * @private
 */


var PolyDateFormatter = /*#__PURE__*/function () {
  function PolyDateFormatter(dt, intl, opts) {
    this.opts = opts;
    var z;

    if (dt.zone.isUniversal) {
      // UTC-8 or Etc/UTC-8 are not part of tzdata, only Etc/GMT+8 and the like.
      // That is why fixed-offset TZ is set to that unless it is:
      // 1. Representing offset 0 when UTC is used to maintain previous behavior and does not become GMT.
      // 2. Unsupported by the browser:
      //    - some do not support Etc/
      //    - < Etc/GMT-14, > Etc/GMT+12, and 30-minute or 45-minute offsets are not part of tzdata
      var gmtOffset = -1 * (dt.offset / 60);
      var offsetZ = gmtOffset >= 0 ? "Etc/GMT+" + gmtOffset : "Etc/GMT" + gmtOffset;

      if (dt.offset !== 0 && IANAZone.create(offsetZ).valid) {
        z = offsetZ;
        this.dt = dt;
      } else {
        // Not all fixed-offset zones like Etc/+4:30 are present in tzdata.
        // So we have to make do. Two cases:
        // 1. The format options tell us to show the zone. We can't do that, so the best
        // we can do is format the date in UTC.
        // 2. The format options don't tell us to show the zone. Then we can adjust them
        // the time and tell the formatter to show it to us in UTC, so that the time is right
        // and the bad zone doesn't show up.
        z = "UTC";

        if (opts.timeZoneName) {
          this.dt = dt;
        } else {
          this.dt = dt.offset === 0 ? dt : DateTime.fromMillis(dt.ts + dt.offset * 60 * 1000);
        }
      }
    } else if (dt.zone.type === "system") {
      this.dt = dt;
    } else {
      this.dt = dt;
      z = dt.zone.name;
    }

    var intlOpts = _extends({}, this.opts);

    if (z) {
      intlOpts.timeZone = z;
    }

    this.dtf = getCachedDTF(intl, intlOpts);
  }

  var _proto2 = PolyDateFormatter.prototype;

  _proto2.format = function format() {
    return this.dtf.format(this.dt.toJSDate());
  };

  _proto2.formatToParts = function formatToParts() {
    return this.dtf.formatToParts(this.dt.toJSDate());
  };

  _proto2.resolvedOptions = function resolvedOptions() {
    return this.dtf.resolvedOptions();
  };

  return PolyDateFormatter;
}();
/**
 * @private
 */


var PolyRelFormatter = /*#__PURE__*/function () {
  function PolyRelFormatter(intl, isEnglish, opts) {
    this.opts = _extends({
      style: "long"
    }, opts);

    if (!isEnglish && hasRelative()) {
      this.rtf = getCachedRTF(intl, opts);
    }
  }

  var _proto3 = PolyRelFormatter.prototype;

  _proto3.format = function format(count, unit) {
    if (this.rtf) {
      return this.rtf.format(count, unit);
    } else {
      return formatRelativeTime(unit, count, this.opts.numeric, this.opts.style !== "long");
    }
  };

  _proto3.formatToParts = function formatToParts(count, unit) {
    if (this.rtf) {
      return this.rtf.formatToParts(count, unit);
    } else {
      return [];
    }
  };

  return PolyRelFormatter;
}();
/**
 * @private
 */


var Locale = /*#__PURE__*/function () {
  Locale.fromOpts = function fromOpts(opts) {
    return Locale.create(opts.locale, opts.numberingSystem, opts.outputCalendar, opts.defaultToEN);
  };

  Locale.create = function create(locale, numberingSystem, outputCalendar, defaultToEN) {
    if (defaultToEN === void 0) {
      defaultToEN = false;
    }

    var specifiedLocale = locale || Settings.defaultLocale; // the system locale is useful for human readable strings but annoying for parsing/formatting known formats

    var localeR = specifiedLocale || (defaultToEN ? "en-US" : systemLocale());
    var numberingSystemR = numberingSystem || Settings.defaultNumberingSystem;
    var outputCalendarR = outputCalendar || Settings.defaultOutputCalendar;
    return new Locale(localeR, numberingSystemR, outputCalendarR, specifiedLocale);
  };

  Locale.resetCache = function resetCache() {
    sysLocaleCache = null;
    intlDTCache = {};
    intlNumCache = {};
    intlRelCache = {};
  };

  Locale.fromObject = function fromObject(_temp) {
    var _ref = _temp === void 0 ? {} : _temp,
        locale = _ref.locale,
        numberingSystem = _ref.numberingSystem,
        outputCalendar = _ref.outputCalendar;

    return Locale.create(locale, numberingSystem, outputCalendar);
  };

  function Locale(locale, numbering, outputCalendar, specifiedLocale) {
    var _parseLocaleString = parseLocaleString(locale),
        parsedLocale = _parseLocaleString[0],
        parsedNumberingSystem = _parseLocaleString[1],
        parsedOutputCalendar = _parseLocaleString[2];

    this.locale = parsedLocale;
    this.numberingSystem = numbering || parsedNumberingSystem || null;
    this.outputCalendar = outputCalendar || parsedOutputCalendar || null;
    this.intl = intlConfigString(this.locale, this.numberingSystem, this.outputCalendar);
    this.weekdaysCache = {
      format: {},
      standalone: {}
    };
    this.monthsCache = {
      format: {},
      standalone: {}
    };
    this.meridiemCache = null;
    this.eraCache = {};
    this.specifiedLocale = specifiedLocale;
    this.fastNumbersCached = null;
  }

  var _proto4 = Locale.prototype;

  _proto4.listingMode = function listingMode() {
    var isActuallyEn = this.isEnglish();
    var hasNoWeirdness = (this.numberingSystem === null || this.numberingSystem === "latn") && (this.outputCalendar === null || this.outputCalendar === "gregory");
    return isActuallyEn && hasNoWeirdness ? "en" : "intl";
  };

  _proto4.clone = function clone(alts) {
    if (!alts || Object.getOwnPropertyNames(alts).length === 0) {
      return this;
    } else {
      return Locale.create(alts.locale || this.specifiedLocale, alts.numberingSystem || this.numberingSystem, alts.outputCalendar || this.outputCalendar, alts.defaultToEN || false);
    }
  };

  _proto4.redefaultToEN = function redefaultToEN(alts) {
    if (alts === void 0) {
      alts = {};
    }

    return this.clone(_extends({}, alts, {
      defaultToEN: true
    }));
  };

  _proto4.redefaultToSystem = function redefaultToSystem(alts) {
    if (alts === void 0) {
      alts = {};
    }

    return this.clone(_extends({}, alts, {
      defaultToEN: false
    }));
  };

  _proto4.months = function months$1(length, format, defaultOK) {
    var _this = this;

    if (format === void 0) {
      format = false;
    }

    if (defaultOK === void 0) {
      defaultOK = true;
    }

    return listStuff(this, length, defaultOK, months, function () {
      var intl = format ? {
        month: length,
        day: "numeric"
      } : {
        month: length
      },
          formatStr = format ? "format" : "standalone";

      if (!_this.monthsCache[formatStr][length]) {
        _this.monthsCache[formatStr][length] = mapMonths(function (dt) {
          return _this.extract(dt, intl, "month");
        });
      }

      return _this.monthsCache[formatStr][length];
    });
  };

  _proto4.weekdays = function weekdays$1(length, format, defaultOK) {
    var _this2 = this;

    if (format === void 0) {
      format = false;
    }

    if (defaultOK === void 0) {
      defaultOK = true;
    }

    return listStuff(this, length, defaultOK, weekdays, function () {
      var intl = format ? {
        weekday: length,
        year: "numeric",
        month: "long",
        day: "numeric"
      } : {
        weekday: length
      },
          formatStr = format ? "format" : "standalone";

      if (!_this2.weekdaysCache[formatStr][length]) {
        _this2.weekdaysCache[formatStr][length] = mapWeekdays(function (dt) {
          return _this2.extract(dt, intl, "weekday");
        });
      }

      return _this2.weekdaysCache[formatStr][length];
    });
  };

  _proto4.meridiems = function meridiems$1(defaultOK) {
    var _this3 = this;

    if (defaultOK === void 0) {
      defaultOK = true;
    }

    return listStuff(this, undefined, defaultOK, function () {
      return meridiems;
    }, function () {
      // In theory there could be aribitrary day periods. We're gonna assume there are exactly two
      // for AM and PM. This is probably wrong, but it's makes parsing way easier.
      if (!_this3.meridiemCache) {
        var intl = {
          hour: "numeric",
          hourCycle: "h12"
        };
        _this3.meridiemCache = [DateTime.utc(2016, 11, 13, 9), DateTime.utc(2016, 11, 13, 19)].map(function (dt) {
          return _this3.extract(dt, intl, "dayperiod");
        });
      }

      return _this3.meridiemCache;
    });
  };

  _proto4.eras = function eras$1(length, defaultOK) {
    var _this4 = this;

    if (defaultOK === void 0) {
      defaultOK = true;
    }

    return listStuff(this, length, defaultOK, eras, function () {
      var intl = {
        era: length
      }; // This is problematic. Different calendars are going to define eras totally differently. What I need is the minimum set of dates
      // to definitely enumerate them.

      if (!_this4.eraCache[length]) {
        _this4.eraCache[length] = [DateTime.utc(-40, 1, 1), DateTime.utc(2017, 1, 1)].map(function (dt) {
          return _this4.extract(dt, intl, "era");
        });
      }

      return _this4.eraCache[length];
    });
  };

  _proto4.extract = function extract(dt, intlOpts, field) {
    var df = this.dtFormatter(dt, intlOpts),
        results = df.formatToParts(),
        matching = results.find(function (m) {
      return m.type.toLowerCase() === field;
    });
    return matching ? matching.value : null;
  };

  _proto4.numberFormatter = function numberFormatter(opts) {
    if (opts === void 0) {
      opts = {};
    }

    // this forcesimple option is never used (the only caller short-circuits on it, but it seems safer to leave)
    // (in contrast, the rest of the condition is used heavily)
    return new PolyNumberFormatter(this.intl, opts.forceSimple || this.fastNumbers, opts);
  };

  _proto4.dtFormatter = function dtFormatter(dt, intlOpts) {
    if (intlOpts === void 0) {
      intlOpts = {};
    }

    return new PolyDateFormatter(dt, this.intl, intlOpts);
  };

  _proto4.relFormatter = function relFormatter(opts) {
    if (opts === void 0) {
      opts = {};
    }

    return new PolyRelFormatter(this.intl, this.isEnglish(), opts);
  };

  _proto4.listFormatter = function listFormatter(opts) {
    if (opts === void 0) {
      opts = {};
    }

    return getCachedLF(this.intl, opts);
  };

  _proto4.isEnglish = function isEnglish() {
    return this.locale === "en" || this.locale.toLowerCase() === "en-us" || new Intl.DateTimeFormat(this.intl).resolvedOptions().locale.startsWith("en-us");
  };

  _proto4.equals = function equals(other) {
    return this.locale === other.locale && this.numberingSystem === other.numberingSystem && this.outputCalendar === other.outputCalendar;
  };

  _createClass(Locale, [{
    key: "fastNumbers",
    get: function get() {
      if (this.fastNumbersCached == null) {
        this.fastNumbersCached = supportsFastNumbers(this);
      }

      return this.fastNumbersCached;
    }
  }]);

  return Locale;
}();

/*
 * This file handles parsing for well-specified formats. Here's how it works:
 * Two things go into parsing: a regex to match with and an extractor to take apart the groups in the match.
 * An extractor is just a function that takes a regex match array and returns a { year: ..., month: ... } object
 * parse() does the work of executing the regex and applying the extractor. It takes multiple regex/extractor pairs to try in sequence.
 * Extractors can take a "cursor" representing the offset in the match to look at. This makes it easy to combine extractors.
 * combineExtractors() does the work of combining them, keeping track of the cursor through multiple extractions.
 * Some extractions are super dumb and simpleParse and fromStrings help DRY them.
 */

function combineRegexes() {
  for (var _len = arguments.length, regexes = new Array(_len), _key = 0; _key < _len; _key++) {
    regexes[_key] = arguments[_key];
  }

  var full = regexes.reduce(function (f, r) {
    return f + r.source;
  }, "");
  return RegExp("^" + full + "$");
}

function combineExtractors() {
  for (var _len2 = arguments.length, extractors = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
    extractors[_key2] = arguments[_key2];
  }

  return function (m) {
    return extractors.reduce(function (_ref, ex) {
      var mergedVals = _ref[0],
          mergedZone = _ref[1],
          cursor = _ref[2];

      var _ex = ex(m, cursor),
          val = _ex[0],
          zone = _ex[1],
          next = _ex[2];

      return [_extends({}, mergedVals, val), zone || mergedZone, next];
    }, [{}, null, 1]).slice(0, 2);
  };
}

function parse(s) {
  if (s == null) {
    return [null, null];
  }

  for (var _len3 = arguments.length, patterns = new Array(_len3 > 1 ? _len3 - 1 : 0), _key3 = 1; _key3 < _len3; _key3++) {
    patterns[_key3 - 1] = arguments[_key3];
  }

  for (var _i = 0, _patterns = patterns; _i < _patterns.length; _i++) {
    var _patterns$_i = _patterns[_i],
        regex = _patterns$_i[0],
        extractor = _patterns$_i[1];
    var m = regex.exec(s);

    if (m) {
      return extractor(m);
    }
  }

  return [null, null];
}

function simpleParse() {
  for (var _len4 = arguments.length, keys = new Array(_len4), _key4 = 0; _key4 < _len4; _key4++) {
    keys[_key4] = arguments[_key4];
  }

  return function (match, cursor) {
    var ret = {};
    var i;

    for (i = 0; i < keys.length; i++) {
      ret[keys[i]] = parseInteger(match[cursor + i]);
    }

    return [ret, null, cursor + i];
  };
} // ISO and SQL parsing


var offsetRegex = /(?:(Z)|([+-]\d\d)(?::?(\d\d))?)/;
var isoExtendedZone = "(?:" + offsetRegex.source + "?(?:\\[(" + ianaRegex.source + ")\\])?)?";
var isoTimeBaseRegex = /(\d\d)(?::?(\d\d)(?::?(\d\d)(?:[.,](\d{1,30}))?)?)?/;
var isoTimeRegex = RegExp("" + isoTimeBaseRegex.source + isoExtendedZone);
var isoTimeExtensionRegex = RegExp("(?:T" + isoTimeRegex.source + ")?");
var isoYmdRegex = /([+-]\d{6}|\d{4})(?:-?(\d\d)(?:-?(\d\d))?)?/;
var isoWeekRegex = /(\d{4})-?W(\d\d)(?:-?(\d))?/;
var isoOrdinalRegex = /(\d{4})-?(\d{3})/;
var extractISOWeekData = simpleParse("weekYear", "weekNumber", "weekDay");
var extractISOOrdinalData = simpleParse("year", "ordinal");
var sqlYmdRegex = /(\d{4})-(\d\d)-(\d\d)/; // dumbed-down version of the ISO one

var sqlTimeRegex = RegExp(isoTimeBaseRegex.source + " ?(?:" + offsetRegex.source + "|(" + ianaRegex.source + "))?");
var sqlTimeExtensionRegex = RegExp("(?: " + sqlTimeRegex.source + ")?");

function int(match, pos, fallback) {
  var m = match[pos];
  return isUndefined(m) ? fallback : parseInteger(m);
}

function extractISOYmd(match, cursor) {
  var item = {
    year: int(match, cursor),
    month: int(match, cursor + 1, 1),
    day: int(match, cursor + 2, 1)
  };
  return [item, null, cursor + 3];
}

function extractISOTime(match, cursor) {
  var item = {
    hours: int(match, cursor, 0),
    minutes: int(match, cursor + 1, 0),
    seconds: int(match, cursor + 2, 0),
    milliseconds: parseMillis(match[cursor + 3])
  };
  return [item, null, cursor + 4];
}

function extractISOOffset(match, cursor) {
  var local = !match[cursor] && !match[cursor + 1],
      fullOffset = signedOffset(match[cursor + 1], match[cursor + 2]),
      zone = local ? null : FixedOffsetZone.instance(fullOffset);
  return [{}, zone, cursor + 3];
}

function extractIANAZone(match, cursor) {
  var zone = match[cursor] ? IANAZone.create(match[cursor]) : null;
  return [{}, zone, cursor + 1];
} // ISO time parsing


var isoTimeOnly = RegExp("^T?" + isoTimeBaseRegex.source + "$"); // ISO duration parsing

var isoDuration = /^-?P(?:(?:(-?\d{1,9}(?:\.\d{1,9})?)Y)?(?:(-?\d{1,9}(?:\.\d{1,9})?)M)?(?:(-?\d{1,9}(?:\.\d{1,9})?)W)?(?:(-?\d{1,9}(?:\.\d{1,9})?)D)?(?:T(?:(-?\d{1,9}(?:\.\d{1,9})?)H)?(?:(-?\d{1,9}(?:\.\d{1,9})?)M)?(?:(-?\d{1,20})(?:[.,](-?\d{1,9}))?S)?)?)$/;

function extractISODuration(match) {
  var s = match[0],
      yearStr = match[1],
      monthStr = match[2],
      weekStr = match[3],
      dayStr = match[4],
      hourStr = match[5],
      minuteStr = match[6],
      secondStr = match[7],
      millisecondsStr = match[8];
  var hasNegativePrefix = s[0] === "-";
  var negativeSeconds = secondStr && secondStr[0] === "-";

  var maybeNegate = function maybeNegate(num, force) {
    if (force === void 0) {
      force = false;
    }

    return num !== undefined && (force || num && hasNegativePrefix) ? -num : num;
  };

  return [{
    years: maybeNegate(parseFloating(yearStr)),
    months: maybeNegate(parseFloating(monthStr)),
    weeks: maybeNegate(parseFloating(weekStr)),
    days: maybeNegate(parseFloating(dayStr)),
    hours: maybeNegate(parseFloating(hourStr)),
    minutes: maybeNegate(parseFloating(minuteStr)),
    seconds: maybeNegate(parseFloating(secondStr), secondStr === "-0"),
    milliseconds: maybeNegate(parseMillis(millisecondsStr), negativeSeconds)
  }];
} // These are a little braindead. EDT *should* tell us that we're in, say, America/New_York
// and not just that we're in -240 *right now*. But since I don't think these are used that often
// I'm just going to ignore that


var obsOffsets = {
  GMT: 0,
  EDT: -4 * 60,
  EST: -5 * 60,
  CDT: -5 * 60,
  CST: -6 * 60,
  MDT: -6 * 60,
  MST: -7 * 60,
  PDT: -7 * 60,
  PST: -8 * 60
};

function fromStrings(weekdayStr, yearStr, monthStr, dayStr, hourStr, minuteStr, secondStr) {
  var result = {
    year: yearStr.length === 2 ? untruncateYear(parseInteger(yearStr)) : parseInteger(yearStr),
    month: monthsShort.indexOf(monthStr) + 1,
    day: parseInteger(dayStr),
    hour: parseInteger(hourStr),
    minute: parseInteger(minuteStr)
  };
  if (secondStr) result.second = parseInteger(secondStr);

  if (weekdayStr) {
    result.weekday = weekdayStr.length > 3 ? weekdaysLong.indexOf(weekdayStr) + 1 : weekdaysShort.indexOf(weekdayStr) + 1;
  }

  return result;
} // RFC 2822/5322


var rfc2822 = /^(?:(Mon|Tue|Wed|Thu|Fri|Sat|Sun),\s)?(\d{1,2})\s(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)\s(\d{2,4})\s(\d\d):(\d\d)(?::(\d\d))?\s(?:(UT|GMT|[ECMP][SD]T)|([Zz])|(?:([+-]\d\d)(\d\d)))$/;

function extractRFC2822(match) {
  var weekdayStr = match[1],
      dayStr = match[2],
      monthStr = match[3],
      yearStr = match[4],
      hourStr = match[5],
      minuteStr = match[6],
      secondStr = match[7],
      obsOffset = match[8],
      milOffset = match[9],
      offHourStr = match[10],
      offMinuteStr = match[11],
      result = fromStrings(weekdayStr, yearStr, monthStr, dayStr, hourStr, minuteStr, secondStr);
  var offset;

  if (obsOffset) {
    offset = obsOffsets[obsOffset];
  } else if (milOffset) {
    offset = 0;
  } else {
    offset = signedOffset(offHourStr, offMinuteStr);
  }

  return [result, new FixedOffsetZone(offset)];
}

function preprocessRFC2822(s) {
  // Remove comments and folding whitespace and replace multiple-spaces with a single space
  return s.replace(/\([^)]*\)|[\n\t]/g, " ").replace(/(\s\s+)/g, " ").trim();
} // http date


var rfc1123 = /^(Mon|Tue|Wed|Thu|Fri|Sat|Sun), (\d\d) (Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec) (\d{4}) (\d\d):(\d\d):(\d\d) GMT$/,
    rfc850 = /^(Monday|Tuesday|Wedsday|Thursday|Friday|Saturday|Sunday), (\d\d)-(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)-(\d\d) (\d\d):(\d\d):(\d\d) GMT$/,
    ascii = /^(Mon|Tue|Wed|Thu|Fri|Sat|Sun) (Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec) ( \d|\d\d) (\d\d):(\d\d):(\d\d) (\d{4})$/;

function extractRFC1123Or850(match) {
  var weekdayStr = match[1],
      dayStr = match[2],
      monthStr = match[3],
      yearStr = match[4],
      hourStr = match[5],
      minuteStr = match[6],
      secondStr = match[7],
      result = fromStrings(weekdayStr, yearStr, monthStr, dayStr, hourStr, minuteStr, secondStr);
  return [result, FixedOffsetZone.utcInstance];
}

function extractASCII(match) {
  var weekdayStr = match[1],
      monthStr = match[2],
      dayStr = match[3],
      hourStr = match[4],
      minuteStr = match[5],
      secondStr = match[6],
      yearStr = match[7],
      result = fromStrings(weekdayStr, yearStr, monthStr, dayStr, hourStr, minuteStr, secondStr);
  return [result, FixedOffsetZone.utcInstance];
}

var isoYmdWithTimeExtensionRegex = combineRegexes(isoYmdRegex, isoTimeExtensionRegex);
var isoWeekWithTimeExtensionRegex = combineRegexes(isoWeekRegex, isoTimeExtensionRegex);
var isoOrdinalWithTimeExtensionRegex = combineRegexes(isoOrdinalRegex, isoTimeExtensionRegex);
var isoTimeCombinedRegex = combineRegexes(isoTimeRegex);
var extractISOYmdTimeAndOffset = combineExtractors(extractISOYmd, extractISOTime, extractISOOffset, extractIANAZone);
var extractISOWeekTimeAndOffset = combineExtractors(extractISOWeekData, extractISOTime, extractISOOffset, extractIANAZone);
var extractISOOrdinalDateAndTime = combineExtractors(extractISOOrdinalData, extractISOTime, extractISOOffset, extractIANAZone);
var extractISOTimeAndOffset = combineExtractors(extractISOTime, extractISOOffset, extractIANAZone);
/*
 * @private
 */

function parseISODate(s) {
  return parse(s, [isoYmdWithTimeExtensionRegex, extractISOYmdTimeAndOffset], [isoWeekWithTimeExtensionRegex, extractISOWeekTimeAndOffset], [isoOrdinalWithTimeExtensionRegex, extractISOOrdinalDateAndTime], [isoTimeCombinedRegex, extractISOTimeAndOffset]);
}
function parseRFC2822Date(s) {
  return parse(preprocessRFC2822(s), [rfc2822, extractRFC2822]);
}
function parseHTTPDate(s) {
  return parse(s, [rfc1123, extractRFC1123Or850], [rfc850, extractRFC1123Or850], [ascii, extractASCII]);
}
function parseISODuration(s) {
  return parse(s, [isoDuration, extractISODuration]);
}
var extractISOTimeOnly = combineExtractors(extractISOTime);
function parseISOTimeOnly(s) {
  return parse(s, [isoTimeOnly, extractISOTimeOnly]);
}
var sqlYmdWithTimeExtensionRegex = combineRegexes(sqlYmdRegex, sqlTimeExtensionRegex);
var sqlTimeCombinedRegex = combineRegexes(sqlTimeRegex);
var extractISOTimeOffsetAndIANAZone = combineExtractors(extractISOTime, extractISOOffset, extractIANAZone);
function parseSQL(s) {
  return parse(s, [sqlYmdWithTimeExtensionRegex, extractISOYmdTimeAndOffset], [sqlTimeCombinedRegex, extractISOTimeOffsetAndIANAZone]);
}

var INVALID$2 = "Invalid Duration"; // unit conversion constants

var lowOrderMatrix = {
  weeks: {
    days: 7,
    hours: 7 * 24,
    minutes: 7 * 24 * 60,
    seconds: 7 * 24 * 60 * 60,
    milliseconds: 7 * 24 * 60 * 60 * 1000
  },
  days: {
    hours: 24,
    minutes: 24 * 60,
    seconds: 24 * 60 * 60,
    milliseconds: 24 * 60 * 60 * 1000
  },
  hours: {
    minutes: 60,
    seconds: 60 * 60,
    milliseconds: 60 * 60 * 1000
  },
  minutes: {
    seconds: 60,
    milliseconds: 60 * 1000
  },
  seconds: {
    milliseconds: 1000
  }
},
    casualMatrix = _extends({
  years: {
    quarters: 4,
    months: 12,
    weeks: 52,
    days: 365,
    hours: 365 * 24,
    minutes: 365 * 24 * 60,
    seconds: 365 * 24 * 60 * 60,
    milliseconds: 365 * 24 * 60 * 60 * 1000
  },
  quarters: {
    months: 3,
    weeks: 13,
    days: 91,
    hours: 91 * 24,
    minutes: 91 * 24 * 60,
    seconds: 91 * 24 * 60 * 60,
    milliseconds: 91 * 24 * 60 * 60 * 1000
  },
  months: {
    weeks: 4,
    days: 30,
    hours: 30 * 24,
    minutes: 30 * 24 * 60,
    seconds: 30 * 24 * 60 * 60,
    milliseconds: 30 * 24 * 60 * 60 * 1000
  }
}, lowOrderMatrix),
    daysInYearAccurate = 146097.0 / 400,
    daysInMonthAccurate = 146097.0 / 4800,
    accurateMatrix = _extends({
  years: {
    quarters: 4,
    months: 12,
    weeks: daysInYearAccurate / 7,
    days: daysInYearAccurate,
    hours: daysInYearAccurate * 24,
    minutes: daysInYearAccurate * 24 * 60,
    seconds: daysInYearAccurate * 24 * 60 * 60,
    milliseconds: daysInYearAccurate * 24 * 60 * 60 * 1000
  },
  quarters: {
    months: 3,
    weeks: daysInYearAccurate / 28,
    days: daysInYearAccurate / 4,
    hours: daysInYearAccurate * 24 / 4,
    minutes: daysInYearAccurate * 24 * 60 / 4,
    seconds: daysInYearAccurate * 24 * 60 * 60 / 4,
    milliseconds: daysInYearAccurate * 24 * 60 * 60 * 1000 / 4
  },
  months: {
    weeks: daysInMonthAccurate / 7,
    days: daysInMonthAccurate,
    hours: daysInMonthAccurate * 24,
    minutes: daysInMonthAccurate * 24 * 60,
    seconds: daysInMonthAccurate * 24 * 60 * 60,
    milliseconds: daysInMonthAccurate * 24 * 60 * 60 * 1000
  }
}, lowOrderMatrix); // units ordered by size

var orderedUnits$1 = ["years", "quarters", "months", "weeks", "days", "hours", "minutes", "seconds", "milliseconds"];
var reverseUnits = orderedUnits$1.slice(0).reverse(); // clone really means "create another instance just like this one, but with these changes"

function clone$1(dur, alts, clear) {
  if (clear === void 0) {
    clear = false;
  }

  // deep merge for vals
  var conf = {
    values: clear ? alts.values : _extends({}, dur.values, alts.values || {}),
    loc: dur.loc.clone(alts.loc),
    conversionAccuracy: alts.conversionAccuracy || dur.conversionAccuracy
  };
  return new Duration(conf);
}

function antiTrunc(n) {
  return n < 0 ? Math.floor(n) : Math.ceil(n);
} // NB: mutates parameters


function convert(matrix, fromMap, fromUnit, toMap, toUnit) {
  var conv = matrix[toUnit][fromUnit],
      raw = fromMap[fromUnit] / conv,
      sameSign = Math.sign(raw) === Math.sign(toMap[toUnit]),
      // ok, so this is wild, but see the matrix in the tests
  added = !sameSign && toMap[toUnit] !== 0 && Math.abs(raw) <= 1 ? antiTrunc(raw) : Math.trunc(raw);
  toMap[toUnit] += added;
  fromMap[fromUnit] -= added * conv;
} // NB: mutates parameters


function normalizeValues(matrix, vals) {
  reverseUnits.reduce(function (previous, current) {
    if (!isUndefined(vals[current])) {
      if (previous) {
        convert(matrix, vals, previous, vals, current);
      }

      return current;
    } else {
      return previous;
    }
  }, null);
}
/**
 * A Duration object represents a period of time, like "2 months" or "1 day, 1 hour". Conceptually, it's just a map of units to their quantities, accompanied by some additional configuration and methods for creating, parsing, interrogating, transforming, and formatting them. They can be used on their own or in conjunction with other Luxon types; for example, you can use {@link DateTime#plus} to add a Duration object to a DateTime, producing another DateTime.
 *
 * Here is a brief overview of commonly used methods and getters in Duration:
 *
 * * **Creation** To create a Duration, use {@link Duration#fromMillis}, {@link Duration#fromObject}, or {@link Duration#fromISO}.
 * * **Unit values** See the {@link Duration#years}, {@link Duration.months}, {@link Duration#weeks}, {@link Duration#days}, {@link Duration#hours}, {@link Duration#minutes}, {@link Duration#seconds}, {@link Duration#milliseconds} accessors.
 * * **Configuration** See  {@link Duration#locale} and {@link Duration#numberingSystem} accessors.
 * * **Transformation** To create new Durations out of old ones use {@link Duration#plus}, {@link Duration#minus}, {@link Duration#normalize}, {@link Duration#set}, {@link Duration#reconfigure}, {@link Duration#shiftTo}, and {@link Duration#negate}.
 * * **Output** To convert the Duration into other representations, see {@link Duration#as}, {@link Duration#toISO}, {@link Duration#toFormat}, and {@link Duration#toJSON}
 *
 * There's are more methods documented below. In addition, for more information on subtler topics like internationalization and validity, see the external documentation.
 */


var Duration = /*#__PURE__*/function () {
  /**
   * @private
   */
  function Duration(config) {
    var accurate = config.conversionAccuracy === "longterm" || false;
    /**
     * @access private
     */

    this.values = config.values;
    /**
     * @access private
     */

    this.loc = config.loc || Locale.create();
    /**
     * @access private
     */

    this.conversionAccuracy = accurate ? "longterm" : "casual";
    /**
     * @access private
     */

    this.invalid = config.invalid || null;
    /**
     * @access private
     */

    this.matrix = accurate ? accurateMatrix : casualMatrix;
    /**
     * @access private
     */

    this.isLuxonDuration = true;
  }
  /**
   * Create Duration from a number of milliseconds.
   * @param {number} count of milliseconds
   * @param {Object} opts - options for parsing
   * @param {string} [opts.locale='en-US'] - the locale to use
   * @param {string} opts.numberingSystem - the numbering system to use
   * @param {string} [opts.conversionAccuracy='casual'] - the conversion system to use
   * @return {Duration}
   */


  Duration.fromMillis = function fromMillis(count, opts) {
    return Duration.fromObject({
      milliseconds: count
    }, opts);
  }
  /**
   * Create a Duration from a JavaScript object with keys like 'years' and 'hours'.
   * If this object is empty then a zero milliseconds duration is returned.
   * @param {Object} obj - the object to create the DateTime from
   * @param {number} obj.years
   * @param {number} obj.quarters
   * @param {number} obj.months
   * @param {number} obj.weeks
   * @param {number} obj.days
   * @param {number} obj.hours
   * @param {number} obj.minutes
   * @param {number} obj.seconds
   * @param {number} obj.milliseconds
   * @param {Object} [opts=[]] - options for creating this Duration
   * @param {string} [opts.locale='en-US'] - the locale to use
   * @param {string} opts.numberingSystem - the numbering system to use
   * @param {string} [opts.conversionAccuracy='casual'] - the conversion system to use
   * @return {Duration}
   */
  ;

  Duration.fromObject = function fromObject(obj, opts) {
    if (opts === void 0) {
      opts = {};
    }

    if (obj == null || typeof obj !== "object") {
      throw new InvalidArgumentError("Duration.fromObject: argument expected to be an object, got " + (obj === null ? "null" : typeof obj));
    }

    return new Duration({
      values: normalizeObject(obj, Duration.normalizeUnit),
      loc: Locale.fromObject(opts),
      conversionAccuracy: opts.conversionAccuracy
    });
  }
  /**
   * Create a Duration from DurationLike.
   *
   * @param {Object | number | Duration} durationLike
   * One of:
   * - object with keys like 'years' and 'hours'.
   * - number representing milliseconds
   * - Duration instance
   * @return {Duration}
   */
  ;

  Duration.fromDurationLike = function fromDurationLike(durationLike) {
    if (isNumber(durationLike)) {
      return Duration.fromMillis(durationLike);
    } else if (Duration.isDuration(durationLike)) {
      return durationLike;
    } else if (typeof durationLike === "object") {
      return Duration.fromObject(durationLike);
    } else {
      throw new InvalidArgumentError("Unknown duration argument " + durationLike + " of type " + typeof durationLike);
    }
  }
  /**
   * Create a Duration from an ISO 8601 duration string.
   * @param {string} text - text to parse
   * @param {Object} opts - options for parsing
   * @param {string} [opts.locale='en-US'] - the locale to use
   * @param {string} opts.numberingSystem - the numbering system to use
   * @param {string} [opts.conversionAccuracy='casual'] - the conversion system to use
   * @see https://en.wikipedia.org/wiki/ISO_8601#Durations
   * @example Duration.fromISO('P3Y6M1W4DT12H30M5S').toObject() //=> { years: 3, months: 6, weeks: 1, days: 4, hours: 12, minutes: 30, seconds: 5 }
   * @example Duration.fromISO('PT23H').toObject() //=> { hours: 23 }
   * @example Duration.fromISO('P5Y3M').toObject() //=> { years: 5, months: 3 }
   * @return {Duration}
   */
  ;

  Duration.fromISO = function fromISO(text, opts) {
    var _parseISODuration = parseISODuration(text),
        parsed = _parseISODuration[0];

    if (parsed) {
      return Duration.fromObject(parsed, opts);
    } else {
      return Duration.invalid("unparsable", "the input \"" + text + "\" can't be parsed as ISO 8601");
    }
  }
  /**
   * Create a Duration from an ISO 8601 time string.
   * @param {string} text - text to parse
   * @param {Object} opts - options for parsing
   * @param {string} [opts.locale='en-US'] - the locale to use
   * @param {string} opts.numberingSystem - the numbering system to use
   * @param {string} [opts.conversionAccuracy='casual'] - the conversion system to use
   * @see https://en.wikipedia.org/wiki/ISO_8601#Times
   * @example Duration.fromISOTime('11:22:33.444').toObject() //=> { hours: 11, minutes: 22, seconds: 33, milliseconds: 444 }
   * @example Duration.fromISOTime('11:00').toObject() //=> { hours: 11, minutes: 0, seconds: 0 }
   * @example Duration.fromISOTime('T11:00').toObject() //=> { hours: 11, minutes: 0, seconds: 0 }
   * @example Duration.fromISOTime('1100').toObject() //=> { hours: 11, minutes: 0, seconds: 0 }
   * @example Duration.fromISOTime('T1100').toObject() //=> { hours: 11, minutes: 0, seconds: 0 }
   * @return {Duration}
   */
  ;

  Duration.fromISOTime = function fromISOTime(text, opts) {
    var _parseISOTimeOnly = parseISOTimeOnly(text),
        parsed = _parseISOTimeOnly[0];

    if (parsed) {
      return Duration.fromObject(parsed, opts);
    } else {
      return Duration.invalid("unparsable", "the input \"" + text + "\" can't be parsed as ISO 8601");
    }
  }
  /**
   * Create an invalid Duration.
   * @param {string} reason - simple string of why this datetime is invalid. Should not contain parameters or anything else data-dependent
   * @param {string} [explanation=null] - longer explanation, may include parameters and other useful debugging information
   * @return {Duration}
   */
  ;

  Duration.invalid = function invalid(reason, explanation) {
    if (explanation === void 0) {
      explanation = null;
    }

    if (!reason) {
      throw new InvalidArgumentError("need to specify a reason the Duration is invalid");
    }

    var invalid = reason instanceof Invalid ? reason : new Invalid(reason, explanation);

    if (Settings.throwOnInvalid) {
      throw new InvalidDurationError(invalid);
    } else {
      return new Duration({
        invalid: invalid
      });
    }
  }
  /**
   * @private
   */
  ;

  Duration.normalizeUnit = function normalizeUnit(unit) {
    var normalized = {
      year: "years",
      years: "years",
      quarter: "quarters",
      quarters: "quarters",
      month: "months",
      months: "months",
      week: "weeks",
      weeks: "weeks",
      day: "days",
      days: "days",
      hour: "hours",
      hours: "hours",
      minute: "minutes",
      minutes: "minutes",
      second: "seconds",
      seconds: "seconds",
      millisecond: "milliseconds",
      milliseconds: "milliseconds"
    }[unit ? unit.toLowerCase() : unit];
    if (!normalized) throw new InvalidUnitError(unit);
    return normalized;
  }
  /**
   * Check if an object is a Duration. Works across context boundaries
   * @param {object} o
   * @return {boolean}
   */
  ;

  Duration.isDuration = function isDuration(o) {
    return o && o.isLuxonDuration || false;
  }
  /**
   * Get  the locale of a Duration, such 'en-GB'
   * @type {string}
   */
  ;

  var _proto = Duration.prototype;

  /**
   * Returns a string representation of this Duration formatted according to the specified format string. You may use these tokens:
   * * `S` for milliseconds
   * * `s` for seconds
   * * `m` for minutes
   * * `h` for hours
   * * `d` for days
   * * `w` for weeks
   * * `M` for months
   * * `y` for years
   * Notes:
   * * Add padding by repeating the token, e.g. "yy" pads the years to two digits, "hhhh" pads the hours out to four digits
   * * The duration will be converted to the set of units in the format string using {@link Duration#shiftTo} and the Durations's conversion accuracy setting.
   * @param {string} fmt - the format string
   * @param {Object} opts - options
   * @param {boolean} [opts.floor=true] - floor numerical values
   * @example Duration.fromObject({ years: 1, days: 6, seconds: 2 }).toFormat("y d s") //=> "1 6 2"
   * @example Duration.fromObject({ years: 1, days: 6, seconds: 2 }).toFormat("yy dd sss") //=> "01 06 002"
   * @example Duration.fromObject({ years: 1, days: 6, seconds: 2 }).toFormat("M S") //=> "12 518402000"
   * @return {string}
   */
  _proto.toFormat = function toFormat(fmt, opts) {
    if (opts === void 0) {
      opts = {};
    }

    // reverse-compat since 1.2; we always round down now, never up, and we do it by default
    var fmtOpts = _extends({}, opts, {
      floor: opts.round !== false && opts.floor !== false
    });

    return this.isValid ? Formatter.create(this.loc, fmtOpts).formatDurationFromString(this, fmt) : INVALID$2;
  }
  /**
   * Returns a string representation of a Duration with all units included.
   * To modify its behavior use the `listStyle` and any Intl.NumberFormat option, though `unitDisplay` is especially relevant.
   * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Intl/NumberFormat
   * @param opts - On option object to override the formatting. Accepts the same keys as the options parameter of the native `Int.NumberFormat` constructor, as well as `listStyle`.
   * @example
   * ```js
   * var dur = Duration.fromObject({ days: 1, hours: 5, minutes: 6 })
   * dur.toHuman() //=> '1 day, 5 hours, 6 minutes'
   * dur.toHuman({ listStyle: "long" }) //=> '1 day, 5 hours, and 6 minutes'
   * dur.toHuman({ unitDisplay: "short" }) //=> '1 day, 5 hr, 6 min'
   * ```
   */
  ;

  _proto.toHuman = function toHuman(opts) {
    var _this = this;

    if (opts === void 0) {
      opts = {};
    }

    var l = orderedUnits$1.map(function (unit) {
      var val = _this.values[unit];

      if (isUndefined(val)) {
        return null;
      }

      return _this.loc.numberFormatter(_extends({
        style: "unit",
        unitDisplay: "long"
      }, opts, {
        unit: unit.slice(0, -1)
      })).format(val);
    }).filter(function (n) {
      return n;
    });
    return this.loc.listFormatter(_extends({
      type: "conjunction",
      style: opts.listStyle || "narrow"
    }, opts)).format(l);
  }
  /**
   * Returns a JavaScript object with this Duration's values.
   * @example Duration.fromObject({ years: 1, days: 6, seconds: 2 }).toObject() //=> { years: 1, days: 6, seconds: 2 }
   * @return {Object}
   */
  ;

  _proto.toObject = function toObject() {
    if (!this.isValid) return {};
    return _extends({}, this.values);
  }
  /**
   * Returns an ISO 8601-compliant string representation of this Duration.
   * @see https://en.wikipedia.org/wiki/ISO_8601#Durations
   * @example Duration.fromObject({ years: 3, seconds: 45 }).toISO() //=> 'P3YT45S'
   * @example Duration.fromObject({ months: 4, seconds: 45 }).toISO() //=> 'P4MT45S'
   * @example Duration.fromObject({ months: 5 }).toISO() //=> 'P5M'
   * @example Duration.fromObject({ minutes: 5 }).toISO() //=> 'PT5M'
   * @example Duration.fromObject({ milliseconds: 6 }).toISO() //=> 'PT0.006S'
   * @return {string}
   */
  ;

  _proto.toISO = function toISO() {
    // we could use the formatter, but this is an easier way to get the minimum string
    if (!this.isValid) return null;
    var s = "P";
    if (this.years !== 0) s += this.years + "Y";
    if (this.months !== 0 || this.quarters !== 0) s += this.months + this.quarters * 3 + "M";
    if (this.weeks !== 0) s += this.weeks + "W";
    if (this.days !== 0) s += this.days + "D";
    if (this.hours !== 0 || this.minutes !== 0 || this.seconds !== 0 || this.milliseconds !== 0) s += "T";
    if (this.hours !== 0) s += this.hours + "H";
    if (this.minutes !== 0) s += this.minutes + "M";
    if (this.seconds !== 0 || this.milliseconds !== 0) // this will handle "floating point madness" by removing extra decimal places
      // https://stackoverflow.com/questions/588004/is-floating-point-math-broken
      s += roundTo(this.seconds + this.milliseconds / 1000, 3) + "S";
    if (s === "P") s += "T0S";
    return s;
  }
  /**
   * Returns an ISO 8601-compliant string representation of this Duration, formatted as a time of day.
   * Note that this will return null if the duration is invalid, negative, or equal to or greater than 24 hours.
   * @see https://en.wikipedia.org/wiki/ISO_8601#Times
   * @param {Object} opts - options
   * @param {boolean} [opts.suppressMilliseconds=false] - exclude milliseconds from the format if they're 0
   * @param {boolean} [opts.suppressSeconds=false] - exclude seconds from the format if they're 0
   * @param {boolean} [opts.includePrefix=false] - include the `T` prefix
   * @param {string} [opts.format='extended'] - choose between the basic and extended format
   * @example Duration.fromObject({ hours: 11 }).toISOTime() //=> '11:00:00.000'
   * @example Duration.fromObject({ hours: 11 }).toISOTime({ suppressMilliseconds: true }) //=> '11:00:00'
   * @example Duration.fromObject({ hours: 11 }).toISOTime({ suppressSeconds: true }) //=> '11:00'
   * @example Duration.fromObject({ hours: 11 }).toISOTime({ includePrefix: true }) //=> 'T11:00:00.000'
   * @example Duration.fromObject({ hours: 11 }).toISOTime({ format: 'basic' }) //=> '110000.000'
   * @return {string}
   */
  ;

  _proto.toISOTime = function toISOTime(opts) {
    if (opts === void 0) {
      opts = {};
    }

    if (!this.isValid) return null;
    var millis = this.toMillis();
    if (millis < 0 || millis >= 86400000) return null;
    opts = _extends({
      suppressMilliseconds: false,
      suppressSeconds: false,
      includePrefix: false,
      format: "extended"
    }, opts);
    var value = this.shiftTo("hours", "minutes", "seconds", "milliseconds");
    var fmt = opts.format === "basic" ? "hhmm" : "hh:mm";

    if (!opts.suppressSeconds || value.seconds !== 0 || value.milliseconds !== 0) {
      fmt += opts.format === "basic" ? "ss" : ":ss";

      if (!opts.suppressMilliseconds || value.milliseconds !== 0) {
        fmt += ".SSS";
      }
    }

    var str = value.toFormat(fmt);

    if (opts.includePrefix) {
      str = "T" + str;
    }

    return str;
  }
  /**
   * Returns an ISO 8601 representation of this Duration appropriate for use in JSON.
   * @return {string}
   */
  ;

  _proto.toJSON = function toJSON() {
    return this.toISO();
  }
  /**
   * Returns an ISO 8601 representation of this Duration appropriate for use in debugging.
   * @return {string}
   */
  ;

  _proto.toString = function toString() {
    return this.toISO();
  }
  /**
   * Returns an milliseconds value of this Duration.
   * @return {number}
   */
  ;

  _proto.toMillis = function toMillis() {
    return this.as("milliseconds");
  }
  /**
   * Returns an milliseconds value of this Duration. Alias of {@link toMillis}
   * @return {number}
   */
  ;

  _proto.valueOf = function valueOf() {
    return this.toMillis();
  }
  /**
   * Make this Duration longer by the specified amount. Return a newly-constructed Duration.
   * @param {Duration|Object|number} duration - The amount to add. Either a Luxon Duration, a number of milliseconds, the object argument to Duration.fromObject()
   * @return {Duration}
   */
  ;

  _proto.plus = function plus(duration) {
    if (!this.isValid) return this;
    var dur = Duration.fromDurationLike(duration),
        result = {};

    for (var _iterator = _createForOfIteratorHelperLoose(orderedUnits$1), _step; !(_step = _iterator()).done;) {
      var k = _step.value;

      if (hasOwnProperty(dur.values, k) || hasOwnProperty(this.values, k)) {
        result[k] = dur.get(k) + this.get(k);
      }
    }

    return clone$1(this, {
      values: result
    }, true);
  }
  /**
   * Make this Duration shorter by the specified amount. Return a newly-constructed Duration.
   * @param {Duration|Object|number} duration - The amount to subtract. Either a Luxon Duration, a number of milliseconds, the object argument to Duration.fromObject()
   * @return {Duration}
   */
  ;

  _proto.minus = function minus(duration) {
    if (!this.isValid) return this;
    var dur = Duration.fromDurationLike(duration);
    return this.plus(dur.negate());
  }
  /**
   * Scale this Duration by the specified amount. Return a newly-constructed Duration.
   * @param {function} fn - The function to apply to each unit. Arity is 1 or 2: the value of the unit and, optionally, the unit name. Must return a number.
   * @example Duration.fromObject({ hours: 1, minutes: 30 }).mapUnits(x => x * 2) //=> { hours: 2, minutes: 60 }
   * @example Duration.fromObject({ hours: 1, minutes: 30 }).mapUnits((x, u) => u === "hour" ? x * 2 : x) //=> { hours: 2, minutes: 30 }
   * @return {Duration}
   */
  ;

  _proto.mapUnits = function mapUnits(fn) {
    if (!this.isValid) return this;
    var result = {};

    for (var _i = 0, _Object$keys = Object.keys(this.values); _i < _Object$keys.length; _i++) {
      var k = _Object$keys[_i];
      result[k] = asNumber(fn(this.values[k], k));
    }

    return clone$1(this, {
      values: result
    }, true);
  }
  /**
   * Get the value of unit.
   * @param {string} unit - a unit such as 'minute' or 'day'
   * @example Duration.fromObject({years: 2, days: 3}).get('years') //=> 2
   * @example Duration.fromObject({years: 2, days: 3}).get('months') //=> 0
   * @example Duration.fromObject({years: 2, days: 3}).get('days') //=> 3
   * @return {number}
   */
  ;

  _proto.get = function get(unit) {
    return this[Duration.normalizeUnit(unit)];
  }
  /**
   * "Set" the values of specified units. Return a newly-constructed Duration.
   * @param {Object} values - a mapping of units to numbers
   * @example dur.set({ years: 2017 })
   * @example dur.set({ hours: 8, minutes: 30 })
   * @return {Duration}
   */
  ;

  _proto.set = function set(values) {
    if (!this.isValid) return this;

    var mixed = _extends({}, this.values, normalizeObject(values, Duration.normalizeUnit));

    return clone$1(this, {
      values: mixed
    });
  }
  /**
   * "Set" the locale and/or numberingSystem.  Returns a newly-constructed Duration.
   * @example dur.reconfigure({ locale: 'en-GB' })
   * @return {Duration}
   */
  ;

  _proto.reconfigure = function reconfigure(_temp) {
    var _ref = _temp === void 0 ? {} : _temp,
        locale = _ref.locale,
        numberingSystem = _ref.numberingSystem,
        conversionAccuracy = _ref.conversionAccuracy;

    var loc = this.loc.clone({
      locale: locale,
      numberingSystem: numberingSystem
    }),
        opts = {
      loc: loc
    };

    if (conversionAccuracy) {
      opts.conversionAccuracy = conversionAccuracy;
    }

    return clone$1(this, opts);
  }
  /**
   * Return the length of the duration in the specified unit.
   * @param {string} unit - a unit such as 'minutes' or 'days'
   * @example Duration.fromObject({years: 1}).as('days') //=> 365
   * @example Duration.fromObject({years: 1}).as('months') //=> 12
   * @example Duration.fromObject({hours: 60}).as('days') //=> 2.5
   * @return {number}
   */
  ;

  _proto.as = function as(unit) {
    return this.isValid ? this.shiftTo(unit).get(unit) : NaN;
  }
  /**
   * Reduce this Duration to its canonical representation in its current units.
   * @example Duration.fromObject({ years: 2, days: 5000 }).normalize().toObject() //=> { years: 15, days: 255 }
   * @example Duration.fromObject({ hours: 12, minutes: -45 }).normalize().toObject() //=> { hours: 11, minutes: 15 }
   * @return {Duration}
   */
  ;

  _proto.normalize = function normalize() {
    if (!this.isValid) return this;
    var vals = this.toObject();
    normalizeValues(this.matrix, vals);
    return clone$1(this, {
      values: vals
    }, true);
  }
  /**
   * Convert this Duration into its representation in a different set of units.
   * @example Duration.fromObject({ hours: 1, seconds: 30 }).shiftTo('minutes', 'milliseconds').toObject() //=> { minutes: 60, milliseconds: 30000 }
   * @return {Duration}
   */
  ;

  _proto.shiftTo = function shiftTo() {
    for (var _len = arguments.length, units = new Array(_len), _key = 0; _key < _len; _key++) {
      units[_key] = arguments[_key];
    }

    if (!this.isValid) return this;

    if (units.length === 0) {
      return this;
    }

    units = units.map(function (u) {
      return Duration.normalizeUnit(u);
    });
    var built = {},
        accumulated = {},
        vals = this.toObject();
    var lastUnit;

    for (var _iterator2 = _createForOfIteratorHelperLoose(orderedUnits$1), _step2; !(_step2 = _iterator2()).done;) {
      var k = _step2.value;

      if (units.indexOf(k) >= 0) {
        lastUnit = k;
        var own = 0; // anything we haven't boiled down yet should get boiled to this unit

        for (var ak in accumulated) {
          own += this.matrix[ak][k] * accumulated[ak];
          accumulated[ak] = 0;
        } // plus anything that's already in this unit


        if (isNumber(vals[k])) {
          own += vals[k];
        }

        var i = Math.trunc(own);
        built[k] = i;
        accumulated[k] = (own * 1000 - i * 1000) / 1000; // plus anything further down the chain that should be rolled up in to this

        for (var down in vals) {
          if (orderedUnits$1.indexOf(down) > orderedUnits$1.indexOf(k)) {
            convert(this.matrix, vals, down, built, k);
          }
        } // otherwise, keep it in the wings to boil it later

      } else if (isNumber(vals[k])) {
        accumulated[k] = vals[k];
      }
    } // anything leftover becomes the decimal for the last unit
    // lastUnit must be defined since units is not empty


    for (var key in accumulated) {
      if (accumulated[key] !== 0) {
        built[lastUnit] += key === lastUnit ? accumulated[key] : accumulated[key] / this.matrix[lastUnit][key];
      }
    }

    return clone$1(this, {
      values: built
    }, true).normalize();
  }
  /**
   * Return the negative of this Duration.
   * @example Duration.fromObject({ hours: 1, seconds: 30 }).negate().toObject() //=> { hours: -1, seconds: -30 }
   * @return {Duration}
   */
  ;

  _proto.negate = function negate() {
    if (!this.isValid) return this;
    var negated = {};

    for (var _i2 = 0, _Object$keys2 = Object.keys(this.values); _i2 < _Object$keys2.length; _i2++) {
      var k = _Object$keys2[_i2];
      negated[k] = this.values[k] === 0 ? 0 : -this.values[k];
    }

    return clone$1(this, {
      values: negated
    }, true);
  }
  /**
   * Get the years.
   * @type {number}
   */
  ;

  /**
   * Equality check
   * Two Durations are equal iff they have the same units and the same values for each unit.
   * @param {Duration} other
   * @return {boolean}
   */
  _proto.equals = function equals(other) {
    if (!this.isValid || !other.isValid) {
      return false;
    }

    if (!this.loc.equals(other.loc)) {
      return false;
    }

    function eq(v1, v2) {
      // Consider 0 and undefined as equal
      if (v1 === undefined || v1 === 0) return v2 === undefined || v2 === 0;
      return v1 === v2;
    }

    for (var _iterator3 = _createForOfIteratorHelperLoose(orderedUnits$1), _step3; !(_step3 = _iterator3()).done;) {
      var u = _step3.value;

      if (!eq(this.values[u], other.values[u])) {
        return false;
      }
    }

    return true;
  };

  _createClass(Duration, [{
    key: "locale",
    get: function get() {
      return this.isValid ? this.loc.locale : null;
    }
    /**
     * Get the numbering system of a Duration, such 'beng'. The numbering system is used when formatting the Duration
     *
     * @type {string}
     */

  }, {
    key: "numberingSystem",
    get: function get() {
      return this.isValid ? this.loc.numberingSystem : null;
    }
  }, {
    key: "years",
    get: function get() {
      return this.isValid ? this.values.years || 0 : NaN;
    }
    /**
     * Get the quarters.
     * @type {number}
     */

  }, {
    key: "quarters",
    get: function get() {
      return this.isValid ? this.values.quarters || 0 : NaN;
    }
    /**
     * Get the months.
     * @type {number}
     */

  }, {
    key: "months",
    get: function get() {
      return this.isValid ? this.values.months || 0 : NaN;
    }
    /**
     * Get the weeks
     * @type {number}
     */

  }, {
    key: "weeks",
    get: function get() {
      return this.isValid ? this.values.weeks || 0 : NaN;
    }
    /**
     * Get the days.
     * @type {number}
     */

  }, {
    key: "days",
    get: function get() {
      return this.isValid ? this.values.days || 0 : NaN;
    }
    /**
     * Get the hours.
     * @type {number}
     */

  }, {
    key: "hours",
    get: function get() {
      return this.isValid ? this.values.hours || 0 : NaN;
    }
    /**
     * Get the minutes.
     * @type {number}
     */

  }, {
    key: "minutes",
    get: function get() {
      return this.isValid ? this.values.minutes || 0 : NaN;
    }
    /**
     * Get the seconds.
     * @return {number}
     */

  }, {
    key: "seconds",
    get: function get() {
      return this.isValid ? this.values.seconds || 0 : NaN;
    }
    /**
     * Get the milliseconds.
     * @return {number}
     */

  }, {
    key: "milliseconds",
    get: function get() {
      return this.isValid ? this.values.milliseconds || 0 : NaN;
    }
    /**
     * Returns whether the Duration is invalid. Invalid durations are returned by diff operations
     * on invalid DateTimes or Intervals.
     * @return {boolean}
     */

  }, {
    key: "isValid",
    get: function get() {
      return this.invalid === null;
    }
    /**
     * Returns an error code if this Duration became invalid, or null if the Duration is valid
     * @return {string}
     */

  }, {
    key: "invalidReason",
    get: function get() {
      return this.invalid ? this.invalid.reason : null;
    }
    /**
     * Returns an explanation of why this Duration became invalid, or null if the Duration is valid
     * @type {string}
     */

  }, {
    key: "invalidExplanation",
    get: function get() {
      return this.invalid ? this.invalid.explanation : null;
    }
  }]);

  return Duration;
}();

var INVALID$1 = "Invalid Interval"; // checks if the start is equal to or before the end

function validateStartEnd(start, end) {
  if (!start || !start.isValid) {
    return Interval.invalid("missing or invalid start");
  } else if (!end || !end.isValid) {
    return Interval.invalid("missing or invalid end");
  } else if (end < start) {
    return Interval.invalid("end before start", "The end of an interval must be after its start, but you had start=" + start.toISO() + " and end=" + end.toISO());
  } else {
    return null;
  }
}
/**
 * An Interval object represents a half-open interval of time, where each endpoint is a {@link DateTime}. Conceptually, it's a container for those two endpoints, accompanied by methods for creating, parsing, interrogating, comparing, transforming, and formatting them.
 *
 * Here is a brief overview of the most commonly used methods and getters in Interval:
 *
 * * **Creation** To create an Interval, use {@link Interval#fromDateTimes}, {@link Interval#after}, {@link Interval#before}, or {@link Interval#fromISO}.
 * * **Accessors** Use {@link Interval#start} and {@link Interval#end} to get the start and end.
 * * **Interrogation** To analyze the Interval, use {@link Interval#count}, {@link Interval#length}, {@link Interval#hasSame}, {@link Interval#contains}, {@link Interval#isAfter}, or {@link Interval#isBefore}.
 * * **Transformation** To create other Intervals out of this one, use {@link Interval#set}, {@link Interval#splitAt}, {@link Interval#splitBy}, {@link Interval#divideEqually}, {@link Interval#merge}, {@link Interval#xor}, {@link Interval#union}, {@link Interval#intersection}, or {@link Interval#difference}.
 * * **Comparison** To compare this Interval to another one, use {@link Interval#equals}, {@link Interval#overlaps}, {@link Interval#abutsStart}, {@link Interval#abutsEnd}, {@link Interval#engulfs}
 * * **Output** To convert the Interval into other representations, see {@link Interval#toString}, {@link Interval#toISO}, {@link Interval#toISODate}, {@link Interval#toISOTime}, {@link Interval#toFormat}, and {@link Interval#toDuration}.
 */


var Interval = /*#__PURE__*/function () {
  /**
   * @private
   */
  function Interval(config) {
    /**
     * @access private
     */
    this.s = config.start;
    /**
     * @access private
     */

    this.e = config.end;
    /**
     * @access private
     */

    this.invalid = config.invalid || null;
    /**
     * @access private
     */

    this.isLuxonInterval = true;
  }
  /**
   * Create an invalid Interval.
   * @param {string} reason - simple string of why this Interval is invalid. Should not contain parameters or anything else data-dependent
   * @param {string} [explanation=null] - longer explanation, may include parameters and other useful debugging information
   * @return {Interval}
   */


  Interval.invalid = function invalid(reason, explanation) {
    if (explanation === void 0) {
      explanation = null;
    }

    if (!reason) {
      throw new InvalidArgumentError("need to specify a reason the Interval is invalid");
    }

    var invalid = reason instanceof Invalid ? reason : new Invalid(reason, explanation);

    if (Settings.throwOnInvalid) {
      throw new InvalidIntervalError(invalid);
    } else {
      return new Interval({
        invalid: invalid
      });
    }
  }
  /**
   * Create an Interval from a start DateTime and an end DateTime. Inclusive of the start but not the end.
   * @param {DateTime|Date|Object} start
   * @param {DateTime|Date|Object} end
   * @return {Interval}
   */
  ;

  Interval.fromDateTimes = function fromDateTimes(start, end) {
    var builtStart = friendlyDateTime(start),
        builtEnd = friendlyDateTime(end);
    var validateError = validateStartEnd(builtStart, builtEnd);

    if (validateError == null) {
      return new Interval({
        start: builtStart,
        end: builtEnd
      });
    } else {
      return validateError;
    }
  }
  /**
   * Create an Interval from a start DateTime and a Duration to extend to.
   * @param {DateTime|Date|Object} start
   * @param {Duration|Object|number} duration - the length of the Interval.
   * @return {Interval}
   */
  ;

  Interval.after = function after(start, duration) {
    var dur = Duration.fromDurationLike(duration),
        dt = friendlyDateTime(start);
    return Interval.fromDateTimes(dt, dt.plus(dur));
  }
  /**
   * Create an Interval from an end DateTime and a Duration to extend backwards to.
   * @param {DateTime|Date|Object} end
   * @param {Duration|Object|number} duration - the length of the Interval.
   * @return {Interval}
   */
  ;

  Interval.before = function before(end, duration) {
    var dur = Duration.fromDurationLike(duration),
        dt = friendlyDateTime(end);
    return Interval.fromDateTimes(dt.minus(dur), dt);
  }
  /**
   * Create an Interval from an ISO 8601 string.
   * Accepts `<start>/<end>`, `<start>/<duration>`, and `<duration>/<end>` formats.
   * @param {string} text - the ISO string to parse
   * @param {Object} [opts] - options to pass {@link DateTime#fromISO} and optionally {@link Duration#fromISO}
   * @see https://en.wikipedia.org/wiki/ISO_8601#Time_intervals
   * @return {Interval}
   */
  ;

  Interval.fromISO = function fromISO(text, opts) {
    var _split = (text || "").split("/", 2),
        s = _split[0],
        e = _split[1];

    if (s && e) {
      var start, startIsValid;

      try {
        start = DateTime.fromISO(s, opts);
        startIsValid = start.isValid;
      } catch (e) {
        startIsValid = false;
      }

      var end, endIsValid;

      try {
        end = DateTime.fromISO(e, opts);
        endIsValid = end.isValid;
      } catch (e) {
        endIsValid = false;
      }

      if (startIsValid && endIsValid) {
        return Interval.fromDateTimes(start, end);
      }

      if (startIsValid) {
        var dur = Duration.fromISO(e, opts);

        if (dur.isValid) {
          return Interval.after(start, dur);
        }
      } else if (endIsValid) {
        var _dur = Duration.fromISO(s, opts);

        if (_dur.isValid) {
          return Interval.before(end, _dur);
        }
      }
    }

    return Interval.invalid("unparsable", "the input \"" + text + "\" can't be parsed as ISO 8601");
  }
  /**
   * Check if an object is an Interval. Works across context boundaries
   * @param {object} o
   * @return {boolean}
   */
  ;

  Interval.isInterval = function isInterval(o) {
    return o && o.isLuxonInterval || false;
  }
  /**
   * Returns the start of the Interval
   * @type {DateTime}
   */
  ;

  var _proto = Interval.prototype;

  /**
   * Returns the length of the Interval in the specified unit.
   * @param {string} unit - the unit (such as 'hours' or 'days') to return the length in.
   * @return {number}
   */
  _proto.length = function length(unit) {
    if (unit === void 0) {
      unit = "milliseconds";
    }

    return this.isValid ? this.toDuration.apply(this, [unit]).get(unit) : NaN;
  }
  /**
   * Returns the count of minutes, hours, days, months, or years included in the Interval, even in part.
   * Unlike {@link Interval#length} this counts sections of the calendar, not periods of time, e.g. specifying 'day'
   * asks 'what dates are included in this interval?', not 'how many days long is this interval?'
   * @param {string} [unit='milliseconds'] - the unit of time to count.
   * @return {number}
   */
  ;

  _proto.count = function count(unit) {
    if (unit === void 0) {
      unit = "milliseconds";
    }

    if (!this.isValid) return NaN;
    var start = this.start.startOf(unit),
        end = this.end.startOf(unit);
    return Math.floor(end.diff(start, unit).get(unit)) + 1;
  }
  /**
   * Returns whether this Interval's start and end are both in the same unit of time
   * @param {string} unit - the unit of time to check sameness on
   * @return {boolean}
   */
  ;

  _proto.hasSame = function hasSame(unit) {
    return this.isValid ? this.isEmpty() || this.e.minus(1).hasSame(this.s, unit) : false;
  }
  /**
   * Return whether this Interval has the same start and end DateTimes.
   * @return {boolean}
   */
  ;

  _proto.isEmpty = function isEmpty() {
    return this.s.valueOf() === this.e.valueOf();
  }
  /**
   * Return whether this Interval's start is after the specified DateTime.
   * @param {DateTime} dateTime
   * @return {boolean}
   */
  ;

  _proto.isAfter = function isAfter(dateTime) {
    if (!this.isValid) return false;
    return this.s > dateTime;
  }
  /**
   * Return whether this Interval's end is before the specified DateTime.
   * @param {DateTime} dateTime
   * @return {boolean}
   */
  ;

  _proto.isBefore = function isBefore(dateTime) {
    if (!this.isValid) return false;
    return this.e <= dateTime;
  }
  /**
   * Return whether this Interval contains the specified DateTime.
   * @param {DateTime} dateTime
   * @return {boolean}
   */
  ;

  _proto.contains = function contains(dateTime) {
    if (!this.isValid) return false;
    return this.s <= dateTime && this.e > dateTime;
  }
  /**
   * "Sets" the start and/or end dates. Returns a newly-constructed Interval.
   * @param {Object} values - the values to set
   * @param {DateTime} values.start - the starting DateTime
   * @param {DateTime} values.end - the ending DateTime
   * @return {Interval}
   */
  ;

  _proto.set = function set(_temp) {
    var _ref = _temp === void 0 ? {} : _temp,
        start = _ref.start,
        end = _ref.end;

    if (!this.isValid) return this;
    return Interval.fromDateTimes(start || this.s, end || this.e);
  }
  /**
   * Split this Interval at each of the specified DateTimes
   * @param {...DateTime} dateTimes - the unit of time to count.
   * @return {Array}
   */
  ;

  _proto.splitAt = function splitAt() {
    var _this = this;

    if (!this.isValid) return [];

    for (var _len = arguments.length, dateTimes = new Array(_len), _key = 0; _key < _len; _key++) {
      dateTimes[_key] = arguments[_key];
    }

    var sorted = dateTimes.map(friendlyDateTime).filter(function (d) {
      return _this.contains(d);
    }).sort(),
        results = [];
    var s = this.s,
        i = 0;

    while (s < this.e) {
      var added = sorted[i] || this.e,
          next = +added > +this.e ? this.e : added;
      results.push(Interval.fromDateTimes(s, next));
      s = next;
      i += 1;
    }

    return results;
  }
  /**
   * Split this Interval into smaller Intervals, each of the specified length.
   * Left over time is grouped into a smaller interval
   * @param {Duration|Object|number} duration - The length of each resulting interval.
   * @return {Array}
   */
  ;

  _proto.splitBy = function splitBy(duration) {
    var dur = Duration.fromDurationLike(duration);

    if (!this.isValid || !dur.isValid || dur.as("milliseconds") === 0) {
      return [];
    }

    var s = this.s,
        idx = 1,
        next;
    var results = [];

    while (s < this.e) {
      var added = this.start.plus(dur.mapUnits(function (x) {
        return x * idx;
      }));
      next = +added > +this.e ? this.e : added;
      results.push(Interval.fromDateTimes(s, next));
      s = next;
      idx += 1;
    }

    return results;
  }
  /**
   * Split this Interval into the specified number of smaller intervals.
   * @param {number} numberOfParts - The number of Intervals to divide the Interval into.
   * @return {Array}
   */
  ;

  _proto.divideEqually = function divideEqually(numberOfParts) {
    if (!this.isValid) return [];
    return this.splitBy(this.length() / numberOfParts).slice(0, numberOfParts);
  }
  /**
   * Return whether this Interval overlaps with the specified Interval
   * @param {Interval} other
   * @return {boolean}
   */
  ;

  _proto.overlaps = function overlaps(other) {
    return this.e > other.s && this.s < other.e;
  }
  /**
   * Return whether this Interval's end is adjacent to the specified Interval's start.
   * @param {Interval} other
   * @return {boolean}
   */
  ;

  _proto.abutsStart = function abutsStart(other) {
    if (!this.isValid) return false;
    return +this.e === +other.s;
  }
  /**
   * Return whether this Interval's start is adjacent to the specified Interval's end.
   * @param {Interval} other
   * @return {boolean}
   */
  ;

  _proto.abutsEnd = function abutsEnd(other) {
    if (!this.isValid) return false;
    return +other.e === +this.s;
  }
  /**
   * Return whether this Interval engulfs the start and end of the specified Interval.
   * @param {Interval} other
   * @return {boolean}
   */
  ;

  _proto.engulfs = function engulfs(other) {
    if (!this.isValid) return false;
    return this.s <= other.s && this.e >= other.e;
  }
  /**
   * Return whether this Interval has the same start and end as the specified Interval.
   * @param {Interval} other
   * @return {boolean}
   */
  ;

  _proto.equals = function equals(other) {
    if (!this.isValid || !other.isValid) {
      return false;
    }

    return this.s.equals(other.s) && this.e.equals(other.e);
  }
  /**
   * Return an Interval representing the intersection of this Interval and the specified Interval.
   * Specifically, the resulting Interval has the maximum start time and the minimum end time of the two Intervals.
   * Returns null if the intersection is empty, meaning, the intervals don't intersect.
   * @param {Interval} other
   * @return {Interval}
   */
  ;

  _proto.intersection = function intersection(other) {
    if (!this.isValid) return this;
    var s = this.s > other.s ? this.s : other.s,
        e = this.e < other.e ? this.e : other.e;

    if (s >= e) {
      return null;
    } else {
      return Interval.fromDateTimes(s, e);
    }
  }
  /**
   * Return an Interval representing the union of this Interval and the specified Interval.
   * Specifically, the resulting Interval has the minimum start time and the maximum end time of the two Intervals.
   * @param {Interval} other
   * @return {Interval}
   */
  ;

  _proto.union = function union(other) {
    if (!this.isValid) return this;
    var s = this.s < other.s ? this.s : other.s,
        e = this.e > other.e ? this.e : other.e;
    return Interval.fromDateTimes(s, e);
  }
  /**
   * Merge an array of Intervals into a equivalent minimal set of Intervals.
   * Combines overlapping and adjacent Intervals.
   * @param {Array} intervals
   * @return {Array}
   */
  ;

  Interval.merge = function merge(intervals) {
    var _intervals$sort$reduc = intervals.sort(function (a, b) {
      return a.s - b.s;
    }).reduce(function (_ref2, item) {
      var sofar = _ref2[0],
          current = _ref2[1];

      if (!current) {
        return [sofar, item];
      } else if (current.overlaps(item) || current.abutsStart(item)) {
        return [sofar, current.union(item)];
      } else {
        return [sofar.concat([current]), item];
      }
    }, [[], null]),
        found = _intervals$sort$reduc[0],
        final = _intervals$sort$reduc[1];

    if (final) {
      found.push(final);
    }

    return found;
  }
  /**
   * Return an array of Intervals representing the spans of time that only appear in one of the specified Intervals.
   * @param {Array} intervals
   * @return {Array}
   */
  ;

  Interval.xor = function xor(intervals) {
    var _Array$prototype;

    var start = null,
        currentCount = 0;

    var results = [],
        ends = intervals.map(function (i) {
      return [{
        time: i.s,
        type: "s"
      }, {
        time: i.e,
        type: "e"
      }];
    }),
        flattened = (_Array$prototype = Array.prototype).concat.apply(_Array$prototype, ends),
        arr = flattened.sort(function (a, b) {
      return a.time - b.time;
    });

    for (var _iterator = _createForOfIteratorHelperLoose(arr), _step; !(_step = _iterator()).done;) {
      var i = _step.value;
      currentCount += i.type === "s" ? 1 : -1;

      if (currentCount === 1) {
        start = i.time;
      } else {
        if (start && +start !== +i.time) {
          results.push(Interval.fromDateTimes(start, i.time));
        }

        start = null;
      }
    }

    return Interval.merge(results);
  }
  /**
   * Return an Interval representing the span of time in this Interval that doesn't overlap with any of the specified Intervals.
   * @param {...Interval} intervals
   * @return {Array}
   */
  ;

  _proto.difference = function difference() {
    var _this2 = this;

    for (var _len2 = arguments.length, intervals = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
      intervals[_key2] = arguments[_key2];
    }

    return Interval.xor([this].concat(intervals)).map(function (i) {
      return _this2.intersection(i);
    }).filter(function (i) {
      return i && !i.isEmpty();
    });
  }
  /**
   * Returns a string representation of this Interval appropriate for debugging.
   * @return {string}
   */
  ;

  _proto.toString = function toString() {
    if (!this.isValid) return INVALID$1;
    return "[" + this.s.toISO() + " \u2013 " + this.e.toISO() + ")";
  }
  /**
   * Returns an ISO 8601-compliant string representation of this Interval.
   * @see https://en.wikipedia.org/wiki/ISO_8601#Time_intervals
   * @param {Object} opts - The same options as {@link DateTime#toISO}
   * @return {string}
   */
  ;

  _proto.toISO = function toISO(opts) {
    if (!this.isValid) return INVALID$1;
    return this.s.toISO(opts) + "/" + this.e.toISO(opts);
  }
  /**
   * Returns an ISO 8601-compliant string representation of date of this Interval.
   * The time components are ignored.
   * @see https://en.wikipedia.org/wiki/ISO_8601#Time_intervals
   * @return {string}
   */
  ;

  _proto.toISODate = function toISODate() {
    if (!this.isValid) return INVALID$1;
    return this.s.toISODate() + "/" + this.e.toISODate();
  }
  /**
   * Returns an ISO 8601-compliant string representation of time of this Interval.
   * The date components are ignored.
   * @see https://en.wikipedia.org/wiki/ISO_8601#Time_intervals
   * @param {Object} opts - The same options as {@link DateTime#toISO}
   * @return {string}
   */
  ;

  _proto.toISOTime = function toISOTime(opts) {
    if (!this.isValid) return INVALID$1;
    return this.s.toISOTime(opts) + "/" + this.e.toISOTime(opts);
  }
  /**
   * Returns a string representation of this Interval formatted according to the specified format string.
   * @param {string} dateFormat - the format string. This string formats the start and end time. See {@link DateTime#toFormat} for details.
   * @param {Object} opts - options
   * @param {string} [opts.separator =  ' – '] - a separator to place between the start and end representations
   * @return {string}
   */
  ;

  _proto.toFormat = function toFormat(dateFormat, _temp2) {
    var _ref3 = _temp2 === void 0 ? {} : _temp2,
        _ref3$separator = _ref3.separator,
        separator = _ref3$separator === void 0 ? " – " : _ref3$separator;

    if (!this.isValid) return INVALID$1;
    return "" + this.s.toFormat(dateFormat) + separator + this.e.toFormat(dateFormat);
  }
  /**
   * Return a Duration representing the time spanned by this interval.
   * @param {string|string[]} [unit=['milliseconds']] - the unit or units (such as 'hours' or 'days') to include in the duration.
   * @param {Object} opts - options that affect the creation of the Duration
   * @param {string} [opts.conversionAccuracy='casual'] - the conversion system to use
   * @example Interval.fromDateTimes(dt1, dt2).toDuration().toObject() //=> { milliseconds: 88489257 }
   * @example Interval.fromDateTimes(dt1, dt2).toDuration('days').toObject() //=> { days: 1.0241812152777778 }
   * @example Interval.fromDateTimes(dt1, dt2).toDuration(['hours', 'minutes']).toObject() //=> { hours: 24, minutes: 34.82095 }
   * @example Interval.fromDateTimes(dt1, dt2).toDuration(['hours', 'minutes', 'seconds']).toObject() //=> { hours: 24, minutes: 34, seconds: 49.257 }
   * @example Interval.fromDateTimes(dt1, dt2).toDuration('seconds').toObject() //=> { seconds: 88489.257 }
   * @return {Duration}
   */
  ;

  _proto.toDuration = function toDuration(unit, opts) {
    if (!this.isValid) {
      return Duration.invalid(this.invalidReason);
    }

    return this.e.diff(this.s, unit, opts);
  }
  /**
   * Run mapFn on the interval start and end, returning a new Interval from the resulting DateTimes
   * @param {function} mapFn
   * @return {Interval}
   * @example Interval.fromDateTimes(dt1, dt2).mapEndpoints(endpoint => endpoint.toUTC())
   * @example Interval.fromDateTimes(dt1, dt2).mapEndpoints(endpoint => endpoint.plus({ hours: 2 }))
   */
  ;

  _proto.mapEndpoints = function mapEndpoints(mapFn) {
    return Interval.fromDateTimes(mapFn(this.s), mapFn(this.e));
  };

  _createClass(Interval, [{
    key: "start",
    get: function get() {
      return this.isValid ? this.s : null;
    }
    /**
     * Returns the end of the Interval
     * @type {DateTime}
     */

  }, {
    key: "end",
    get: function get() {
      return this.isValid ? this.e : null;
    }
    /**
     * Returns whether this Interval's end is at least its start, meaning that the Interval isn't 'backwards'.
     * @type {boolean}
     */

  }, {
    key: "isValid",
    get: function get() {
      return this.invalidReason === null;
    }
    /**
     * Returns an error code if this Interval is invalid, or null if the Interval is valid
     * @type {string}
     */

  }, {
    key: "invalidReason",
    get: function get() {
      return this.invalid ? this.invalid.reason : null;
    }
    /**
     * Returns an explanation of why this Interval became invalid, or null if the Interval is valid
     * @type {string}
     */

  }, {
    key: "invalidExplanation",
    get: function get() {
      return this.invalid ? this.invalid.explanation : null;
    }
  }]);

  return Interval;
}();

/**
 * The Info class contains static methods for retrieving general time and date related data. For example, it has methods for finding out if a time zone has a DST, for listing the months in any supported locale, and for discovering which of Luxon features are available in the current environment.
 */

var Info = /*#__PURE__*/function () {
  function Info() {}

  /**
   * Return whether the specified zone contains a DST.
   * @param {string|Zone} [zone='local'] - Zone to check. Defaults to the environment's local zone.
   * @return {boolean}
   */
  Info.hasDST = function hasDST(zone) {
    if (zone === void 0) {
      zone = Settings.defaultZone;
    }

    var proto = DateTime.now().setZone(zone).set({
      month: 12
    });
    return !zone.isUniversal && proto.offset !== proto.set({
      month: 6
    }).offset;
  }
  /**
   * Return whether the specified zone is a valid IANA specifier.
   * @param {string} zone - Zone to check
   * @return {boolean}
   */
  ;

  Info.isValidIANAZone = function isValidIANAZone(zone) {
    return IANAZone.isValidZone(zone);
  }
  /**
   * Converts the input into a {@link Zone} instance.
   *
   * * If `input` is already a Zone instance, it is returned unchanged.
   * * If `input` is a string containing a valid time zone name, a Zone instance
   *   with that name is returned.
   * * If `input` is a string that doesn't refer to a known time zone, a Zone
   *   instance with {@link Zone#isValid} == false is returned.
   * * If `input is a number, a Zone instance with the specified fixed offset
   *   in minutes is returned.
   * * If `input` is `null` or `undefined`, the default zone is returned.
   * @param {string|Zone|number} [input] - the value to be converted
   * @return {Zone}
   */
  ;

  Info.normalizeZone = function normalizeZone$1(input) {
    return normalizeZone(input, Settings.defaultZone);
  }
  /**
   * Return an array of standalone month names.
   * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/DateTimeFormat
   * @param {string} [length='long'] - the length of the month representation, such as "numeric", "2-digit", "narrow", "short", "long"
   * @param {Object} opts - options
   * @param {string} [opts.locale] - the locale code
   * @param {string} [opts.numberingSystem=null] - the numbering system
   * @param {string} [opts.locObj=null] - an existing locale object to use
   * @param {string} [opts.outputCalendar='gregory'] - the calendar
   * @example Info.months()[0] //=> 'January'
   * @example Info.months('short')[0] //=> 'Jan'
   * @example Info.months('numeric')[0] //=> '1'
   * @example Info.months('short', { locale: 'fr-CA' } )[0] //=> 'janv.'
   * @example Info.months('numeric', { locale: 'ar' })[0] //=> '١'
   * @example Info.months('long', { outputCalendar: 'islamic' })[0] //=> 'Rabiʻ I'
   * @return {Array}
   */
  ;

  Info.months = function months(length, _temp) {
    if (length === void 0) {
      length = "long";
    }

    var _ref = _temp === void 0 ? {} : _temp,
        _ref$locale = _ref.locale,
        locale = _ref$locale === void 0 ? null : _ref$locale,
        _ref$numberingSystem = _ref.numberingSystem,
        numberingSystem = _ref$numberingSystem === void 0 ? null : _ref$numberingSystem,
        _ref$locObj = _ref.locObj,
        locObj = _ref$locObj === void 0 ? null : _ref$locObj,
        _ref$outputCalendar = _ref.outputCalendar,
        outputCalendar = _ref$outputCalendar === void 0 ? "gregory" : _ref$outputCalendar;

    return (locObj || Locale.create(locale, numberingSystem, outputCalendar)).months(length);
  }
  /**
   * Return an array of format month names.
   * Format months differ from standalone months in that they're meant to appear next to the day of the month. In some languages, that
   * changes the string.
   * See {@link Info#months}
   * @param {string} [length='long'] - the length of the month representation, such as "numeric", "2-digit", "narrow", "short", "long"
   * @param {Object} opts - options
   * @param {string} [opts.locale] - the locale code
   * @param {string} [opts.numberingSystem=null] - the numbering system
   * @param {string} [opts.locObj=null] - an existing locale object to use
   * @param {string} [opts.outputCalendar='gregory'] - the calendar
   * @return {Array}
   */
  ;

  Info.monthsFormat = function monthsFormat(length, _temp2) {
    if (length === void 0) {
      length = "long";
    }

    var _ref2 = _temp2 === void 0 ? {} : _temp2,
        _ref2$locale = _ref2.locale,
        locale = _ref2$locale === void 0 ? null : _ref2$locale,
        _ref2$numberingSystem = _ref2.numberingSystem,
        numberingSystem = _ref2$numberingSystem === void 0 ? null : _ref2$numberingSystem,
        _ref2$locObj = _ref2.locObj,
        locObj = _ref2$locObj === void 0 ? null : _ref2$locObj,
        _ref2$outputCalendar = _ref2.outputCalendar,
        outputCalendar = _ref2$outputCalendar === void 0 ? "gregory" : _ref2$outputCalendar;

    return (locObj || Locale.create(locale, numberingSystem, outputCalendar)).months(length, true);
  }
  /**
   * Return an array of standalone week names.
   * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/DateTimeFormat
   * @param {string} [length='long'] - the length of the weekday representation, such as "narrow", "short", "long".
   * @param {Object} opts - options
   * @param {string} [opts.locale] - the locale code
   * @param {string} [opts.numberingSystem=null] - the numbering system
   * @param {string} [opts.locObj=null] - an existing locale object to use
   * @example Info.weekdays()[0] //=> 'Monday'
   * @example Info.weekdays('short')[0] //=> 'Mon'
   * @example Info.weekdays('short', { locale: 'fr-CA' })[0] //=> 'lun.'
   * @example Info.weekdays('short', { locale: 'ar' })[0] //=> 'الاثنين'
   * @return {Array}
   */
  ;

  Info.weekdays = function weekdays(length, _temp3) {
    if (length === void 0) {
      length = "long";
    }

    var _ref3 = _temp3 === void 0 ? {} : _temp3,
        _ref3$locale = _ref3.locale,
        locale = _ref3$locale === void 0 ? null : _ref3$locale,
        _ref3$numberingSystem = _ref3.numberingSystem,
        numberingSystem = _ref3$numberingSystem === void 0 ? null : _ref3$numberingSystem,
        _ref3$locObj = _ref3.locObj,
        locObj = _ref3$locObj === void 0 ? null : _ref3$locObj;

    return (locObj || Locale.create(locale, numberingSystem, null)).weekdays(length);
  }
  /**
   * Return an array of format week names.
   * Format weekdays differ from standalone weekdays in that they're meant to appear next to more date information. In some languages, that
   * changes the string.
   * See {@link Info#weekdays}
   * @param {string} [length='long'] - the length of the month representation, such as "narrow", "short", "long".
   * @param {Object} opts - options
   * @param {string} [opts.locale=null] - the locale code
   * @param {string} [opts.numberingSystem=null] - the numbering system
   * @param {string} [opts.locObj=null] - an existing locale object to use
   * @return {Array}
   */
  ;

  Info.weekdaysFormat = function weekdaysFormat(length, _temp4) {
    if (length === void 0) {
      length = "long";
    }

    var _ref4 = _temp4 === void 0 ? {} : _temp4,
        _ref4$locale = _ref4.locale,
        locale = _ref4$locale === void 0 ? null : _ref4$locale,
        _ref4$numberingSystem = _ref4.numberingSystem,
        numberingSystem = _ref4$numberingSystem === void 0 ? null : _ref4$numberingSystem,
        _ref4$locObj = _ref4.locObj,
        locObj = _ref4$locObj === void 0 ? null : _ref4$locObj;

    return (locObj || Locale.create(locale, numberingSystem, null)).weekdays(length, true);
  }
  /**
   * Return an array of meridiems.
   * @param {Object} opts - options
   * @param {string} [opts.locale] - the locale code
   * @example Info.meridiems() //=> [ 'AM', 'PM' ]
   * @example Info.meridiems({ locale: 'my' }) //=> [ 'နံနက်', 'ညနေ' ]
   * @return {Array}
   */
  ;

  Info.meridiems = function meridiems(_temp5) {
    var _ref5 = _temp5 === void 0 ? {} : _temp5,
        _ref5$locale = _ref5.locale,
        locale = _ref5$locale === void 0 ? null : _ref5$locale;

    return Locale.create(locale).meridiems();
  }
  /**
   * Return an array of eras, such as ['BC', 'AD']. The locale can be specified, but the calendar system is always Gregorian.
   * @param {string} [length='short'] - the length of the era representation, such as "short" or "long".
   * @param {Object} opts - options
   * @param {string} [opts.locale] - the locale code
   * @example Info.eras() //=> [ 'BC', 'AD' ]
   * @example Info.eras('long') //=> [ 'Before Christ', 'Anno Domini' ]
   * @example Info.eras('long', { locale: 'fr' }) //=> [ 'avant Jésus-Christ', 'après Jésus-Christ' ]
   * @return {Array}
   */
  ;

  Info.eras = function eras(length, _temp6) {
    if (length === void 0) {
      length = "short";
    }

    var _ref6 = _temp6 === void 0 ? {} : _temp6,
        _ref6$locale = _ref6.locale,
        locale = _ref6$locale === void 0 ? null : _ref6$locale;

    return Locale.create(locale, null, "gregory").eras(length);
  }
  /**
   * Return the set of available features in this environment.
   * Some features of Luxon are not available in all environments. For example, on older browsers, relative time formatting support is not available. Use this function to figure out if that's the case.
   * Keys:
   * * `relative`: whether this environment supports relative time formatting
   * @example Info.features() //=> { relative: false }
   * @return {Object}
   */
  ;

  Info.features = function features() {
    return {
      relative: hasRelative()
    };
  };

  return Info;
}();

function dayDiff(earlier, later) {
  var utcDayStart = function utcDayStart(dt) {
    return dt.toUTC(0, {
      keepLocalTime: true
    }).startOf("day").valueOf();
  },
      ms = utcDayStart(later) - utcDayStart(earlier);

  return Math.floor(Duration.fromMillis(ms).as("days"));
}

function highOrderDiffs(cursor, later, units) {
  var differs = [["years", function (a, b) {
    return b.year - a.year;
  }], ["quarters", function (a, b) {
    return b.quarter - a.quarter;
  }], ["months", function (a, b) {
    return b.month - a.month + (b.year - a.year) * 12;
  }], ["weeks", function (a, b) {
    var days = dayDiff(a, b);
    return (days - days % 7) / 7;
  }], ["days", dayDiff]];
  var results = {};
  var lowestOrder, highWater;

  for (var _i = 0, _differs = differs; _i < _differs.length; _i++) {
    var _differs$_i = _differs[_i],
        unit = _differs$_i[0],
        differ = _differs$_i[1];

    if (units.indexOf(unit) >= 0) {
      var _cursor$plus;

      lowestOrder = unit;
      var delta = differ(cursor, later);
      highWater = cursor.plus((_cursor$plus = {}, _cursor$plus[unit] = delta, _cursor$plus));

      if (highWater > later) {
        var _cursor$plus2;

        cursor = cursor.plus((_cursor$plus2 = {}, _cursor$plus2[unit] = delta - 1, _cursor$plus2));
        delta -= 1;
      } else {
        cursor = highWater;
      }

      results[unit] = delta;
    }
  }

  return [cursor, results, highWater, lowestOrder];
}

function _diff (earlier, later, units, opts) {
  var _highOrderDiffs = highOrderDiffs(earlier, later, units),
      cursor = _highOrderDiffs[0],
      results = _highOrderDiffs[1],
      highWater = _highOrderDiffs[2],
      lowestOrder = _highOrderDiffs[3];

  var remainingMillis = later - cursor;
  var lowerOrderUnits = units.filter(function (u) {
    return ["hours", "minutes", "seconds", "milliseconds"].indexOf(u) >= 0;
  });

  if (lowerOrderUnits.length === 0) {
    if (highWater < later) {
      var _cursor$plus3;

      highWater = cursor.plus((_cursor$plus3 = {}, _cursor$plus3[lowestOrder] = 1, _cursor$plus3));
    }

    if (highWater !== cursor) {
      results[lowestOrder] = (results[lowestOrder] || 0) + remainingMillis / (highWater - cursor);
    }
  }

  var duration = Duration.fromObject(results, opts);

  if (lowerOrderUnits.length > 0) {
    var _Duration$fromMillis;

    return (_Duration$fromMillis = Duration.fromMillis(remainingMillis, opts)).shiftTo.apply(_Duration$fromMillis, lowerOrderUnits).plus(duration);
  } else {
    return duration;
  }
}

var numberingSystems = {
  arab: "[\u0660-\u0669]",
  arabext: "[\u06F0-\u06F9]",
  bali: "[\u1B50-\u1B59]",
  beng: "[\u09E6-\u09EF]",
  deva: "[\u0966-\u096F]",
  fullwide: "[\uFF10-\uFF19]",
  gujr: "[\u0AE6-\u0AEF]",
  hanidec: "[〇|一|二|三|四|五|六|七|八|九]",
  khmr: "[\u17E0-\u17E9]",
  knda: "[\u0CE6-\u0CEF]",
  laoo: "[\u0ED0-\u0ED9]",
  limb: "[\u1946-\u194F]",
  mlym: "[\u0D66-\u0D6F]",
  mong: "[\u1810-\u1819]",
  mymr: "[\u1040-\u1049]",
  orya: "[\u0B66-\u0B6F]",
  tamldec: "[\u0BE6-\u0BEF]",
  telu: "[\u0C66-\u0C6F]",
  thai: "[\u0E50-\u0E59]",
  tibt: "[\u0F20-\u0F29]",
  latn: "\\d"
};
var numberingSystemsUTF16 = {
  arab: [1632, 1641],
  arabext: [1776, 1785],
  bali: [6992, 7001],
  beng: [2534, 2543],
  deva: [2406, 2415],
  fullwide: [65296, 65303],
  gujr: [2790, 2799],
  khmr: [6112, 6121],
  knda: [3302, 3311],
  laoo: [3792, 3801],
  limb: [6470, 6479],
  mlym: [3430, 3439],
  mong: [6160, 6169],
  mymr: [4160, 4169],
  orya: [2918, 2927],
  tamldec: [3046, 3055],
  telu: [3174, 3183],
  thai: [3664, 3673],
  tibt: [3872, 3881]
};
var hanidecChars = numberingSystems.hanidec.replace(/[\[|\]]/g, "").split("");
function parseDigits(str) {
  var value = parseInt(str, 10);

  if (isNaN(value)) {
    value = "";

    for (var i = 0; i < str.length; i++) {
      var code = str.charCodeAt(i);

      if (str[i].search(numberingSystems.hanidec) !== -1) {
        value += hanidecChars.indexOf(str[i]);
      } else {
        for (var key in numberingSystemsUTF16) {
          var _numberingSystemsUTF = numberingSystemsUTF16[key],
              min = _numberingSystemsUTF[0],
              max = _numberingSystemsUTF[1];

          if (code >= min && code <= max) {
            value += code - min;
          }
        }
      }
    }

    return parseInt(value, 10);
  } else {
    return value;
  }
}
function digitRegex(_ref, append) {
  var numberingSystem = _ref.numberingSystem;

  if (append === void 0) {
    append = "";
  }

  return new RegExp("" + numberingSystems[numberingSystem || "latn"] + append);
}

var MISSING_FTP = "missing Intl.DateTimeFormat.formatToParts support";

function intUnit(regex, post) {
  if (post === void 0) {
    post = function post(i) {
      return i;
    };
  }

  return {
    regex: regex,
    deser: function deser(_ref) {
      var s = _ref[0];
      return post(parseDigits(s));
    }
  };
}

var NBSP = String.fromCharCode(160);
var spaceOrNBSP = "[ " + NBSP + "]";
var spaceOrNBSPRegExp = new RegExp(spaceOrNBSP, "g");

function fixListRegex(s) {
  // make dots optional and also make them literal
  // make space and non breakable space characters interchangeable
  return s.replace(/\./g, "\\.?").replace(spaceOrNBSPRegExp, spaceOrNBSP);
}

function stripInsensitivities(s) {
  return s.replace(/\./g, "") // ignore dots that were made optional
  .replace(spaceOrNBSPRegExp, " ") // interchange space and nbsp
  .toLowerCase();
}

function oneOf(strings, startIndex) {
  if (strings === null) {
    return null;
  } else {
    return {
      regex: RegExp(strings.map(fixListRegex).join("|")),
      deser: function deser(_ref2) {
        var s = _ref2[0];
        return strings.findIndex(function (i) {
          return stripInsensitivities(s) === stripInsensitivities(i);
        }) + startIndex;
      }
    };
  }
}

function offset(regex, groups) {
  return {
    regex: regex,
    deser: function deser(_ref3) {
      var h = _ref3[1],
          m = _ref3[2];
      return signedOffset(h, m);
    },
    groups: groups
  };
}

function simple(regex) {
  return {
    regex: regex,
    deser: function deser(_ref4) {
      var s = _ref4[0];
      return s;
    }
  };
}

function escapeToken(value) {
  return value.replace(/[\-\[\]{}()*+?.,\\\^$|#\s]/g, "\\$&");
}

function unitForToken(token, loc) {
  var one = digitRegex(loc),
      two = digitRegex(loc, "{2}"),
      three = digitRegex(loc, "{3}"),
      four = digitRegex(loc, "{4}"),
      six = digitRegex(loc, "{6}"),
      oneOrTwo = digitRegex(loc, "{1,2}"),
      oneToThree = digitRegex(loc, "{1,3}"),
      oneToSix = digitRegex(loc, "{1,6}"),
      oneToNine = digitRegex(loc, "{1,9}"),
      twoToFour = digitRegex(loc, "{2,4}"),
      fourToSix = digitRegex(loc, "{4,6}"),
      literal = function literal(t) {
    return {
      regex: RegExp(escapeToken(t.val)),
      deser: function deser(_ref5) {
        var s = _ref5[0];
        return s;
      },
      literal: true
    };
  },
      unitate = function unitate(t) {
    if (token.literal) {
      return literal(t);
    }

    switch (t.val) {
      // era
      case "G":
        return oneOf(loc.eras("short", false), 0);

      case "GG":
        return oneOf(loc.eras("long", false), 0);
      // years

      case "y":
        return intUnit(oneToSix);

      case "yy":
        return intUnit(twoToFour, untruncateYear);

      case "yyyy":
        return intUnit(four);

      case "yyyyy":
        return intUnit(fourToSix);

      case "yyyyyy":
        return intUnit(six);
      // months

      case "M":
        return intUnit(oneOrTwo);

      case "MM":
        return intUnit(two);

      case "MMM":
        return oneOf(loc.months("short", true, false), 1);

      case "MMMM":
        return oneOf(loc.months("long", true, false), 1);

      case "L":
        return intUnit(oneOrTwo);

      case "LL":
        return intUnit(two);

      case "LLL":
        return oneOf(loc.months("short", false, false), 1);

      case "LLLL":
        return oneOf(loc.months("long", false, false), 1);
      // dates

      case "d":
        return intUnit(oneOrTwo);

      case "dd":
        return intUnit(two);
      // ordinals

      case "o":
        return intUnit(oneToThree);

      case "ooo":
        return intUnit(three);
      // time

      case "HH":
        return intUnit(two);

      case "H":
        return intUnit(oneOrTwo);

      case "hh":
        return intUnit(two);

      case "h":
        return intUnit(oneOrTwo);

      case "mm":
        return intUnit(two);

      case "m":
        return intUnit(oneOrTwo);

      case "q":
        return intUnit(oneOrTwo);

      case "qq":
        return intUnit(two);

      case "s":
        return intUnit(oneOrTwo);

      case "ss":
        return intUnit(two);

      case "S":
        return intUnit(oneToThree);

      case "SSS":
        return intUnit(three);

      case "u":
        return simple(oneToNine);

      case "uu":
        return simple(oneOrTwo);

      case "uuu":
        return intUnit(one);
      // meridiem

      case "a":
        return oneOf(loc.meridiems(), 0);
      // weekYear (k)

      case "kkkk":
        return intUnit(four);

      case "kk":
        return intUnit(twoToFour, untruncateYear);
      // weekNumber (W)

      case "W":
        return intUnit(oneOrTwo);

      case "WW":
        return intUnit(two);
      // weekdays

      case "E":
      case "c":
        return intUnit(one);

      case "EEE":
        return oneOf(loc.weekdays("short", false, false), 1);

      case "EEEE":
        return oneOf(loc.weekdays("long", false, false), 1);

      case "ccc":
        return oneOf(loc.weekdays("short", true, false), 1);

      case "cccc":
        return oneOf(loc.weekdays("long", true, false), 1);
      // offset/zone

      case "Z":
      case "ZZ":
        return offset(new RegExp("([+-]" + oneOrTwo.source + ")(?::(" + two.source + "))?"), 2);

      case "ZZZ":
        return offset(new RegExp("([+-]" + oneOrTwo.source + ")(" + two.source + ")?"), 2);
      // we don't support ZZZZ (PST) or ZZZZZ (Pacific Standard Time) in parsing
      // because we don't have any way to figure out what they are

      case "z":
        return simple(/[a-z_+-/]{1,256}?/i);

      default:
        return literal(t);
    }
  };

  var unit = unitate(token) || {
    invalidReason: MISSING_FTP
  };
  unit.token = token;
  return unit;
}

var partTypeStyleToTokenVal = {
  year: {
    "2-digit": "yy",
    numeric: "yyyyy"
  },
  month: {
    numeric: "M",
    "2-digit": "MM",
    short: "MMM",
    long: "MMMM"
  },
  day: {
    numeric: "d",
    "2-digit": "dd"
  },
  weekday: {
    short: "EEE",
    long: "EEEE"
  },
  dayperiod: "a",
  dayPeriod: "a",
  hour: {
    numeric: "h",
    "2-digit": "hh"
  },
  minute: {
    numeric: "m",
    "2-digit": "mm"
  },
  second: {
    numeric: "s",
    "2-digit": "ss"
  }
};

function tokenForPart(part, locale, formatOpts) {
  var type = part.type,
      value = part.value;

  if (type === "literal") {
    return {
      literal: true,
      val: value
    };
  }

  var style = formatOpts[type];
  var val = partTypeStyleToTokenVal[type];

  if (typeof val === "object") {
    val = val[style];
  }

  if (val) {
    return {
      literal: false,
      val: val
    };
  }

  return undefined;
}

function buildRegex(units) {
  var re = units.map(function (u) {
    return u.regex;
  }).reduce(function (f, r) {
    return f + "(" + r.source + ")";
  }, "");
  return ["^" + re + "$", units];
}

function match(input, regex, handlers) {
  var matches = input.match(regex);

  if (matches) {
    var all = {};
    var matchIndex = 1;

    for (var i in handlers) {
      if (hasOwnProperty(handlers, i)) {
        var h = handlers[i],
            groups = h.groups ? h.groups + 1 : 1;

        if (!h.literal && h.token) {
          all[h.token.val[0]] = h.deser(matches.slice(matchIndex, matchIndex + groups));
        }

        matchIndex += groups;
      }
    }

    return [matches, all];
  } else {
    return [matches, {}];
  }
}

function dateTimeFromMatches(matches) {
  var toField = function toField(token) {
    switch (token) {
      case "S":
        return "millisecond";

      case "s":
        return "second";

      case "m":
        return "minute";

      case "h":
      case "H":
        return "hour";

      case "d":
        return "day";

      case "o":
        return "ordinal";

      case "L":
      case "M":
        return "month";

      case "y":
        return "year";

      case "E":
      case "c":
        return "weekday";

      case "W":
        return "weekNumber";

      case "k":
        return "weekYear";

      case "q":
        return "quarter";

      default:
        return null;
    }
  };

  var zone = null;
  var specificOffset;

  if (!isUndefined(matches.z)) {
    zone = IANAZone.create(matches.z);
  }

  if (!isUndefined(matches.Z)) {
    if (!zone) {
      zone = new FixedOffsetZone(matches.Z);
    }

    specificOffset = matches.Z;
  }

  if (!isUndefined(matches.q)) {
    matches.M = (matches.q - 1) * 3 + 1;
  }

  if (!isUndefined(matches.h)) {
    if (matches.h < 12 && matches.a === 1) {
      matches.h += 12;
    } else if (matches.h === 12 && matches.a === 0) {
      matches.h = 0;
    }
  }

  if (matches.G === 0 && matches.y) {
    matches.y = -matches.y;
  }

  if (!isUndefined(matches.u)) {
    matches.S = parseMillis(matches.u);
  }

  var vals = Object.keys(matches).reduce(function (r, k) {
    var f = toField(k);

    if (f) {
      r[f] = matches[k];
    }

    return r;
  }, {});
  return [vals, zone, specificOffset];
}

var dummyDateTimeCache = null;

function getDummyDateTime() {
  if (!dummyDateTimeCache) {
    dummyDateTimeCache = DateTime.fromMillis(1555555555555);
  }

  return dummyDateTimeCache;
}

function maybeExpandMacroToken(token, locale) {
  if (token.literal) {
    return token;
  }

  var formatOpts = Formatter.macroTokenToFormatOpts(token.val);

  if (!formatOpts) {
    return token;
  }

  var formatter = Formatter.create(locale, formatOpts);
  var parts = formatter.formatDateTimeParts(getDummyDateTime());
  var tokens = parts.map(function (p) {
    return tokenForPart(p, locale, formatOpts);
  });

  if (tokens.includes(undefined)) {
    return token;
  }

  return tokens;
}

function expandMacroTokens(tokens, locale) {
  var _Array$prototype;

  return (_Array$prototype = Array.prototype).concat.apply(_Array$prototype, tokens.map(function (t) {
    return maybeExpandMacroToken(t, locale);
  }));
}
/**
 * @private
 */


function explainFromTokens(locale, input, format) {
  var tokens = expandMacroTokens(Formatter.parseFormat(format), locale),
      units = tokens.map(function (t) {
    return unitForToken(t, locale);
  }),
      disqualifyingUnit = units.find(function (t) {
    return t.invalidReason;
  });

  if (disqualifyingUnit) {
    return {
      input: input,
      tokens: tokens,
      invalidReason: disqualifyingUnit.invalidReason
    };
  } else {
    var _buildRegex = buildRegex(units),
        regexString = _buildRegex[0],
        handlers = _buildRegex[1],
        regex = RegExp(regexString, "i"),
        _match = match(input, regex, handlers),
        rawMatches = _match[0],
        matches = _match[1],
        _ref6 = matches ? dateTimeFromMatches(matches) : [null, null, undefined],
        result = _ref6[0],
        zone = _ref6[1],
        specificOffset = _ref6[2];

    if (hasOwnProperty(matches, "a") && hasOwnProperty(matches, "H")) {
      throw new ConflictingSpecificationError("Can't include meridiem when specifying 24-hour format");
    }

    return {
      input: input,
      tokens: tokens,
      regex: regex,
      rawMatches: rawMatches,
      matches: matches,
      result: result,
      zone: zone,
      specificOffset: specificOffset
    };
  }
}
function parseFromTokens(locale, input, format) {
  var _explainFromTokens = explainFromTokens(locale, input, format),
      result = _explainFromTokens.result,
      zone = _explainFromTokens.zone,
      specificOffset = _explainFromTokens.specificOffset,
      invalidReason = _explainFromTokens.invalidReason;

  return [result, zone, specificOffset, invalidReason];
}

var nonLeapLadder = [0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334],
    leapLadder = [0, 31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335];

function unitOutOfRange(unit, value) {
  return new Invalid("unit out of range", "you specified " + value + " (of type " + typeof value + ") as a " + unit + ", which is invalid");
}

function dayOfWeek(year, month, day) {
  var d = new Date(Date.UTC(year, month - 1, day));

  if (year < 100 && year >= 0) {
    d.setUTCFullYear(d.getUTCFullYear() - 1900);
  }

  var js = d.getUTCDay();
  return js === 0 ? 7 : js;
}

function computeOrdinal(year, month, day) {
  return day + (isLeapYear(year) ? leapLadder : nonLeapLadder)[month - 1];
}

function uncomputeOrdinal(year, ordinal) {
  var table = isLeapYear(year) ? leapLadder : nonLeapLadder,
      month0 = table.findIndex(function (i) {
    return i < ordinal;
  }),
      day = ordinal - table[month0];
  return {
    month: month0 + 1,
    day: day
  };
}
/**
 * @private
 */


function gregorianToWeek(gregObj) {
  var year = gregObj.year,
      month = gregObj.month,
      day = gregObj.day,
      ordinal = computeOrdinal(year, month, day),
      weekday = dayOfWeek(year, month, day);
  var weekNumber = Math.floor((ordinal - weekday + 10) / 7),
      weekYear;

  if (weekNumber < 1) {
    weekYear = year - 1;
    weekNumber = weeksInWeekYear(weekYear);
  } else if (weekNumber > weeksInWeekYear(year)) {
    weekYear = year + 1;
    weekNumber = 1;
  } else {
    weekYear = year;
  }

  return _extends({
    weekYear: weekYear,
    weekNumber: weekNumber,
    weekday: weekday
  }, timeObject(gregObj));
}
function weekToGregorian(weekData) {
  var weekYear = weekData.weekYear,
      weekNumber = weekData.weekNumber,
      weekday = weekData.weekday,
      weekdayOfJan4 = dayOfWeek(weekYear, 1, 4),
      yearInDays = daysInYear(weekYear);
  var ordinal = weekNumber * 7 + weekday - weekdayOfJan4 - 3,
      year;

  if (ordinal < 1) {
    year = weekYear - 1;
    ordinal += daysInYear(year);
  } else if (ordinal > yearInDays) {
    year = weekYear + 1;
    ordinal -= daysInYear(weekYear);
  } else {
    year = weekYear;
  }

  var _uncomputeOrdinal = uncomputeOrdinal(year, ordinal),
      month = _uncomputeOrdinal.month,
      day = _uncomputeOrdinal.day;

  return _extends({
    year: year,
    month: month,
    day: day
  }, timeObject(weekData));
}
function gregorianToOrdinal(gregData) {
  var year = gregData.year,
      month = gregData.month,
      day = gregData.day;
  var ordinal = computeOrdinal(year, month, day);
  return _extends({
    year: year,
    ordinal: ordinal
  }, timeObject(gregData));
}
function ordinalToGregorian(ordinalData) {
  var year = ordinalData.year,
      ordinal = ordinalData.ordinal;

  var _uncomputeOrdinal2 = uncomputeOrdinal(year, ordinal),
      month = _uncomputeOrdinal2.month,
      day = _uncomputeOrdinal2.day;

  return _extends({
    year: year,
    month: month,
    day: day
  }, timeObject(ordinalData));
}
function hasInvalidWeekData(obj) {
  var validYear = isInteger(obj.weekYear),
      validWeek = integerBetween(obj.weekNumber, 1, weeksInWeekYear(obj.weekYear)),
      validWeekday = integerBetween(obj.weekday, 1, 7);

  if (!validYear) {
    return unitOutOfRange("weekYear", obj.weekYear);
  } else if (!validWeek) {
    return unitOutOfRange("week", obj.week);
  } else if (!validWeekday) {
    return unitOutOfRange("weekday", obj.weekday);
  } else return false;
}
function hasInvalidOrdinalData(obj) {
  var validYear = isInteger(obj.year),
      validOrdinal = integerBetween(obj.ordinal, 1, daysInYear(obj.year));

  if (!validYear) {
    return unitOutOfRange("year", obj.year);
  } else if (!validOrdinal) {
    return unitOutOfRange("ordinal", obj.ordinal);
  } else return false;
}
function hasInvalidGregorianData(obj) {
  var validYear = isInteger(obj.year),
      validMonth = integerBetween(obj.month, 1, 12),
      validDay = integerBetween(obj.day, 1, daysInMonth(obj.year, obj.month));

  if (!validYear) {
    return unitOutOfRange("year", obj.year);
  } else if (!validMonth) {
    return unitOutOfRange("month", obj.month);
  } else if (!validDay) {
    return unitOutOfRange("day", obj.day);
  } else return false;
}
function hasInvalidTimeData(obj) {
  var hour = obj.hour,
      minute = obj.minute,
      second = obj.second,
      millisecond = obj.millisecond;
  var validHour = integerBetween(hour, 0, 23) || hour === 24 && minute === 0 && second === 0 && millisecond === 0,
      validMinute = integerBetween(minute, 0, 59),
      validSecond = integerBetween(second, 0, 59),
      validMillisecond = integerBetween(millisecond, 0, 999);

  if (!validHour) {
    return unitOutOfRange("hour", hour);
  } else if (!validMinute) {
    return unitOutOfRange("minute", minute);
  } else if (!validSecond) {
    return unitOutOfRange("second", second);
  } else if (!validMillisecond) {
    return unitOutOfRange("millisecond", millisecond);
  } else return false;
}

var INVALID = "Invalid DateTime";
var MAX_DATE = 8.64e15;

function unsupportedZone(zone) {
  return new Invalid("unsupported zone", "the zone \"" + zone.name + "\" is not supported");
} // we cache week data on the DT object and this intermediates the cache


function possiblyCachedWeekData(dt) {
  if (dt.weekData === null) {
    dt.weekData = gregorianToWeek(dt.c);
  }

  return dt.weekData;
} // clone really means, "make a new object with these modifications". all "setters" really use this
// to create a new object while only changing some of the properties


function clone(inst, alts) {
  var current = {
    ts: inst.ts,
    zone: inst.zone,
    c: inst.c,
    o: inst.o,
    loc: inst.loc,
    invalid: inst.invalid
  };
  return new DateTime(_extends({}, current, alts, {
    old: current
  }));
} // find the right offset a given local time. The o input is our guess, which determines which
// offset we'll pick in ambiguous cases (e.g. there are two 3 AMs b/c Fallback DST)


function fixOffset(localTS, o, tz) {
  // Our UTC time is just a guess because our offset is just a guess
  var utcGuess = localTS - o * 60 * 1000; // Test whether the zone matches the offset for this ts

  var o2 = tz.offset(utcGuess); // If so, offset didn't change and we're done

  if (o === o2) {
    return [utcGuess, o];
  } // If not, change the ts by the difference in the offset


  utcGuess -= (o2 - o) * 60 * 1000; // If that gives us the local time we want, we're done

  var o3 = tz.offset(utcGuess);

  if (o2 === o3) {
    return [utcGuess, o2];
  } // If it's different, we're in a hole time. The offset has changed, but the we don't adjust the time


  return [localTS - Math.min(o2, o3) * 60 * 1000, Math.max(o2, o3)];
} // convert an epoch timestamp into a calendar object with the given offset


function tsToObj(ts, offset) {
  ts += offset * 60 * 1000;
  var d = new Date(ts);
  return {
    year: d.getUTCFullYear(),
    month: d.getUTCMonth() + 1,
    day: d.getUTCDate(),
    hour: d.getUTCHours(),
    minute: d.getUTCMinutes(),
    second: d.getUTCSeconds(),
    millisecond: d.getUTCMilliseconds()
  };
} // convert a calendar object to a epoch timestamp


function objToTS(obj, offset, zone) {
  return fixOffset(objToLocalTS(obj), offset, zone);
} // create a new DT instance by adding a duration, adjusting for DSTs


function adjustTime(inst, dur) {
  var oPre = inst.o,
      year = inst.c.year + Math.trunc(dur.years),
      month = inst.c.month + Math.trunc(dur.months) + Math.trunc(dur.quarters) * 3,
      c = _extends({}, inst.c, {
    year: year,
    month: month,
    day: Math.min(inst.c.day, daysInMonth(year, month)) + Math.trunc(dur.days) + Math.trunc(dur.weeks) * 7
  }),
      millisToAdd = Duration.fromObject({
    years: dur.years - Math.trunc(dur.years),
    quarters: dur.quarters - Math.trunc(dur.quarters),
    months: dur.months - Math.trunc(dur.months),
    weeks: dur.weeks - Math.trunc(dur.weeks),
    days: dur.days - Math.trunc(dur.days),
    hours: dur.hours,
    minutes: dur.minutes,
    seconds: dur.seconds,
    milliseconds: dur.milliseconds
  }).as("milliseconds"),
      localTS = objToLocalTS(c);

  var _fixOffset = fixOffset(localTS, oPre, inst.zone),
      ts = _fixOffset[0],
      o = _fixOffset[1];

  if (millisToAdd !== 0) {
    ts += millisToAdd; // that could have changed the offset by going over a DST, but we want to keep the ts the same

    o = inst.zone.offset(ts);
  }

  return {
    ts: ts,
    o: o
  };
} // helper useful in turning the results of parsing into real dates
// by handling the zone options


function parseDataToDateTime(parsed, parsedZone, opts, format, text, specificOffset) {
  var setZone = opts.setZone,
      zone = opts.zone;

  if (parsed && Object.keys(parsed).length !== 0) {
    var interpretationZone = parsedZone || zone,
        inst = DateTime.fromObject(parsed, _extends({}, opts, {
      zone: interpretationZone,
      specificOffset: specificOffset
    }));
    return setZone ? inst : inst.setZone(zone);
  } else {
    return DateTime.invalid(new Invalid("unparsable", "the input \"" + text + "\" can't be parsed as " + format));
  }
} // if you want to output a technical format (e.g. RFC 2822), this helper
// helps handle the details


function toTechFormat(dt, format, allowZ) {
  if (allowZ === void 0) {
    allowZ = true;
  }

  return dt.isValid ? Formatter.create(Locale.create("en-US"), {
    allowZ: allowZ,
    forceSimple: true
  }).formatDateTimeFromString(dt, format) : null;
}

function _toISODate(o, extended) {
  var longFormat = o.c.year > 9999 || o.c.year < 0;
  var c = "";
  if (longFormat && o.c.year >= 0) c += "+";
  c += padStart(o.c.year, longFormat ? 6 : 4);

  if (extended) {
    c += "-";
    c += padStart(o.c.month);
    c += "-";
    c += padStart(o.c.day);
  } else {
    c += padStart(o.c.month);
    c += padStart(o.c.day);
  }

  return c;
}

function _toISOTime(o, extended, suppressSeconds, suppressMilliseconds, includeOffset, extendedZone) {
  var c = padStart(o.c.hour);

  if (extended) {
    c += ":";
    c += padStart(o.c.minute);

    if (o.c.second !== 0 || !suppressSeconds) {
      c += ":";
    }
  } else {
    c += padStart(o.c.minute);
  }

  if (o.c.second !== 0 || !suppressSeconds) {
    c += padStart(o.c.second);

    if (o.c.millisecond !== 0 || !suppressMilliseconds) {
      c += ".";
      c += padStart(o.c.millisecond, 3);
    }
  }

  if (includeOffset) {
    if (o.isOffsetFixed && o.offset === 0 && !extendedZone) {
      c += "Z";
    } else if (o.o < 0) {
      c += "-";
      c += padStart(Math.trunc(-o.o / 60));
      c += ":";
      c += padStart(Math.trunc(-o.o % 60));
    } else {
      c += "+";
      c += padStart(Math.trunc(o.o / 60));
      c += ":";
      c += padStart(Math.trunc(o.o % 60));
    }
  }

  if (extendedZone) {
    c += "[" + o.zone.ianaName + "]";
  }

  return c;
} // defaults for unspecified units in the supported calendars


var defaultUnitValues = {
  month: 1,
  day: 1,
  hour: 0,
  minute: 0,
  second: 0,
  millisecond: 0
},
    defaultWeekUnitValues = {
  weekNumber: 1,
  weekday: 1,
  hour: 0,
  minute: 0,
  second: 0,
  millisecond: 0
},
    defaultOrdinalUnitValues = {
  ordinal: 1,
  hour: 0,
  minute: 0,
  second: 0,
  millisecond: 0
}; // Units in the supported calendars, sorted by bigness

var orderedUnits = ["year", "month", "day", "hour", "minute", "second", "millisecond"],
    orderedWeekUnits = ["weekYear", "weekNumber", "weekday", "hour", "minute", "second", "millisecond"],
    orderedOrdinalUnits = ["year", "ordinal", "hour", "minute", "second", "millisecond"]; // standardize case and plurality in units

function normalizeUnit(unit) {
  var normalized = {
    year: "year",
    years: "year",
    month: "month",
    months: "month",
    day: "day",
    days: "day",
    hour: "hour",
    hours: "hour",
    minute: "minute",
    minutes: "minute",
    quarter: "quarter",
    quarters: "quarter",
    second: "second",
    seconds: "second",
    millisecond: "millisecond",
    milliseconds: "millisecond",
    weekday: "weekday",
    weekdays: "weekday",
    weeknumber: "weekNumber",
    weeksnumber: "weekNumber",
    weeknumbers: "weekNumber",
    weekyear: "weekYear",
    weekyears: "weekYear",
    ordinal: "ordinal"
  }[unit.toLowerCase()];
  if (!normalized) throw new InvalidUnitError(unit);
  return normalized;
} // this is a dumbed down version of fromObject() that runs about 60% faster
// but doesn't do any validation, makes a bunch of assumptions about what units
// are present, and so on.


function quickDT(obj, opts) {
  var zone = normalizeZone(opts.zone, Settings.defaultZone),
      loc = Locale.fromObject(opts),
      tsNow = Settings.now();
  var ts, o; // assume we have the higher-order units

  if (!isUndefined(obj.year)) {
    for (var _iterator = _createForOfIteratorHelperLoose(orderedUnits), _step; !(_step = _iterator()).done;) {
      var u = _step.value;

      if (isUndefined(obj[u])) {
        obj[u] = defaultUnitValues[u];
      }
    }

    var invalid = hasInvalidGregorianData(obj) || hasInvalidTimeData(obj);

    if (invalid) {
      return DateTime.invalid(invalid);
    }

    var offsetProvis = zone.offset(tsNow);

    var _objToTS = objToTS(obj, offsetProvis, zone);

    ts = _objToTS[0];
    o = _objToTS[1];
  } else {
    ts = tsNow;
  }

  return new DateTime({
    ts: ts,
    zone: zone,
    loc: loc,
    o: o
  });
}

function diffRelative(start, end, opts) {
  var round = isUndefined(opts.round) ? true : opts.round,
      format = function format(c, unit) {
    c = roundTo(c, round || opts.calendary ? 0 : 2, true);
    var formatter = end.loc.clone(opts).relFormatter(opts);
    return formatter.format(c, unit);
  },
      differ = function differ(unit) {
    if (opts.calendary) {
      if (!end.hasSame(start, unit)) {
        return end.startOf(unit).diff(start.startOf(unit), unit).get(unit);
      } else return 0;
    } else {
      return end.diff(start, unit).get(unit);
    }
  };

  if (opts.unit) {
    return format(differ(opts.unit), opts.unit);
  }

  for (var _iterator2 = _createForOfIteratorHelperLoose(opts.units), _step2; !(_step2 = _iterator2()).done;) {
    var unit = _step2.value;
    var count = differ(unit);

    if (Math.abs(count) >= 1) {
      return format(count, unit);
    }
  }

  return format(start > end ? -0 : 0, opts.units[opts.units.length - 1]);
}

function lastOpts(argList) {
  var opts = {},
      args;

  if (argList.length > 0 && typeof argList[argList.length - 1] === "object") {
    opts = argList[argList.length - 1];
    args = Array.from(argList).slice(0, argList.length - 1);
  } else {
    args = Array.from(argList);
  }

  return [opts, args];
}
/**
 * A DateTime is an immutable data structure representing a specific date and time and accompanying methods. It contains class and instance methods for creating, parsing, interrogating, transforming, and formatting them.
 *
 * A DateTime comprises of:
 * * A timestamp. Each DateTime instance refers to a specific millisecond of the Unix epoch.
 * * A time zone. Each instance is considered in the context of a specific zone (by default the local system's zone).
 * * Configuration properties that effect how output strings are formatted, such as `locale`, `numberingSystem`, and `outputCalendar`.
 *
 * Here is a brief overview of the most commonly used functionality it provides:
 *
 * * **Creation**: To create a DateTime from its components, use one of its factory class methods: {@link DateTime#local}, {@link DateTime#utc}, and (most flexibly) {@link DateTime#fromObject}. To create one from a standard string format, use {@link DateTime#fromISO}, {@link DateTime#fromHTTP}, and {@link DateTime#fromRFC2822}. To create one from a custom string format, use {@link DateTime#fromFormat}. To create one from a native JS date, use {@link DateTime#fromJSDate}.
 * * **Gregorian calendar and time**: To examine the Gregorian properties of a DateTime individually (i.e as opposed to collectively through {@link DateTime#toObject}), use the {@link DateTime#year}, {@link DateTime#month},
 * {@link DateTime#day}, {@link DateTime#hour}, {@link DateTime#minute}, {@link DateTime#second}, {@link DateTime#millisecond} accessors.
 * * **Week calendar**: For ISO week calendar attributes, see the {@link DateTime#weekYear}, {@link DateTime#weekNumber}, and {@link DateTime#weekday} accessors.
 * * **Configuration** See the {@link DateTime#locale} and {@link DateTime#numberingSystem} accessors.
 * * **Transformation**: To transform the DateTime into other DateTimes, use {@link DateTime#set}, {@link DateTime#reconfigure}, {@link DateTime#setZone}, {@link DateTime#setLocale}, {@link DateTime.plus}, {@link DateTime#minus}, {@link DateTime#endOf}, {@link DateTime#startOf}, {@link DateTime#toUTC}, and {@link DateTime#toLocal}.
 * * **Output**: To convert the DateTime to other representations, use the {@link DateTime#toRelative}, {@link DateTime#toRelativeCalendar}, {@link DateTime#toJSON}, {@link DateTime#toISO}, {@link DateTime#toHTTP}, {@link DateTime#toObject}, {@link DateTime#toRFC2822}, {@link DateTime#toString}, {@link DateTime#toLocaleString}, {@link DateTime#toFormat}, {@link DateTime#toMillis} and {@link DateTime#toJSDate}.
 *
 * There's plenty others documented below. In addition, for more information on subtler topics like internationalization, time zones, alternative calendars, validity, and so on, see the external documentation.
 */


var DateTime = /*#__PURE__*/function () {
  /**
   * @access private
   */
  function DateTime(config) {
    var zone = config.zone || Settings.defaultZone;
    var invalid = config.invalid || (Number.isNaN(config.ts) ? new Invalid("invalid input") : null) || (!zone.isValid ? unsupportedZone(zone) : null);
    /**
     * @access private
     */

    this.ts = isUndefined(config.ts) ? Settings.now() : config.ts;
    var c = null,
        o = null;

    if (!invalid) {
      var unchanged = config.old && config.old.ts === this.ts && config.old.zone.equals(zone);

      if (unchanged) {
        var _ref = [config.old.c, config.old.o];
        c = _ref[0];
        o = _ref[1];
      } else {
        var ot = zone.offset(this.ts);
        c = tsToObj(this.ts, ot);
        invalid = Number.isNaN(c.year) ? new Invalid("invalid input") : null;
        c = invalid ? null : c;
        o = invalid ? null : ot;
      }
    }
    /**
     * @access private
     */


    this._zone = zone;
    /**
     * @access private
     */

    this.loc = config.loc || Locale.create();
    /**
     * @access private
     */

    this.invalid = invalid;
    /**
     * @access private
     */

    this.weekData = null;
    /**
     * @access private
     */

    this.c = c;
    /**
     * @access private
     */

    this.o = o;
    /**
     * @access private
     */

    this.isLuxonDateTime = true;
  } // CONSTRUCT

  /**
   * Create a DateTime for the current instant, in the system's time zone.
   *
   * Use Settings to override these default values if needed.
   * @example DateTime.now().toISO() //~> now in the ISO format
   * @return {DateTime}
   */


  DateTime.now = function now() {
    return new DateTime({});
  }
  /**
   * Create a local DateTime
   * @param {number} [year] - The calendar year. If omitted (as in, call `local()` with no arguments), the current time will be used
   * @param {number} [month=1] - The month, 1-indexed
   * @param {number} [day=1] - The day of the month, 1-indexed
   * @param {number} [hour=0] - The hour of the day, in 24-hour time
   * @param {number} [minute=0] - The minute of the hour, meaning a number between 0 and 59
   * @param {number} [second=0] - The second of the minute, meaning a number between 0 and 59
   * @param {number} [millisecond=0] - The millisecond of the second, meaning a number between 0 and 999
   * @example DateTime.local()                                  //~> now
   * @example DateTime.local({ zone: "America/New_York" })      //~> now, in US east coast time
   * @example DateTime.local(2017)                              //~> 2017-01-01T00:00:00
   * @example DateTime.local(2017, 3)                           //~> 2017-03-01T00:00:00
   * @example DateTime.local(2017, 3, 12, { locale: "fr" })     //~> 2017-03-12T00:00:00, with a French locale
   * @example DateTime.local(2017, 3, 12, 5)                    //~> 2017-03-12T05:00:00
   * @example DateTime.local(2017, 3, 12, 5, { zone: "utc" })   //~> 2017-03-12T05:00:00, in UTC
   * @example DateTime.local(2017, 3, 12, 5, 45)                //~> 2017-03-12T05:45:00
   * @example DateTime.local(2017, 3, 12, 5, 45, 10)            //~> 2017-03-12T05:45:10
   * @example DateTime.local(2017, 3, 12, 5, 45, 10, 765)       //~> 2017-03-12T05:45:10.765
   * @return {DateTime}
   */
  ;

  DateTime.local = function local() {
    var _lastOpts = lastOpts(arguments),
        opts = _lastOpts[0],
        args = _lastOpts[1],
        year = args[0],
        month = args[1],
        day = args[2],
        hour = args[3],
        minute = args[4],
        second = args[5],
        millisecond = args[6];

    return quickDT({
      year: year,
      month: month,
      day: day,
      hour: hour,
      minute: minute,
      second: second,
      millisecond: millisecond
    }, opts);
  }
  /**
   * Create a DateTime in UTC
   * @param {number} [year] - The calendar year. If omitted (as in, call `utc()` with no arguments), the current time will be used
   * @param {number} [month=1] - The month, 1-indexed
   * @param {number} [day=1] - The day of the month
   * @param {number} [hour=0] - The hour of the day, in 24-hour time
   * @param {number} [minute=0] - The minute of the hour, meaning a number between 0 and 59
   * @param {number} [second=0] - The second of the minute, meaning a number between 0 and 59
   * @param {number} [millisecond=0] - The millisecond of the second, meaning a number between 0 and 999
   * @param {Object} options - configuration options for the DateTime
   * @param {string} [options.locale] - a locale to set on the resulting DateTime instance
   * @param {string} [options.outputCalendar] - the output calendar to set on the resulting DateTime instance
   * @param {string} [options.numberingSystem] - the numbering system to set on the resulting DateTime instance
   * @example DateTime.utc()                                              //~> now
   * @example DateTime.utc(2017)                                          //~> 2017-01-01T00:00:00Z
   * @example DateTime.utc(2017, 3)                                       //~> 2017-03-01T00:00:00Z
   * @example DateTime.utc(2017, 3, 12)                                   //~> 2017-03-12T00:00:00Z
   * @example DateTime.utc(2017, 3, 12, 5)                                //~> 2017-03-12T05:00:00Z
   * @example DateTime.utc(2017, 3, 12, 5, 45)                            //~> 2017-03-12T05:45:00Z
   * @example DateTime.utc(2017, 3, 12, 5, 45, { locale: "fr" })          //~> 2017-03-12T05:45:00Z with a French locale
   * @example DateTime.utc(2017, 3, 12, 5, 45, 10)                        //~> 2017-03-12T05:45:10Z
   * @example DateTime.utc(2017, 3, 12, 5, 45, 10, 765, { locale: "fr" }) //~> 2017-03-12T05:45:10.765Z with a French locale
   * @return {DateTime}
   */
  ;

  DateTime.utc = function utc() {
    var _lastOpts2 = lastOpts(arguments),
        opts = _lastOpts2[0],
        args = _lastOpts2[1],
        year = args[0],
        month = args[1],
        day = args[2],
        hour = args[3],
        minute = args[4],
        second = args[5],
        millisecond = args[6];

    opts.zone = FixedOffsetZone.utcInstance;
    return quickDT({
      year: year,
      month: month,
      day: day,
      hour: hour,
      minute: minute,
      second: second,
      millisecond: millisecond
    }, opts);
  }
  /**
   * Create a DateTime from a JavaScript Date object. Uses the default zone.
   * @param {Date} date - a JavaScript Date object
   * @param {Object} options - configuration options for the DateTime
   * @param {string|Zone} [options.zone='local'] - the zone to place the DateTime into
   * @return {DateTime}
   */
  ;

  DateTime.fromJSDate = function fromJSDate(date, options) {
    if (options === void 0) {
      options = {};
    }

    var ts = isDate(date) ? date.valueOf() : NaN;

    if (Number.isNaN(ts)) {
      return DateTime.invalid("invalid input");
    }

    var zoneToUse = normalizeZone(options.zone, Settings.defaultZone);

    if (!zoneToUse.isValid) {
      return DateTime.invalid(unsupportedZone(zoneToUse));
    }

    return new DateTime({
      ts: ts,
      zone: zoneToUse,
      loc: Locale.fromObject(options)
    });
  }
  /**
   * Create a DateTime from a number of milliseconds since the epoch (meaning since 1 January 1970 00:00:00 UTC). Uses the default zone.
   * @param {number} milliseconds - a number of milliseconds since 1970 UTC
   * @param {Object} options - configuration options for the DateTime
   * @param {string|Zone} [options.zone='local'] - the zone to place the DateTime into
   * @param {string} [options.locale] - a locale to set on the resulting DateTime instance
   * @param {string} options.outputCalendar - the output calendar to set on the resulting DateTime instance
   * @param {string} options.numberingSystem - the numbering system to set on the resulting DateTime instance
   * @return {DateTime}
   */
  ;

  DateTime.fromMillis = function fromMillis(milliseconds, options) {
    if (options === void 0) {
      options = {};
    }

    if (!isNumber(milliseconds)) {
      throw new InvalidArgumentError("fromMillis requires a numerical input, but received a " + typeof milliseconds + " with value " + milliseconds);
    } else if (milliseconds < -MAX_DATE || milliseconds > MAX_DATE) {
      // this isn't perfect because because we can still end up out of range because of additional shifting, but it's a start
      return DateTime.invalid("Timestamp out of range");
    } else {
      return new DateTime({
        ts: milliseconds,
        zone: normalizeZone(options.zone, Settings.defaultZone),
        loc: Locale.fromObject(options)
      });
    }
  }
  /**
   * Create a DateTime from a number of seconds since the epoch (meaning since 1 January 1970 00:00:00 UTC). Uses the default zone.
   * @param {number} seconds - a number of seconds since 1970 UTC
   * @param {Object} options - configuration options for the DateTime
   * @param {string|Zone} [options.zone='local'] - the zone to place the DateTime into
   * @param {string} [options.locale] - a locale to set on the resulting DateTime instance
   * @param {string} options.outputCalendar - the output calendar to set on the resulting DateTime instance
   * @param {string} options.numberingSystem - the numbering system to set on the resulting DateTime instance
   * @return {DateTime}
   */
  ;

  DateTime.fromSeconds = function fromSeconds(seconds, options) {
    if (options === void 0) {
      options = {};
    }

    if (!isNumber(seconds)) {
      throw new InvalidArgumentError("fromSeconds requires a numerical input");
    } else {
      return new DateTime({
        ts: seconds * 1000,
        zone: normalizeZone(options.zone, Settings.defaultZone),
        loc: Locale.fromObject(options)
      });
    }
  }
  /**
   * Create a DateTime from a JavaScript object with keys like 'year' and 'hour' with reasonable defaults.
   * @param {Object} obj - the object to create the DateTime from
   * @param {number} obj.year - a year, such as 1987
   * @param {number} obj.month - a month, 1-12
   * @param {number} obj.day - a day of the month, 1-31, depending on the month
   * @param {number} obj.ordinal - day of the year, 1-365 or 366
   * @param {number} obj.weekYear - an ISO week year
   * @param {number} obj.weekNumber - an ISO week number, between 1 and 52 or 53, depending on the year
   * @param {number} obj.weekday - an ISO weekday, 1-7, where 1 is Monday and 7 is Sunday
   * @param {number} obj.hour - hour of the day, 0-23
   * @param {number} obj.minute - minute of the hour, 0-59
   * @param {number} obj.second - second of the minute, 0-59
   * @param {number} obj.millisecond - millisecond of the second, 0-999
   * @param {Object} opts - options for creating this DateTime
   * @param {string|Zone} [opts.zone='local'] - interpret the numbers in the context of a particular zone. Can take any value taken as the first argument to setZone()
   * @param {string} [opts.locale='system's locale'] - a locale to set on the resulting DateTime instance
   * @param {string} opts.outputCalendar - the output calendar to set on the resulting DateTime instance
   * @param {string} opts.numberingSystem - the numbering system to set on the resulting DateTime instance
   * @example DateTime.fromObject({ year: 1982, month: 5, day: 25}).toISODate() //=> '1982-05-25'
   * @example DateTime.fromObject({ year: 1982 }).toISODate() //=> '1982-01-01'
   * @example DateTime.fromObject({ hour: 10, minute: 26, second: 6 }) //~> today at 10:26:06
   * @example DateTime.fromObject({ hour: 10, minute: 26, second: 6 }, { zone: 'utc' }),
   * @example DateTime.fromObject({ hour: 10, minute: 26, second: 6 }, { zone: 'local' })
   * @example DateTime.fromObject({ hour: 10, minute: 26, second: 6 }, { zone: 'America/New_York' })
   * @example DateTime.fromObject({ weekYear: 2016, weekNumber: 2, weekday: 3 }).toISODate() //=> '2016-01-13'
   * @return {DateTime}
   */
  ;

  DateTime.fromObject = function fromObject(obj, opts) {
    if (opts === void 0) {
      opts = {};
    }

    obj = obj || {};
    var zoneToUse = normalizeZone(opts.zone, Settings.defaultZone);

    if (!zoneToUse.isValid) {
      return DateTime.invalid(unsupportedZone(zoneToUse));
    }

    var tsNow = Settings.now(),
        offsetProvis = !isUndefined(opts.specificOffset) ? opts.specificOffset : zoneToUse.offset(tsNow),
        normalized = normalizeObject(obj, normalizeUnit),
        containsOrdinal = !isUndefined(normalized.ordinal),
        containsGregorYear = !isUndefined(normalized.year),
        containsGregorMD = !isUndefined(normalized.month) || !isUndefined(normalized.day),
        containsGregor = containsGregorYear || containsGregorMD,
        definiteWeekDef = normalized.weekYear || normalized.weekNumber,
        loc = Locale.fromObject(opts); // cases:
    // just a weekday -> this week's instance of that weekday, no worries
    // (gregorian data or ordinal) + (weekYear or weekNumber) -> error
    // (gregorian month or day) + ordinal -> error
    // otherwise just use weeks or ordinals or gregorian, depending on what's specified

    if ((containsGregor || containsOrdinal) && definiteWeekDef) {
      throw new ConflictingSpecificationError("Can't mix weekYear/weekNumber units with year/month/day or ordinals");
    }

    if (containsGregorMD && containsOrdinal) {
      throw new ConflictingSpecificationError("Can't mix ordinal dates with month/day");
    }

    var useWeekData = definiteWeekDef || normalized.weekday && !containsGregor; // configure ourselves to deal with gregorian dates or week stuff

    var units,
        defaultValues,
        objNow = tsToObj(tsNow, offsetProvis);

    if (useWeekData) {
      units = orderedWeekUnits;
      defaultValues = defaultWeekUnitValues;
      objNow = gregorianToWeek(objNow);
    } else if (containsOrdinal) {
      units = orderedOrdinalUnits;
      defaultValues = defaultOrdinalUnitValues;
      objNow = gregorianToOrdinal(objNow);
    } else {
      units = orderedUnits;
      defaultValues = defaultUnitValues;
    } // set default values for missing stuff


    var foundFirst = false;

    for (var _iterator3 = _createForOfIteratorHelperLoose(units), _step3; !(_step3 = _iterator3()).done;) {
      var u = _step3.value;
      var v = normalized[u];

      if (!isUndefined(v)) {
        foundFirst = true;
      } else if (foundFirst) {
        normalized[u] = defaultValues[u];
      } else {
        normalized[u] = objNow[u];
      }
    } // make sure the values we have are in range


    var higherOrderInvalid = useWeekData ? hasInvalidWeekData(normalized) : containsOrdinal ? hasInvalidOrdinalData(normalized) : hasInvalidGregorianData(normalized),
        invalid = higherOrderInvalid || hasInvalidTimeData(normalized);

    if (invalid) {
      return DateTime.invalid(invalid);
    } // compute the actual time


    var gregorian = useWeekData ? weekToGregorian(normalized) : containsOrdinal ? ordinalToGregorian(normalized) : normalized,
        _objToTS2 = objToTS(gregorian, offsetProvis, zoneToUse),
        tsFinal = _objToTS2[0],
        offsetFinal = _objToTS2[1],
        inst = new DateTime({
      ts: tsFinal,
      zone: zoneToUse,
      o: offsetFinal,
      loc: loc
    }); // gregorian data + weekday serves only to validate


    if (normalized.weekday && containsGregor && obj.weekday !== inst.weekday) {
      return DateTime.invalid("mismatched weekday", "you can't specify both a weekday of " + normalized.weekday + " and a date of " + inst.toISO());
    }

    return inst;
  }
  /**
   * Create a DateTime from an ISO 8601 string
   * @param {string} text - the ISO string
   * @param {Object} opts - options to affect the creation
   * @param {string|Zone} [opts.zone='local'] - use this zone if no offset is specified in the input string itself. Will also convert the time to this zone
   * @param {boolean} [opts.setZone=false] - override the zone with a fixed-offset zone specified in the string itself, if it specifies one
   * @param {string} [opts.locale='system's locale'] - a locale to set on the resulting DateTime instance
   * @param {string} [opts.outputCalendar] - the output calendar to set on the resulting DateTime instance
   * @param {string} [opts.numberingSystem] - the numbering system to set on the resulting DateTime instance
   * @example DateTime.fromISO('2016-05-25T09:08:34.123')
   * @example DateTime.fromISO('2016-05-25T09:08:34.123+06:00')
   * @example DateTime.fromISO('2016-05-25T09:08:34.123+06:00', {setZone: true})
   * @example DateTime.fromISO('2016-05-25T09:08:34.123', {zone: 'utc'})
   * @example DateTime.fromISO('2016-W05-4')
   * @return {DateTime}
   */
  ;

  DateTime.fromISO = function fromISO(text, opts) {
    if (opts === void 0) {
      opts = {};
    }

    var _parseISODate = parseISODate(text),
        vals = _parseISODate[0],
        parsedZone = _parseISODate[1];

    return parseDataToDateTime(vals, parsedZone, opts, "ISO 8601", text);
  }
  /**
   * Create a DateTime from an RFC 2822 string
   * @param {string} text - the RFC 2822 string
   * @param {Object} opts - options to affect the creation
   * @param {string|Zone} [opts.zone='local'] - convert the time to this zone. Since the offset is always specified in the string itself, this has no effect on the interpretation of string, merely the zone the resulting DateTime is expressed in.
   * @param {boolean} [opts.setZone=false] - override the zone with a fixed-offset zone specified in the string itself, if it specifies one
   * @param {string} [opts.locale='system's locale'] - a locale to set on the resulting DateTime instance
   * @param {string} opts.outputCalendar - the output calendar to set on the resulting DateTime instance
   * @param {string} opts.numberingSystem - the numbering system to set on the resulting DateTime instance
   * @example DateTime.fromRFC2822('25 Nov 2016 13:23:12 GMT')
   * @example DateTime.fromRFC2822('Fri, 25 Nov 2016 13:23:12 +0600')
   * @example DateTime.fromRFC2822('25 Nov 2016 13:23 Z')
   * @return {DateTime}
   */
  ;

  DateTime.fromRFC2822 = function fromRFC2822(text, opts) {
    if (opts === void 0) {
      opts = {};
    }

    var _parseRFC2822Date = parseRFC2822Date(text),
        vals = _parseRFC2822Date[0],
        parsedZone = _parseRFC2822Date[1];

    return parseDataToDateTime(vals, parsedZone, opts, "RFC 2822", text);
  }
  /**
   * Create a DateTime from an HTTP header date
   * @see https://www.w3.org/Protocols/rfc2616/rfc2616-sec3.html#sec3.3.1
   * @param {string} text - the HTTP header date
   * @param {Object} opts - options to affect the creation
   * @param {string|Zone} [opts.zone='local'] - convert the time to this zone. Since HTTP dates are always in UTC, this has no effect on the interpretation of string, merely the zone the resulting DateTime is expressed in.
   * @param {boolean} [opts.setZone=false] - override the zone with the fixed-offset zone specified in the string. For HTTP dates, this is always UTC, so this option is equivalent to setting the `zone` option to 'utc', but this option is included for consistency with similar methods.
   * @param {string} [opts.locale='system's locale'] - a locale to set on the resulting DateTime instance
   * @param {string} opts.outputCalendar - the output calendar to set on the resulting DateTime instance
   * @param {string} opts.numberingSystem - the numbering system to set on the resulting DateTime instance
   * @example DateTime.fromHTTP('Sun, 06 Nov 1994 08:49:37 GMT')
   * @example DateTime.fromHTTP('Sunday, 06-Nov-94 08:49:37 GMT')
   * @example DateTime.fromHTTP('Sun Nov  6 08:49:37 1994')
   * @return {DateTime}
   */
  ;

  DateTime.fromHTTP = function fromHTTP(text, opts) {
    if (opts === void 0) {
      opts = {};
    }

    var _parseHTTPDate = parseHTTPDate(text),
        vals = _parseHTTPDate[0],
        parsedZone = _parseHTTPDate[1];

    return parseDataToDateTime(vals, parsedZone, opts, "HTTP", opts);
  }
  /**
   * Create a DateTime from an input string and format string.
   * Defaults to en-US if no locale has been specified, regardless of the system's locale. For a table of tokens and their interpretations, see [here](https://moment.github.io/luxon/#/parsing?id=table-of-tokens).
   * @param {string} text - the string to parse
   * @param {string} fmt - the format the string is expected to be in (see the link below for the formats)
   * @param {Object} opts - options to affect the creation
   * @param {string|Zone} [opts.zone='local'] - use this zone if no offset is specified in the input string itself. Will also convert the DateTime to this zone
   * @param {boolean} [opts.setZone=false] - override the zone with a zone specified in the string itself, if it specifies one
   * @param {string} [opts.locale='en-US'] - a locale string to use when parsing. Will also set the DateTime to this locale
   * @param {string} opts.numberingSystem - the numbering system to use when parsing. Will also set the resulting DateTime to this numbering system
   * @param {string} opts.outputCalendar - the output calendar to set on the resulting DateTime instance
   * @return {DateTime}
   */
  ;

  DateTime.fromFormat = function fromFormat(text, fmt, opts) {
    if (opts === void 0) {
      opts = {};
    }

    if (isUndefined(text) || isUndefined(fmt)) {
      throw new InvalidArgumentError("fromFormat requires an input string and a format");
    }

    var _opts = opts,
        _opts$locale = _opts.locale,
        locale = _opts$locale === void 0 ? null : _opts$locale,
        _opts$numberingSystem = _opts.numberingSystem,
        numberingSystem = _opts$numberingSystem === void 0 ? null : _opts$numberingSystem,
        localeToUse = Locale.fromOpts({
      locale: locale,
      numberingSystem: numberingSystem,
      defaultToEN: true
    }),
        _parseFromTokens = parseFromTokens(localeToUse, text, fmt),
        vals = _parseFromTokens[0],
        parsedZone = _parseFromTokens[1],
        specificOffset = _parseFromTokens[2],
        invalid = _parseFromTokens[3];

    if (invalid) {
      return DateTime.invalid(invalid);
    } else {
      return parseDataToDateTime(vals, parsedZone, opts, "format " + fmt, text, specificOffset);
    }
  }
  /**
   * @deprecated use fromFormat instead
   */
  ;

  DateTime.fromString = function fromString(text, fmt, opts) {
    if (opts === void 0) {
      opts = {};
    }

    return DateTime.fromFormat(text, fmt, opts);
  }
  /**
   * Create a DateTime from a SQL date, time, or datetime
   * Defaults to en-US if no locale has been specified, regardless of the system's locale
   * @param {string} text - the string to parse
   * @param {Object} opts - options to affect the creation
   * @param {string|Zone} [opts.zone='local'] - use this zone if no offset is specified in the input string itself. Will also convert the DateTime to this zone
   * @param {boolean} [opts.setZone=false] - override the zone with a zone specified in the string itself, if it specifies one
   * @param {string} [opts.locale='en-US'] - a locale string to use when parsing. Will also set the DateTime to this locale
   * @param {string} opts.numberingSystem - the numbering system to use when parsing. Will also set the resulting DateTime to this numbering system
   * @param {string} opts.outputCalendar - the output calendar to set on the resulting DateTime instance
   * @example DateTime.fromSQL('2017-05-15')
   * @example DateTime.fromSQL('2017-05-15 09:12:34')
   * @example DateTime.fromSQL('2017-05-15 09:12:34.342')
   * @example DateTime.fromSQL('2017-05-15 09:12:34.342+06:00')
   * @example DateTime.fromSQL('2017-05-15 09:12:34.342 America/Los_Angeles')
   * @example DateTime.fromSQL('2017-05-15 09:12:34.342 America/Los_Angeles', { setZone: true })
   * @example DateTime.fromSQL('2017-05-15 09:12:34.342', { zone: 'America/Los_Angeles' })
   * @example DateTime.fromSQL('09:12:34.342')
   * @return {DateTime}
   */
  ;

  DateTime.fromSQL = function fromSQL(text, opts) {
    if (opts === void 0) {
      opts = {};
    }

    var _parseSQL = parseSQL(text),
        vals = _parseSQL[0],
        parsedZone = _parseSQL[1];

    return parseDataToDateTime(vals, parsedZone, opts, "SQL", text);
  }
  /**
   * Create an invalid DateTime.
   * @param {string} reason - simple string of why this DateTime is invalid. Should not contain parameters or anything else data-dependent
   * @param {string} [explanation=null] - longer explanation, may include parameters and other useful debugging information
   * @return {DateTime}
   */
  ;

  DateTime.invalid = function invalid(reason, explanation) {
    if (explanation === void 0) {
      explanation = null;
    }

    if (!reason) {
      throw new InvalidArgumentError("need to specify a reason the DateTime is invalid");
    }

    var invalid = reason instanceof Invalid ? reason : new Invalid(reason, explanation);

    if (Settings.throwOnInvalid) {
      throw new InvalidDateTimeError(invalid);
    } else {
      return new DateTime({
        invalid: invalid
      });
    }
  }
  /**
   * Check if an object is an instance of DateTime. Works across context boundaries
   * @param {object} o
   * @return {boolean}
   */
  ;

  DateTime.isDateTime = function isDateTime(o) {
    return o && o.isLuxonDateTime || false;
  } // INFO

  /**
   * Get the value of unit.
   * @param {string} unit - a unit such as 'minute' or 'day'
   * @example DateTime.local(2017, 7, 4).get('month'); //=> 7
   * @example DateTime.local(2017, 7, 4).get('day'); //=> 4
   * @return {number}
   */
  ;

  var _proto = DateTime.prototype;

  _proto.get = function get(unit) {
    return this[unit];
  }
  /**
   * Returns whether the DateTime is valid. Invalid DateTimes occur when:
   * * The DateTime was created from invalid calendar information, such as the 13th month or February 30
   * * The DateTime was created by an operation on another invalid date
   * @type {boolean}
   */
  ;

  /**
   * Returns the resolved Intl options for this DateTime.
   * This is useful in understanding the behavior of formatting methods
   * @param {Object} opts - the same options as toLocaleString
   * @return {Object}
   */
  _proto.resolvedLocaleOptions = function resolvedLocaleOptions(opts) {
    if (opts === void 0) {
      opts = {};
    }

    var _Formatter$create$res = Formatter.create(this.loc.clone(opts), opts).resolvedOptions(this),
        locale = _Formatter$create$res.locale,
        numberingSystem = _Formatter$create$res.numberingSystem,
        calendar = _Formatter$create$res.calendar;

    return {
      locale: locale,
      numberingSystem: numberingSystem,
      outputCalendar: calendar
    };
  } // TRANSFORM

  /**
   * "Set" the DateTime's zone to UTC. Returns a newly-constructed DateTime.
   *
   * Equivalent to {@link DateTime#setZone}('utc')
   * @param {number} [offset=0] - optionally, an offset from UTC in minutes
   * @param {Object} [opts={}] - options to pass to `setZone()`
   * @return {DateTime}
   */
  ;

  _proto.toUTC = function toUTC(offset, opts) {
    if (offset === void 0) {
      offset = 0;
    }

    if (opts === void 0) {
      opts = {};
    }

    return this.setZone(FixedOffsetZone.instance(offset), opts);
  }
  /**
   * "Set" the DateTime's zone to the host's local zone. Returns a newly-constructed DateTime.
   *
   * Equivalent to `setZone('local')`
   * @return {DateTime}
   */
  ;

  _proto.toLocal = function toLocal() {
    return this.setZone(Settings.defaultZone);
  }
  /**
   * "Set" the DateTime's zone to specified zone. Returns a newly-constructed DateTime.
   *
   * By default, the setter keeps the underlying time the same (as in, the same timestamp), but the new instance will report different local times and consider DSTs when making computations, as with {@link DateTime#plus}. You may wish to use {@link DateTime#toLocal} and {@link DateTime#toUTC} which provide simple convenience wrappers for commonly used zones.
   * @param {string|Zone} [zone='local'] - a zone identifier. As a string, that can be any IANA zone supported by the host environment, or a fixed-offset name of the form 'UTC+3', or the strings 'local' or 'utc'. You may also supply an instance of a {@link DateTime#Zone} class.
   * @param {Object} opts - options
   * @param {boolean} [opts.keepLocalTime=false] - If true, adjust the underlying time so that the local time stays the same, but in the target zone. You should rarely need this.
   * @return {DateTime}
   */
  ;

  _proto.setZone = function setZone(zone, _temp) {
    var _ref2 = _temp === void 0 ? {} : _temp,
        _ref2$keepLocalTime = _ref2.keepLocalTime,
        keepLocalTime = _ref2$keepLocalTime === void 0 ? false : _ref2$keepLocalTime,
        _ref2$keepCalendarTim = _ref2.keepCalendarTime,
        keepCalendarTime = _ref2$keepCalendarTim === void 0 ? false : _ref2$keepCalendarTim;

    zone = normalizeZone(zone, Settings.defaultZone);

    if (zone.equals(this.zone)) {
      return this;
    } else if (!zone.isValid) {
      return DateTime.invalid(unsupportedZone(zone));
    } else {
      var newTS = this.ts;

      if (keepLocalTime || keepCalendarTime) {
        var offsetGuess = zone.offset(this.ts);
        var asObj = this.toObject();

        var _objToTS3 = objToTS(asObj, offsetGuess, zone);

        newTS = _objToTS3[0];
      }

      return clone(this, {
        ts: newTS,
        zone: zone
      });
    }
  }
  /**
   * "Set" the locale, numberingSystem, or outputCalendar. Returns a newly-constructed DateTime.
   * @param {Object} properties - the properties to set
   * @example DateTime.local(2017, 5, 25).reconfigure({ locale: 'en-GB' })
   * @return {DateTime}
   */
  ;

  _proto.reconfigure = function reconfigure(_temp2) {
    var _ref3 = _temp2 === void 0 ? {} : _temp2,
        locale = _ref3.locale,
        numberingSystem = _ref3.numberingSystem,
        outputCalendar = _ref3.outputCalendar;

    var loc = this.loc.clone({
      locale: locale,
      numberingSystem: numberingSystem,
      outputCalendar: outputCalendar
    });
    return clone(this, {
      loc: loc
    });
  }
  /**
   * "Set" the locale. Returns a newly-constructed DateTime.
   * Just a convenient alias for reconfigure({ locale })
   * @example DateTime.local(2017, 5, 25).setLocale('en-GB')
   * @return {DateTime}
   */
  ;

  _proto.setLocale = function setLocale(locale) {
    return this.reconfigure({
      locale: locale
    });
  }
  /**
   * "Set" the values of specified units. Returns a newly-constructed DateTime.
   * You can only set units with this method; for "setting" metadata, see {@link DateTime#reconfigure} and {@link DateTime#setZone}.
   * @param {Object} values - a mapping of units to numbers
   * @example dt.set({ year: 2017 })
   * @example dt.set({ hour: 8, minute: 30 })
   * @example dt.set({ weekday: 5 })
   * @example dt.set({ year: 2005, ordinal: 234 })
   * @return {DateTime}
   */
  ;

  _proto.set = function set(values) {
    if (!this.isValid) return this;
    var normalized = normalizeObject(values, normalizeUnit),
        settingWeekStuff = !isUndefined(normalized.weekYear) || !isUndefined(normalized.weekNumber) || !isUndefined(normalized.weekday),
        containsOrdinal = !isUndefined(normalized.ordinal),
        containsGregorYear = !isUndefined(normalized.year),
        containsGregorMD = !isUndefined(normalized.month) || !isUndefined(normalized.day),
        containsGregor = containsGregorYear || containsGregorMD,
        definiteWeekDef = normalized.weekYear || normalized.weekNumber;

    if ((containsGregor || containsOrdinal) && definiteWeekDef) {
      throw new ConflictingSpecificationError("Can't mix weekYear/weekNumber units with year/month/day or ordinals");
    }

    if (containsGregorMD && containsOrdinal) {
      throw new ConflictingSpecificationError("Can't mix ordinal dates with month/day");
    }

    var mixed;

    if (settingWeekStuff) {
      mixed = weekToGregorian(_extends({}, gregorianToWeek(this.c), normalized));
    } else if (!isUndefined(normalized.ordinal)) {
      mixed = ordinalToGregorian(_extends({}, gregorianToOrdinal(this.c), normalized));
    } else {
      mixed = _extends({}, this.toObject(), normalized); // if we didn't set the day but we ended up on an overflow date,
      // use the last day of the right month

      if (isUndefined(normalized.day)) {
        mixed.day = Math.min(daysInMonth(mixed.year, mixed.month), mixed.day);
      }
    }

    var _objToTS4 = objToTS(mixed, this.o, this.zone),
        ts = _objToTS4[0],
        o = _objToTS4[1];

    return clone(this, {
      ts: ts,
      o: o
    });
  }
  /**
   * Add a period of time to this DateTime and return the resulting DateTime
   *
   * Adding hours, minutes, seconds, or milliseconds increases the timestamp by the right number of milliseconds. Adding days, months, or years shifts the calendar, accounting for DSTs and leap years along the way. Thus, `dt.plus({ hours: 24 })` may result in a different time than `dt.plus({ days: 1 })` if there's a DST shift in between.
   * @param {Duration|Object|number} duration - The amount to add. Either a Luxon Duration, a number of milliseconds, the object argument to Duration.fromObject()
   * @example DateTime.now().plus(123) //~> in 123 milliseconds
   * @example DateTime.now().plus({ minutes: 15 }) //~> in 15 minutes
   * @example DateTime.now().plus({ days: 1 }) //~> this time tomorrow
   * @example DateTime.now().plus({ days: -1 }) //~> this time yesterday
   * @example DateTime.now().plus({ hours: 3, minutes: 13 }) //~> in 3 hr, 13 min
   * @example DateTime.now().plus(Duration.fromObject({ hours: 3, minutes: 13 })) //~> in 3 hr, 13 min
   * @return {DateTime}
   */
  ;

  _proto.plus = function plus(duration) {
    if (!this.isValid) return this;
    var dur = Duration.fromDurationLike(duration);
    return clone(this, adjustTime(this, dur));
  }
  /**
   * Subtract a period of time to this DateTime and return the resulting DateTime
   * See {@link DateTime#plus}
   * @param {Duration|Object|number} duration - The amount to subtract. Either a Luxon Duration, a number of milliseconds, the object argument to Duration.fromObject()
   @return {DateTime}
   */
  ;

  _proto.minus = function minus(duration) {
    if (!this.isValid) return this;
    var dur = Duration.fromDurationLike(duration).negate();
    return clone(this, adjustTime(this, dur));
  }
  /**
   * "Set" this DateTime to the beginning of a unit of time.
   * @param {string} unit - The unit to go to the beginning of. Can be 'year', 'quarter', 'month', 'week', 'day', 'hour', 'minute', 'second', or 'millisecond'.
   * @example DateTime.local(2014, 3, 3).startOf('month').toISODate(); //=> '2014-03-01'
   * @example DateTime.local(2014, 3, 3).startOf('year').toISODate(); //=> '2014-01-01'
   * @example DateTime.local(2014, 3, 3).startOf('week').toISODate(); //=> '2014-03-03', weeks always start on Mondays
   * @example DateTime.local(2014, 3, 3, 5, 30).startOf('day').toISOTime(); //=> '00:00.000-05:00'
   * @example DateTime.local(2014, 3, 3, 5, 30).startOf('hour').toISOTime(); //=> '05:00:00.000-05:00'
   * @return {DateTime}
   */
  ;

  _proto.startOf = function startOf(unit) {
    if (!this.isValid) return this;
    var o = {},
        normalizedUnit = Duration.normalizeUnit(unit);

    switch (normalizedUnit) {
      case "years":
        o.month = 1;
      // falls through

      case "quarters":
      case "months":
        o.day = 1;
      // falls through

      case "weeks":
      case "days":
        o.hour = 0;
      // falls through

      case "hours":
        o.minute = 0;
      // falls through

      case "minutes":
        o.second = 0;
      // falls through

      case "seconds":
        o.millisecond = 0;
        break;
      // no default, invalid units throw in normalizeUnit()
    }

    if (normalizedUnit === "weeks") {
      o.weekday = 1;
    }

    if (normalizedUnit === "quarters") {
      var q = Math.ceil(this.month / 3);
      o.month = (q - 1) * 3 + 1;
    }

    return this.set(o);
  }
  /**
   * "Set" this DateTime to the end (meaning the last millisecond) of a unit of time
   * @param {string} unit - The unit to go to the end of. Can be 'year', 'quarter', 'month', 'week', 'day', 'hour', 'minute', 'second', or 'millisecond'.
   * @example DateTime.local(2014, 3, 3).endOf('month').toISO(); //=> '2014-03-31T23:59:59.999-05:00'
   * @example DateTime.local(2014, 3, 3).endOf('year').toISO(); //=> '2014-12-31T23:59:59.999-05:00'
   * @example DateTime.local(2014, 3, 3).endOf('week').toISO(); // => '2014-03-09T23:59:59.999-05:00', weeks start on Mondays
   * @example DateTime.local(2014, 3, 3, 5, 30).endOf('day').toISO(); //=> '2014-03-03T23:59:59.999-05:00'
   * @example DateTime.local(2014, 3, 3, 5, 30).endOf('hour').toISO(); //=> '2014-03-03T05:59:59.999-05:00'
   * @return {DateTime}
   */
  ;

  _proto.endOf = function endOf(unit) {
    var _this$plus;

    return this.isValid ? this.plus((_this$plus = {}, _this$plus[unit] = 1, _this$plus)).startOf(unit).minus(1) : this;
  } // OUTPUT

  /**
   * Returns a string representation of this DateTime formatted according to the specified format string.
   * **You may not want this.** See {@link DateTime#toLocaleString} for a more flexible formatting tool. For a table of tokens and their interpretations, see [here](https://moment.github.io/luxon/#/formatting?id=table-of-tokens).
   * Defaults to en-US if no locale has been specified, regardless of the system's locale.
   * @param {string} fmt - the format string
   * @param {Object} opts - opts to override the configuration options on this DateTime
   * @example DateTime.now().toFormat('yyyy LLL dd') //=> '2017 Apr 22'
   * @example DateTime.now().setLocale('fr').toFormat('yyyy LLL dd') //=> '2017 avr. 22'
   * @example DateTime.now().toFormat('yyyy LLL dd', { locale: "fr" }) //=> '2017 avr. 22'
   * @example DateTime.now().toFormat("HH 'hours and' mm 'minutes'") //=> '20 hours and 55 minutes'
   * @return {string}
   */
  ;

  _proto.toFormat = function toFormat(fmt, opts) {
    if (opts === void 0) {
      opts = {};
    }

    return this.isValid ? Formatter.create(this.loc.redefaultToEN(opts)).formatDateTimeFromString(this, fmt) : INVALID;
  }
  /**
   * Returns a localized string representing this date. Accepts the same options as the Intl.DateTimeFormat constructor and any presets defined by Luxon, such as `DateTime.DATE_FULL` or `DateTime.TIME_SIMPLE`.
   * The exact behavior of this method is browser-specific, but in general it will return an appropriate representation
   * of the DateTime in the assigned locale.
   * Defaults to the system's locale if no locale has been specified
   * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/DateTimeFormat
   * @param formatOpts {Object} - Intl.DateTimeFormat constructor options and configuration options
   * @param {Object} opts - opts to override the configuration options on this DateTime
   * @example DateTime.now().toLocaleString(); //=> 4/20/2017
   * @example DateTime.now().setLocale('en-gb').toLocaleString(); //=> '20/04/2017'
   * @example DateTime.now().toLocaleString({ locale: 'en-gb' }); //=> '20/04/2017'
   * @example DateTime.now().toLocaleString(DateTime.DATE_FULL); //=> 'April 20, 2017'
   * @example DateTime.now().toLocaleString(DateTime.TIME_SIMPLE); //=> '11:32 AM'
   * @example DateTime.now().toLocaleString(DateTime.DATETIME_SHORT); //=> '4/20/2017, 11:32 AM'
   * @example DateTime.now().toLocaleString({ weekday: 'long', month: 'long', day: '2-digit' }); //=> 'Thursday, April 20'
   * @example DateTime.now().toLocaleString({ weekday: 'short', month: 'short', day: '2-digit', hour: '2-digit', minute: '2-digit' }); //=> 'Thu, Apr 20, 11:27 AM'
   * @example DateTime.now().toLocaleString({ hour: '2-digit', minute: '2-digit', hourCycle: 'h23' }); //=> '11:32'
   * @return {string}
   */
  ;

  _proto.toLocaleString = function toLocaleString(formatOpts, opts) {
    if (formatOpts === void 0) {
      formatOpts = DATE_SHORT;
    }

    if (opts === void 0) {
      opts = {};
    }

    return this.isValid ? Formatter.create(this.loc.clone(opts), formatOpts).formatDateTime(this) : INVALID;
  }
  /**
   * Returns an array of format "parts", meaning individual tokens along with metadata. This is allows callers to post-process individual sections of the formatted output.
   * Defaults to the system's locale if no locale has been specified
   * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/DateTimeFormat/formatToParts
   * @param opts {Object} - Intl.DateTimeFormat constructor options, same as `toLocaleString`.
   * @example DateTime.now().toLocaleParts(); //=> [
   *                                   //=>   { type: 'day', value: '25' },
   *                                   //=>   { type: 'literal', value: '/' },
   *                                   //=>   { type: 'month', value: '05' },
   *                                   //=>   { type: 'literal', value: '/' },
   *                                   //=>   { type: 'year', value: '1982' }
   *                                   //=> ]
   */
  ;

  _proto.toLocaleParts = function toLocaleParts(opts) {
    if (opts === void 0) {
      opts = {};
    }

    return this.isValid ? Formatter.create(this.loc.clone(opts), opts).formatDateTimeParts(this) : [];
  }
  /**
   * Returns an ISO 8601-compliant string representation of this DateTime
   * @param {Object} opts - options
   * @param {boolean} [opts.suppressMilliseconds=false] - exclude milliseconds from the format if they're 0
   * @param {boolean} [opts.suppressSeconds=false] - exclude seconds from the format if they're 0
   * @param {boolean} [opts.includeOffset=true] - include the offset, such as 'Z' or '-04:00'
   * @param {boolean} [opts.extendedZone=true] - add the time zone format extension
   * @param {string} [opts.format='extended'] - choose between the basic and extended format
   * @example DateTime.utc(1983, 5, 25).toISO() //=> '1982-05-25T00:00:00.000Z'
   * @example DateTime.now().toISO() //=> '2017-04-22T20:47:05.335-04:00'
   * @example DateTime.now().toISO({ includeOffset: false }) //=> '2017-04-22T20:47:05.335'
   * @example DateTime.now().toISO({ format: 'basic' }) //=> '20170422T204705.335-0400'
   * @return {string}
   */
  ;

  _proto.toISO = function toISO(_temp3) {
    var _ref4 = _temp3 === void 0 ? {} : _temp3,
        _ref4$format = _ref4.format,
        format = _ref4$format === void 0 ? "extended" : _ref4$format,
        _ref4$suppressSeconds = _ref4.suppressSeconds,
        suppressSeconds = _ref4$suppressSeconds === void 0 ? false : _ref4$suppressSeconds,
        _ref4$suppressMillise = _ref4.suppressMilliseconds,
        suppressMilliseconds = _ref4$suppressMillise === void 0 ? false : _ref4$suppressMillise,
        _ref4$includeOffset = _ref4.includeOffset,
        includeOffset = _ref4$includeOffset === void 0 ? true : _ref4$includeOffset,
        _ref4$extendedZone = _ref4.extendedZone,
        extendedZone = _ref4$extendedZone === void 0 ? false : _ref4$extendedZone;

    if (!this.isValid) {
      return null;
    }

    var ext = format === "extended";

    var c = _toISODate(this, ext);

    c += "T";
    c += _toISOTime(this, ext, suppressSeconds, suppressMilliseconds, includeOffset, extendedZone);
    return c;
  }
  /**
   * Returns an ISO 8601-compliant string representation of this DateTime's date component
   * @param {Object} opts - options
   * @param {string} [opts.format='extended'] - choose between the basic and extended format
   * @example DateTime.utc(1982, 5, 25).toISODate() //=> '1982-05-25'
   * @example DateTime.utc(1982, 5, 25).toISODate({ format: 'basic' }) //=> '19820525'
   * @return {string}
   */
  ;

  _proto.toISODate = function toISODate(_temp4) {
    var _ref5 = _temp4 === void 0 ? {} : _temp4,
        _ref5$format = _ref5.format,
        format = _ref5$format === void 0 ? "extended" : _ref5$format;

    if (!this.isValid) {
      return null;
    }

    return _toISODate(this, format === "extended");
  }
  /**
   * Returns an ISO 8601-compliant string representation of this DateTime's week date
   * @example DateTime.utc(1982, 5, 25).toISOWeekDate() //=> '1982-W21-2'
   * @return {string}
   */
  ;

  _proto.toISOWeekDate = function toISOWeekDate() {
    return toTechFormat(this, "kkkk-'W'WW-c");
  }
  /**
   * Returns an ISO 8601-compliant string representation of this DateTime's time component
   * @param {Object} opts - options
   * @param {boolean} [opts.suppressMilliseconds=false] - exclude milliseconds from the format if they're 0
   * @param {boolean} [opts.suppressSeconds=false] - exclude seconds from the format if they're 0
   * @param {boolean} [opts.includeOffset=true] - include the offset, such as 'Z' or '-04:00'
   * @param {boolean} [opts.extendedZone=true] - add the time zone format extension
   * @param {boolean} [opts.includePrefix=false] - include the `T` prefix
   * @param {string} [opts.format='extended'] - choose between the basic and extended format
   * @example DateTime.utc().set({ hour: 7, minute: 34 }).toISOTime() //=> '07:34:19.361Z'
   * @example DateTime.utc().set({ hour: 7, minute: 34, seconds: 0, milliseconds: 0 }).toISOTime({ suppressSeconds: true }) //=> '07:34Z'
   * @example DateTime.utc().set({ hour: 7, minute: 34 }).toISOTime({ format: 'basic' }) //=> '073419.361Z'
   * @example DateTime.utc().set({ hour: 7, minute: 34 }).toISOTime({ includePrefix: true }) //=> 'T07:34:19.361Z'
   * @return {string}
   */
  ;

  _proto.toISOTime = function toISOTime(_temp5) {
    var _ref6 = _temp5 === void 0 ? {} : _temp5,
        _ref6$suppressMillise = _ref6.suppressMilliseconds,
        suppressMilliseconds = _ref6$suppressMillise === void 0 ? false : _ref6$suppressMillise,
        _ref6$suppressSeconds = _ref6.suppressSeconds,
        suppressSeconds = _ref6$suppressSeconds === void 0 ? false : _ref6$suppressSeconds,
        _ref6$includeOffset = _ref6.includeOffset,
        includeOffset = _ref6$includeOffset === void 0 ? true : _ref6$includeOffset,
        _ref6$includePrefix = _ref6.includePrefix,
        includePrefix = _ref6$includePrefix === void 0 ? false : _ref6$includePrefix,
        _ref6$extendedZone = _ref6.extendedZone,
        extendedZone = _ref6$extendedZone === void 0 ? false : _ref6$extendedZone,
        _ref6$format = _ref6.format,
        format = _ref6$format === void 0 ? "extended" : _ref6$format;

    if (!this.isValid) {
      return null;
    }

    var c = includePrefix ? "T" : "";
    return c + _toISOTime(this, format === "extended", suppressSeconds, suppressMilliseconds, includeOffset, extendedZone);
  }
  /**
   * Returns an RFC 2822-compatible string representation of this DateTime
   * @example DateTime.utc(2014, 7, 13).toRFC2822() //=> 'Sun, 13 Jul 2014 00:00:00 +0000'
   * @example DateTime.local(2014, 7, 13).toRFC2822() //=> 'Sun, 13 Jul 2014 00:00:00 -0400'
   * @return {string}
   */
  ;

  _proto.toRFC2822 = function toRFC2822() {
    return toTechFormat(this, "EEE, dd LLL yyyy HH:mm:ss ZZZ", false);
  }
  /**
   * Returns a string representation of this DateTime appropriate for use in HTTP headers. The output is always expressed in GMT.
   * Specifically, the string conforms to RFC 1123.
   * @see https://www.w3.org/Protocols/rfc2616/rfc2616-sec3.html#sec3.3.1
   * @example DateTime.utc(2014, 7, 13).toHTTP() //=> 'Sun, 13 Jul 2014 00:00:00 GMT'
   * @example DateTime.utc(2014, 7, 13, 19).toHTTP() //=> 'Sun, 13 Jul 2014 19:00:00 GMT'
   * @return {string}
   */
  ;

  _proto.toHTTP = function toHTTP() {
    return toTechFormat(this.toUTC(), "EEE, dd LLL yyyy HH:mm:ss 'GMT'");
  }
  /**
   * Returns a string representation of this DateTime appropriate for use in SQL Date
   * @example DateTime.utc(2014, 7, 13).toSQLDate() //=> '2014-07-13'
   * @return {string}
   */
  ;

  _proto.toSQLDate = function toSQLDate() {
    if (!this.isValid) {
      return null;
    }

    return _toISODate(this, true);
  }
  /**
   * Returns a string representation of this DateTime appropriate for use in SQL Time
   * @param {Object} opts - options
   * @param {boolean} [opts.includeZone=false] - include the zone, such as 'America/New_York'. Overrides includeOffset.
   * @param {boolean} [opts.includeOffset=true] - include the offset, such as 'Z' or '-04:00'
   * @param {boolean} [opts.includeOffsetSpace=true] - include the space between the time and the offset, such as '05:15:16.345 -04:00'
   * @example DateTime.utc().toSQL() //=> '05:15:16.345'
   * @example DateTime.now().toSQL() //=> '05:15:16.345 -04:00'
   * @example DateTime.now().toSQL({ includeOffset: false }) //=> '05:15:16.345'
   * @example DateTime.now().toSQL({ includeZone: false }) //=> '05:15:16.345 America/New_York'
   * @return {string}
   */
  ;

  _proto.toSQLTime = function toSQLTime(_temp6) {
    var _ref7 = _temp6 === void 0 ? {} : _temp6,
        _ref7$includeOffset = _ref7.includeOffset,
        includeOffset = _ref7$includeOffset === void 0 ? true : _ref7$includeOffset,
        _ref7$includeZone = _ref7.includeZone,
        includeZone = _ref7$includeZone === void 0 ? false : _ref7$includeZone,
        _ref7$includeOffsetSp = _ref7.includeOffsetSpace,
        includeOffsetSpace = _ref7$includeOffsetSp === void 0 ? true : _ref7$includeOffsetSp;

    var fmt = "HH:mm:ss.SSS";

    if (includeZone || includeOffset) {
      if (includeOffsetSpace) {
        fmt += " ";
      }

      if (includeZone) {
        fmt += "z";
      } else if (includeOffset) {
        fmt += "ZZ";
      }
    }

    return toTechFormat(this, fmt, true);
  }
  /**
   * Returns a string representation of this DateTime appropriate for use in SQL DateTime
   * @param {Object} opts - options
   * @param {boolean} [opts.includeZone=false] - include the zone, such as 'America/New_York'. Overrides includeOffset.
   * @param {boolean} [opts.includeOffset=true] - include the offset, such as 'Z' or '-04:00'
   * @param {boolean} [opts.includeOffsetSpace=true] - include the space between the time and the offset, such as '05:15:16.345 -04:00'
   * @example DateTime.utc(2014, 7, 13).toSQL() //=> '2014-07-13 00:00:00.000 Z'
   * @example DateTime.local(2014, 7, 13).toSQL() //=> '2014-07-13 00:00:00.000 -04:00'
   * @example DateTime.local(2014, 7, 13).toSQL({ includeOffset: false }) //=> '2014-07-13 00:00:00.000'
   * @example DateTime.local(2014, 7, 13).toSQL({ includeZone: true }) //=> '2014-07-13 00:00:00.000 America/New_York'
   * @return {string}
   */
  ;

  _proto.toSQL = function toSQL(opts) {
    if (opts === void 0) {
      opts = {};
    }

    if (!this.isValid) {
      return null;
    }

    return this.toSQLDate() + " " + this.toSQLTime(opts);
  }
  /**
   * Returns a string representation of this DateTime appropriate for debugging
   * @return {string}
   */
  ;

  _proto.toString = function toString() {
    return this.isValid ? this.toISO() : INVALID;
  }
  /**
   * Returns the epoch milliseconds of this DateTime. Alias of {@link DateTime#toMillis}
   * @return {number}
   */
  ;

  _proto.valueOf = function valueOf() {
    return this.toMillis();
  }
  /**
   * Returns the epoch milliseconds of this DateTime.
   * @return {number}
   */
  ;

  _proto.toMillis = function toMillis() {
    return this.isValid ? this.ts : NaN;
  }
  /**
   * Returns the epoch seconds of this DateTime.
   * @return {number}
   */
  ;

  _proto.toSeconds = function toSeconds() {
    return this.isValid ? this.ts / 1000 : NaN;
  }
  /**
   * Returns the epoch seconds (as a whole number) of this DateTime.
   * @return {number}
   */
  ;

  _proto.toUnixInteger = function toUnixInteger() {
    return this.isValid ? Math.floor(this.ts / 1000) : NaN;
  }
  /**
   * Returns an ISO 8601 representation of this DateTime appropriate for use in JSON.
   * @return {string}
   */
  ;

  _proto.toJSON = function toJSON() {
    return this.toISO();
  }
  /**
   * Returns a BSON serializable equivalent to this DateTime.
   * @return {Date}
   */
  ;

  _proto.toBSON = function toBSON() {
    return this.toJSDate();
  }
  /**
   * Returns a JavaScript object with this DateTime's year, month, day, and so on.
   * @param opts - options for generating the object
   * @param {boolean} [opts.includeConfig=false] - include configuration attributes in the output
   * @example DateTime.now().toObject() //=> { year: 2017, month: 4, day: 22, hour: 20, minute: 49, second: 42, millisecond: 268 }
   * @return {Object}
   */
  ;

  _proto.toObject = function toObject(opts) {
    if (opts === void 0) {
      opts = {};
    }

    if (!this.isValid) return {};

    var base = _extends({}, this.c);

    if (opts.includeConfig) {
      base.outputCalendar = this.outputCalendar;
      base.numberingSystem = this.loc.numberingSystem;
      base.locale = this.loc.locale;
    }

    return base;
  }
  /**
   * Returns a JavaScript Date equivalent to this DateTime.
   * @return {Date}
   */
  ;

  _proto.toJSDate = function toJSDate() {
    return new Date(this.isValid ? this.ts : NaN);
  } // COMPARE

  /**
   * Return the difference between two DateTimes as a Duration.
   * @param {DateTime} otherDateTime - the DateTime to compare this one to
   * @param {string|string[]} [unit=['milliseconds']] - the unit or array of units (such as 'hours' or 'days') to include in the duration.
   * @param {Object} opts - options that affect the creation of the Duration
   * @param {string} [opts.conversionAccuracy='casual'] - the conversion system to use
   * @example
   * var i1 = DateTime.fromISO('1982-05-25T09:45'),
   *     i2 = DateTime.fromISO('1983-10-14T10:30');
   * i2.diff(i1).toObject() //=> { milliseconds: 43807500000 }
   * i2.diff(i1, 'hours').toObject() //=> { hours: 12168.75 }
   * i2.diff(i1, ['months', 'days']).toObject() //=> { months: 16, days: 19.03125 }
   * i2.diff(i1, ['months', 'days', 'hours']).toObject() //=> { months: 16, days: 19, hours: 0.75 }
   * @return {Duration}
   */
  ;

  _proto.diff = function diff(otherDateTime, unit, opts) {
    if (unit === void 0) {
      unit = "milliseconds";
    }

    if (opts === void 0) {
      opts = {};
    }

    if (!this.isValid || !otherDateTime.isValid) {
      return Duration.invalid("created by diffing an invalid DateTime");
    }

    var durOpts = _extends({
      locale: this.locale,
      numberingSystem: this.numberingSystem
    }, opts);

    var units = maybeArray(unit).map(Duration.normalizeUnit),
        otherIsLater = otherDateTime.valueOf() > this.valueOf(),
        earlier = otherIsLater ? this : otherDateTime,
        later = otherIsLater ? otherDateTime : this,
        diffed = _diff(earlier, later, units, durOpts);

    return otherIsLater ? diffed.negate() : diffed;
  }
  /**
   * Return the difference between this DateTime and right now.
   * See {@link DateTime#diff}
   * @param {string|string[]} [unit=['milliseconds']] - the unit or units units (such as 'hours' or 'days') to include in the duration
   * @param {Object} opts - options that affect the creation of the Duration
   * @param {string} [opts.conversionAccuracy='casual'] - the conversion system to use
   * @return {Duration}
   */
  ;

  _proto.diffNow = function diffNow(unit, opts) {
    if (unit === void 0) {
      unit = "milliseconds";
    }

    if (opts === void 0) {
      opts = {};
    }

    return this.diff(DateTime.now(), unit, opts);
  }
  /**
   * Return an Interval spanning between this DateTime and another DateTime
   * @param {DateTime} otherDateTime - the other end point of the Interval
   * @return {Interval}
   */
  ;

  _proto.until = function until(otherDateTime) {
    return this.isValid ? Interval.fromDateTimes(this, otherDateTime) : this;
  }
  /**
   * Return whether this DateTime is in the same unit of time as another DateTime.
   * Higher-order units must also be identical for this function to return `true`.
   * Note that time zones are **ignored** in this comparison, which compares the **local** calendar time. Use {@link DateTime#setZone} to convert one of the dates if needed.
   * @param {DateTime} otherDateTime - the other DateTime
   * @param {string} unit - the unit of time to check sameness on
   * @example DateTime.now().hasSame(otherDT, 'day'); //~> true if otherDT is in the same current calendar day
   * @return {boolean}
   */
  ;

  _proto.hasSame = function hasSame(otherDateTime, unit) {
    if (!this.isValid) return false;
    var inputMs = otherDateTime.valueOf();
    var adjustedToZone = this.setZone(otherDateTime.zone, {
      keepLocalTime: true
    });
    return adjustedToZone.startOf(unit) <= inputMs && inputMs <= adjustedToZone.endOf(unit);
  }
  /**
   * Equality check
   * Two DateTimes are equal iff they represent the same millisecond, have the same zone and location, and are both valid.
   * To compare just the millisecond values, use `+dt1 === +dt2`.
   * @param {DateTime} other - the other DateTime
   * @return {boolean}
   */
  ;

  _proto.equals = function equals(other) {
    return this.isValid && other.isValid && this.valueOf() === other.valueOf() && this.zone.equals(other.zone) && this.loc.equals(other.loc);
  }
  /**
   * Returns a string representation of a this time relative to now, such as "in two days". Can only internationalize if your
   * platform supports Intl.RelativeTimeFormat. Rounds down by default.
   * @param {Object} options - options that affect the output
   * @param {DateTime} [options.base=DateTime.now()] - the DateTime to use as the basis to which this time is compared. Defaults to now.
   * @param {string} [options.style="long"] - the style of units, must be "long", "short", or "narrow"
   * @param {string|string[]} options.unit - use a specific unit or array of units; if omitted, or an array, the method will pick the best unit. Use an array or one of "years", "quarters", "months", "weeks", "days", "hours", "minutes", or "seconds"
   * @param {boolean} [options.round=true] - whether to round the numbers in the output.
   * @param {number} [options.padding=0] - padding in milliseconds. This allows you to round up the result if it fits inside the threshold. Don't use in combination with {round: false} because the decimal output will include the padding.
   * @param {string} options.locale - override the locale of this DateTime
   * @param {string} options.numberingSystem - override the numberingSystem of this DateTime. The Intl system may choose not to honor this
   * @example DateTime.now().plus({ days: 1 }).toRelative() //=> "in 1 day"
   * @example DateTime.now().setLocale("es").toRelative({ days: 1 }) //=> "dentro de 1 día"
   * @example DateTime.now().plus({ days: 1 }).toRelative({ locale: "fr" }) //=> "dans 23 heures"
   * @example DateTime.now().minus({ days: 2 }).toRelative() //=> "2 days ago"
   * @example DateTime.now().minus({ days: 2 }).toRelative({ unit: "hours" }) //=> "48 hours ago"
   * @example DateTime.now().minus({ hours: 36 }).toRelative({ round: false }) //=> "1.5 days ago"
   */
  ;

  _proto.toRelative = function toRelative(options) {
    if (options === void 0) {
      options = {};
    }

    if (!this.isValid) return null;
    var base = options.base || DateTime.fromObject({}, {
      zone: this.zone
    }),
        padding = options.padding ? this < base ? -options.padding : options.padding : 0;
    var units = ["years", "months", "days", "hours", "minutes", "seconds"];
    var unit = options.unit;

    if (Array.isArray(options.unit)) {
      units = options.unit;
      unit = undefined;
    }

    return diffRelative(base, this.plus(padding), _extends({}, options, {
      numeric: "always",
      units: units,
      unit: unit
    }));
  }
  /**
   * Returns a string representation of this date relative to today, such as "yesterday" or "next month".
   * Only internationalizes on platforms that supports Intl.RelativeTimeFormat.
   * @param {Object} options - options that affect the output
   * @param {DateTime} [options.base=DateTime.now()] - the DateTime to use as the basis to which this time is compared. Defaults to now.
   * @param {string} options.locale - override the locale of this DateTime
   * @param {string} options.unit - use a specific unit; if omitted, the method will pick the unit. Use one of "years", "quarters", "months", "weeks", or "days"
   * @param {string} options.numberingSystem - override the numberingSystem of this DateTime. The Intl system may choose not to honor this
   * @example DateTime.now().plus({ days: 1 }).toRelativeCalendar() //=> "tomorrow"
   * @example DateTime.now().setLocale("es").plus({ days: 1 }).toRelative() //=> ""mañana"
   * @example DateTime.now().plus({ days: 1 }).toRelativeCalendar({ locale: "fr" }) //=> "demain"
   * @example DateTime.now().minus({ days: 2 }).toRelativeCalendar() //=> "2 days ago"
   */
  ;

  _proto.toRelativeCalendar = function toRelativeCalendar(options) {
    if (options === void 0) {
      options = {};
    }

    if (!this.isValid) return null;
    return diffRelative(options.base || DateTime.fromObject({}, {
      zone: this.zone
    }), this, _extends({}, options, {
      numeric: "auto",
      units: ["years", "months", "days"],
      calendary: true
    }));
  }
  /**
   * Return the min of several date times
   * @param {...DateTime} dateTimes - the DateTimes from which to choose the minimum
   * @return {DateTime} the min DateTime, or undefined if called with no argument
   */
  ;

  DateTime.min = function min() {
    for (var _len = arguments.length, dateTimes = new Array(_len), _key = 0; _key < _len; _key++) {
      dateTimes[_key] = arguments[_key];
    }

    if (!dateTimes.every(DateTime.isDateTime)) {
      throw new InvalidArgumentError("min requires all arguments be DateTimes");
    }

    return bestBy(dateTimes, function (i) {
      return i.valueOf();
    }, Math.min);
  }
  /**
   * Return the max of several date times
   * @param {...DateTime} dateTimes - the DateTimes from which to choose the maximum
   * @return {DateTime} the max DateTime, or undefined if called with no argument
   */
  ;

  DateTime.max = function max() {
    for (var _len2 = arguments.length, dateTimes = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
      dateTimes[_key2] = arguments[_key2];
    }

    if (!dateTimes.every(DateTime.isDateTime)) {
      throw new InvalidArgumentError("max requires all arguments be DateTimes");
    }

    return bestBy(dateTimes, function (i) {
      return i.valueOf();
    }, Math.max);
  } // MISC

  /**
   * Explain how a string would be parsed by fromFormat()
   * @param {string} text - the string to parse
   * @param {string} fmt - the format the string is expected to be in (see description)
   * @param {Object} options - options taken by fromFormat()
   * @return {Object}
   */
  ;

  DateTime.fromFormatExplain = function fromFormatExplain(text, fmt, options) {
    if (options === void 0) {
      options = {};
    }

    var _options = options,
        _options$locale = _options.locale,
        locale = _options$locale === void 0 ? null : _options$locale,
        _options$numberingSys = _options.numberingSystem,
        numberingSystem = _options$numberingSys === void 0 ? null : _options$numberingSys,
        localeToUse = Locale.fromOpts({
      locale: locale,
      numberingSystem: numberingSystem,
      defaultToEN: true
    });
    return explainFromTokens(localeToUse, text, fmt);
  }
  /**
   * @deprecated use fromFormatExplain instead
   */
  ;

  DateTime.fromStringExplain = function fromStringExplain(text, fmt, options) {
    if (options === void 0) {
      options = {};
    }

    return DateTime.fromFormatExplain(text, fmt, options);
  } // FORMAT PRESETS

  /**
   * {@link DateTime#toLocaleString} format like 10/14/1983
   * @type {Object}
   */
  ;

  _createClass(DateTime, [{
    key: "isValid",
    get: function get() {
      return this.invalid === null;
    }
    /**
     * Returns an error code if this DateTime is invalid, or null if the DateTime is valid
     * @type {string}
     */

  }, {
    key: "invalidReason",
    get: function get() {
      return this.invalid ? this.invalid.reason : null;
    }
    /**
     * Returns an explanation of why this DateTime became invalid, or null if the DateTime is valid
     * @type {string}
     */

  }, {
    key: "invalidExplanation",
    get: function get() {
      return this.invalid ? this.invalid.explanation : null;
    }
    /**
     * Get the locale of a DateTime, such 'en-GB'. The locale is used when formatting the DateTime
     *
     * @type {string}
     */

  }, {
    key: "locale",
    get: function get() {
      return this.isValid ? this.loc.locale : null;
    }
    /**
     * Get the numbering system of a DateTime, such 'beng'. The numbering system is used when formatting the DateTime
     *
     * @type {string}
     */

  }, {
    key: "numberingSystem",
    get: function get() {
      return this.isValid ? this.loc.numberingSystem : null;
    }
    /**
     * Get the output calendar of a DateTime, such 'islamic'. The output calendar is used when formatting the DateTime
     *
     * @type {string}
     */

  }, {
    key: "outputCalendar",
    get: function get() {
      return this.isValid ? this.loc.outputCalendar : null;
    }
    /**
     * Get the time zone associated with this DateTime.
     * @type {Zone}
     */

  }, {
    key: "zone",
    get: function get() {
      return this._zone;
    }
    /**
     * Get the name of the time zone.
     * @type {string}
     */

  }, {
    key: "zoneName",
    get: function get() {
      return this.isValid ? this.zone.name : null;
    }
    /**
     * Get the year
     * @example DateTime.local(2017, 5, 25).year //=> 2017
     * @type {number}
     */

  }, {
    key: "year",
    get: function get() {
      return this.isValid ? this.c.year : NaN;
    }
    /**
     * Get the quarter
     * @example DateTime.local(2017, 5, 25).quarter //=> 2
     * @type {number}
     */

  }, {
    key: "quarter",
    get: function get() {
      return this.isValid ? Math.ceil(this.c.month / 3) : NaN;
    }
    /**
     * Get the month (1-12).
     * @example DateTime.local(2017, 5, 25).month //=> 5
     * @type {number}
     */

  }, {
    key: "month",
    get: function get() {
      return this.isValid ? this.c.month : NaN;
    }
    /**
     * Get the day of the month (1-30ish).
     * @example DateTime.local(2017, 5, 25).day //=> 25
     * @type {number}
     */

  }, {
    key: "day",
    get: function get() {
      return this.isValid ? this.c.day : NaN;
    }
    /**
     * Get the hour of the day (0-23).
     * @example DateTime.local(2017, 5, 25, 9).hour //=> 9
     * @type {number}
     */

  }, {
    key: "hour",
    get: function get() {
      return this.isValid ? this.c.hour : NaN;
    }
    /**
     * Get the minute of the hour (0-59).
     * @example DateTime.local(2017, 5, 25, 9, 30).minute //=> 30
     * @type {number}
     */

  }, {
    key: "minute",
    get: function get() {
      return this.isValid ? this.c.minute : NaN;
    }
    /**
     * Get the second of the minute (0-59).
     * @example DateTime.local(2017, 5, 25, 9, 30, 52).second //=> 52
     * @type {number}
     */

  }, {
    key: "second",
    get: function get() {
      return this.isValid ? this.c.second : NaN;
    }
    /**
     * Get the millisecond of the second (0-999).
     * @example DateTime.local(2017, 5, 25, 9, 30, 52, 654).millisecond //=> 654
     * @type {number}
     */

  }, {
    key: "millisecond",
    get: function get() {
      return this.isValid ? this.c.millisecond : NaN;
    }
    /**
     * Get the week year
     * @see https://en.wikipedia.org/wiki/ISO_week_date
     * @example DateTime.local(2014, 12, 31).weekYear //=> 2015
     * @type {number}
     */

  }, {
    key: "weekYear",
    get: function get() {
      return this.isValid ? possiblyCachedWeekData(this).weekYear : NaN;
    }
    /**
     * Get the week number of the week year (1-52ish).
     * @see https://en.wikipedia.org/wiki/ISO_week_date
     * @example DateTime.local(2017, 5, 25).weekNumber //=> 21
     * @type {number}
     */

  }, {
    key: "weekNumber",
    get: function get() {
      return this.isValid ? possiblyCachedWeekData(this).weekNumber : NaN;
    }
    /**
     * Get the day of the week.
     * 1 is Monday and 7 is Sunday
     * @see https://en.wikipedia.org/wiki/ISO_week_date
     * @example DateTime.local(2014, 11, 31).weekday //=> 4
     * @type {number}
     */

  }, {
    key: "weekday",
    get: function get() {
      return this.isValid ? possiblyCachedWeekData(this).weekday : NaN;
    }
    /**
     * Get the ordinal (meaning the day of the year)
     * @example DateTime.local(2017, 5, 25).ordinal //=> 145
     * @type {number|DateTime}
     */

  }, {
    key: "ordinal",
    get: function get() {
      return this.isValid ? gregorianToOrdinal(this.c).ordinal : NaN;
    }
    /**
     * Get the human readable short month name, such as 'Oct'.
     * Defaults to the system's locale if no locale has been specified
     * @example DateTime.local(2017, 10, 30).monthShort //=> Oct
     * @type {string}
     */

  }, {
    key: "monthShort",
    get: function get() {
      return this.isValid ? Info.months("short", {
        locObj: this.loc
      })[this.month - 1] : null;
    }
    /**
     * Get the human readable long month name, such as 'October'.
     * Defaults to the system's locale if no locale has been specified
     * @example DateTime.local(2017, 10, 30).monthLong //=> October
     * @type {string}
     */

  }, {
    key: "monthLong",
    get: function get() {
      return this.isValid ? Info.months("long", {
        locObj: this.loc
      })[this.month - 1] : null;
    }
    /**
     * Get the human readable short weekday, such as 'Mon'.
     * Defaults to the system's locale if no locale has been specified
     * @example DateTime.local(2017, 10, 30).weekdayShort //=> Mon
     * @type {string}
     */

  }, {
    key: "weekdayShort",
    get: function get() {
      return this.isValid ? Info.weekdays("short", {
        locObj: this.loc
      })[this.weekday - 1] : null;
    }
    /**
     * Get the human readable long weekday, such as 'Monday'.
     * Defaults to the system's locale if no locale has been specified
     * @example DateTime.local(2017, 10, 30).weekdayLong //=> Monday
     * @type {string}
     */

  }, {
    key: "weekdayLong",
    get: function get() {
      return this.isValid ? Info.weekdays("long", {
        locObj: this.loc
      })[this.weekday - 1] : null;
    }
    /**
     * Get the UTC offset of this DateTime in minutes
     * @example DateTime.now().offset //=> -240
     * @example DateTime.utc().offset //=> 0
     * @type {number}
     */

  }, {
    key: "offset",
    get: function get() {
      return this.isValid ? +this.o : NaN;
    }
    /**
     * Get the short human name for the zone's current offset, for example "EST" or "EDT".
     * Defaults to the system's locale if no locale has been specified
     * @type {string}
     */

  }, {
    key: "offsetNameShort",
    get: function get() {
      if (this.isValid) {
        return this.zone.offsetName(this.ts, {
          format: "short",
          locale: this.locale
        });
      } else {
        return null;
      }
    }
    /**
     * Get the long human name for the zone's current offset, for example "Eastern Standard Time" or "Eastern Daylight Time".
     * Defaults to the system's locale if no locale has been specified
     * @type {string}
     */

  }, {
    key: "offsetNameLong",
    get: function get() {
      if (this.isValid) {
        return this.zone.offsetName(this.ts, {
          format: "long",
          locale: this.locale
        });
      } else {
        return null;
      }
    }
    /**
     * Get whether this zone's offset ever changes, as in a DST.
     * @type {boolean}
     */

  }, {
    key: "isOffsetFixed",
    get: function get() {
      return this.isValid ? this.zone.isUniversal : null;
    }
    /**
     * Get whether the DateTime is in a DST.
     * @type {boolean}
     */

  }, {
    key: "isInDST",
    get: function get() {
      if (this.isOffsetFixed) {
        return false;
      } else {
        return this.offset > this.set({
          month: 1,
          day: 1
        }).offset || this.offset > this.set({
          month: 5
        }).offset;
      }
    }
    /**
     * Returns true if this DateTime is in a leap year, false otherwise
     * @example DateTime.local(2016).isInLeapYear //=> true
     * @example DateTime.local(2013).isInLeapYear //=> false
     * @type {boolean}
     */

  }, {
    key: "isInLeapYear",
    get: function get() {
      return isLeapYear(this.year);
    }
    /**
     * Returns the number of days in this DateTime's month
     * @example DateTime.local(2016, 2).daysInMonth //=> 29
     * @example DateTime.local(2016, 3).daysInMonth //=> 31
     * @type {number}
     */

  }, {
    key: "daysInMonth",
    get: function get() {
      return daysInMonth(this.year, this.month);
    }
    /**
     * Returns the number of days in this DateTime's year
     * @example DateTime.local(2016).daysInYear //=> 366
     * @example DateTime.local(2013).daysInYear //=> 365
     * @type {number}
     */

  }, {
    key: "daysInYear",
    get: function get() {
      return this.isValid ? daysInYear(this.year) : NaN;
    }
    /**
     * Returns the number of weeks in this DateTime's year
     * @see https://en.wikipedia.org/wiki/ISO_week_date
     * @example DateTime.local(2004).weeksInWeekYear //=> 53
     * @example DateTime.local(2013).weeksInWeekYear //=> 52
     * @type {number}
     */

  }, {
    key: "weeksInWeekYear",
    get: function get() {
      return this.isValid ? weeksInWeekYear(this.weekYear) : NaN;
    }
  }], [{
    key: "DATE_SHORT",
    get: function get() {
      return DATE_SHORT;
    }
    /**
     * {@link DateTime#toLocaleString} format like 'Oct 14, 1983'
     * @type {Object}
     */

  }, {
    key: "DATE_MED",
    get: function get() {
      return DATE_MED;
    }
    /**
     * {@link DateTime#toLocaleString} format like 'Fri, Oct 14, 1983'
     * @type {Object}
     */

  }, {
    key: "DATE_MED_WITH_WEEKDAY",
    get: function get() {
      return DATE_MED_WITH_WEEKDAY;
    }
    /**
     * {@link DateTime#toLocaleString} format like 'October 14, 1983'
     * @type {Object}
     */

  }, {
    key: "DATE_FULL",
    get: function get() {
      return DATE_FULL;
    }
    /**
     * {@link DateTime#toLocaleString} format like 'Tuesday, October 14, 1983'
     * @type {Object}
     */

  }, {
    key: "DATE_HUGE",
    get: function get() {
      return DATE_HUGE;
    }
    /**
     * {@link DateTime#toLocaleString} format like '09:30 AM'. Only 12-hour if the locale is.
     * @type {Object}
     */

  }, {
    key: "TIME_SIMPLE",
    get: function get() {
      return TIME_SIMPLE;
    }
    /**
     * {@link DateTime#toLocaleString} format like '09:30:23 AM'. Only 12-hour if the locale is.
     * @type {Object}
     */

  }, {
    key: "TIME_WITH_SECONDS",
    get: function get() {
      return TIME_WITH_SECONDS;
    }
    /**
     * {@link DateTime#toLocaleString} format like '09:30:23 AM EDT'. Only 12-hour if the locale is.
     * @type {Object}
     */

  }, {
    key: "TIME_WITH_SHORT_OFFSET",
    get: function get() {
      return TIME_WITH_SHORT_OFFSET;
    }
    /**
     * {@link DateTime#toLocaleString} format like '09:30:23 AM Eastern Daylight Time'. Only 12-hour if the locale is.
     * @type {Object}
     */

  }, {
    key: "TIME_WITH_LONG_OFFSET",
    get: function get() {
      return TIME_WITH_LONG_OFFSET;
    }
    /**
     * {@link DateTime#toLocaleString} format like '09:30', always 24-hour.
     * @type {Object}
     */

  }, {
    key: "TIME_24_SIMPLE",
    get: function get() {
      return TIME_24_SIMPLE;
    }
    /**
     * {@link DateTime#toLocaleString} format like '09:30:23', always 24-hour.
     * @type {Object}
     */

  }, {
    key: "TIME_24_WITH_SECONDS",
    get: function get() {
      return TIME_24_WITH_SECONDS;
    }
    /**
     * {@link DateTime#toLocaleString} format like '09:30:23 EDT', always 24-hour.
     * @type {Object}
     */

  }, {
    key: "TIME_24_WITH_SHORT_OFFSET",
    get: function get() {
      return TIME_24_WITH_SHORT_OFFSET;
    }
    /**
     * {@link DateTime#toLocaleString} format like '09:30:23 Eastern Daylight Time', always 24-hour.
     * @type {Object}
     */

  }, {
    key: "TIME_24_WITH_LONG_OFFSET",
    get: function get() {
      return TIME_24_WITH_LONG_OFFSET;
    }
    /**
     * {@link DateTime#toLocaleString} format like '10/14/1983, 9:30 AM'. Only 12-hour if the locale is.
     * @type {Object}
     */

  }, {
    key: "DATETIME_SHORT",
    get: function get() {
      return DATETIME_SHORT;
    }
    /**
     * {@link DateTime#toLocaleString} format like '10/14/1983, 9:30:33 AM'. Only 12-hour if the locale is.
     * @type {Object}
     */

  }, {
    key: "DATETIME_SHORT_WITH_SECONDS",
    get: function get() {
      return DATETIME_SHORT_WITH_SECONDS;
    }
    /**
     * {@link DateTime#toLocaleString} format like 'Oct 14, 1983, 9:30 AM'. Only 12-hour if the locale is.
     * @type {Object}
     */

  }, {
    key: "DATETIME_MED",
    get: function get() {
      return DATETIME_MED;
    }
    /**
     * {@link DateTime#toLocaleString} format like 'Oct 14, 1983, 9:30:33 AM'. Only 12-hour if the locale is.
     * @type {Object}
     */

  }, {
    key: "DATETIME_MED_WITH_SECONDS",
    get: function get() {
      return DATETIME_MED_WITH_SECONDS;
    }
    /**
     * {@link DateTime#toLocaleString} format like 'Fri, 14 Oct 1983, 9:30 AM'. Only 12-hour if the locale is.
     * @type {Object}
     */

  }, {
    key: "DATETIME_MED_WITH_WEEKDAY",
    get: function get() {
      return DATETIME_MED_WITH_WEEKDAY;
    }
    /**
     * {@link DateTime#toLocaleString} format like 'October 14, 1983, 9:30 AM EDT'. Only 12-hour if the locale is.
     * @type {Object}
     */

  }, {
    key: "DATETIME_FULL",
    get: function get() {
      return DATETIME_FULL;
    }
    /**
     * {@link DateTime#toLocaleString} format like 'October 14, 1983, 9:30:33 AM EDT'. Only 12-hour if the locale is.
     * @type {Object}
     */

  }, {
    key: "DATETIME_FULL_WITH_SECONDS",
    get: function get() {
      return DATETIME_FULL_WITH_SECONDS;
    }
    /**
     * {@link DateTime#toLocaleString} format like 'Friday, October 14, 1983, 9:30 AM Eastern Daylight Time'. Only 12-hour if the locale is.
     * @type {Object}
     */

  }, {
    key: "DATETIME_HUGE",
    get: function get() {
      return DATETIME_HUGE;
    }
    /**
     * {@link DateTime#toLocaleString} format like 'Friday, October 14, 1983, 9:30:33 AM Eastern Daylight Time'. Only 12-hour if the locale is.
     * @type {Object}
     */

  }, {
    key: "DATETIME_HUGE_WITH_SECONDS",
    get: function get() {
      return DATETIME_HUGE_WITH_SECONDS;
    }
  }]);

  return DateTime;
}();
function friendlyDateTime(dateTimeish) {
  if (DateTime.isDateTime(dateTimeish)) {
    return dateTimeish;
  } else if (dateTimeish && dateTimeish.valueOf && isNumber(dateTimeish.valueOf())) {
    return DateTime.fromJSDate(dateTimeish);
  } else if (dateTimeish && typeof dateTimeish === "object") {
    return DateTime.fromObject(dateTimeish);
  } else {
    throw new InvalidArgumentError("Unknown datetime argument: " + dateTimeish + ", of type " + typeof dateTimeish);
  }
}

var VERSION = "2.4.0";

var DateTime_1 = luxon.DateTime = DateTime;
var Duration_1 = luxon.Duration = Duration;
var FixedOffsetZone_1 = luxon.FixedOffsetZone = FixedOffsetZone;
var IANAZone_1 = luxon.IANAZone = IANAZone;
var Info_1 = luxon.Info = Info;
var Interval_1 = luxon.Interval = Interval;
var InvalidZone_1 = luxon.InvalidZone = InvalidZone;
var Settings_1 = luxon.Settings = Settings;
var SystemZone_1 = luxon.SystemZone = SystemZone;
var VERSION_1 = luxon.VERSION = VERSION;
var Zone_1 = luxon.Zone = Zone;

var Luxon = /*#__PURE__*/_mergeNamespaces({
	__proto__: null,
	DateTime: DateTime_1,
	Duration: Duration_1,
	FixedOffsetZone: FixedOffsetZone_1,
	IANAZone: IANAZone_1,
	Info: Info_1,
	Interval: Interval_1,
	InvalidZone: InvalidZone_1,
	Settings: Settings_1,
	SystemZone: SystemZone_1,
	VERSION: VERSION_1,
	Zone: Zone_1,
	'default': luxon
}, [luxon]);

////////////////////
// Query Settings //
////////////////////
const DEFAULT_QUERY_SETTINGS = {
    renderNullAs: "\\-",
    taskCompletionTracking: false,
    taskCompletionUseEmojiShorthand: false,
    taskCompletionText: "completion",
    taskCompletionDateFormat: "yyyy-MM-dd",
    warnOnEmptyResult: true,
    refreshEnabled: true,
    refreshInterval: 2500,
    defaultDateFormat: "MMMM dd, yyyy",
    defaultDateTimeFormat: "h:mm a - MMMM dd, yyyy",
    maxRecursiveRenderDepth: 4,
    tableIdColumnName: "File",
    tableGroupColumnName: "Group",
};
const DEFAULT_EXPORT_SETTINGS = {
    allowHtml: true,
};
/** Default settings for dataview on install. */
const DEFAULT_SETTINGS = {
    ...DEFAULT_QUERY_SETTINGS,
    ...DEFAULT_EXPORT_SETTINGS,
    ...{
        inlineQueryPrefix: "=",
        inlineJsQueryPrefix: "$=",
        inlineQueriesInCodeblocks: true,
        enableDataviewJs: false,
        enableInlineDataviewJs: false,
        prettyRenderInlineFields: true,
    },
};

/** Functional return type for error handling. */
class Success {
    constructor(value) {
        this.value = value;
        this.successful = true;
    }
    map(f) {
        return new Success(f(this.value));
    }
    flatMap(f) {
        return f(this.value);
    }
    mapErr(f) {
        return this;
    }
    bimap(succ, _fail) {
        return this.map(succ);
    }
    orElse(_value) {
        return this.value;
    }
    cast() {
        return this;
    }
    orElseThrow(_message) {
        return this.value;
    }
}
/** Functional return type for error handling. */
class Failure {
    constructor(error) {
        this.error = error;
        this.successful = false;
    }
    map(_f) {
        return this;
    }
    flatMap(_f) {
        return this;
    }
    mapErr(f) {
        return new Failure(f(this.error));
    }
    bimap(_succ, fail) {
        return this.mapErr(fail);
    }
    orElse(value) {
        return value;
    }
    cast() {
        return this;
    }
    orElseThrow(message) {
        if (message)
            throw new Error(message(this.error));
        else
            throw new Error("" + this.error);
    }
}
/** Monadic 'Result' type which encapsulates whether a procedure succeeded or failed, as well as it's return value. */
var Result;
(function (Result) {
    /** Construct a new success result wrapping the given value. */
    function success(value) {
        return new Success(value);
    }
    Result.success = success;
    /** Construct a new failure value wrapping the given error. */
    function failure(error) {
        return new Failure(error);
    }
    Result.failure = failure;
    /** Join two results with a bi-function and return a new result. */
    function flatMap2(first, second, f) {
        if (first.successful) {
            if (second.successful)
                return f(first.value, second.value);
            else
                return failure(second.error);
        }
        else {
            return failure(first.error);
        }
    }
    Result.flatMap2 = flatMap2;
    /** Join two results with a bi-function and return a new result. */
    function map2(first, second, f) {
        return flatMap2(first, second, (a, b) => success(f(a, b)));
    }
    Result.map2 = map2;
})(Result || (Result = {}));

var parsimmon_umd_min = {exports: {}};

(function (module, exports) {
!function(n,t){module.exports=t();}("undefined"!=typeof self?self:commonjsGlobal,function(){return function(n){var t={};function r(e){if(t[e])return t[e].exports;var u=t[e]={i:e,l:!1,exports:{}};return n[e].call(u.exports,u,u.exports,r),u.l=!0,u.exports}return r.m=n,r.c=t,r.d=function(n,t,e){r.o(n,t)||Object.defineProperty(n,t,{configurable:!1,enumerable:!0,get:e});},r.r=function(n){Object.defineProperty(n,"__esModule",{value:!0});},r.n=function(n){var t=n&&n.__esModule?function(){return n.default}:function(){return n};return r.d(t,"a",t),t},r.o=function(n,t){return Object.prototype.hasOwnProperty.call(n,t)},r.p="",r(r.s=0)}([function(n,t,r){function e(n){if(!(this instanceof e))return new e(n);this._=n;}var u=e.prototype;function o(n,t){for(var r=0;r<n;r++)t(r);}function i(n,t,r){return function(n,t){o(t.length,function(r){n(t[r],r,t);});}(function(r,e,u){t=n(t,r,e,u);},r),t}function a(n,t){return i(function(t,r,e,u){return t.concat([n(r,e,u)])},[],t)}function f(n,t){var r={v:0,buf:t};return o(n,function(){var n;r={v:r.v<<1|(n=r.buf,n[0]>>7),buf:function(n){var t=i(function(n,t,r,e){return n.concat(r===e.length-1?Buffer.from([t,0]).readUInt16BE(0):e.readUInt16BE(r))},[],n);return Buffer.from(a(function(n){return (n<<1&65535)>>8},t))}(r.buf)};}),r}function c(){return "undefined"!=typeof Buffer}function s(){if(!c())throw new Error("Buffer global does not exist; please use webpack if you need to parse Buffers in the browser.")}function l(n){s();var t=i(function(n,t){return n+t},0,n);if(t%8!=0)throw new Error("The bits ["+n.join(", ")+"] add up to "+t+" which is not an even number of bytes; the total should be divisible by 8");var r,u=t/8,o=(r=function(n){return n>48},i(function(n,t){return n||(r(t)?t:n)},null,n));if(o)throw new Error(o+" bit range requested exceeds 48 bit (6 byte) Number max.");return new e(function(t,r){var e=u+r;return e>t.length?x(r,u.toString()+" bytes"):b(e,i(function(n,t){var r=f(t,n.buf);return {coll:n.coll.concat(r.v),buf:r.buf}},{coll:[],buf:t.slice(r,e)},n).coll)})}function h(n,t){return new e(function(r,e){return s(),e+t>r.length?x(e,t+" bytes for "+n):b(e+t,r.slice(e,e+t))})}function p(n,t){if("number"!=typeof(r=t)||Math.floor(r)!==r||t<0||t>6)throw new Error(n+" requires integer length in range [0, 6].");var r;}function d(n){return p("uintBE",n),h("uintBE("+n+")",n).map(function(t){return t.readUIntBE(0,n)})}function v(n){return p("uintLE",n),h("uintLE("+n+")",n).map(function(t){return t.readUIntLE(0,n)})}function g(n){return p("intBE",n),h("intBE("+n+")",n).map(function(t){return t.readIntBE(0,n)})}function m(n){return p("intLE",n),h("intLE("+n+")",n).map(function(t){return t.readIntLE(0,n)})}function y(n){return n instanceof e}function E(n){return "[object Array]"==={}.toString.call(n)}function w(n){return c()&&Buffer.isBuffer(n)}function b(n,t){return {status:!0,index:n,value:t,furthest:-1,expected:[]}}function x(n,t){return E(t)||(t=[t]),{status:!1,index:-1,value:null,furthest:n,expected:t}}function B(n,t){if(!t)return n;if(n.furthest>t.furthest)return n;var r=n.furthest===t.furthest?function(n,t){if(function(){if(void 0!==e._supportsSet)return e._supportsSet;var n="undefined"!=typeof Set;return e._supportsSet=n,n}()&&Array.from){for(var r=new Set(n),u=0;u<t.length;u++)r.add(t[u]);var o=Array.from(r);return o.sort(),o}for(var i={},a=0;a<n.length;a++)i[n[a]]=!0;for(var f=0;f<t.length;f++)i[t[f]]=!0;var c=[];for(var s in i)({}).hasOwnProperty.call(i,s)&&c.push(s);return c.sort(),c}(n.expected,t.expected):t.expected;return {status:n.status,index:n.index,value:n.value,furthest:t.furthest,expected:r}}var j={};function S(n,t){if(w(n))return {offset:t,line:-1,column:-1};n in j||(j[n]={});for(var r=j[n],e=0,u=0,o=0,i=t;i>=0;){if(i in r){e=r[i].line,0===o&&(o=r[i].lineStart);break}("\n"===n.charAt(i)||"\r"===n.charAt(i)&&"\n"!==n.charAt(i+1))&&(u++,0===o&&(o=i+1)),i--;}var a=e+u,f=t-o;return r[t]={line:a,lineStart:o},{offset:t,line:a+1,column:f+1}}function _(n){if(!y(n))throw new Error("not a parser: "+n)}function L(n,t){return "string"==typeof n?n.charAt(t):n[t]}function O(n){if("number"!=typeof n)throw new Error("not a number: "+n)}function k(n){if("function"!=typeof n)throw new Error("not a function: "+n)}function P(n){if("string"!=typeof n)throw new Error("not a string: "+n)}var q=2,A=3,I=8,F=5*I,M=4*I,z="  ";function R(n,t){return new Array(t+1).join(n)}function U(n,t,r){var e=t-n.length;return e<=0?n:R(r,e)+n}function W(n,t,r,e){return {from:n-t>0?n-t:0,to:n+r>e?e:n+r}}function D(n,t){var r,e,u,o,f,c=t.index,s=c.offset,l=1;if(s===n.length)return "Got the end of the input";if(w(n)){var h=s-s%I,p=s-h,d=W(h,F,M+I,n.length),v=a(function(n){return a(function(n){return U(n.toString(16),2,"0")},n)},function(n,t){var r=n.length,e=[],u=0;if(r<=t)return [n.slice()];for(var o=0;o<r;o++)e[u]||e.push([]),e[u].push(n[o]),(o+1)%t==0&&u++;return e}(n.slice(d.from,d.to).toJSON().data,I));o=function(n){return 0===n.from&&1===n.to?{from:n.from,to:n.to}:{from:n.from/I,to:Math.floor(n.to/I)}}(d),e=h/I,r=3*p,p>=4&&(r+=1),l=2,u=a(function(n){return n.length<=4?n.join(" "):n.slice(0,4).join(" ")+"  "+n.slice(4).join(" ")},v),(f=(8*(o.to>0?o.to-1:o.to)).toString(16).length)<2&&(f=2);}else {var g=n.split(/\r\n|[\n\r\u2028\u2029]/);r=c.column-1,e=c.line-1,o=W(e,q,A,g.length),u=g.slice(o.from,o.to),f=o.to.toString().length;}var m=e-o.from;return w(n)&&(f=(8*(o.to>0?o.to-1:o.to)).toString(16).length)<2&&(f=2),i(function(t,e,u){var i,a=u===m,c=a?"> ":z;return i=w(n)?U((8*(o.from+u)).toString(16),f,"0"):U((o.from+u+1).toString(),f," "),[].concat(t,[c+i+" | "+e],a?[z+R(" ",f)+" | "+U("",r," ")+R("^",l)]:[])},[],u).join("\n")}function N(n,t){return ["\n","-- PARSING FAILED "+R("-",50),"\n\n",D(n,t),"\n\n",(r=t.expected,1===r.length?"Expected:\n\n"+r[0]:"Expected one of the following: \n\n"+r.join(", ")),"\n"].join("");var r;}function G(n){return void 0!==n.flags?n.flags:[n.global?"g":"",n.ignoreCase?"i":"",n.multiline?"m":"",n.unicode?"u":"",n.sticky?"y":""].join("")}function C(){for(var n=[].slice.call(arguments),t=n.length,r=0;r<t;r+=1)_(n[r]);return e(function(r,e){for(var u,o=new Array(t),i=0;i<t;i+=1){if(!(u=B(n[i]._(r,e),u)).status)return u;o[i]=u.value,e=u.index;}return B(b(e,o),u)})}function J(){var n=[].slice.call(arguments);if(0===n.length)throw new Error("seqMap needs at least one argument");var t=n.pop();return k(t),C.apply(null,n).map(function(n){return t.apply(null,n)})}function T(){var n=[].slice.call(arguments),t=n.length;if(0===t)return Y("zero alternates");for(var r=0;r<t;r+=1)_(n[r]);return e(function(t,r){for(var e,u=0;u<n.length;u+=1)if((e=B(n[u]._(t,r),e)).status)return e;return e})}function V(n,t){return H(n,t).or(X([]))}function H(n,t){return _(n),_(t),J(n,t.then(n).many(),function(n,t){return [n].concat(t)})}function K(n){P(n);var t="'"+n+"'";return e(function(r,e){var u=e+n.length,o=r.slice(e,u);return o===n?b(u,o):x(e,t)})}function Q(n,t){!function(n){if(!(n instanceof RegExp))throw new Error("not a regexp: "+n);for(var t=G(n),r=0;r<t.length;r++){var e=t.charAt(r);if("i"!==e&&"m"!==e&&"u"!==e&&"s"!==e)throw new Error('unsupported regexp flag "'+e+'": '+n)}}(n),arguments.length>=2?O(t):t=0;var r=function(n){return RegExp("^(?:"+n.source+")",G(n))}(n),u=""+n;return e(function(n,e){var o=r.exec(n.slice(e));if(o){if(0<=t&&t<=o.length){var i=o[0],a=o[t];return b(e+i.length,a)}return x(e,"valid match group (0 to "+o.length+") in "+u)}return x(e,u)})}function X(n){return e(function(t,r){return b(r,n)})}function Y(n){return e(function(t,r){return x(r,n)})}function Z(n){if(y(n))return e(function(t,r){var e=n._(t,r);return e.index=r,e.value="",e});if("string"==typeof n)return Z(K(n));if(n instanceof RegExp)return Z(Q(n));throw new Error("not a string, regexp, or parser: "+n)}function $(n){return _(n),e(function(t,r){var e=n._(t,r),u=t.slice(r,e.index);return e.status?x(r,'not "'+u+'"'):b(r,null)})}function nn(n){return k(n),e(function(t,r){var e=L(t,r);return r<t.length&&n(e)?b(r+1,e):x(r,"a character/byte matching "+n)})}function tn(n,t){arguments.length<2&&(t=n,n=void 0);var r=e(function(n,e){return r._=t()._,r._(n,e)});return n?r.desc(n):r}function rn(){return Y("fantasy-land/empty")}u.parse=function(n){if("string"!=typeof n&&!w(n))throw new Error(".parse must be called with a string or Buffer as its argument");var t,r=this.skip(an)._(n,0);return t=r.status?{status:!0,value:r.value}:{status:!1,index:S(n,r.furthest),expected:r.expected},delete j[n],t},u.tryParse=function(n){var t=this.parse(n);if(t.status)return t.value;var r=N(n,t),e=new Error(r);throw e.type="ParsimmonError",e.result=t,e},u.assert=function(n,t){return this.chain(function(r){return n(r)?X(r):Y(t)})},u.or=function(n){return T(this,n)},u.trim=function(n){return this.wrap(n,n)},u.wrap=function(n,t){return J(n,this,t,function(n,t){return t})},u.thru=function(n){return n(this)},u.then=function(n){return _(n),C(this,n).map(function(n){return n[1]})},u.many=function(){var n=this;return e(function(t,r){for(var e=[],u=void 0;;){if(!(u=B(n._(t,r),u)).status)return B(b(r,e),u);if(r===u.index)throw new Error("infinite loop detected in .many() parser --- calling .many() on a parser which can accept zero characters is usually the cause");r=u.index,e.push(u.value);}})},u.tieWith=function(n){return P(n),this.map(function(t){if(function(n){if(!E(n))throw new Error("not an array: "+n)}(t),t.length){P(t[0]);for(var r=t[0],e=1;e<t.length;e++)P(t[e]),r+=n+t[e];return r}return ""})},u.tie=function(){return this.tieWith("")},u.times=function(n,t){var r=this;return arguments.length<2&&(t=n),O(n),O(t),e(function(e,u){for(var o=[],i=void 0,a=void 0,f=0;f<n;f+=1){if(a=B(i=r._(e,u),a),!i.status)return a;u=i.index,o.push(i.value);}for(;f<t&&(a=B(i=r._(e,u),a),i.status);f+=1)u=i.index,o.push(i.value);return B(b(u,o),a)})},u.result=function(n){return this.map(function(){return n})},u.atMost=function(n){return this.times(0,n)},u.atLeast=function(n){return J(this.times(n),this.many(),function(n,t){return n.concat(t)})},u.map=function(n){k(n);var t=this;return e(function(r,e){var u=t._(r,e);return u.status?B(b(u.index,n(u.value)),u):u})},u.contramap=function(n){k(n);var t=this;return e(function(r,e){var u=t.parse(n(r.slice(e)));return u.status?b(e+r.length,u.value):u})},u.promap=function(n,t){return k(n),k(t),this.contramap(n).map(t)},u.skip=function(n){return C(this,n).map(function(n){return n[0]})},u.mark=function(){return J(en,this,en,function(n,t,r){return {start:n,value:t,end:r}})},u.node=function(n){return J(en,this,en,function(t,r,e){return {name:n,value:r,start:t,end:e}})},u.sepBy=function(n){return V(this,n)},u.sepBy1=function(n){return H(this,n)},u.lookahead=function(n){return this.skip(Z(n))},u.notFollowedBy=function(n){return this.skip($(n))},u.desc=function(n){E(n)||(n=[n]);var t=this;return e(function(r,e){var u=t._(r,e);return u.status||(u.expected=n),u})},u.fallback=function(n){return this.or(X(n))},u.ap=function(n){return J(n,this,function(n,t){return n(t)})},u.chain=function(n){var t=this;return e(function(r,e){var u=t._(r,e);return u.status?B(n(u.value)._(r,u.index),u):u})},u.concat=u.or,u.empty=rn,u.of=X,u["fantasy-land/ap"]=u.ap,u["fantasy-land/chain"]=u.chain,u["fantasy-land/concat"]=u.concat,u["fantasy-land/empty"]=u.empty,u["fantasy-land/of"]=u.of,u["fantasy-land/map"]=u.map;var en=e(function(n,t){return b(t,S(n,t))}),un=e(function(n,t){return t>=n.length?x(t,"any character/byte"):b(t+1,L(n,t))}),on=e(function(n,t){return b(n.length,n.slice(t))}),an=e(function(n,t){return t<n.length?x(t,"EOF"):b(t,null)}),fn=Q(/[0-9]/).desc("a digit"),cn=Q(/[0-9]*/).desc("optional digits"),sn=Q(/[a-z]/i).desc("a letter"),ln=Q(/[a-z]*/i).desc("optional letters"),hn=Q(/\s*/).desc("optional whitespace"),pn=Q(/\s+/).desc("whitespace"),dn=K("\r"),vn=K("\n"),gn=K("\r\n"),mn=T(gn,vn,dn).desc("newline"),yn=T(mn,an);e.all=on,e.alt=T,e.any=un,e.cr=dn,e.createLanguage=function(n){var t={};for(var r in n)({}).hasOwnProperty.call(n,r)&&function(r){t[r]=tn(function(){return n[r](t)});}(r);return t},e.crlf=gn,e.custom=function(n){return e(n(b,x))},e.digit=fn,e.digits=cn,e.empty=rn,e.end=yn,e.eof=an,e.fail=Y,e.formatError=N,e.index=en,e.isParser=y,e.lazy=tn,e.letter=sn,e.letters=ln,e.lf=vn,e.lookahead=Z,e.makeFailure=x,e.makeSuccess=b,e.newline=mn,e.noneOf=function(n){return nn(function(t){return n.indexOf(t)<0}).desc("none of '"+n+"'")},e.notFollowedBy=$,e.of=X,e.oneOf=function(n){for(var t=n.split(""),r=0;r<t.length;r++)t[r]="'"+t[r]+"'";return nn(function(t){return n.indexOf(t)>=0}).desc(t)},e.optWhitespace=hn,e.Parser=e,e.range=function(n,t){return nn(function(r){return n<=r&&r<=t}).desc(n+"-"+t)},e.regex=Q,e.regexp=Q,e.sepBy=V,e.sepBy1=H,e.seq=C,e.seqMap=J,e.seqObj=function(){for(var n,t={},r=0,u=(n=arguments,Array.prototype.slice.call(n)),o=u.length,i=0;i<o;i+=1){var a=u[i];if(!y(a)){if(E(a)&&2===a.length&&"string"==typeof a[0]&&y(a[1])){var f=a[0];if(Object.prototype.hasOwnProperty.call(t,f))throw new Error("seqObj: duplicate key "+f);t[f]=!0,r++;continue}throw new Error("seqObj arguments must be parsers or [string, parser] array pairs.")}}if(0===r)throw new Error("seqObj expects at least one named parser, found zero");return e(function(n,t){for(var r,e={},i=0;i<o;i+=1){var a,f;if(E(u[i])?(a=u[i][0],f=u[i][1]):(a=null,f=u[i]),!(r=B(f._(n,t),r)).status)return r;a&&(e[a]=r.value),t=r.index;}return B(b(t,e),r)})},e.string=K,e.succeed=X,e.takeWhile=function(n){return k(n),e(function(t,r){for(var e=r;e<t.length&&n(L(t,e));)e++;return b(e,t.slice(r,e))})},e.test=nn,e.whitespace=pn,e["fantasy-land/empty"]=rn,e["fantasy-land/of"]=X,e.Binary={bitSeq:l,bitSeqObj:function(n){s();var t={},r=0,e=a(function(n){if(E(n)){var e=n;if(2!==e.length)throw new Error("["+e.join(", ")+"] should be length 2, got length "+e.length);if(P(e[0]),O(e[1]),Object.prototype.hasOwnProperty.call(t,e[0]))throw new Error("duplicate key in bitSeqObj: "+e[0]);return t[e[0]]=!0,r++,e}return O(n),[null,n]},n);if(r<1)throw new Error("bitSeqObj expects at least one named pair, got ["+n.join(", ")+"]");var u=a(function(n){return n[0]},e);return l(a(function(n){return n[1]},e)).map(function(n){return i(function(n,t){return null!==t[0]&&(n[t[0]]=t[1]),n},{},a(function(t,r){return [t,n[r]]},u))})},byte:function(n){if(s(),O(n),n>255)throw new Error("Value specified to byte constructor ("+n+"=0x"+n.toString(16)+") is larger in value than a single byte.");var t=(n>15?"0x":"0x0")+n.toString(16);return e(function(r,e){var u=L(r,e);return u===n?b(e+1,u):x(e,t)})},buffer:function(n){return h("buffer",n).map(function(n){return Buffer.from(n)})},encodedString:function(n,t){return h("string",t).map(function(t){return t.toString(n)})},uintBE:d,uint8BE:d(1),uint16BE:d(2),uint32BE:d(4),uintLE:v,uint8LE:v(1),uint16LE:v(2),uint32LE:v(4),intBE:g,int8BE:g(1),int16BE:g(2),int32BE:g(4),intLE:m,int8LE:m(1),int16LE:m(2),int32LE:m(4),floatBE:h("floatBE",4).map(function(n){return n.readFloatBE(0)}),floatLE:h("floatLE",4).map(function(n){return n.readFloatLE(0)}),doubleBE:h("doubleBE",8).map(function(n){return n.readDoubleBE(0)}),doubleLE:h("doubleLE",8).map(function(n){return n.readDoubleLE(0)})},n.exports=e;}])});
}(parsimmon_umd_min));

var emojiRegex = () => {
	// https://mths.be/emoji
	return /(?:[#*0-9]\uFE0F?\u20E3|[\xA9\xAE\u203C\u2049\u2122\u2139\u2194-\u2199\u21A9\u21AA\u231A\u231B\u2328\u23CF\u23ED-\u23EF\u23F1\u23F2\u23F8-\u23FA\u24C2\u25AA\u25AB\u25B6\u25C0\u25FB\u25FC\u25FE\u2600-\u2604\u260E\u2611\u2614\u2615\u2618\u2620\u2622\u2623\u2626\u262A\u262E\u262F\u2638-\u263A\u2640\u2642\u2648-\u2653\u265F\u2660\u2663\u2665\u2666\u2668\u267B\u267E\u267F\u2692\u2694-\u2697\u2699\u269B\u269C\u26A0\u26A7\u26AA\u26B0\u26B1\u26BD\u26BE\u26C4\u26C8\u26CF\u26D1\u26D3\u26E9\u26F0-\u26F5\u26F7\u26F8\u26FA\u2702\u2708\u2709\u270F\u2712\u2714\u2716\u271D\u2721\u2733\u2734\u2744\u2747\u2757\u2763\u27A1\u2934\u2935\u2B05-\u2B07\u2B1B\u2B1C\u2B55\u3030\u303D\u3297\u3299]\uFE0F?|[\u261D\u270C\u270D](?:\uFE0F|\uD83C[\uDFFB-\uDFFF])?|[\u270A\u270B](?:\uD83C[\uDFFB-\uDFFF])?|[\u23E9-\u23EC\u23F0\u23F3\u25FD\u2693\u26A1\u26AB\u26C5\u26CE\u26D4\u26EA\u26FD\u2705\u2728\u274C\u274E\u2753-\u2755\u2795-\u2797\u27B0\u27BF\u2B50]|\u26F9(?:\uFE0F|\uD83C[\uDFFB-\uDFFF])?(?:\u200D[\u2640\u2642]\uFE0F?)?|\u2764\uFE0F?(?:\u200D(?:\uD83D\uDD25|\uD83E\uDE79))?|\uD83C(?:[\uDC04\uDD70\uDD71\uDD7E\uDD7F\uDE02\uDE37\uDF21\uDF24-\uDF2C\uDF36\uDF7D\uDF96\uDF97\uDF99-\uDF9B\uDF9E\uDF9F\uDFCD\uDFCE\uDFD4-\uDFDF\uDFF5\uDFF7]\uFE0F?|[\uDF85\uDFC2\uDFC7](?:\uD83C[\uDFFB-\uDFFF])?|[\uDFC3\uDFC4\uDFCA](?:\uD83C[\uDFFB-\uDFFF])?(?:\u200D[\u2640\u2642]\uFE0F?)?|[\uDFCB\uDFCC](?:\uFE0F|\uD83C[\uDFFB-\uDFFF])?(?:\u200D[\u2640\u2642]\uFE0F?)?|[\uDCCF\uDD8E\uDD91-\uDD9A\uDE01\uDE1A\uDE2F\uDE32-\uDE36\uDE38-\uDE3A\uDE50\uDE51\uDF00-\uDF20\uDF2D-\uDF35\uDF37-\uDF7C\uDF7E-\uDF84\uDF86-\uDF93\uDFA0-\uDFC1\uDFC5\uDFC6\uDFC8\uDFC9\uDFCF-\uDFD3\uDFE0-\uDFF0\uDFF8-\uDFFF]|\uDDE6\uD83C[\uDDE8-\uDDEC\uDDEE\uDDF1\uDDF2\uDDF4\uDDF6-\uDDFA\uDDFC\uDDFD\uDDFF]|\uDDE7\uD83C[\uDDE6\uDDE7\uDDE9-\uDDEF\uDDF1-\uDDF4\uDDF6-\uDDF9\uDDFB\uDDFC\uDDFE\uDDFF]|\uDDE8\uD83C[\uDDE6\uDDE8\uDDE9\uDDEB-\uDDEE\uDDF0-\uDDF5\uDDF7\uDDFA-\uDDFF]|\uDDE9\uD83C[\uDDEA\uDDEC\uDDEF\uDDF0\uDDF2\uDDF4\uDDFF]|\uDDEA\uD83C[\uDDE6\uDDE8\uDDEA\uDDEC\uDDED\uDDF7-\uDDFA]|\uDDEB\uD83C[\uDDEE-\uDDF0\uDDF2\uDDF4\uDDF7]|\uDDEC\uD83C[\uDDE6\uDDE7\uDDE9-\uDDEE\uDDF1-\uDDF3\uDDF5-\uDDFA\uDDFC\uDDFE]|\uDDED\uD83C[\uDDF0\uDDF2\uDDF3\uDDF7\uDDF9\uDDFA]|\uDDEE\uD83C[\uDDE8-\uDDEA\uDDF1-\uDDF4\uDDF6-\uDDF9]|\uDDEF\uD83C[\uDDEA\uDDF2\uDDF4\uDDF5]|\uDDF0\uD83C[\uDDEA\uDDEC-\uDDEE\uDDF2\uDDF3\uDDF5\uDDF7\uDDFC\uDDFE\uDDFF]|\uDDF1\uD83C[\uDDE6-\uDDE8\uDDEE\uDDF0\uDDF7-\uDDFB\uDDFE]|\uDDF2\uD83C[\uDDE6\uDDE8-\uDDED\uDDF0-\uDDFF]|\uDDF3\uD83C[\uDDE6\uDDE8\uDDEA-\uDDEC\uDDEE\uDDF1\uDDF4\uDDF5\uDDF7\uDDFA\uDDFF]|\uDDF4\uD83C\uDDF2|\uDDF5\uD83C[\uDDE6\uDDEA-\uDDED\uDDF0-\uDDF3\uDDF7-\uDDF9\uDDFC\uDDFE]|\uDDF6\uD83C\uDDE6|\uDDF7\uD83C[\uDDEA\uDDF4\uDDF8\uDDFA\uDDFC]|\uDDF8\uD83C[\uDDE6-\uDDEA\uDDEC-\uDDF4\uDDF7-\uDDF9\uDDFB\uDDFD-\uDDFF]|\uDDF9\uD83C[\uDDE6\uDDE8\uDDE9\uDDEB-\uDDED\uDDEF-\uDDF4\uDDF7\uDDF9\uDDFB\uDDFC\uDDFF]|\uDDFA\uD83C[\uDDE6\uDDEC\uDDF2\uDDF3\uDDF8\uDDFE\uDDFF]|\uDDFB\uD83C[\uDDE6\uDDE8\uDDEA\uDDEC\uDDEE\uDDF3\uDDFA]|\uDDFC\uD83C[\uDDEB\uDDF8]|\uDDFD\uD83C\uDDF0|\uDDFE\uD83C[\uDDEA\uDDF9]|\uDDFF\uD83C[\uDDE6\uDDF2\uDDFC]|\uDFF3\uFE0F?(?:\u200D(?:\u26A7\uFE0F?|\uD83C\uDF08))?|\uDFF4(?:\u200D\u2620\uFE0F?|\uDB40\uDC67\uDB40\uDC62\uDB40(?:\uDC65\uDB40\uDC6E\uDB40\uDC67|\uDC73\uDB40\uDC63\uDB40\uDC74|\uDC77\uDB40\uDC6C\uDB40\uDC73)\uDB40\uDC7F)?)|\uD83D(?:[\uDC3F\uDCFD\uDD49\uDD4A\uDD6F\uDD70\uDD73\uDD76-\uDD79\uDD87\uDD8A-\uDD8D\uDDA5\uDDA8\uDDB1\uDDB2\uDDBC\uDDC2-\uDDC4\uDDD1-\uDDD3\uDDDC-\uDDDE\uDDE1\uDDE3\uDDE8\uDDEF\uDDF3\uDDFA\uDECB\uDECD-\uDECF\uDEE0-\uDEE5\uDEE9\uDEF0\uDEF3]\uFE0F?|[\uDC42\uDC43\uDC46-\uDC50\uDC66\uDC67\uDC6B-\uDC6D\uDC72\uDC74-\uDC76\uDC78\uDC7C\uDC83\uDC85\uDC8F\uDC91\uDCAA\uDD7A\uDD95\uDD96\uDE4C\uDE4F\uDEC0\uDECC](?:\uD83C[\uDFFB-\uDFFF])?|[\uDC6E\uDC70\uDC71\uDC73\uDC77\uDC81\uDC82\uDC86\uDC87\uDE45-\uDE47\uDE4B\uDE4D\uDE4E\uDEA3\uDEB4-\uDEB6](?:\uD83C[\uDFFB-\uDFFF])?(?:\u200D[\u2640\u2642]\uFE0F?)?|[\uDD74\uDD90](?:\uFE0F|\uD83C[\uDFFB-\uDFFF])?|[\uDC00-\uDC07\uDC09-\uDC14\uDC16-\uDC3A\uDC3C-\uDC3E\uDC40\uDC44\uDC45\uDC51-\uDC65\uDC6A\uDC79-\uDC7B\uDC7D-\uDC80\uDC84\uDC88-\uDC8E\uDC90\uDC92-\uDCA9\uDCAB-\uDCFC\uDCFF-\uDD3D\uDD4B-\uDD4E\uDD50-\uDD67\uDDA4\uDDFB-\uDE2D\uDE2F-\uDE34\uDE37-\uDE44\uDE48-\uDE4A\uDE80-\uDEA2\uDEA4-\uDEB3\uDEB7-\uDEBF\uDEC1-\uDEC5\uDED0-\uDED2\uDED5-\uDED7\uDEDD-\uDEDF\uDEEB\uDEEC\uDEF4-\uDEFC\uDFE0-\uDFEB\uDFF0]|\uDC08(?:\u200D\u2B1B)?|\uDC15(?:\u200D\uD83E\uDDBA)?|\uDC3B(?:\u200D\u2744\uFE0F?)?|\uDC41\uFE0F?(?:\u200D\uD83D\uDDE8\uFE0F?)?|\uDC68(?:\u200D(?:[\u2695\u2696\u2708]\uFE0F?|\u2764\uFE0F?\u200D\uD83D(?:\uDC8B\u200D\uD83D)?\uDC68|\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D(?:[\uDC68\uDC69]\u200D\uD83D(?:\uDC66(?:\u200D\uD83D\uDC66)?|\uDC67(?:\u200D\uD83D[\uDC66\uDC67])?)|[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uDC66(?:\u200D\uD83D\uDC66)?|\uDC67(?:\u200D\uD83D[\uDC66\uDC67])?)|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD])|\uD83C(?:\uDFFB(?:\u200D(?:[\u2695\u2696\u2708]\uFE0F?|\u2764\uFE0F?\u200D\uD83D(?:\uDC8B\u200D\uD83D)?\uDC68\uD83C[\uDFFB-\uDFFF]|\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E(?:[\uDDAF-\uDDB3\uDDBC\uDDBD]|\uDD1D\u200D\uD83D\uDC68\uD83C[\uDFFC-\uDFFF])))?|\uDFFC(?:\u200D(?:[\u2695\u2696\u2708]\uFE0F?|\u2764\uFE0F?\u200D\uD83D(?:\uDC8B\u200D\uD83D)?\uDC68\uD83C[\uDFFB-\uDFFF]|\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E(?:[\uDDAF-\uDDB3\uDDBC\uDDBD]|\uDD1D\u200D\uD83D\uDC68\uD83C[\uDFFB\uDFFD-\uDFFF])))?|\uDFFD(?:\u200D(?:[\u2695\u2696\u2708]\uFE0F?|\u2764\uFE0F?\u200D\uD83D(?:\uDC8B\u200D\uD83D)?\uDC68\uD83C[\uDFFB-\uDFFF]|\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E(?:[\uDDAF-\uDDB3\uDDBC\uDDBD]|\uDD1D\u200D\uD83D\uDC68\uD83C[\uDFFB\uDFFC\uDFFE\uDFFF])))?|\uDFFE(?:\u200D(?:[\u2695\u2696\u2708]\uFE0F?|\u2764\uFE0F?\u200D\uD83D(?:\uDC8B\u200D\uD83D)?\uDC68\uD83C[\uDFFB-\uDFFF]|\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E(?:[\uDDAF-\uDDB3\uDDBC\uDDBD]|\uDD1D\u200D\uD83D\uDC68\uD83C[\uDFFB-\uDFFD\uDFFF])))?|\uDFFF(?:\u200D(?:[\u2695\u2696\u2708]\uFE0F?|\u2764\uFE0F?\u200D\uD83D(?:\uDC8B\u200D\uD83D)?\uDC68\uD83C[\uDFFB-\uDFFF]|\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E(?:[\uDDAF-\uDDB3\uDDBC\uDDBD]|\uDD1D\u200D\uD83D\uDC68\uD83C[\uDFFB-\uDFFE])))?))?|\uDC69(?:\u200D(?:[\u2695\u2696\u2708]\uFE0F?|\u2764\uFE0F?\u200D\uD83D(?:\uDC8B\u200D\uD83D)?[\uDC68\uDC69]|\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D(?:[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uDC66(?:\u200D\uD83D\uDC66)?|\uDC67(?:\u200D\uD83D[\uDC66\uDC67])?|\uDC69\u200D\uD83D(?:\uDC66(?:\u200D\uD83D\uDC66)?|\uDC67(?:\u200D\uD83D[\uDC66\uDC67])?))|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD])|\uD83C(?:\uDFFB(?:\u200D(?:[\u2695\u2696\u2708]\uFE0F?|\u2764\uFE0F?\u200D\uD83D(?:[\uDC68\uDC69]|\uDC8B\u200D\uD83D[\uDC68\uDC69])\uD83C[\uDFFB-\uDFFF]|\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E(?:[\uDDAF-\uDDB3\uDDBC\uDDBD]|\uDD1D\u200D\uD83D[\uDC68\uDC69]\uD83C[\uDFFC-\uDFFF])))?|\uDFFC(?:\u200D(?:[\u2695\u2696\u2708]\uFE0F?|\u2764\uFE0F?\u200D\uD83D(?:[\uDC68\uDC69]|\uDC8B\u200D\uD83D[\uDC68\uDC69])\uD83C[\uDFFB-\uDFFF]|\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E(?:[\uDDAF-\uDDB3\uDDBC\uDDBD]|\uDD1D\u200D\uD83D[\uDC68\uDC69]\uD83C[\uDFFB\uDFFD-\uDFFF])))?|\uDFFD(?:\u200D(?:[\u2695\u2696\u2708]\uFE0F?|\u2764\uFE0F?\u200D\uD83D(?:[\uDC68\uDC69]|\uDC8B\u200D\uD83D[\uDC68\uDC69])\uD83C[\uDFFB-\uDFFF]|\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E(?:[\uDDAF-\uDDB3\uDDBC\uDDBD]|\uDD1D\u200D\uD83D[\uDC68\uDC69]\uD83C[\uDFFB\uDFFC\uDFFE\uDFFF])))?|\uDFFE(?:\u200D(?:[\u2695\u2696\u2708]\uFE0F?|\u2764\uFE0F?\u200D\uD83D(?:[\uDC68\uDC69]|\uDC8B\u200D\uD83D[\uDC68\uDC69])\uD83C[\uDFFB-\uDFFF]|\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E(?:[\uDDAF-\uDDB3\uDDBC\uDDBD]|\uDD1D\u200D\uD83D[\uDC68\uDC69]\uD83C[\uDFFB-\uDFFD\uDFFF])))?|\uDFFF(?:\u200D(?:[\u2695\u2696\u2708]\uFE0F?|\u2764\uFE0F?\u200D\uD83D(?:[\uDC68\uDC69]|\uDC8B\u200D\uD83D[\uDC68\uDC69])\uD83C[\uDFFB-\uDFFF]|\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E(?:[\uDDAF-\uDDB3\uDDBC\uDDBD]|\uDD1D\u200D\uD83D[\uDC68\uDC69]\uD83C[\uDFFB-\uDFFE])))?))?|\uDC6F(?:\u200D[\u2640\u2642]\uFE0F?)?|\uDD75(?:\uFE0F|\uD83C[\uDFFB-\uDFFF])?(?:\u200D[\u2640\u2642]\uFE0F?)?|\uDE2E(?:\u200D\uD83D\uDCA8)?|\uDE35(?:\u200D\uD83D\uDCAB)?|\uDE36(?:\u200D\uD83C\uDF2B\uFE0F?)?)|\uD83E(?:[\uDD0C\uDD0F\uDD18-\uDD1F\uDD30-\uDD34\uDD36\uDD77\uDDB5\uDDB6\uDDBB\uDDD2\uDDD3\uDDD5\uDEC3-\uDEC5\uDEF0\uDEF2-\uDEF6](?:\uD83C[\uDFFB-\uDFFF])?|[\uDD26\uDD35\uDD37-\uDD39\uDD3D\uDD3E\uDDB8\uDDB9\uDDCD-\uDDCF\uDDD4\uDDD6-\uDDDD](?:\uD83C[\uDFFB-\uDFFF])?(?:\u200D[\u2640\u2642]\uFE0F?)?|[\uDDDE\uDDDF](?:\u200D[\u2640\u2642]\uFE0F?)?|[\uDD0D\uDD0E\uDD10-\uDD17\uDD20-\uDD25\uDD27-\uDD2F\uDD3A\uDD3F-\uDD45\uDD47-\uDD76\uDD78-\uDDB4\uDDB7\uDDBA\uDDBC-\uDDCC\uDDD0\uDDE0-\uDDFF\uDE70-\uDE74\uDE78-\uDE7C\uDE80-\uDE86\uDE90-\uDEAC\uDEB0-\uDEBA\uDEC0-\uDEC2\uDED0-\uDED9\uDEE0-\uDEE7]|\uDD3C(?:\u200D[\u2640\u2642]\uFE0F?|\uD83C[\uDFFB-\uDFFF])?|\uDDD1(?:\u200D(?:[\u2695\u2696\u2708]\uFE0F?|\uD83C[\uDF3E\uDF73\uDF7C\uDF84\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E(?:[\uDDAF-\uDDB3\uDDBC\uDDBD]|\uDD1D\u200D\uD83E\uDDD1))|\uD83C(?:\uDFFB(?:\u200D(?:[\u2695\u2696\u2708]\uFE0F?|\u2764\uFE0F?\u200D(?:\uD83D\uDC8B\u200D)?\uD83E\uDDD1\uD83C[\uDFFC-\uDFFF]|\uD83C[\uDF3E\uDF73\uDF7C\uDF84\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E(?:[\uDDAF-\uDDB3\uDDBC\uDDBD]|\uDD1D\u200D\uD83E\uDDD1\uD83C[\uDFFB-\uDFFF])))?|\uDFFC(?:\u200D(?:[\u2695\u2696\u2708]\uFE0F?|\u2764\uFE0F?\u200D(?:\uD83D\uDC8B\u200D)?\uD83E\uDDD1\uD83C[\uDFFB\uDFFD-\uDFFF]|\uD83C[\uDF3E\uDF73\uDF7C\uDF84\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E(?:[\uDDAF-\uDDB3\uDDBC\uDDBD]|\uDD1D\u200D\uD83E\uDDD1\uD83C[\uDFFB-\uDFFF])))?|\uDFFD(?:\u200D(?:[\u2695\u2696\u2708]\uFE0F?|\u2764\uFE0F?\u200D(?:\uD83D\uDC8B\u200D)?\uD83E\uDDD1\uD83C[\uDFFB\uDFFC\uDFFE\uDFFF]|\uD83C[\uDF3E\uDF73\uDF7C\uDF84\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E(?:[\uDDAF-\uDDB3\uDDBC\uDDBD]|\uDD1D\u200D\uD83E\uDDD1\uD83C[\uDFFB-\uDFFF])))?|\uDFFE(?:\u200D(?:[\u2695\u2696\u2708]\uFE0F?|\u2764\uFE0F?\u200D(?:\uD83D\uDC8B\u200D)?\uD83E\uDDD1\uD83C[\uDFFB-\uDFFD\uDFFF]|\uD83C[\uDF3E\uDF73\uDF7C\uDF84\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E(?:[\uDDAF-\uDDB3\uDDBC\uDDBD]|\uDD1D\u200D\uD83E\uDDD1\uD83C[\uDFFB-\uDFFF])))?|\uDFFF(?:\u200D(?:[\u2695\u2696\u2708]\uFE0F?|\u2764\uFE0F?\u200D(?:\uD83D\uDC8B\u200D)?\uD83E\uDDD1\uD83C[\uDFFB-\uDFFE]|\uD83C[\uDF3E\uDF73\uDF7C\uDF84\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E(?:[\uDDAF-\uDDB3\uDDBC\uDDBD]|\uDD1D\u200D\uD83E\uDDD1\uD83C[\uDFFB-\uDFFF])))?))?|\uDEF1(?:\uD83C(?:\uDFFB(?:\u200D\uD83E\uDEF2\uD83C[\uDFFC-\uDFFF])?|\uDFFC(?:\u200D\uD83E\uDEF2\uD83C[\uDFFB\uDFFD-\uDFFF])?|\uDFFD(?:\u200D\uD83E\uDEF2\uD83C[\uDFFB\uDFFC\uDFFE\uDFFF])?|\uDFFE(?:\u200D\uD83E\uDEF2\uD83C[\uDFFB-\uDFFD\uDFFF])?|\uDFFF(?:\u200D\uD83E\uDEF2\uD83C[\uDFFB-\uDFFE])?))?))/g;
};

/** Normalize a duration to all of the proper units. */
function normalizeDuration(dur) {
    if (dur === undefined || dur === null)
        return dur;
    return dur.shiftTo("years", "months", "weeks", "days", "hours", "minutes", "seconds", "milliseconds").normalize();
}
/** Strip the time components of a date time object. */
function stripTime(dt) {
    if (dt === null || dt === undefined)
        return dt;
    return DateTime_1.fromObject({
        year: dt.year,
        month: dt.month,
        day: dt.day,
    });
}
/** Get the folder containing the given path (i.e., like computing 'path/..'). */
function getParentFolder(path) {
    return path.split("/").slice(0, -1).join("/");
}
/** Get the "title" for a file, by stripping other parts of the path as well as the extension. */
function getFileTitle(path) {
    if (path.includes("/"))
        path = path.substring(path.lastIndexOf("/") + 1);
    if (path.endsWith(".md"))
        path = path.substring(0, path.length - 3);
    return path;
}
/** Get the extension of a file from the file path. */
function getExtension(path) {
    if (!path.includes("."))
        return "";
    return path.substring(path.lastIndexOf(".") + 1);
}
/** Parse all subtags out of the given tag. I.e., #hello/i/am would yield [#hello/i/am, #hello/i, #hello]. */
function extractSubtags(tag) {
    let result = [tag];
    while (tag.includes("/")) {
        tag = tag.substring(0, tag.lastIndexOf("/"));
        result.push(tag);
    }
    return result;
}
/** Try calling the given function; on failure, return the error message.  */
function tryOrPropogate(func) {
    try {
        return func();
    }
    catch (error) {
        return Result.failure("" + error + "\n\n" + error.stack);
    }
}
/** Try asynchronously calling the given function; on failure, return the error message. */
async function asyncTryOrPropogate(func) {
    try {
        return await func();
    }
    catch (error) {
        return Result.failure("" + error + "\n\n" + error.stack);
    }
}
/**
 * Escape regex characters in a string.
 * See https://developer.mozilla.org/en-US/docs/Web/JavaScript/Guide/Regular_Expressions.
 */
function escapeRegex(str) {
    return str.replace(/[.*+?^${}()|[\]\\]/g, "\\$&");
}
/** A parsimmon parser which canonicalizes variable names while properly respecting emoji. */
const VAR_NAME_CANONICALIZER = parsimmon_umd_min.exports.alt(parsimmon_umd_min.exports.regex(new RegExp(emojiRegex(), "")), parsimmon_umd_min.exports.regex(/[0-9\p{Letter}_-]+/u).map(str => str.toLocaleLowerCase()), parsimmon_umd_min.exports.whitespace.map(_ => "-"), parsimmon_umd_min.exports.any.map(_ => ""))
    .many()
    .map(result => result.join(""));
/** Convert an arbitrary variable name into something JS/query friendly. */
function canonicalizeVarName(name) {
    return VAR_NAME_CANONICALIZER.tryParse(name);
}
const HEADER_CANONICALIZER = parsimmon_umd_min.exports.alt(parsimmon_umd_min.exports.regex(new RegExp(emojiRegex(), "")), parsimmon_umd_min.exports.regex(/[0-9\p{Letter}_-]+/u), parsimmon_umd_min.exports.whitespace.map(_ => " "), parsimmon_umd_min.exports.any.map(_ => " "))
    .many()
    .map(result => {
    return result.join("").split(/\s+/).join(" ").trim();
});
/**
 * Normalizes the text in a header to be something that is actually linkable to. This mimics
 * how Obsidian does it's normalization, collapsing repeated spaces and stripping out control characters.
 */
function normalizeHeaderForLink(header) {
    return HEADER_CANONICALIZER.tryParse(header);
}
/** Render a DateTime in a minimal format to save space. */
function renderMinimalDate(time, settings, locale) {
    // If there is no relevant time specified, fall back to just rendering the date.
    if (time.second == 0 && time.minute == 0 && time.hour == 0) {
        return time.toLocal().toFormat(settings.defaultDateFormat, { locale });
    }
    return time.toLocal().toFormat(settings.defaultDateTimeFormat, { locale });
}
/** Render a duration in a minimal format to save space. */
function renderMinimalDuration(dur) {
    dur = normalizeDuration(dur);
    // TODO: Luxon does not have multi-lingual/locale-aware duration rendering.
    let result = "";
    if (dur.years)
        result += `${dur.years} years, `;
    if (dur.months)
        result += `${dur.months} months, `;
    if (dur.weeks)
        result += `${dur.weeks} weeks, `;
    if (dur.days)
        result += `${dur.days} days, `;
    if (dur.hours)
        result += `${dur.hours} hours, `;
    if (dur.minutes)
        result += `${dur.minutes} minutes, `;
    if (dur.seconds)
        result += `${Math.round(dur.seconds)} seconds, `;
    if (dur.milliseconds)
        result += `${Math.round(dur.milliseconds)} ms, `;
    if (result.endsWith(", "))
        result = result.substring(0, result.length - 2);
    return result;
}
/** Determine if two sets are equal in contents. */
function setsEqual(first, second) {
    if (first.size != second.size)
        return false;
    for (let elem of first)
        if (!second.has(elem))
            return false;
    return true;
}

var Values;
(function (Values) {
    /** Convert an arbitary value into a reasonable, Markdown-friendly string if possible. */
    function toString(field, setting = DEFAULT_QUERY_SETTINGS, recursive = false) {
        let wrapped = wrapValue(field);
        if (!wrapped)
            return setting.renderNullAs;
        switch (wrapped.type) {
            case "null":
                return setting.renderNullAs;
            case "string":
                return wrapped.value;
            case "number":
            case "boolean":
                return "" + wrapped.value;
            case "html":
                return wrapped.value.outerHTML;
            case "widget":
                return wrapped.value.markdown();
            case "link":
                return wrapped.value.markdown();
            case "function":
                return "<function>";
            case "array":
                let result = "";
                if (recursive)
                    result += "[";
                result += wrapped.value.map(f => toString(f, setting, true)).join(", ");
                if (recursive)
                    result += "]";
                return result;
            case "object":
                return ("{ " +
                    Object.entries(wrapped.value)
                        .map(e => e[0] + ": " + toString(e[1], setting, true))
                        .join(", ") +
                    " }");
            case "date":
                if (wrapped.value.second == 0 && wrapped.value.hour == 0 && wrapped.value.minute == 0) {
                    return wrapped.value.toFormat(setting.defaultDateFormat);
                }
                return wrapped.value.toFormat(setting.defaultDateTimeFormat);
            case "duration":
                return renderMinimalDuration(wrapped.value);
        }
    }
    Values.toString = toString;
    /** Wrap a literal value so you can switch on it easily. */
    function wrapValue(val) {
        if (isNull(val))
            return { type: "null", value: val };
        else if (isNumber(val))
            return { type: "number", value: val };
        else if (isString(val))
            return { type: "string", value: val };
        else if (isBoolean(val))
            return { type: "boolean", value: val };
        else if (isDuration(val))
            return { type: "duration", value: val };
        else if (isDate(val))
            return { type: "date", value: val };
        else if (isWidget(val))
            return { type: "widget", value: val };
        else if (isArray(val))
            return { type: "array", value: val };
        else if (isLink(val))
            return { type: "link", value: val };
        else if (isFunction(val))
            return { type: "function", value: val };
        else if (isHtml(val))
            return { type: "html", value: val };
        else if (isObject(val))
            return { type: "object", value: val };
        else
            return undefined;
    }
    Values.wrapValue = wrapValue;
    /** Recursively map complex objects at the leaves. */
    function mapLeaves(val, func) {
        if (isObject(val)) {
            let result = {};
            for (let [key, value] of Object.entries(val))
                result[key] = mapLeaves(value, func);
            return result;
        }
        else if (isArray(val)) {
            let result = [];
            for (let value of val)
                result.push(mapLeaves(value, func));
            return result;
        }
        else {
            return func(val);
        }
    }
    Values.mapLeaves = mapLeaves;
    /** Compare two arbitrary JavaScript values. Produces a total ordering over ANY possible dataview value. */
    function compareValue(val1, val2, linkNormalizer) {
        var _a, _b;
        // Handle undefined/nulls first.
        if (val1 === undefined)
            val1 = null;
        if (val2 === undefined)
            val2 = null;
        if (val1 === null && val2 === null)
            return 0;
        else if (val1 === null)
            return -1;
        else if (val2 === null)
            return 1;
        // A non-null value now which we can wrap & compare on.
        let wrap1 = wrapValue(val1);
        let wrap2 = wrapValue(val2);
        if (wrap1 === undefined && wrap2 === undefined)
            return 0;
        else if (wrap1 === undefined)
            return -1;
        else if (wrap2 === undefined)
            return 1;
        // Short-circuit on different types or on reference equality.
        if (wrap1.type != wrap2.type)
            return wrap1.type.localeCompare(wrap2.type);
        if (wrap1.value === wrap2.value)
            return 0;
        switch (wrap1.type) {
            case "string":
                return wrap1.value.localeCompare(wrap2.value);
            case "number":
                if (wrap1.value < wrap2.value)
                    return -1;
                else if (wrap1.value == wrap2.value)
                    return 0;
                return 1;
            case "null":
                return 0;
            case "boolean":
                if (wrap1.value == wrap2.value)
                    return 0;
                else
                    return wrap1.value ? 1 : -1;
            case "link":
                let link1 = wrap1.value;
                let link2 = wrap2.value;
                let normalize = linkNormalizer !== null && linkNormalizer !== void 0 ? linkNormalizer : ((x) => x);
                // We can't compare by file name or display, since that would break link equality. Compare by path.
                let pathCompare = normalize(link1.path).localeCompare(normalize(link2.path));
                if (pathCompare != 0)
                    return pathCompare;
                // Then compare by type.
                let typeCompare = link1.type.localeCompare(link2.type);
                if (typeCompare != 0)
                    return typeCompare;
                // Then compare by subpath existence.
                if (link1.subpath && !link2.subpath)
                    return 1;
                if (!link1.subpath && link2.subpath)
                    return -1;
                if (!link1.subpath && !link2.subpath)
                    return 0;
                // Since both have a subpath, compare by subpath.
                return ((_a = link1.subpath) !== null && _a !== void 0 ? _a : "").localeCompare((_b = link2.subpath) !== null && _b !== void 0 ? _b : "");
            case "date":
                return wrap1.value < wrap2.value
                    ? -1
                    : wrap1.value.equals(wrap2.value)
                        ? 0
                        : 1;
            case "duration":
                return wrap1.value < wrap2.value
                    ? -1
                    : wrap1.value.equals(wrap2.value)
                        ? 0
                        : 1;
            case "array":
                let f1 = wrap1.value;
                let f2 = wrap2.value;
                for (let index = 0; index < Math.min(f1.length, f2.length); index++) {
                    let comp = compareValue(f1[index], f2[index]);
                    if (comp != 0)
                        return comp;
                }
                return f1.length - f2.length;
            case "object":
                let o1 = wrap1.value;
                let o2 = wrap2.value;
                let k1 = Array.from(Object.keys(o1));
                let k2 = Array.from(Object.keys(o2));
                k1.sort();
                k2.sort();
                let keyCompare = compareValue(k1, k2);
                if (keyCompare != 0)
                    return keyCompare;
                for (let key of k1) {
                    let comp = compareValue(o1[key], o2[key]);
                    if (comp != 0)
                        return comp;
                }
                return 0;
            case "widget":
            case "html":
            case "function":
                return 0;
        }
    }
    Values.compareValue = compareValue;
    /** Find the corresponding Dataveiw type for an arbitrary value. */
    function typeOf(val) {
        var _a;
        return (_a = wrapValue(val)) === null || _a === void 0 ? void 0 : _a.type;
    }
    Values.typeOf = typeOf;
    /** Determine if the given value is "truthy" (i.e., is non-null and has data in it). */
    function isTruthy(field) {
        let wrapped = wrapValue(field);
        if (!wrapped)
            return false;
        switch (wrapped.type) {
            case "number":
                return wrapped.value != 0;
            case "string":
                return wrapped.value.length > 0;
            case "boolean":
                return wrapped.value;
            case "link":
                return !!wrapped.value.path;
            case "date":
                return wrapped.value.toMillis() != 0;
            case "duration":
                return wrapped.value.as("seconds") != 0;
            case "object":
                return Object.keys(wrapped.value).length > 0;
            case "array":
                return wrapped.value.length > 0;
            case "null":
                return false;
            case "html":
            case "widget":
            case "function":
                return true;
        }
    }
    Values.isTruthy = isTruthy;
    /** Deep copy a field. */
    function deepCopy(field) {
        if (field === null || field === undefined)
            return field;
        if (Values.isArray(field)) {
            return [].concat(field.map(v => deepCopy(v)));
        }
        else if (Values.isObject(field)) {
            let result = {};
            for (let [key, value] of Object.entries(field))
                result[key] = deepCopy(value);
            return result;
        }
        else {
            return field;
        }
    }
    Values.deepCopy = deepCopy;
    function isString(val) {
        return typeof val == "string";
    }
    Values.isString = isString;
    function isNumber(val) {
        return typeof val == "number";
    }
    Values.isNumber = isNumber;
    function isDate(val) {
        return val instanceof DateTime_1;
    }
    Values.isDate = isDate;
    function isDuration(val) {
        return val instanceof Duration_1;
    }
    Values.isDuration = isDuration;
    function isNull(val) {
        return val === null || val === undefined;
    }
    Values.isNull = isNull;
    function isArray(val) {
        return Array.isArray(val);
    }
    Values.isArray = isArray;
    function isBoolean(val) {
        return typeof val === "boolean";
    }
    Values.isBoolean = isBoolean;
    function isLink(val) {
        return val instanceof Link;
    }
    Values.isLink = isLink;
    function isWidget(val) {
        return val instanceof Widget;
    }
    Values.isWidget = isWidget;
    function isHtml(val) {
        if (typeof HTMLElement !== "undefined") {
            return val instanceof HTMLElement;
        }
        else {
            return false;
        }
    }
    Values.isHtml = isHtml;
    /** Checks if the given value is an object (and not any other dataview-recognized object-like type). */
    function isObject(val) {
        return (typeof val == "object" &&
            !isHtml(val) &&
            !isWidget(val) &&
            !isArray(val) &&
            !isDuration(val) &&
            !isDate(val) &&
            !isLink(val) &&
            val !== undefined &&
            !isNull(val));
    }
    Values.isObject = isObject;
    function isFunction(val) {
        return typeof val == "function";
    }
    Values.isFunction = isFunction;
})(Values || (Values = {}));
///////////////
// Groupings //
///////////////
var Groupings;
(function (Groupings) {
    /** Determines if the given group entry is a standalone value, or a grouping of sub-entries. */
    function isElementGroup(entry) {
        return Values.isObject(entry) && Object.keys(entry).length == 2 && "key" in entry && "rows" in entry;
    }
    Groupings.isElementGroup = isElementGroup;
    /** Determines if the given array is a grouping array. */
    function isGrouping(entry) {
        for (let element of entry)
            if (!isElementGroup(element))
                return false;
        return true;
    }
    Groupings.isGrouping = isGrouping;
    /** Count the total number of elements in a recursive grouping. */
    function count(elements) {
        if (isGrouping(elements)) {
            let result = 0;
            for (let subgroup of elements)
                result += count(subgroup.rows);
            return result;
        }
        else {
            return elements.length;
        }
    }
    Groupings.count = count;
})(Groupings || (Groupings = {}));
//////////
// LINK //
//////////
/** The Obsidian 'link', used for uniquely describing a file, header, or block. */
class Link {
    constructor(fields) {
        Object.assign(this, fields);
    }
    /** Create a link to a specific file. */
    static file(path, embed = false, display) {
        return new Link({
            path,
            embed,
            display,
            subpath: undefined,
            type: "file",
        });
    }
    static infer(linkpath, embed = false, display) {
        if (linkpath.includes("#^")) {
            let split = linkpath.split("#^");
            return Link.block(split[0], split[1], embed, display);
        }
        else if (linkpath.includes("#")) {
            let split = linkpath.split("#");
            return Link.header(split[0], split[1], embed, display);
        }
        else
            return Link.file(linkpath, embed, display);
    }
    /** Create a link to a specific file and header in that file. */
    static header(path, header, embed, display) {
        // Headers need to be normalized to alpha-numeric & with extra spacing removed.
        return new Link({
            path,
            embed,
            display,
            subpath: normalizeHeaderForLink(header),
            type: "header",
        });
    }
    /** Create a link to a specific file and block in that file. */
    static block(path, blockId, embed, display) {
        return new Link({
            path,
            embed,
            display,
            subpath: blockId,
            type: "block",
        });
    }
    static fromObject(object) {
        return new Link(object);
    }
    /** Checks for link equality (i.e., that the links are pointing to the same exact location). */
    equals(other) {
        if (other == undefined || other == null)
            return false;
        return this.path == other.path && this.type == other.type && this.subpath == other.subpath;
    }
    /** Convert this link to it's markdown representation. */
    toString() {
        return this.markdown();
    }
    /** Convert this link to a raw object which is serialization-friendly. */
    toObject() {
        return { path: this.path, type: this.type, subpath: this.subpath, display: this.display, embed: this.embed };
    }
    /** Update this link with a new path. */
    //@ts-ignore; error appeared after updating Obsidian to 0.15.4; it also updated other packages but didn't say which
    withPath(path) {
        return new Link(Object.assign({}, this, { path }));
    }
    /** Return a new link which points to the same location but with a new display value. */
    withDisplay(display) {
        return new Link(Object.assign({}, this, { display }));
    }
    /** Convert a file link into a link to a specific header. */
    withHeader(header) {
        return Link.header(this.path, header, this.embed, this.display);
    }
    /** Convert any link into a link to its file. */
    toFile() {
        return Link.file(this.path, this.embed, this.display);
    }
    /** Convert this link into an embedded link. */
    toEmbed() {
        if (this.embed) {
            return this;
        }
        else {
            let link = new Link(this);
            link.embed = true;
            return link;
        }
    }
    /** Convert this link into a non-embedded link. */
    fromEmbed() {
        if (!this.embed) {
            return this;
        }
        else {
            let link = new Link(this);
            link.embed = false;
            return link;
        }
    }
    /** Convert this link to markdown so it can be rendered. */
    markdown() {
        let result = (this.embed ? "!" : "") + "[[" + this.obsidianLink();
        if (this.display) {
            result += "|" + this.display;
        }
        else {
            result += "|" + getFileTitle(this.path);
            if (this.type == "header" || this.type == "block")
                result += " > " + this.subpath;
        }
        result += "]]";
        return result;
    }
    /** Convert the inner part of the link to something that Obsidian can open / understand. */
    obsidianLink() {
        var _a, _b;
        const escaped = this.path.replace("|", "\\|");
        if (this.type == "header")
            return escaped + "#" + ((_a = this.subpath) === null || _a === void 0 ? void 0 : _a.replace("|", "\\|"));
        if (this.type == "block")
            return escaped + "#^" + ((_b = this.subpath) === null || _b === void 0 ? void 0 : _b.replace("|", "\\|"));
        else
            return escaped;
    }
    /** The stripped name of the file this link points to. */
    fileName() {
        return getFileTitle(this.path).replace(".md", "");
    }
}
/////////////////
// WIDGET BASE //
/////////////////
/**
 * A trivial base class which just defines the '$widget' identifier type. Subtypes of
 * widget are responsible for adding whatever metadata is relevant. If you want your widget
 * to have rendering functionality (which you probably do), you should extend `RenderWidget`.
 */
class Widget {
    constructor($widget) {
        this.$widget = $widget;
    }
}
/** A trivial widget which renders a (key, value) pair, and allows accessing the key and value. */
class ListPairWidget extends Widget {
    constructor(key, value) {
        super("dataview:list-pair");
        this.key = key;
        this.value = value;
    }
    markdown() {
        return `${Values.toString(this.key)}: ${Values.toString(this.value)}`;
    }
}
/** A simple widget which renders an external link. */
class ExternalLinkWidget extends Widget {
    constructor(url, display) {
        super("dataview:external-link");
        this.url = url;
        this.display = display;
    }
    markdown() {
        var _a;
        return `[${(_a = this.display) !== null && _a !== void 0 ? _a : this.url}](${this.url})`;
    }
}
var Widgets;
(function (Widgets) {
    /** Create a list pair widget matching the given key and value. */
    function listPair(key, value) {
        return new ListPairWidget(key, value);
    }
    Widgets.listPair = listPair;
    /** Create an external link widget which renders an external Obsidian link. */
    function externalLink(url, display) {
        return new ExternalLinkWidget(url, display);
    }
    Widgets.externalLink = externalLink;
    /** Checks if the given widget is a list pair widget. */
    function isListPair(widget) {
        return widget.$widget === "dataview:list-pair";
    }
    Widgets.isListPair = isListPair;
    function isExternalLink(widget) {
        return widget.$widget === "dataview:external-link";
    }
    Widgets.isExternalLink = isExternalLink;
    /** Determines if the given widget is any kind of built-in widget with special rendering handling. */
    function isBuiltin(widget) {
        return isListPair(widget) || isExternalLink(widget);
    }
    Widgets.isBuiltin = isBuiltin;
})(Widgets || (Widgets = {}));

/** Implementation of DataArray, minus the dynamic variable access, which is implemented via proxy. */
class DataArrayImpl {
    constructor(values, settings, defaultComparator = Values.compareValue) {
        this.values = values;
        this.settings = settings;
        this.defaultComparator = defaultComparator;
        this.length = values.length;
    }
    static wrap(arr, settings, defaultComparator = Values.compareValue) {
        return new Proxy(new DataArrayImpl(arr, settings, defaultComparator), DataArrayImpl.ARRAY_PROXY);
    }
    lwrap(values) {
        return DataArrayImpl.wrap(values, this.settings, this.defaultComparator);
    }
    where(predicate) {
        return this.lwrap(this.values.filter(predicate));
    }
    filter(predicate) {
        return this.where(predicate);
    }
    map(f) {
        return this.lwrap(this.values.map(f));
    }
    flatMap(f) {
        let result = [];
        for (let index = 0; index < this.length; index++) {
            let value = f(this.values[index], index, this.values);
            if (!value || value.length == 0)
                continue;
            for (let r of value)
                result.push(r);
        }
        return this.lwrap(result);
    }
    mutate(f) {
        for (let index = 0; index < this.values.length; index++) {
            f(this.values[index], index, this.values);
        }
        return this;
    }
    limit(count) {
        return this.lwrap(this.values.slice(0, count));
    }
    slice(start, end) {
        return this.lwrap(this.values.slice(start, end));
    }
    concat(other) {
        return this.lwrap(this.values.concat(other.values));
    }
    /** Return the first index of the given (optionally starting the search) */
    indexOf(element, fromIndex) {
        return this.findIndex(e => this.defaultComparator(e, element) == 0, fromIndex);
    }
    /** Return the first element that satisfies the given predicate. */
    find(pred) {
        let index = this.findIndex(pred);
        if (index == -1)
            return undefined;
        else
            return this.values[index];
    }
    findIndex(pred, fromIndex) {
        for (let index = fromIndex !== null && fromIndex !== void 0 ? fromIndex : 0; index < this.length; index++) {
            if (pred(this.values[index], index, this.values))
                return index;
        }
        return -1;
    }
    includes(element) {
        return this.indexOf(element, 0) != -1;
    }
    join(sep) {
        return this.map(s => Values.toString(s, this.settings))
            .array()
            .join(sep !== null && sep !== void 0 ? sep : ", ");
    }
    sort(key, direction, comparator) {
        if (this.values.length == 0)
            return this;
        let realComparator = comparator !== null && comparator !== void 0 ? comparator : this.defaultComparator;
        let realKey = key !== null && key !== void 0 ? key : ((l) => l);
        // Associate each entry with it's index for the key function, and then do a normal sort.
        let copy = [].concat(this.array()).map((elem, index) => {
            return { index: index, value: elem };
        });
        copy.sort((a, b) => {
            let aKey = realKey(a.value, a.index, this.values);
            let bKey = realKey(b.value, b.index, this.values);
            return direction === "desc" ? -realComparator(aKey, bKey) : realComparator(aKey, bKey);
        });
        return this.lwrap(copy.map(e => e.value));
    }
    sortInPlace(key, direction, comparator) {
        if (this.values.length == 0)
            return this;
        let realComparator = comparator !== null && comparator !== void 0 ? comparator : this.defaultComparator;
        let realKey = key !== null && key !== void 0 ? key : ((l) => l);
        this.values.sort((a, b) => {
            let aKey = realKey(a);
            let bKey = realKey(b);
            return direction == "desc" ? -realComparator(aKey, bKey) : realComparator(aKey, bKey);
        });
        return this;
    }
    groupBy(key, comparator) {
        if (this.values.length == 0)
            return this.lwrap([]);
        // JavaScript sucks and we can't make hash maps over arbitrary types (only strings/ints), so
        // we do a poor man algorithm where we SORT, followed by grouping.
        let intermediate = this.sort(key, "asc", comparator);
        comparator = comparator !== null && comparator !== void 0 ? comparator : this.defaultComparator;
        let result = [];
        let currentRow = [intermediate[0]];
        let current = key(intermediate[0], 0, intermediate.values);
        for (let index = 1; index < intermediate.length; index++) {
            let newKey = key(intermediate[index], index, intermediate.values);
            if (comparator(current, newKey) != 0) {
                result.push({ key: current, rows: this.lwrap(currentRow) });
                current = newKey;
                currentRow = [intermediate[index]];
            }
            else {
                currentRow.push(intermediate[index]);
            }
        }
        result.push({ key: current, rows: this.lwrap(currentRow) });
        return this.lwrap(result);
    }
    groupIn(key, comparator) {
        if (Groupings.isGrouping(this.values)) {
            return this.map(v => {
                return {
                    key: v.key,
                    rows: DataArray.wrap(v.rows, this.settings).groupIn(key, comparator),
                };
            });
        }
        else {
            return this.groupBy(key, comparator);
        }
    }
    distinct(key, comparator) {
        if (this.values.length == 0)
            return this;
        let realKey = key !== null && key !== void 0 ? key : (x => x);
        // For similar reasons to groupBy, do a sort and take the first element of each block.
        let intermediate = this.map((x, index) => {
            return { key: realKey(x, index, this.values), value: x };
        }).sort(x => x.key, "asc", comparator);
        comparator = comparator !== null && comparator !== void 0 ? comparator : this.defaultComparator;
        let result = [intermediate[0].value];
        for (let index = 1; index < intermediate.length; index++) {
            if (comparator(intermediate[index - 1].key, intermediate[index].key) != 0) {
                result.push(intermediate[index].value);
            }
        }
        return this.lwrap(result);
    }
    every(f) {
        return this.values.every(f);
    }
    some(f) {
        return this.values.some(f);
    }
    none(f) {
        return this.values.every((v, i, a) => !f(v, i, a));
    }
    first() {
        return this.values.length > 0 ? this.values[0] : undefined;
    }
    last() {
        return this.values.length > 0 ? this.values[this.values.length - 1] : undefined;
    }
    to(key) {
        let result = [];
        for (let child of this.values) {
            let value = child[key];
            if (value === undefined || value === null)
                continue;
            if (Array.isArray(value) || DataArray.isDataArray(value))
                value.forEach(v => result.push(v));
            else
                result.push(value);
        }
        return this.lwrap(result);
    }
    into(key) {
        let result = [];
        for (let child of this.values) {
            let value = child[key];
            if (value === undefined || value === null)
                continue;
            result.push(value);
        }
        return this.lwrap(result);
    }
    expand(key) {
        let result = [];
        let queue = [].concat(this.values);
        while (queue.length > 0) {
            let next = queue.pop();
            let value = next[key];
            if (value === undefined || value === null)
                continue;
            if (Array.isArray(value))
                value.forEach(v => queue.push(v));
            else if (value instanceof DataArrayImpl)
                value.forEach(v => queue.push(v));
            else
                queue.push(value);
            result.push(next);
        }
        return this.lwrap(result);
    }
    forEach(f) {
        for (let index = 0; index < this.values.length; index++) {
            f(this.values[index], index, this.values);
        }
    }
    array() {
        return [].concat(this.values);
    }
    [Symbol.iterator]() {
        return this.values[Symbol.iterator]();
    }
    toString() {
        return "[" + this.values.join(", ") + "]";
    }
}
DataArrayImpl.ARRAY_FUNCTIONS = new Set([
    "where",
    "filter",
    "map",
    "flatMap",
    "mutate",
    "slice",
    "concat",
    "indexOf",
    "limit",
    "find",
    "findIndex",
    "includes",
    "join",
    "sort",
    "sortInPlace",
    "groupBy",
    "groupIn",
    "distinct",
    "every",
    "some",
    "none",
    "first",
    "last",
    "to",
    "into",
    "lwrap",
    "expand",
    "forEach",
    "length",
    "values",
    "array",
    "defaultComparator",
    "toString",
    "settings",
]);
DataArrayImpl.ARRAY_PROXY = {
    get: function (target, prop, reciever) {
        if (typeof prop === "symbol")
            return target[prop];
        else if (typeof prop === "number")
            return target.values[prop];
        else if (prop === "constructor")
            return target.values.constructor;
        else if (!isNaN(parseInt(prop)))
            return target.values[parseInt(prop)];
        else if (DataArrayImpl.ARRAY_FUNCTIONS.has(prop.toString()))
            return target[prop.toString()];
        return target.to(prop);
    },
};
/** Provides utility functions for generating data arrays. */
var DataArray;
(function (DataArray) {
    /** Create a new Dataview data array. */
    function wrap(raw, settings) {
        if (isDataArray(raw))
            return raw;
        return DataArrayImpl.wrap(raw, settings);
    }
    DataArray.wrap = wrap;
    /** Create a new DataArray from an iterable object. */
    function from(raw, settings) {
        if (isDataArray(raw))
            return raw;
        let data = [];
        for (let elem of raw)
            data.push(elem);
        return DataArrayImpl.wrap(data, settings);
    }
    DataArray.from = from;
    /** Return true if the given object is a data array. */
    function isDataArray(obj) {
        return obj instanceof DataArrayImpl;
    }
    DataArray.isDataArray = isDataArray;
})(DataArray || (DataArray = {}));
// A scary looking polyfill, sure, but it fixes up data array/array interop for us.
const oldArrayIsArray = Array.isArray;
Array.isArray = (arg) => {
    return oldArrayIsArray(arg) || DataArray.isDataArray(arg);
};

/** Test-environment-friendly function which fetches the current system locale. */
function currentLocale() {
    if (typeof window === "undefined")
        return "en-US";
    return window.navigator.language;
}

/** Render simple fields compactly, removing wrapping content like paragraph and span. */
async function renderCompactMarkdown(markdown, container, sourcePath, component) {
    let subcontainer = container.createSpan();
    await obsidian.MarkdownRenderer.renderMarkdown(markdown, subcontainer, sourcePath, component);
    let paragraph = subcontainer.querySelector(":scope > p");
    if (subcontainer.children.length == 1 && paragraph) {
        while (paragraph.firstChild) {
            subcontainer.appendChild(paragraph.firstChild);
        }
        subcontainer.removeChild(paragraph);
    }
}
/** Render a pre block with an error in it; returns the element to allow for dynamic updating. */
function renderErrorPre(container, error) {
    let pre = container.createEl("pre", { cls: ["dataview", "dataview-error"] });
    pre.appendText(error);
    return pre;
}
/** Render a static codeblock. */
function renderCodeBlock(container, source, language) {
    let code = container.createEl("code", { cls: ["dataview"] });
    if (language)
        code.classList.add("language-" + language);
    code.appendText(source);
    return code;
}
/** Prettily render a value into a container with the given settings. */
async function renderValue(field, container, originFile, component, settings, expandList = false, context = "root", depth = 0) {
    var _a, _b, _c;
    // Prevent infinite recursion.
    if (depth > settings.maxRecursiveRenderDepth) {
        container.appendText("...");
        return;
    }
    if (Values.isNull(field)) {
        await renderCompactMarkdown(settings.renderNullAs, container, originFile, component);
    }
    else if (Values.isDate(field)) {
        container.appendText(renderMinimalDate(field, settings, currentLocale()));
    }
    else if (Values.isDuration(field)) {
        container.appendText(renderMinimalDuration(field));
    }
    else if (Values.isString(field) || Values.isBoolean(field) || Values.isNumber(field)) {
        await renderCompactMarkdown("" + field, container, originFile, component);
    }
    else if (Values.isLink(field)) {
        await renderCompactMarkdown(field.markdown(), container, originFile, component);
    }
    else if (Values.isHtml(field)) {
        container.appendChild(field);
    }
    else if (Values.isWidget(field)) {
        if (Widgets.isListPair(field)) {
            await renderValue(field.key, container, originFile, component, settings, expandList, context, depth);
            container.appendText(": ");
            await renderValue(field.value, container, originFile, component, settings, expandList, context, depth);
        }
        else if (Widgets.isExternalLink(field)) {
            let elem = document.createElement("a");
            elem.textContent = (_a = field.display) !== null && _a !== void 0 ? _a : field.url;
            elem.rel = "noopener";
            elem.target = "_blank";
            elem.classList.add("external-link");
            elem.href = field.url;
            container.appendChild(elem);
        }
        else {
            container.appendText(`<unknown widget '${field.$widget}>`);
        }
    }
    else if (Values.isFunction(field)) {
        container.appendText("<function>");
    }
    else if (Values.isArray(field) || DataArray.isDataArray(field)) {
        if (expandList) {
            let list = container.createEl("ul", {
                cls: [
                    "dataview",
                    "dataview-ul",
                    context == "list" ? "dataview-result-list-ul" : "dataview-result-list-root-ul",
                ],
            });
            for (let child of field) {
                let li = list.createEl("li", { cls: "dataview-result-list-li" });
                await renderValue(child, li, originFile, component, settings, expandList, "list", depth + 1);
            }
        }
        else {
            if (field.length == 0) {
                container.appendText("<empty list>");
                return;
            }
            let span = container.createEl("span", { cls: ["dataview", "dataview-result-list-span"] });
            let first = true;
            for (let val of field) {
                if (first)
                    first = false;
                else
                    span.appendText(", ");
                await renderValue(val, span, originFile, component, settings, expandList, "list", depth + 1);
            }
        }
    }
    else if (Values.isObject(field)) {
        // Don't render classes in case they have recursive references; spoopy.
        if (((_b = field === null || field === void 0 ? void 0 : field.constructor) === null || _b === void 0 ? void 0 : _b.name) && ((_c = field === null || field === void 0 ? void 0 : field.constructor) === null || _c === void 0 ? void 0 : _c.name) != "Object") {
            container.appendText(`<${field.constructor.name}>`);
            return;
        }
        if (expandList) {
            let list = container.createEl("ul", { cls: ["dataview", "dataview-ul", "dataview-result-object-ul"] });
            for (let [key, value] of Object.entries(field)) {
                let li = list.createEl("li", { cls: ["dataview", "dataview-li", "dataview-result-object-li"] });
                li.appendText(key + ": ");
                await renderValue(value, li, originFile, component, settings, expandList, "list", depth + 1);
            }
        }
        else {
            if (Object.keys(field).length == 0) {
                container.appendText("<empty object>");
                return;
            }
            let span = container.createEl("span", { cls: ["dataview", "dataview-result-object-span"] });
            let first = true;
            for (let [key, value] of Object.entries(field)) {
                if (first)
                    first = false;
                else
                    span.appendText(", ");
                span.appendText(key + ": ");
                await renderValue(value, span, originFile, component, settings, expandList, "list", depth + 1);
            }
        }
    }
    else {
        container.appendText("Unrecognized: " + JSON.stringify(field));
    }
}

var papaparse_min = {exports: {}};

/* @license
Papa Parse
v5.3.2
https://github.com/mholt/PapaParse
License: MIT
*/

(function (module, exports) {
!function(e,t){module.exports=t();}(commonjsGlobal,function s(){var f="undefined"!=typeof self?self:"undefined"!=typeof window?window:void 0!==f?f:{};var n=!f.document&&!!f.postMessage,o=n&&/blob:/i.test((f.location||{}).protocol),a={},h=0,b={parse:function(e,t){var i=(t=t||{}).dynamicTyping||!1;M(i)&&(t.dynamicTypingFunction=i,i={});if(t.dynamicTyping=i,t.transform=!!M(t.transform)&&t.transform,t.worker&&b.WORKERS_SUPPORTED){var r=function(){if(!b.WORKERS_SUPPORTED)return !1;var e=(i=f.URL||f.webkitURL||null,r=s.toString(),b.BLOB_URL||(b.BLOB_URL=i.createObjectURL(new Blob(["(",r,")();"],{type:"text/javascript"})))),t=new f.Worker(e);var i,r;return t.onmessage=_,t.id=h++,a[t.id]=t}();return r.userStep=t.step,r.userChunk=t.chunk,r.userComplete=t.complete,r.userError=t.error,t.step=M(t.step),t.chunk=M(t.chunk),t.complete=M(t.complete),t.error=M(t.error),delete t.worker,void r.postMessage({input:e,config:t,workerId:r.id})}var n=null;b.NODE_STREAM_INPUT,"string"==typeof e?n=t.download?new l(t):new p(t):!0===e.readable&&M(e.read)&&M(e.on)?n=new g(t):(f.File&&e instanceof File||e instanceof Object)&&(n=new c(t));return n.stream(e)},unparse:function(e,t){var n=!1,_=!0,m=",",y="\r\n",s='"',a=s+s,i=!1,r=null,o=!1;!function(){if("object"!=typeof t)return;"string"!=typeof t.delimiter||b.BAD_DELIMITERS.filter(function(e){return -1!==t.delimiter.indexOf(e)}).length||(m=t.delimiter);("boolean"==typeof t.quotes||"function"==typeof t.quotes||Array.isArray(t.quotes))&&(n=t.quotes);"boolean"!=typeof t.skipEmptyLines&&"string"!=typeof t.skipEmptyLines||(i=t.skipEmptyLines);"string"==typeof t.newline&&(y=t.newline);"string"==typeof t.quoteChar&&(s=t.quoteChar);"boolean"==typeof t.header&&(_=t.header);if(Array.isArray(t.columns)){if(0===t.columns.length)throw new Error("Option columns is empty");r=t.columns;}void 0!==t.escapeChar&&(a=t.escapeChar+s);("boolean"==typeof t.escapeFormulae||t.escapeFormulae instanceof RegExp)&&(o=t.escapeFormulae instanceof RegExp?t.escapeFormulae:/^[=+\-@\t\r].*$/);}();var h=new RegExp(j(s),"g");"string"==typeof e&&(e=JSON.parse(e));if(Array.isArray(e)){if(!e.length||Array.isArray(e[0]))return u(null,e,i);if("object"==typeof e[0])return u(r||Object.keys(e[0]),e,i)}else if("object"==typeof e)return "string"==typeof e.data&&(e.data=JSON.parse(e.data)),Array.isArray(e.data)&&(e.fields||(e.fields=e.meta&&e.meta.fields||r),e.fields||(e.fields=Array.isArray(e.data[0])?e.fields:"object"==typeof e.data[0]?Object.keys(e.data[0]):[]),Array.isArray(e.data[0])||"object"==typeof e.data[0]||(e.data=[e.data])),u(e.fields||[],e.data||[],i);throw new Error("Unable to serialize unrecognized input");function u(e,t,i){var r="";"string"==typeof e&&(e=JSON.parse(e)),"string"==typeof t&&(t=JSON.parse(t));var n=Array.isArray(e)&&0<e.length,s=!Array.isArray(t[0]);if(n&&_){for(var a=0;a<e.length;a++)0<a&&(r+=m),r+=v(e[a],a);0<t.length&&(r+=y);}for(var o=0;o<t.length;o++){var h=n?e.length:t[o].length,u=!1,f=n?0===Object.keys(t[o]).length:0===t[o].length;if(i&&!n&&(u="greedy"===i?""===t[o].join("").trim():1===t[o].length&&0===t[o][0].length),"greedy"===i&&n){for(var d=[],l=0;l<h;l++){var c=s?e[l]:l;d.push(t[o][c]);}u=""===d.join("").trim();}if(!u){for(var p=0;p<h;p++){0<p&&!f&&(r+=m);var g=n&&s?e[p]:p;r+=v(t[o][g],p);}o<t.length-1&&(!i||0<h&&!f)&&(r+=y);}}return r}function v(e,t){if(null==e)return "";if(e.constructor===Date)return JSON.stringify(e).slice(1,25);var i=!1;o&&"string"==typeof e&&o.test(e)&&(e="'"+e,i=!0);var r=e.toString().replace(h,a);return (i=i||!0===n||"function"==typeof n&&n(e,t)||Array.isArray(n)&&n[t]||function(e,t){for(var i=0;i<t.length;i++)if(-1<e.indexOf(t[i]))return !0;return !1}(r,b.BAD_DELIMITERS)||-1<r.indexOf(m)||" "===r.charAt(0)||" "===r.charAt(r.length-1))?s+r+s:r}}};if(b.RECORD_SEP=String.fromCharCode(30),b.UNIT_SEP=String.fromCharCode(31),b.BYTE_ORDER_MARK="\ufeff",b.BAD_DELIMITERS=["\r","\n",'"',b.BYTE_ORDER_MARK],b.WORKERS_SUPPORTED=!n&&!!f.Worker,b.NODE_STREAM_INPUT=1,b.LocalChunkSize=10485760,b.RemoteChunkSize=5242880,b.DefaultDelimiter=",",b.Parser=E,b.ParserHandle=i,b.NetworkStreamer=l,b.FileStreamer=c,b.StringStreamer=p,b.ReadableStreamStreamer=g,f.jQuery){var d=f.jQuery;d.fn.parse=function(o){var i=o.config||{},h=[];return this.each(function(e){if(!("INPUT"===d(this).prop("tagName").toUpperCase()&&"file"===d(this).attr("type").toLowerCase()&&f.FileReader)||!this.files||0===this.files.length)return !0;for(var t=0;t<this.files.length;t++)h.push({file:this.files[t],inputElem:this,instanceConfig:d.extend({},i)});}),e(),this;function e(){if(0!==h.length){var e,t,i,r,n=h[0];if(M(o.before)){var s=o.before(n.file,n.inputElem);if("object"==typeof s){if("abort"===s.action)return e="AbortError",t=n.file,i=n.inputElem,r=s.reason,void(M(o.error)&&o.error({name:e},t,i,r));if("skip"===s.action)return void u();"object"==typeof s.config&&(n.instanceConfig=d.extend(n.instanceConfig,s.config));}else if("skip"===s)return void u()}var a=n.instanceConfig.complete;n.instanceConfig.complete=function(e){M(a)&&a(e,n.file,n.inputElem),u();},b.parse(n.file,n.instanceConfig);}else M(o.complete)&&o.complete();}function u(){h.splice(0,1),e();}};}function u(e){this._handle=null,this._finished=!1,this._completed=!1,this._halted=!1,this._input=null,this._baseIndex=0,this._partialLine="",this._rowCount=0,this._start=0,this._nextChunk=null,this.isFirstChunk=!0,this._completeResults={data:[],errors:[],meta:{}},function(e){var t=w(e);t.chunkSize=parseInt(t.chunkSize),e.step||e.chunk||(t.chunkSize=null);this._handle=new i(t),(this._handle.streamer=this)._config=t;}.call(this,e),this.parseChunk=function(e,t){if(this.isFirstChunk&&M(this._config.beforeFirstChunk)){var i=this._config.beforeFirstChunk(e);void 0!==i&&(e=i);}this.isFirstChunk=!1,this._halted=!1;var r=this._partialLine+e;this._partialLine="";var n=this._handle.parse(r,this._baseIndex,!this._finished);if(!this._handle.paused()&&!this._handle.aborted()){var s=n.meta.cursor;this._finished||(this._partialLine=r.substring(s-this._baseIndex),this._baseIndex=s),n&&n.data&&(this._rowCount+=n.data.length);var a=this._finished||this._config.preview&&this._rowCount>=this._config.preview;if(o)f.postMessage({results:n,workerId:b.WORKER_ID,finished:a});else if(M(this._config.chunk)&&!t){if(this._config.chunk(n,this._handle),this._handle.paused()||this._handle.aborted())return void(this._halted=!0);n=void 0,this._completeResults=void 0;}return this._config.step||this._config.chunk||(this._completeResults.data=this._completeResults.data.concat(n.data),this._completeResults.errors=this._completeResults.errors.concat(n.errors),this._completeResults.meta=n.meta),this._completed||!a||!M(this._config.complete)||n&&n.meta.aborted||(this._config.complete(this._completeResults,this._input),this._completed=!0),a||n&&n.meta.paused||this._nextChunk(),n}this._halted=!0;},this._sendError=function(e){M(this._config.error)?this._config.error(e):o&&this._config.error&&f.postMessage({workerId:b.WORKER_ID,error:e,finished:!1});};}function l(e){var r;(e=e||{}).chunkSize||(e.chunkSize=b.RemoteChunkSize),u.call(this,e),this._nextChunk=n?function(){this._readChunk(),this._chunkLoaded();}:function(){this._readChunk();},this.stream=function(e){this._input=e,this._nextChunk();},this._readChunk=function(){if(this._finished)this._chunkLoaded();else {if(r=new XMLHttpRequest,this._config.withCredentials&&(r.withCredentials=this._config.withCredentials),n||(r.onload=v(this._chunkLoaded,this),r.onerror=v(this._chunkError,this)),r.open(this._config.downloadRequestBody?"POST":"GET",this._input,!n),this._config.downloadRequestHeaders){var e=this._config.downloadRequestHeaders;for(var t in e)r.setRequestHeader(t,e[t]);}if(this._config.chunkSize){var i=this._start+this._config.chunkSize-1;r.setRequestHeader("Range","bytes="+this._start+"-"+i);}try{r.send(this._config.downloadRequestBody);}catch(e){this._chunkError(e.message);}n&&0===r.status&&this._chunkError();}},this._chunkLoaded=function(){4===r.readyState&&(r.status<200||400<=r.status?this._chunkError():(this._start+=this._config.chunkSize?this._config.chunkSize:r.responseText.length,this._finished=!this._config.chunkSize||this._start>=function(e){var t=e.getResponseHeader("Content-Range");if(null===t)return -1;return parseInt(t.substring(t.lastIndexOf("/")+1))}(r),this.parseChunk(r.responseText)));},this._chunkError=function(e){var t=r.statusText||e;this._sendError(new Error(t));};}function c(e){var r,n;(e=e||{}).chunkSize||(e.chunkSize=b.LocalChunkSize),u.call(this,e);var s="undefined"!=typeof FileReader;this.stream=function(e){this._input=e,n=e.slice||e.webkitSlice||e.mozSlice,s?((r=new FileReader).onload=v(this._chunkLoaded,this),r.onerror=v(this._chunkError,this)):r=new FileReaderSync,this._nextChunk();},this._nextChunk=function(){this._finished||this._config.preview&&!(this._rowCount<this._config.preview)||this._readChunk();},this._readChunk=function(){var e=this._input;if(this._config.chunkSize){var t=Math.min(this._start+this._config.chunkSize,this._input.size);e=n.call(e,this._start,t);}var i=r.readAsText(e,this._config.encoding);s||this._chunkLoaded({target:{result:i}});},this._chunkLoaded=function(e){this._start+=this._config.chunkSize,this._finished=!this._config.chunkSize||this._start>=this._input.size,this.parseChunk(e.target.result);},this._chunkError=function(){this._sendError(r.error);};}function p(e){var i;u.call(this,e=e||{}),this.stream=function(e){return i=e,this._nextChunk()},this._nextChunk=function(){if(!this._finished){var e,t=this._config.chunkSize;return t?(e=i.substring(0,t),i=i.substring(t)):(e=i,i=""),this._finished=!i,this.parseChunk(e)}};}function g(e){u.call(this,e=e||{});var t=[],i=!0,r=!1;this.pause=function(){u.prototype.pause.apply(this,arguments),this._input.pause();},this.resume=function(){u.prototype.resume.apply(this,arguments),this._input.resume();},this.stream=function(e){this._input=e,this._input.on("data",this._streamData),this._input.on("end",this._streamEnd),this._input.on("error",this._streamError);},this._checkIsFinished=function(){r&&1===t.length&&(this._finished=!0);},this._nextChunk=function(){this._checkIsFinished(),t.length?this.parseChunk(t.shift()):i=!0;},this._streamData=v(function(e){try{t.push("string"==typeof e?e:e.toString(this._config.encoding)),i&&(i=!1,this._checkIsFinished(),this.parseChunk(t.shift()));}catch(e){this._streamError(e);}},this),this._streamError=v(function(e){this._streamCleanUp(),this._sendError(e);},this),this._streamEnd=v(function(){this._streamCleanUp(),r=!0,this._streamData("");},this),this._streamCleanUp=v(function(){this._input.removeListener("data",this._streamData),this._input.removeListener("end",this._streamEnd),this._input.removeListener("error",this._streamError);},this);}function i(m){var a,o,h,r=Math.pow(2,53),n=-r,s=/^\s*-?(\d+\.?|\.\d+|\d+\.\d+)([eE][-+]?\d+)?\s*$/,u=/^(\d{4}-[01]\d-[0-3]\dT[0-2]\d:[0-5]\d:[0-5]\d\.\d+([+-][0-2]\d:[0-5]\d|Z))|(\d{4}-[01]\d-[0-3]\dT[0-2]\d:[0-5]\d:[0-5]\d([+-][0-2]\d:[0-5]\d|Z))|(\d{4}-[01]\d-[0-3]\dT[0-2]\d:[0-5]\d([+-][0-2]\d:[0-5]\d|Z))$/,t=this,i=0,f=0,d=!1,e=!1,l=[],c={data:[],errors:[],meta:{}};if(M(m.step)){var p=m.step;m.step=function(e){if(c=e,_())g();else {if(g(),0===c.data.length)return;i+=e.data.length,m.preview&&i>m.preview?o.abort():(c.data=c.data[0],p(c,t));}};}function y(e){return "greedy"===m.skipEmptyLines?""===e.join("").trim():1===e.length&&0===e[0].length}function g(){return c&&h&&(k("Delimiter","UndetectableDelimiter","Unable to auto-detect delimiting character; defaulted to '"+b.DefaultDelimiter+"'"),h=!1),m.skipEmptyLines&&(c.data=c.data.filter(function(e){return !y(e)})),_()&&function(){if(!c)return;function e(e,t){M(m.transformHeader)&&(e=m.transformHeader(e,t)),l.push(e);}if(Array.isArray(c.data[0])){for(var t=0;_()&&t<c.data.length;t++)c.data[t].forEach(e);c.data.splice(0,1);}else c.data.forEach(e);}(),function(){if(!c||!m.header&&!m.dynamicTyping&&!m.transform)return c;function e(e,t){var i,r=m.header?{}:[];for(i=0;i<e.length;i++){var n=i,s=e[i];m.header&&(n=i>=l.length?"__parsed_extra":l[i]),m.transform&&(s=m.transform(s,n)),s=v(n,s),"__parsed_extra"===n?(r[n]=r[n]||[],r[n].push(s)):r[n]=s;}return m.header&&(i>l.length?k("FieldMismatch","TooManyFields","Too many fields: expected "+l.length+" fields but parsed "+i,f+t):i<l.length&&k("FieldMismatch","TooFewFields","Too few fields: expected "+l.length+" fields but parsed "+i,f+t)),r}var t=1;!c.data.length||Array.isArray(c.data[0])?(c.data=c.data.map(e),t=c.data.length):c.data=e(c.data,0);m.header&&c.meta&&(c.meta.fields=l);return f+=t,c}()}function _(){return m.header&&0===l.length}function v(e,t){return i=e,m.dynamicTypingFunction&&void 0===m.dynamicTyping[i]&&(m.dynamicTyping[i]=m.dynamicTypingFunction(i)),!0===(m.dynamicTyping[i]||m.dynamicTyping)?"true"===t||"TRUE"===t||"false"!==t&&"FALSE"!==t&&(function(e){if(s.test(e)){var t=parseFloat(e);if(n<t&&t<r)return !0}return !1}(t)?parseFloat(t):u.test(t)?new Date(t):""===t?null:t):t;var i;}function k(e,t,i,r){var n={type:e,code:t,message:i};void 0!==r&&(n.row=r),c.errors.push(n);}this.parse=function(e,t,i){var r=m.quoteChar||'"';if(m.newline||(m.newline=function(e,t){e=e.substring(0,1048576);var i=new RegExp(j(t)+"([^]*?)"+j(t),"gm"),r=(e=e.replace(i,"")).split("\r"),n=e.split("\n"),s=1<n.length&&n[0].length<r[0].length;if(1===r.length||s)return "\n";for(var a=0,o=0;o<r.length;o++)"\n"===r[o][0]&&a++;return a>=r.length/2?"\r\n":"\r"}(e,r)),h=!1,m.delimiter)M(m.delimiter)&&(m.delimiter=m.delimiter(e),c.meta.delimiter=m.delimiter);else {var n=function(e,t,i,r,n){var s,a,o,h;n=n||[",","\t","|",";",b.RECORD_SEP,b.UNIT_SEP];for(var u=0;u<n.length;u++){var f=n[u],d=0,l=0,c=0;o=void 0;for(var p=new E({comments:r,delimiter:f,newline:t,preview:10}).parse(e),g=0;g<p.data.length;g++)if(i&&y(p.data[g]))c++;else {var _=p.data[g].length;l+=_,void 0!==o?0<_&&(d+=Math.abs(_-o),o=_):o=_;}0<p.data.length&&(l/=p.data.length-c),(void 0===a||d<=a)&&(void 0===h||h<l)&&1.99<l&&(a=d,s=f,h=l);}return {successful:!!(m.delimiter=s),bestDelimiter:s}}(e,m.newline,m.skipEmptyLines,m.comments,m.delimitersToGuess);n.successful?m.delimiter=n.bestDelimiter:(h=!0,m.delimiter=b.DefaultDelimiter),c.meta.delimiter=m.delimiter;}var s=w(m);return m.preview&&m.header&&s.preview++,a=e,o=new E(s),c=o.parse(a,t,i),g(),d?{meta:{paused:!0}}:c||{meta:{paused:!1}}},this.paused=function(){return d},this.pause=function(){d=!0,o.abort(),a=M(m.chunk)?"":a.substring(o.getCharIndex());},this.resume=function(){t.streamer._halted?(d=!1,t.streamer.parseChunk(a,!0)):setTimeout(t.resume,3);},this.aborted=function(){return e},this.abort=function(){e=!0,o.abort(),c.meta.aborted=!0,M(m.complete)&&m.complete(c),a="";};}function j(e){return e.replace(/[.*+?^${}()|[\]\\]/g,"\\$&")}function E(e){var S,O=(e=e||{}).delimiter,x=e.newline,I=e.comments,T=e.step,D=e.preview,A=e.fastMode,L=S=void 0===e.quoteChar||null===e.quoteChar?'"':e.quoteChar;if(void 0!==e.escapeChar&&(L=e.escapeChar),("string"!=typeof O||-1<b.BAD_DELIMITERS.indexOf(O))&&(O=","),I===O)throw new Error("Comment character same as delimiter");!0===I?I="#":("string"!=typeof I||-1<b.BAD_DELIMITERS.indexOf(I))&&(I=!1),"\n"!==x&&"\r"!==x&&"\r\n"!==x&&(x="\n");var F=0,z=!1;this.parse=function(r,t,i){if("string"!=typeof r)throw new Error("Input must be a string");var n=r.length,e=O.length,s=x.length,a=I.length,o=M(T),h=[],u=[],f=[],d=F=0;if(!r)return C();if(A||!1!==A&&-1===r.indexOf(S)){for(var l=r.split(x),c=0;c<l.length;c++){if(f=l[c],F+=f.length,c!==l.length-1)F+=x.length;else if(i)return C();if(!I||f.substring(0,a)!==I){if(o){if(h=[],k(f.split(O)),R(),z)return C()}else k(f.split(O));if(D&&D<=c)return h=h.slice(0,D),C(!0)}}return C()}for(var p=r.indexOf(O,F),g=r.indexOf(x,F),_=new RegExp(j(L)+j(S),"g"),m=r.indexOf(S,F);;)if(r[F]!==S)if(I&&0===f.length&&r.substring(F,F+a)===I){if(-1===g)return C();F=g+s,g=r.indexOf(x,F),p=r.indexOf(O,F);}else if(-1!==p&&(p<g||-1===g))f.push(r.substring(F,p)),F=p+e,p=r.indexOf(O,F);else {if(-1===g)break;if(f.push(r.substring(F,g)),w(g+s),o&&(R(),z))return C();if(D&&h.length>=D)return C(!0)}else for(m=F,F++;;){if(-1===(m=r.indexOf(S,m+1)))return i||u.push({type:"Quotes",code:"MissingQuotes",message:"Quoted field unterminated",row:h.length,index:F}),E();if(m===n-1)return E(r.substring(F,m).replace(_,S));if(S!==L||r[m+1]!==L){if(S===L||0===m||r[m-1]!==L){-1!==p&&p<m+1&&(p=r.indexOf(O,m+1)),-1!==g&&g<m+1&&(g=r.indexOf(x,m+1));var y=b(-1===g?p:Math.min(p,g));if(r.substr(m+1+y,e)===O){f.push(r.substring(F,m).replace(_,S)),r[F=m+1+y+e]!==S&&(m=r.indexOf(S,F)),p=r.indexOf(O,F),g=r.indexOf(x,F);break}var v=b(g);if(r.substring(m+1+v,m+1+v+s)===x){if(f.push(r.substring(F,m).replace(_,S)),w(m+1+v+s),p=r.indexOf(O,F),m=r.indexOf(S,F),o&&(R(),z))return C();if(D&&h.length>=D)return C(!0);break}u.push({type:"Quotes",code:"InvalidQuotes",message:"Trailing quote on quoted field is malformed",row:h.length,index:F}),m++;}}else m++;}return E();function k(e){h.push(e),d=F;}function b(e){var t=0;if(-1!==e){var i=r.substring(m+1,e);i&&""===i.trim()&&(t=i.length);}return t}function E(e){return i||(void 0===e&&(e=r.substring(F)),f.push(e),F=n,k(f),o&&R()),C()}function w(e){F=e,k(f),f=[],g=r.indexOf(x,F);}function C(e){return {data:h,errors:u,meta:{delimiter:O,linebreak:x,aborted:z,truncated:!!e,cursor:d+(t||0)}}}function R(){T(C()),h=[],u=[];}},this.abort=function(){z=!0;},this.getCharIndex=function(){return F};}function _(e){var t=e.data,i=a[t.workerId],r=!1;if(t.error)i.userError(t.error,t.file);else if(t.results&&t.results.data){var n={abort:function(){r=!0,m(t.workerId,{data:[],errors:[],meta:{aborted:!0}});},pause:y,resume:y};if(M(i.userStep)){for(var s=0;s<t.results.data.length&&(i.userStep({data:t.results.data[s],errors:t.results.errors,meta:t.results.meta},n),!r);s++);delete t.results;}else M(i.userChunk)&&(i.userChunk(t.results,n,t.file),delete t.results);}t.finished&&!r&&m(t.workerId,t.results);}function m(e,t){var i=a[e];M(i.userComplete)&&i.userComplete(t),i.terminate(),delete a[e];}function y(){throw new Error("Not implemented.")}function w(e){if("object"!=typeof e||null===e)return e;var t=Array.isArray(e)?[]:{};for(var i in e)t[i]=w(e[i]);return t}function v(e,t){return function(){e.apply(t,arguments);}}function M(e){return "function"==typeof e}return o&&(f.onmessage=function(e){var t=e.data;void 0===b.WORKER_ID&&t&&(b.WORKER_ID=t.workerId);if("string"==typeof t.input)f.postMessage({workerId:b.WORKER_ID,results:b.parse(t.input,t.config),finished:!0});else if(f.File&&t.input instanceof File||t.input instanceof Object){var i=b.parse(t.input,t.config);i&&f.postMessage({workerId:b.WORKER_ID,results:i,finished:!0});}}),(l.prototype=Object.create(u.prototype)).constructor=l,(c.prototype=Object.create(u.prototype)).constructor=c,(p.prototype=Object.create(p.prototype)).constructor=p,(g.prototype=Object.create(u.prototype)).constructor=g,b});
}(papaparse_min));

/** Utility methods for creating & comparing fields. */
var Fields;
(function (Fields) {
    function variable(name) {
        return { type: "variable", name };
    }
    Fields.variable = variable;
    function literal(value) {
        return { type: "literal", value };
    }
    Fields.literal = literal;
    function binaryOp(left, op, right) {
        return { type: "binaryop", left, op, right };
    }
    Fields.binaryOp = binaryOp;
    function index(obj, index) {
        return { type: "index", object: obj, index };
    }
    Fields.index = index;
    /** Converts a string in dot-notation-format into a variable which indexes. */
    function indexVariable(name) {
        let parts = name.split(".");
        let result = Fields.variable(parts[0]);
        for (let index = 1; index < parts.length; index++) {
            result = Fields.index(result, Fields.literal(parts[index]));
        }
        return result;
    }
    Fields.indexVariable = indexVariable;
    function lambda(args, value) {
        return { type: "lambda", arguments: args, value };
    }
    Fields.lambda = lambda;
    function func(func, args) {
        return { type: "function", func, arguments: args };
    }
    Fields.func = func;
    function list(values) {
        return { type: "list", values };
    }
    Fields.list = list;
    function object(values) {
        return { type: "object", values };
    }
    Fields.object = object;
    function negate(child) {
        return { type: "negated", child };
    }
    Fields.negate = negate;
    function isCompareOp(op) {
        return op == "<=" || op == "<" || op == ">" || op == ">=" || op == "!=" || op == "=";
    }
    Fields.isCompareOp = isCompareOp;
    Fields.NULL = Fields.literal(null);
})(Fields || (Fields = {}));

/** AST implementation for queries over data sources. */
/** Utility functions for creating and manipulating sources. */
var Sources;
(function (Sources) {
    /** Create a source which searches from a tag. */
    function tag(tag) {
        return { type: "tag", tag };
    }
    Sources.tag = tag;
    /** Create a source which fetches from a CSV file. */
    function csv(path) {
        return { type: "csv", path };
    }
    Sources.csv = csv;
    /** Create a source which searches for files under a folder prefix. */
    function folder(prefix) {
        return { type: "folder", folder: prefix };
    }
    Sources.folder = folder;
    /** Create a source which searches for files which link to/from a given file. */
    function link(file, incoming) {
        return { type: "link", file, direction: incoming ? "incoming" : "outgoing" };
    }
    Sources.link = link;
    /** Create a source which joins two sources by a logical operator (and/or). */
    function binaryOp(left, op, right) {
        return { type: "binaryop", left, op, right };
    }
    Sources.binaryOp = binaryOp;
    /** Create a source which takes the intersection of two sources. */
    function and(left, right) {
        return { type: "binaryop", left, op: "&", right };
    }
    Sources.and = and;
    /** Create a source which takes the union of two sources. */
    function or(left, right) {
        return { type: "binaryop", left, op: "|", right };
    }
    Sources.or = or;
    /** Create a source which negates the underlying source. */
    function negate(child) {
        return { type: "negate", child };
    }
    Sources.negate = negate;
    function empty() {
        return { type: "empty" };
    }
    Sources.empty = empty;
})(Sources || (Sources = {}));

/** Emoji regex without any additional flags. */
const EMOJI_REGEX = new RegExp(emojiRegex(), "");
/** Provides a lookup table for unit durations of the given type. */
const DURATION_TYPES = {
    year: Duration_1.fromObject({ years: 1 }),
    years: Duration_1.fromObject({ years: 1 }),
    yr: Duration_1.fromObject({ years: 1 }),
    yrs: Duration_1.fromObject({ years: 1 }),
    month: Duration_1.fromObject({ months: 1 }),
    months: Duration_1.fromObject({ months: 1 }),
    mo: Duration_1.fromObject({ months: 1 }),
    mos: Duration_1.fromObject({ months: 1 }),
    week: Duration_1.fromObject({ weeks: 1 }),
    weeks: Duration_1.fromObject({ weeks: 1 }),
    wk: Duration_1.fromObject({ weeks: 1 }),
    wks: Duration_1.fromObject({ weeks: 1 }),
    w: Duration_1.fromObject({ weeks: 1 }),
    day: Duration_1.fromObject({ days: 1 }),
    days: Duration_1.fromObject({ days: 1 }),
    d: Duration_1.fromObject({ days: 1 }),
    hour: Duration_1.fromObject({ hours: 1 }),
    hours: Duration_1.fromObject({ hours: 1 }),
    hr: Duration_1.fromObject({ hours: 1 }),
    hrs: Duration_1.fromObject({ hours: 1 }),
    h: Duration_1.fromObject({ hours: 1 }),
    minute: Duration_1.fromObject({ minutes: 1 }),
    minutes: Duration_1.fromObject({ minutes: 1 }),
    min: Duration_1.fromObject({ minutes: 1 }),
    mins: Duration_1.fromObject({ minutes: 1 }),
    m: Duration_1.fromObject({ minutes: 1 }),
    second: Duration_1.fromObject({ seconds: 1 }),
    seconds: Duration_1.fromObject({ seconds: 1 }),
    sec: Duration_1.fromObject({ seconds: 1 }),
    secs: Duration_1.fromObject({ seconds: 1 }),
    s: Duration_1.fromObject({ seconds: 1 }),
};
/** Shorthand for common dates (relative to right now). */
const DATE_SHORTHANDS = {
    now: () => DateTime_1.local(),
    today: () => DateTime_1.local().startOf("day"),
    yesterday: () => DateTime_1.local()
        .startOf("day")
        .minus(Duration_1.fromObject({ days: 1 })),
    tomorrow: () => DateTime_1.local()
        .startOf("day")
        .plus(Duration_1.fromObject({ days: 1 })),
    sow: () => DateTime_1.local().startOf("week"),
    "start-of-week": () => DateTime_1.local().startOf("week"),
    eow: () => DateTime_1.local().endOf("week"),
    "end-of-week": () => DateTime_1.local().endOf("week"),
    soy: () => DateTime_1.local().startOf("year"),
    "start-of-year": () => DateTime_1.local().startOf("year"),
    eoy: () => DateTime_1.local().endOf("year"),
    "end-of-year": () => DateTime_1.local().endOf("year"),
    som: () => DateTime_1.local().startOf("month"),
    "start-of-month": () => DateTime_1.local().startOf("month"),
    eom: () => DateTime_1.local().endOf("month"),
    "end-of-month": () => DateTime_1.local().endOf("month"),
};
/**
 * Keywords which cannot be used as variables directly. Use `row.<thing>` if it is a variable you have defined and want
 * to access.
 */
const KEYWORDS = ["FROM", "WHERE", "LIMIT", "GROUP", "FLATTEN"];
///////////////
// Utilities //
///////////////
/** Split on unescaped pipes in an inner link. */
function splitOnUnescapedPipe(link) {
    let pipe = -1;
    while ((pipe = link.indexOf("|", pipe + 1)) >= 0) {
        if (pipe > 0 && link[pipe - 1] == "\\")
            continue;
        return [link.substring(0, pipe).replace(/\\\|/g, "|"), link.substring(pipe + 1)];
    }
    return [link.replace(/\\\|/g, "|"), undefined];
}
/** Attempt to parse the inside of a link to pull out display name, subpath, etc. */
function parseInnerLink(rawlink) {
    let [link, display] = splitOnUnescapedPipe(rawlink);
    return Link.infer(link, false, display);
}
/** Create a left-associative binary parser which parses the given sub-element and separator. Handles whitespace. */
function createBinaryParser(child, sep, combine) {
    return parsimmon_umd_min.exports.seqMap(child, parsimmon_umd_min.exports.seq(parsimmon_umd_min.exports.optWhitespace, sep, parsimmon_umd_min.exports.optWhitespace, child).many(), (first, rest) => {
        if (rest.length == 0)
            return first;
        let node = combine(first, rest[0][1], rest[0][3]);
        for (let index = 1; index < rest.length; index++) {
            node = combine(node, rest[index][1], rest[index][3]);
        }
        return node;
    });
}
function chainOpt(base, ...funcs) {
    return parsimmon_umd_min.exports.custom((success, failure) => {
        return (input, i) => {
            let result = base._(input, i);
            if (!result.status)
                return result;
            for (let func of funcs) {
                let next = func(result.value)._(input, result.index);
                if (!next.status)
                    return result;
                result = next;
            }
            return result;
        };
    });
}
const EXPRESSION = parsimmon_umd_min.exports.createLanguage({
    // A floating point number; the decimal point is optional.
    number: q => parsimmon_umd_min.exports.regexp(/-?[0-9]+(\.[0-9]+)?/)
        .map(str => Number.parseFloat(str))
        .desc("number"),
    // A quote-surrounded string which supports escape characters ('\').
    string: q => parsimmon_umd_min.exports.string('"')
        .then(parsimmon_umd_min.exports.alt(q.escapeCharacter, parsimmon_umd_min.exports.noneOf('"\\'))
        .atLeast(0)
        .map(chars => chars.join("")))
        .skip(parsimmon_umd_min.exports.string('"'))
        .desc("string"),
    escapeCharacter: _ => parsimmon_umd_min.exports.string("\\")
        .then(parsimmon_umd_min.exports.any)
        .map(escaped => {
        // If we are escaping a backslash or a quote, pass in on in escaped form
        if (escaped === '"')
            return '"';
        if (escaped === "\\")
            return "\\";
        else
            return "\\" + escaped;
    }),
    // A boolean true/false value.
    bool: _ => parsimmon_umd_min.exports.regexp(/true|false|True|False/)
        .map(str => str.toLowerCase() == "true")
        .desc("boolean ('true' or 'false')"),
    // A tag of the form '#stuff/hello-there'.
    tag: _ => parsimmon_umd_min.exports.seqMap(parsimmon_umd_min.exports.string("#"), parsimmon_umd_min.exports.alt(parsimmon_umd_min.exports.regexp(/[\p{Letter}0-9_/-]/u).desc("text"), parsimmon_umd_min.exports.regexp(EMOJI_REGEX).desc("text")).many(), (start, rest) => start + rest.join("")).desc("tag ('#hello/stuff')"),
    // A variable identifier, which is alphanumeric and must start with a letter or... emoji.
    identifier: _ => parsimmon_umd_min.exports.seqMap(parsimmon_umd_min.exports.alt(parsimmon_umd_min.exports.regexp(/\p{Letter}/u), parsimmon_umd_min.exports.regexp(EMOJI_REGEX).desc("text")), parsimmon_umd_min.exports.alt(parsimmon_umd_min.exports.regexp(/[0-9\p{Letter}_-]/u), parsimmon_umd_min.exports.regexp(EMOJI_REGEX).desc("text")).many(), (first, rest) => first + rest.join("")).desc("variable identifier"),
    // An Obsidian link of the form [[<link>]].
    link: _ => parsimmon_umd_min.exports.regexp(/\[\[([^\[\]]*?)\]\]/u, 1)
        .map(linkInner => parseInnerLink(linkInner))
        .desc("file link"),
    // An embeddable link which can start with '!'. This overlaps with the normal negation operator, so it is only
    // provided for metadata parsing.
    embedLink: q => parsimmon_umd_min.exports.seqMap(parsimmon_umd_min.exports.string("!").atMost(1), q.link, (p, l) => {
        if (p.length > 0)
            l.embed = true;
        return l;
    }).desc("file link"),
    // Binary plus or minus operator.
    binaryPlusMinus: _ => parsimmon_umd_min.exports.regexp(/\+|-/)
        .map(str => str)
        .desc("'+' or '-'"),
    // Binary times or divide operator.
    binaryMulDiv: _ => parsimmon_umd_min.exports.regexp(/\*|\/|%/)
        .map(str => str)
        .desc("'*' or '/' or '%'"),
    // Binary comparison operator.
    binaryCompareOp: _ => parsimmon_umd_min.exports.regexp(/>=|<=|!=|>|<|=/)
        .map(str => str)
        .desc("'>=' or '<=' or '!=' or '=' or '>' or '<'"),
    // Binary boolean combination operator.
    binaryBooleanOp: _ => parsimmon_umd_min.exports.regexp(/and|or|&|\|/i)
        .map(str => {
        if (str.toLowerCase() == "and")
            return "&";
        else if (str.toLowerCase() == "or")
            return "|";
        else
            return str;
    })
        .desc("'and' or 'or'"),
    // A date which can be YYYY-MM[-DDTHH:mm:ss].
    rootDate: _ => parsimmon_umd_min.exports.seqMap(parsimmon_umd_min.exports.regexp(/\d{4}/), parsimmon_umd_min.exports.string("-"), parsimmon_umd_min.exports.regexp(/\d{2}/), (year, _, month) => {
        return DateTime_1.fromObject({ year: Number.parseInt(year), month: Number.parseInt(month) });
    }).desc("date in format YYYY-MM[-DDTHH-MM-SS.MS]"),
    dateShorthand: _ => parsimmon_umd_min.exports.alt(...Object.keys(DATE_SHORTHANDS)
        .sort((a, b) => b.length - a.length)
        .map(parsimmon_umd_min.exports.string)),
    date: q => chainOpt(q.rootDate, (ym) => parsimmon_umd_min.exports.seqMap(parsimmon_umd_min.exports.string("-"), parsimmon_umd_min.exports.regexp(/\d{2}/), (_, day) => ym.set({ day: Number.parseInt(day) })), (ymd) => parsimmon_umd_min.exports.seqMap(parsimmon_umd_min.exports.string("T"), parsimmon_umd_min.exports.regexp(/\d{2}/), (_, hour) => ymd.set({ hour: Number.parseInt(hour) })), (ymdh) => parsimmon_umd_min.exports.seqMap(parsimmon_umd_min.exports.string(":"), parsimmon_umd_min.exports.regexp(/\d{2}/), (_, minute) => ymdh.set({ minute: Number.parseInt(minute) })), (ymdhm) => parsimmon_umd_min.exports.seqMap(parsimmon_umd_min.exports.string(":"), parsimmon_umd_min.exports.regexp(/\d{2}/), (_, second) => ymdhm.set({ second: Number.parseInt(second) })), (ymdhms) => parsimmon_umd_min.exports.alt(parsimmon_umd_min.exports.seqMap(parsimmon_umd_min.exports.string("."), parsimmon_umd_min.exports.regexp(/\d{3}/), (_, millisecond) => ymdhms.set({ millisecond: Number.parseInt(millisecond) })), parsimmon_umd_min.exports.succeed(ymdhms) // pass
    ), (dt) => parsimmon_umd_min.exports.alt(parsimmon_umd_min.exports.seqMap(parsimmon_umd_min.exports.string("+").or(parsimmon_umd_min.exports.string("-")), parsimmon_umd_min.exports.regexp(/\d{1,2}(:\d{2})?/), (pm, hr) => dt.setZone("UTC" + pm + hr, { keepLocalTime: true })), parsimmon_umd_min.exports.seqMap(parsimmon_umd_min.exports.string("Z"), () => dt.setZone("utc", { keepLocalTime: true })), parsimmon_umd_min.exports.seqMap(parsimmon_umd_min.exports.string("["), parsimmon_umd_min.exports.regexp(/[0-9A-Za-z+-\/]+/u), parsimmon_umd_min.exports.string("]"), (_a, zone, _b) => dt.setZone(zone, { keepLocalTime: true }))))
        .assert((dt) => dt.isValid, "valid date")
        .desc("date in format YYYY-MM[-DDTHH-MM-SS.MS]"),
    // A date, plus various shorthand times of day it could be.
    datePlus: q => parsimmon_umd_min.exports.alt(q.dateShorthand.map(d => DATE_SHORTHANDS[d]()), q.date).desc("date in format YYYY-MM[-DDTHH-MM-SS.MS] or in shorthand"),
    // A duration of time.
    durationType: _ => parsimmon_umd_min.exports.alt(...Object.keys(DURATION_TYPES)
        .sort((a, b) => b.length - a.length)
        .map(parsimmon_umd_min.exports.string)),
    duration: q => parsimmon_umd_min.exports.seqMap(q.number, parsimmon_umd_min.exports.optWhitespace, q.durationType, (count, _, t) => DURATION_TYPES[t].mapUnits(x => x * count))
        .sepBy1(parsimmon_umd_min.exports.string(",").trim(parsimmon_umd_min.exports.optWhitespace).or(parsimmon_umd_min.exports.optWhitespace))
        .map(durations => durations.reduce((p, c) => p.plus(c)))
        .desc("duration like 4hr2min"),
    // A raw null value.
    rawNull: _ => parsimmon_umd_min.exports.string("null"),
    // Source parsing.
    tagSource: q => q.tag.map(tag => Sources.tag(tag)),
    csvSource: q => parsimmon_umd_min.exports.seqMap(parsimmon_umd_min.exports.string("csv(").skip(parsimmon_umd_min.exports.optWhitespace), q.string, parsimmon_umd_min.exports.string(")"), (_1, path, _2) => Sources.csv(path)),
    linkIncomingSource: q => q.link.map(link => Sources.link(link.path, true)),
    linkOutgoingSource: q => parsimmon_umd_min.exports.seqMap(parsimmon_umd_min.exports.string("outgoing(").skip(parsimmon_umd_min.exports.optWhitespace), q.link, parsimmon_umd_min.exports.string(")"), (_1, link, _2) => Sources.link(link.path, false)),
    folderSource: q => q.string.map(str => Sources.folder(str)),
    parensSource: q => parsimmon_umd_min.exports.seqMap(parsimmon_umd_min.exports.string("("), parsimmon_umd_min.exports.optWhitespace, q.source, parsimmon_umd_min.exports.optWhitespace, parsimmon_umd_min.exports.string(")"), (_1, _2, field, _3, _4) => field),
    negateSource: q => parsimmon_umd_min.exports.seqMap(parsimmon_umd_min.exports.alt(parsimmon_umd_min.exports.string("-"), parsimmon_umd_min.exports.string("!")), q.atomSource, (_, source) => Sources.negate(source)),
    atomSource: q => parsimmon_umd_min.exports.alt(q.parensSource, q.negateSource, q.linkOutgoingSource, q.linkIncomingSource, q.folderSource, q.tagSource, q.csvSource),
    binaryOpSource: q => createBinaryParser(q.atomSource, q.binaryBooleanOp.map(s => s), Sources.binaryOp),
    source: q => q.binaryOpSource,
    // Field parsing.
    variableField: q => q.identifier
        .chain(r => {
        if (KEYWORDS.includes(r.toUpperCase())) {
            return parsimmon_umd_min.exports.fail("Variable fields cannot be a keyword (" + KEYWORDS.join(" or ") + ")");
        }
        else {
            return parsimmon_umd_min.exports.succeed(Fields.variable(r));
        }
    })
        .desc("variable"),
    numberField: q => q.number.map(val => Fields.literal(val)).desc("number"),
    stringField: q => q.string.map(val => Fields.literal(val)).desc("string"),
    boolField: q => q.bool.map(val => Fields.literal(val)).desc("boolean"),
    dateField: q => parsimmon_umd_min.exports.seqMap(parsimmon_umd_min.exports.string("date("), parsimmon_umd_min.exports.optWhitespace, q.datePlus, parsimmon_umd_min.exports.optWhitespace, parsimmon_umd_min.exports.string(")"), (prefix, _1, date, _2, postfix) => Fields.literal(date)).desc("date"),
    durationField: q => parsimmon_umd_min.exports.seqMap(parsimmon_umd_min.exports.string("dur("), parsimmon_umd_min.exports.optWhitespace, q.duration, parsimmon_umd_min.exports.optWhitespace, parsimmon_umd_min.exports.string(")"), (prefix, _1, dur, _2, postfix) => Fields.literal(dur)).desc("duration"),
    nullField: q => q.rawNull.map(_ => Fields.NULL),
    linkField: q => q.link.map(f => Fields.literal(f)),
    listField: q => q.field
        .sepBy(parsimmon_umd_min.exports.string(",").trim(parsimmon_umd_min.exports.optWhitespace))
        .wrap(parsimmon_umd_min.exports.string("[").skip(parsimmon_umd_min.exports.optWhitespace), parsimmon_umd_min.exports.optWhitespace.then(parsimmon_umd_min.exports.string("]")))
        .map(l => Fields.list(l))
        .desc("list ('[1, 2, 3]')"),
    objectField: q => parsimmon_umd_min.exports.seqMap(q.identifier.or(q.string), parsimmon_umd_min.exports.string(":").trim(parsimmon_umd_min.exports.optWhitespace), q.field, (name, _sep, value) => {
        return { name, value };
    })
        .sepBy(parsimmon_umd_min.exports.string(",").trim(parsimmon_umd_min.exports.optWhitespace))
        .wrap(parsimmon_umd_min.exports.string("{").skip(parsimmon_umd_min.exports.optWhitespace), parsimmon_umd_min.exports.optWhitespace.then(parsimmon_umd_min.exports.string("}")))
        .map(vals => {
        let res = {};
        for (let entry of vals)
            res[entry.name] = entry.value;
        return Fields.object(res);
    })
        .desc("object ('{ a: 1, b: 2 }')"),
    atomInlineField: q => parsimmon_umd_min.exports.alt(q.date, q.duration.map(d => normalizeDuration(d)), q.string, q.tag, q.embedLink, q.bool, q.number, q.rawNull),
    inlineFieldList: q => q.atomInlineField.sepBy(parsimmon_umd_min.exports.string(",").trim(parsimmon_umd_min.exports.optWhitespace).lookahead(q.atomInlineField)),
    inlineField: q => parsimmon_umd_min.exports.alt(parsimmon_umd_min.exports.seqMap(q.atomInlineField, parsimmon_umd_min.exports.string(",").trim(parsimmon_umd_min.exports.optWhitespace), q.inlineFieldList, (f, _s, l) => [f].concat(l)), q.atomInlineField),
    atomField: q => parsimmon_umd_min.exports.alt(
    // Place embed links above negated fields as they are the special parser case '![[thing]]' and are generally unambigious.
    q.embedLink.map(l => Fields.literal(l)), q.negatedField, q.linkField, q.listField, q.objectField, q.lambdaField, q.parensField, q.boolField, q.numberField, q.stringField, q.dateField, q.durationField, q.nullField, q.variableField),
    indexField: q => parsimmon_umd_min.exports.seqMap(q.atomField, parsimmon_umd_min.exports.alt(q.dotPostfix, q.indexPostfix, q.functionPostfix).many(), (obj, postfixes) => {
        let result = obj;
        for (let post of postfixes) {
            switch (post.type) {
                case "dot":
                    result = Fields.index(result, Fields.literal(post.field));
                    break;
                case "index":
                    result = Fields.index(result, post.field);
                    break;
                case "function":
                    result = Fields.func(result, post.fields);
                    break;
            }
        }
        return result;
    }),
    negatedField: q => parsimmon_umd_min.exports.seqMap(parsimmon_umd_min.exports.string("!"), q.indexField, (_, field) => Fields.negate(field)).desc("negated field"),
    parensField: q => parsimmon_umd_min.exports.seqMap(parsimmon_umd_min.exports.string("("), parsimmon_umd_min.exports.optWhitespace, q.field, parsimmon_umd_min.exports.optWhitespace, parsimmon_umd_min.exports.string(")"), (_1, _2, field, _3, _4) => field),
    lambdaField: q => parsimmon_umd_min.exports.seqMap(q.identifier
        .sepBy(parsimmon_umd_min.exports.string(",").trim(parsimmon_umd_min.exports.optWhitespace))
        .wrap(parsimmon_umd_min.exports.string("(").trim(parsimmon_umd_min.exports.optWhitespace), parsimmon_umd_min.exports.string(")").trim(parsimmon_umd_min.exports.optWhitespace)), parsimmon_umd_min.exports.string("=>").trim(parsimmon_umd_min.exports.optWhitespace), q.field, (ident, _ignore, value) => {
        return { type: "lambda", arguments: ident, value };
    }),
    dotPostfix: q => parsimmon_umd_min.exports.seqMap(parsimmon_umd_min.exports.string("."), q.identifier, (_, field) => {
        return { type: "dot", field: field };
    }),
    indexPostfix: q => parsimmon_umd_min.exports.seqMap(parsimmon_umd_min.exports.string("["), parsimmon_umd_min.exports.optWhitespace, q.field, parsimmon_umd_min.exports.optWhitespace, parsimmon_umd_min.exports.string("]"), (_, _2, field, _3, _4) => {
        return { type: "index", field };
    }),
    functionPostfix: q => parsimmon_umd_min.exports.seqMap(parsimmon_umd_min.exports.string("("), parsimmon_umd_min.exports.optWhitespace, q.field.sepBy(parsimmon_umd_min.exports.string(",").trim(parsimmon_umd_min.exports.optWhitespace)), parsimmon_umd_min.exports.optWhitespace, parsimmon_umd_min.exports.string(")"), (_, _1, fields, _2, _3) => {
        return { type: "function", fields };
    }),
    // The precedence hierarchy of operators - multiply/divide, add/subtract, compare, and then boolean operations.
    binaryMulDivField: q => createBinaryParser(q.indexField, q.binaryMulDiv, Fields.binaryOp),
    binaryPlusMinusField: q => createBinaryParser(q.binaryMulDivField, q.binaryPlusMinus, Fields.binaryOp),
    binaryCompareField: q => createBinaryParser(q.binaryPlusMinusField, q.binaryCompareOp, Fields.binaryOp),
    binaryBooleanField: q => createBinaryParser(q.binaryCompareField, q.binaryBooleanOp, Fields.binaryOp),
    binaryOpField: q => q.binaryBooleanField,
    field: q => q.binaryOpField,
});
/**
 * Attempt to parse a field from the given text, returning a string error if the
 * parse failed.
 */
function parseField(text) {
    try {
        return Result.success(EXPRESSION.field.tryParse(text));
    }
    catch (error) {
        return Result.failure("" + error);
    }
}

/** Parse inline fields and other embedded metadata in a line. */
/** The wrapper characters that can be used to define an inline field. */
const INLINE_FIELD_WRAPPERS = Object.freeze({
    "[": "]",
    "(": ")",
});
/**
 * Find a matching closing bracket that occurs at or after `start`, respecting nesting and escapes. If found,
 * returns the value contained within and the string index after the end of the value.
 */
function findClosing(line, start, open, close) {
    let nesting = 0;
    let escaped = false;
    for (let index = start; index < line.length; index++) {
        let char = line.charAt(index);
        // Allows for double escapes like '\\' to be rendered normally.
        if (char == "\\") {
            escaped = !escaped;
            continue;
        }
        // If escaped, ignore the next character for computing nesting, regardless of what it is.
        if (escaped) {
            escaped = false;
            continue;
        }
        if (char == open)
            nesting++;
        else if (char == close)
            nesting--;
        // Only occurs if we are on a close character and trhere is no more nesting.
        if (nesting < 0)
            return { value: line.substring(start, index).trim(), endIndex: index + 1 };
        escaped = false;
    }
    return undefined;
}
/** Find the '::' separator in an inline field. */
function findSeparator(line, start) {
    let sep = line.indexOf("::", start);
    if (sep < 0)
        return undefined;
    return { key: line.substring(start, sep).trim(), valueIndex: sep + 2 };
}
/** Try to completely parse an inline field starting at the given position. Assuems `start` is on a wrapping character. */
function findSpecificInlineField(line, start) {
    let open = line.charAt(start);
    let key = findSeparator(line, start + 1);
    if (key === undefined)
        return undefined;
    // Fail the match if we find any separator characters (not allowed in keys).
    for (let sep of Object.keys(INLINE_FIELD_WRAPPERS).concat(Object.values(INLINE_FIELD_WRAPPERS))) {
        if (key.key.includes(sep))
            return undefined;
    }
    let value = findClosing(line, key.valueIndex, open, INLINE_FIELD_WRAPPERS[open]);
    if (value === undefined)
        return undefined;
    return {
        key: key.key,
        value: value.value,
        start: start,
        startValue: key.valueIndex,
        end: value.endIndex,
        wrapping: open,
    };
}
/** Parse a textual inline field value into something we can work with. */
function parseInlineValue(value) {
    // Empty inline values (i.e., no text) should map to null to match long-term Dataview semantics.
    // Null is also a more universal type to deal with than strings, since all functions accept nulls.
    if (value.trim() == "")
        return null;
    // The stripped literal field parser understands all of the non-array/non-object fields and can parse them for us.
    // Inline field objects are not currently supported; inline array objects have to be handled by the parser
    // separately.
    let inline = EXPRESSION.inlineField.parse(value);
    if (inline.status)
        return inline.value;
    else
        return value;
}
/** Extracts inline fields of the form '[key:: value]' from a line of text. This is done in a relatively
 * "robust" way to avoid failing due to bad nesting or other interfering Markdown symbols:
 *
 * - Look for any wrappers ('[' and '(') in the line, trying to parse whatever comes after it as an inline key::.
 * - If successful, scan until you find a matching end bracket, and parse whatever remains as an inline value.
 */
function extractInlineFields(line, includeTaskFields = false) {
    let fields = [];
    for (let wrapper of Object.keys(INLINE_FIELD_WRAPPERS)) {
        let foundIndex = line.indexOf(wrapper);
        while (foundIndex >= 0) {
            let parsedField = findSpecificInlineField(line, foundIndex);
            if (!parsedField) {
                foundIndex = line.indexOf(wrapper, foundIndex + 1);
                continue;
            }
            fields.push(parsedField);
            foundIndex = line.indexOf(wrapper, parsedField.end);
        }
    }
    if (includeTaskFields)
        fields = fields.concat(extractSpecialTaskFields(line));
    fields.sort((a, b) => a.start - b.start);
    let filteredFields = [];
    for (let i = 0; i < fields.length; i++) {
        if (i == 0 || filteredFields[filteredFields.length - 1].end < fields[i].start) {
            filteredFields.push(fields[i]);
        }
    }
    return filteredFields;
}
/** Validates that a raw field name has a valid form. */
const FULL_LINE_KEY_PART = parsimmon_umd_min.exports.alt(parsimmon_umd_min.exports.regexp(new RegExp(emojiRegex(), "u")), parsimmon_umd_min.exports.regexp(/[0-9\p{Letter}\w\s_/-]+/u))
    .many()
    .map(parts => parts.join(""));
parsimmon_umd_min.exports.regexp(/[^0-9\w\p{Letter}]*/u)
    .then(FULL_LINE_KEY_PART)
    .skip(parsimmon_umd_min.exports.regexp(/[_\*~`]*/u));
const CREATED_DATE_REGEX = /\u{2795}\s*(\d{4}-\d{2}-\d{2})/u;
const DUE_DATE_REGEX = /(?:\u{1F4C5}|\u{1F4C6}|\u{1F5D3}\u{FE0F}?)\s*(\d{4}-\d{2}-\d{2})/u;
const DONE_DATE_REGEX = /\u{2705}\s*(\d{4}-\d{2}-\d{2})/u;
const SCHEDULED_DATE_REGEX = /[\u{23F3}\u{231B}]\s*(\d{4}-\d{2}-\d{2})/u;
const START_DATE_REGEX = /\u{1F6EB}\s*(\d{4}-\d{2}-\d{2})/u;
const EMOJI_REGEXES = [
    { regex: CREATED_DATE_REGEX, key: "created" },
    { regex: START_DATE_REGEX, key: "start" },
    { regex: SCHEDULED_DATE_REGEX, key: "scheduled" },
    { regex: DUE_DATE_REGEX, key: "due" },
    { regex: DONE_DATE_REGEX, key: "completion" },
];
/** Parse special completed/due/done task fields which are marked via emoji. */
function extractSpecialTaskFields(line) {
    let results = [];
    for (let { regex, key } of EMOJI_REGEXES) {
        const match = regex.exec(line);
        if (!match)
            continue;
        results.push({
            key,
            value: match[1],
            start: match.index,
            startValue: match.index + 1,
            end: match.index + match[0].length,
            wrapping: "emoji-shorthand",
        });
    }
    return results;
}
/** Sets or replaces the value of an inline field; if the value is 'undefined', deletes the key. */
function setInlineField(source, key, value) {
    let existing = extractInlineFields(source);
    let existingKeys = existing.filter(f => f.key == key);
    // Don't do anything if there are duplicate keys OR the key already doesn't exist.
    if (existingKeys.length > 2 || (existingKeys.length == 0 && !value))
        return source;
    let existingKey = existingKeys[0];
    let annotation = value ? `[${key}:: ${value}]` : "";
    if (existingKey) {
        let prefix = source.substring(0, existingKey.start);
        let suffix = source.substring(existingKey.end);
        if (annotation)
            return `${prefix}${annotation}${suffix}`;
        else
            return `${prefix}${suffix.trimStart()}`;
    }
    else if (annotation) {
        return `${source.trimEnd()} ${annotation}`;
    }
    return source;
}
function setEmojiShorthandCompletionField(source, value) {
    const existing = extractInlineFields(source, true);
    const existingKeys = existing.filter(f => f.key === "completion" && f.wrapping === "emoji-shorthand");
    // Don't do anything if there are duplicate keys OR the key already doesn't exist.
    if (existingKeys.length > 2 || (existingKeys.length == 0 && !value))
        return source;
    /* No wrapper, add own spacing at start */
    const annotation = value ? ` ✅ ${value}` : "";
    let existingKey = existingKeys[0];
    if (existingKey) {
        const prefix = source.substring(0, existingKey.start);
        const suffix = source.substring(existingKey.end);
        return `${prefix.trimEnd()}${annotation}${suffix}`;
    }
    else {
        return `${source.trimEnd()}${annotation}`;
    }
}

/** All extracted markdown file metadata obtained from a file. */
class PageMetadata {
    constructor(path, init) {
        this.path = path;
        this.fields = new Map();
        this.frontmatter = {};
        this.tags = new Set();
        this.aliases = new Set();
        this.links = [];
        Object.assign(this, init);
        this.lists = (this.lists || []).map(l => new ListItem$1(l));
    }
    /** Canonicalize raw links and other data in partial data with normalizers, returning a completed object. */
    static canonicalize(data, linkNormalizer) {
        // Mutate the data for now, which is probably a bad idea but... all well.
        if (data.frontmatter) {
            data.frontmatter = Values.mapLeaves(data.frontmatter, t => Values.isLink(t) ? linkNormalizer(t) : t);
        }
        if (data.fields) {
            for (let [key, value] of data.fields.entries()) {
                data.fields.set(key, Values.mapLeaves(value, t => (Values.isLink(t) ? linkNormalizer(t) : t)));
            }
        }
        if (data.lists) {
            for (let item of data.lists) {
                for (let [key, value] of item.fields.entries()) {
                    item.fields.set(key, value.map(x => Values.mapLeaves(x, t => (Values.isLink(t) ? linkNormalizer(t) : t))));
                }
            }
        }
        if (data.links) {
            data.links = data.links.map(l => linkNormalizer(l));
        }
        // This is pretty ugly, but it's not possible to normalize on the worker thread that does parsing.
        // The best way to improve this is to instead just canonicalize the entire data object; I can try to
        // optimize `Values.mapLeaves` to only mutate if it actually changes things.
        return new PageMetadata(data.path, data);
    }
    /** The name (based on path) of this file. */
    name() {
        return getFileTitle(this.path);
    }
    /** The containing folder (based on path) of this file. */
    folder() {
        return getParentFolder(this.path);
    }
    /** The extension of this file (likely 'md'). */
    extension() {
        return getExtension(this.path);
    }
    /** Return a set of tags AND all of their parent tags (so #hello/yes would become #hello, #hello/yes). */
    fullTags() {
        let result = new Set();
        for (let tag of this.tags) {
            for (let subtag of extractSubtags(tag))
                result.add(subtag);
        }
        return result;
    }
    /** Convert all links in this file to file links. */
    fileLinks() {
        let distinctPaths = new Set(this.links.map(l => l.path));
        return Array.from(distinctPaths).map(l => Link.file(l));
    }
    /** Map this metadata to a full object; uses the index for additional data lookups.  */
    serialize(index, cache) {
        // Convert list items via the canonicalization cache.
        let realCache = cache !== null && cache !== void 0 ? cache : new ListSerializationCache(this.lists);
        let result = {
            file: {
                path: this.path,
                folder: this.folder(),
                name: this.name(),
                link: Link.file(this.path),
                outlinks: this.fileLinks(),
                inlinks: Array.from(index.links.getInverse(this.path)).map(l => Link.file(l)),
                etags: Array.from(this.tags),
                tags: Array.from(this.fullTags()),
                aliases: Array.from(this.aliases),
                lists: this.lists.map(l => realCache.get(l.line)),
                tasks: this.lists.filter(l => !!l.task).map(l => realCache.get(l.line)),
                ctime: this.ctime,
                cday: stripTime(this.ctime),
                mtime: this.mtime,
                mday: stripTime(this.mtime),
                size: this.size,
                starred: index.starred.starred(this.path),
                frontmatter: Values.deepCopy(this.frontmatter),
                ext: this.extension(),
            },
        };
        // Add the current day if present.
        if (this.day)
            result.file.day = this.day;
        // Then append the computed fields.
        for (let [key, value] of this.fields.entries()) {
            if (key in result)
                continue; // Don't allow fields to override existing keys.
            result[key] = value;
        }
        return result;
    }
}
/** A list item inside of a list. */
class ListItem$1 {
    constructor(init) {
        Object.assign(this, init);
        this.fields = this.fields || new Map();
        this.tags = this.tags || new Set();
        this.children = this.children || [];
        this.links = this.links || [];
    }
    id() {
        return `${this.file().path}-${this.line}`;
    }
    file() {
        return this.link.toFile();
    }
    markdown() {
        if (this.task)
            return `${this.symbol} [${this.task.completed ? "x" : " "}] ${this.text}`;
        else
            return `${this.symbol} ${this.text}`;
    }
    created() {
        var _a, _b, _c;
        return (_c = ((_b = (_a = this.fields.get("created")) !== null && _a !== void 0 ? _a : this.fields.get("ctime")) !== null && _b !== void 0 ? _b : this.fields.get("cday"))) === null || _c === void 0 ? void 0 : _c[0];
    }
    due() {
        var _a, _b, _c;
        return (_c = ((_b = (_a = this.fields.get("due")) !== null && _a !== void 0 ? _a : this.fields.get("duetime")) !== null && _b !== void 0 ? _b : this.fields.get("dueday"))) === null || _c === void 0 ? void 0 : _c[0];
    }
    completed() {
        var _a, _b, _c, _d;
        return (_d = ((_c = (_b = (_a = this.fields.get("completed")) !== null && _a !== void 0 ? _a : this.fields.get("completion")) !== null && _b !== void 0 ? _b : this.fields.get("comptime")) !== null && _c !== void 0 ? _c : this.fields.get("compday"))) === null || _d === void 0 ? void 0 : _d[0];
    }
    start() {
        var _a;
        return (_a = this.fields.get("start")) === null || _a === void 0 ? void 0 : _a[0];
    }
    scheduled() {
        var _a;
        return (_a = this.fields.get("scheduled")) === null || _a === void 0 ? void 0 : _a[0];
    }
    /** Create an API-friendly copy of this list item. De-duplication is done via the provided cache. */
    serialize(cache) {
        // Map children to their serialized/de-duplicated equivalents right away.
        let children = this.children.map(l => cache.get(l)).filter((l) => l !== undefined);
        let result = {
            symbol: this.symbol,
            link: this.link,
            section: this.section,
            text: this.text,
            tags: Array.from(this.tags),
            line: this.line,
            lineCount: this.lineCount,
            list: this.list,
            outlinks: Array.from(this.links),
            path: this.link.path,
            children: children,
            task: !!this.task,
            annotated: this.fields.size > 0,
            position: Values.deepCopy(this.position),
            subtasks: children,
            real: !!this.task,
            header: this.section, // @deprecated, use 'item.section' instead.
        };
        if (this.parent)
            result.parent = this.parent;
        if (this.blockId)
            result.blockId = this.blockId;
        addFields(this.fields, result);
        if (this.task) {
            result.status = this.task.status;
            result.checked = this.task.checked;
            result.completed = this.task.completed;
            result.fullyCompleted = this.task.fullyCompleted;
            let created = this.created(), due = this.due(), completed = this.completed(), start = this.start(), scheduled = this.scheduled();
            if (created)
                result.created = Values.deepCopy(created);
            if (due)
                result.due = Values.deepCopy(due);
            if (completed)
                result.completion = Values.deepCopy(completed);
            if (start)
                result.start = Values.deepCopy(start);
            if (scheduled)
                result.scheduled = Values.deepCopy(scheduled);
        }
        return result;
    }
}
//////////////////////////////////////////
// Conversion / Serialization Utilities //
//////////////////////////////////////////
/** De-duplicates list items across section metadata and page metadata. */
class ListSerializationCache {
    constructor(listItems) {
        this.listItems = {};
        this.cache = {};
        this.seen = new Set();
        for (let item of listItems)
            this.listItems[item.line] = item;
    }
    get(lineno) {
        if (lineno in this.cache)
            return this.cache[lineno];
        else if (this.seen.has(lineno)) {
            console.log(`Dataview: Encountered a circular list (line number ${lineno}; children ${this.listItems[lineno].children.join(", ")})`);
            return undefined;
        }
        this.seen.add(lineno);
        let result = this.listItems[lineno].serialize(this);
        this.cache[lineno] = result;
        return result;
    }
}
function addFields(fields, target) {
    for (let [key, values] of fields.entries()) {
        if (key in target)
            continue;
        target[key] = values.length == 1 ? values[0] : values;
    }
    return target;
}

/** Importer for markdown documents. */
// TODO: Consider using an actual parser in leiu of a more expensive regex.
const LIST_ITEM_REGEX = /^[\s>]*(\d+\.|\d+\)|\*|-|\+)\s*(\[.{0,1}\])?\s*(.*)$/mu;
/** Recursively convert frontmatter into fields. We have to dance around YAML structure. */
function parseFrontmatter(value) {
    if (value == null) {
        return null;
    }
    else if (typeof value === "object") {
        if (Array.isArray(value)) {
            let result = [];
            for (let child of value) {
                result.push(parseFrontmatter(child));
            }
            return result;
        }
        else {
            let object = value;
            let result = {};
            for (let key in object) {
                result[key] = parseFrontmatter(object[key]);
            }
            return result;
        }
    }
    else if (typeof value === "number") {
        return value;
    }
    else if (typeof value === "boolean") {
        return value;
    }
    else if (typeof value === "string") {
        let dateParse = EXPRESSION.date.parse(value);
        if (dateParse.status)
            return dateParse.value;
        let durationParse = EXPRESSION.duration.parse(value);
        if (durationParse.status)
            return durationParse.value;
        let linkParse = EXPRESSION.embedLink.parse(value);
        if (linkParse.status)
            return linkParse.value;
        return value;
    }
    // Backup if we don't understand the type.
    return null;
}

/** Parse a CSV file into a collection of data rows. */
function parseCsv(content) {
    let parsed = papaparse_min.exports.parse(content, {
        header: true,
        skipEmptyLines: true,
        comments: "#",
        dynamicTyping: true,
    });
    let rows = [];
    for (let parsedRow of parsed.data) {
        let fields = parseFrontmatter(parsedRow);
        let result = {};
        for (let [key, value] of Object.entries(fields)) {
            result[key] = value;
            result[canonicalizeVarName(key)] = value;
        }
        rows.push(result);
    }
    return rows;
}

/** Simplifies passing dataview values across the JS web worker barrier. */
var Transferable;
(function (Transferable) {
    /** Convert a literal value to a serializer-friendly transferable value. */
    function transferable(value) {
        // Handle simple universal types first.
        if (value instanceof Map) {
            let copied = new Map();
            for (let [key, val] of value.entries())
                copied.set(transferable(key), transferable(val));
            return copied;
        }
        else if (value instanceof Set) {
            let copied = new Set();
            for (let val of value)
                copied.add(transferable(val));
            return copied;
        }
        let wrapped = Values.wrapValue(value);
        if (wrapped === undefined)
            throw Error("Unrecognized transferable value: " + value);
        switch (wrapped.type) {
            case "null":
            case "number":
            case "string":
            case "boolean":
                return wrapped.value;
            case "date":
                return {
                    "___transfer-type": "date",
                    value: transferable(wrapped.value.toObject()),
                    options: {
                        zone: wrapped.value.zone.equals(SystemZone_1.instance) ? undefined : wrapped.value.zoneName,
                    },
                };
            case "duration":
                return { "___transfer-type": "duration", value: transferable(wrapped.value.toObject()) };
            case "array":
                return wrapped.value.map(v => transferable(v));
            case "link":
                return { "___transfer-type": "link", value: transferable(wrapped.value.toObject()) };
            case "object":
                let result = {};
                for (let [key, value] of Object.entries(wrapped.value))
                    result[key] = transferable(value);
                return result;
        }
    }
    Transferable.transferable = transferable;
    /** Convert a transferable value back to a literal value we can work with. */
    function value(transferable) {
        if (transferable === null) {
            return null;
        }
        else if (transferable === undefined) {
            return undefined;
        }
        else if (transferable instanceof Map) {
            let real = new Map();
            for (let [key, val] of transferable.entries())
                real.set(value(key), value(val));
            return real;
        }
        else if (transferable instanceof Set) {
            let real = new Set();
            for (let val of transferable)
                real.add(value(val));
            return real;
        }
        else if (Array.isArray(transferable)) {
            return transferable.map(v => value(v));
        }
        else if (typeof transferable === "object") {
            if ("___transfer-type" in transferable) {
                switch (transferable["___transfer-type"]) {
                    case "date":
                        let dateOpts = value(transferable.options);
                        let dateData = value(transferable.value);
                        return DateTime_1.fromObject(dateData, { zone: dateOpts.zone });
                    case "duration":
                        return Duration_1.fromObject(value(transferable.value));
                    case "link":
                        return Link.fromObject(value(transferable.value));
                    default:
                        throw Error(`Unrecognized transfer type '${transferable["___transfer-type"]}'`);
                }
            }
            let result = {};
            for (let [key, val] of Object.entries(transferable))
                result[key] = value(val);
            return result;
        }
        return transferable;
    }
    Transferable.value = value;
})(Transferable || (Transferable = {}));

var localforage$1 = {exports: {}};

/*!
    localForage -- Offline Storage, Improved
    Version 1.10.0
    https://localforage.github.io/localForage
    (c) 2013-2017 Mozilla, Apache License 2.0
*/

(function (module, exports) {
(function(f){{module.exports=f();}})(function(){return (function e(t,n,r){function s(o,u){if(!n[o]){if(!t[o]){var a=typeof commonjsRequire=="function"&&commonjsRequire;if(!u&&a)return a(o,!0);if(i)return i(o,!0);var f=new Error("Cannot find module '"+o+"'");throw (f.code="MODULE_NOT_FOUND", f)}var l=n[o]={exports:{}};t[o][0].call(l.exports,function(e){var n=t[o][1][e];return s(n?n:e)},l,l.exports,e,t,n,r);}return n[o].exports}var i=typeof commonjsRequire=="function"&&commonjsRequire;for(var o=0;o<r.length;o++)s(r[o]);return s})({1:[function(_dereq_,module,exports){
(function (global){
var Mutation = global.MutationObserver || global.WebKitMutationObserver;

var scheduleDrain;

{
  if (Mutation) {
    var called = 0;
    var observer = new Mutation(nextTick);
    var element = global.document.createTextNode('');
    observer.observe(element, {
      characterData: true
    });
    scheduleDrain = function () {
      element.data = (called = ++called % 2);
    };
  } else if (!global.setImmediate && typeof global.MessageChannel !== 'undefined') {
    var channel = new global.MessageChannel();
    channel.port1.onmessage = nextTick;
    scheduleDrain = function () {
      channel.port2.postMessage(0);
    };
  } else if ('document' in global && 'onreadystatechange' in global.document.createElement('script')) {
    scheduleDrain = function () {

      // Create a <script> element; its readystatechange event will be fired asynchronously once it is inserted
      // into the document. Do so, thus queuing up the task. Remember to clean up once it's been called.
      var scriptEl = global.document.createElement('script');
      scriptEl.onreadystatechange = function () {
        nextTick();

        scriptEl.onreadystatechange = null;
        scriptEl.parentNode.removeChild(scriptEl);
        scriptEl = null;
      };
      global.document.documentElement.appendChild(scriptEl);
    };
  } else {
    scheduleDrain = function () {
      setTimeout(nextTick, 0);
    };
  }
}

var draining;
var queue = [];
//named nextTick for less confusing stack traces
function nextTick() {
  draining = true;
  var i, oldQueue;
  var len = queue.length;
  while (len) {
    oldQueue = queue;
    queue = [];
    i = -1;
    while (++i < len) {
      oldQueue[i]();
    }
    len = queue.length;
  }
  draining = false;
}

module.exports = immediate;
function immediate(task) {
  if (queue.push(task) === 1 && !draining) {
    scheduleDrain();
  }
}

}).call(this,typeof commonjsGlobal !== "undefined" ? commonjsGlobal : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {});
},{}],2:[function(_dereq_,module,exports){
var immediate = _dereq_(1);

/* istanbul ignore next */
function INTERNAL() {}

var handlers = {};

var REJECTED = ['REJECTED'];
var FULFILLED = ['FULFILLED'];
var PENDING = ['PENDING'];

module.exports = Promise;

function Promise(resolver) {
  if (typeof resolver !== 'function') {
    throw new TypeError('resolver must be a function');
  }
  this.state = PENDING;
  this.queue = [];
  this.outcome = void 0;
  if (resolver !== INTERNAL) {
    safelyResolveThenable(this, resolver);
  }
}

Promise.prototype["catch"] = function (onRejected) {
  return this.then(null, onRejected);
};
Promise.prototype.then = function (onFulfilled, onRejected) {
  if (typeof onFulfilled !== 'function' && this.state === FULFILLED ||
    typeof onRejected !== 'function' && this.state === REJECTED) {
    return this;
  }
  var promise = new this.constructor(INTERNAL);
  if (this.state !== PENDING) {
    var resolver = this.state === FULFILLED ? onFulfilled : onRejected;
    unwrap(promise, resolver, this.outcome);
  } else {
    this.queue.push(new QueueItem(promise, onFulfilled, onRejected));
  }

  return promise;
};
function QueueItem(promise, onFulfilled, onRejected) {
  this.promise = promise;
  if (typeof onFulfilled === 'function') {
    this.onFulfilled = onFulfilled;
    this.callFulfilled = this.otherCallFulfilled;
  }
  if (typeof onRejected === 'function') {
    this.onRejected = onRejected;
    this.callRejected = this.otherCallRejected;
  }
}
QueueItem.prototype.callFulfilled = function (value) {
  handlers.resolve(this.promise, value);
};
QueueItem.prototype.otherCallFulfilled = function (value) {
  unwrap(this.promise, this.onFulfilled, value);
};
QueueItem.prototype.callRejected = function (value) {
  handlers.reject(this.promise, value);
};
QueueItem.prototype.otherCallRejected = function (value) {
  unwrap(this.promise, this.onRejected, value);
};

function unwrap(promise, func, value) {
  immediate(function () {
    var returnValue;
    try {
      returnValue = func(value);
    } catch (e) {
      return handlers.reject(promise, e);
    }
    if (returnValue === promise) {
      handlers.reject(promise, new TypeError('Cannot resolve promise with itself'));
    } else {
      handlers.resolve(promise, returnValue);
    }
  });
}

handlers.resolve = function (self, value) {
  var result = tryCatch(getThen, value);
  if (result.status === 'error') {
    return handlers.reject(self, result.value);
  }
  var thenable = result.value;

  if (thenable) {
    safelyResolveThenable(self, thenable);
  } else {
    self.state = FULFILLED;
    self.outcome = value;
    var i = -1;
    var len = self.queue.length;
    while (++i < len) {
      self.queue[i].callFulfilled(value);
    }
  }
  return self;
};
handlers.reject = function (self, error) {
  self.state = REJECTED;
  self.outcome = error;
  var i = -1;
  var len = self.queue.length;
  while (++i < len) {
    self.queue[i].callRejected(error);
  }
  return self;
};

function getThen(obj) {
  // Make sure we only access the accessor once as required by the spec
  var then = obj && obj.then;
  if (obj && (typeof obj === 'object' || typeof obj === 'function') && typeof then === 'function') {
    return function appyThen() {
      then.apply(obj, arguments);
    };
  }
}

function safelyResolveThenable(self, thenable) {
  // Either fulfill, reject or reject with error
  var called = false;
  function onError(value) {
    if (called) {
      return;
    }
    called = true;
    handlers.reject(self, value);
  }

  function onSuccess(value) {
    if (called) {
      return;
    }
    called = true;
    handlers.resolve(self, value);
  }

  function tryToUnwrap() {
    thenable(onSuccess, onError);
  }

  var result = tryCatch(tryToUnwrap);
  if (result.status === 'error') {
    onError(result.value);
  }
}

function tryCatch(func, value) {
  var out = {};
  try {
    out.value = func(value);
    out.status = 'success';
  } catch (e) {
    out.status = 'error';
    out.value = e;
  }
  return out;
}

Promise.resolve = resolve;
function resolve(value) {
  if (value instanceof this) {
    return value;
  }
  return handlers.resolve(new this(INTERNAL), value);
}

Promise.reject = reject;
function reject(reason) {
  var promise = new this(INTERNAL);
  return handlers.reject(promise, reason);
}

Promise.all = all;
function all(iterable) {
  var self = this;
  if (Object.prototype.toString.call(iterable) !== '[object Array]') {
    return this.reject(new TypeError('must be an array'));
  }

  var len = iterable.length;
  var called = false;
  if (!len) {
    return this.resolve([]);
  }

  var values = new Array(len);
  var resolved = 0;
  var i = -1;
  var promise = new this(INTERNAL);

  while (++i < len) {
    allResolver(iterable[i], i);
  }
  return promise;
  function allResolver(value, i) {
    self.resolve(value).then(resolveFromAll, function (error) {
      if (!called) {
        called = true;
        handlers.reject(promise, error);
      }
    });
    function resolveFromAll(outValue) {
      values[i] = outValue;
      if (++resolved === len && !called) {
        called = true;
        handlers.resolve(promise, values);
      }
    }
  }
}

Promise.race = race;
function race(iterable) {
  var self = this;
  if (Object.prototype.toString.call(iterable) !== '[object Array]') {
    return this.reject(new TypeError('must be an array'));
  }

  var len = iterable.length;
  var called = false;
  if (!len) {
    return this.resolve([]);
  }

  var i = -1;
  var promise = new this(INTERNAL);

  while (++i < len) {
    resolver(iterable[i]);
  }
  return promise;
  function resolver(value) {
    self.resolve(value).then(function (response) {
      if (!called) {
        called = true;
        handlers.resolve(promise, response);
      }
    }, function (error) {
      if (!called) {
        called = true;
        handlers.reject(promise, error);
      }
    });
  }
}

},{"1":1}],3:[function(_dereq_,module,exports){
(function (global){
if (typeof global.Promise !== 'function') {
  global.Promise = _dereq_(2);
}

}).call(this,typeof commonjsGlobal !== "undefined" ? commonjsGlobal : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {});
},{"2":2}],4:[function(_dereq_,module,exports){

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function getIDB() {
    /* global indexedDB,webkitIndexedDB,mozIndexedDB,OIndexedDB,msIndexedDB */
    try {
        if (typeof indexedDB !== 'undefined') {
            return indexedDB;
        }
        if (typeof webkitIndexedDB !== 'undefined') {
            return webkitIndexedDB;
        }
        if (typeof mozIndexedDB !== 'undefined') {
            return mozIndexedDB;
        }
        if (typeof OIndexedDB !== 'undefined') {
            return OIndexedDB;
        }
        if (typeof msIndexedDB !== 'undefined') {
            return msIndexedDB;
        }
    } catch (e) {
        return;
    }
}

var idb = getIDB();

function isIndexedDBValid() {
    try {
        // Initialize IndexedDB; fall back to vendor-prefixed versions
        // if needed.
        if (!idb || !idb.open) {
            return false;
        }
        // We mimic PouchDB here;
        //
        // We test for openDatabase because IE Mobile identifies itself
        // as Safari. Oh the lulz...
        var isSafari = typeof openDatabase !== 'undefined' && /(Safari|iPhone|iPad|iPod)/.test(navigator.userAgent) && !/Chrome/.test(navigator.userAgent) && !/BlackBerry/.test(navigator.platform);

        var hasFetch = typeof fetch === 'function' && fetch.toString().indexOf('[native code') !== -1;

        // Safari <10.1 does not meet our requirements for IDB support
        // (see: https://github.com/pouchdb/pouchdb/issues/5572).
        // Safari 10.1 shipped with fetch, we can use that to detect it.
        // Note: this creates issues with `window.fetch` polyfills and
        // overrides; see:
        // https://github.com/localForage/localForage/issues/856
        return (!isSafari || hasFetch) && typeof indexedDB !== 'undefined' &&
        // some outdated implementations of IDB that appear on Samsung
        // and HTC Android devices <4.4 are missing IDBKeyRange
        // See: https://github.com/mozilla/localForage/issues/128
        // See: https://github.com/mozilla/localForage/issues/272
        typeof IDBKeyRange !== 'undefined';
    } catch (e) {
        return false;
    }
}

// Abstracts constructing a Blob object, so it also works in older
// browsers that don't support the native Blob constructor. (i.e.
// old QtWebKit versions, at least).
// Abstracts constructing a Blob object, so it also works in older
// browsers that don't support the native Blob constructor. (i.e.
// old QtWebKit versions, at least).
function createBlob(parts, properties) {
    /* global BlobBuilder,MSBlobBuilder,MozBlobBuilder,WebKitBlobBuilder */
    parts = parts || [];
    properties = properties || {};
    try {
        return new Blob(parts, properties);
    } catch (e) {
        if (e.name !== 'TypeError') {
            throw e;
        }
        var Builder = typeof BlobBuilder !== 'undefined' ? BlobBuilder : typeof MSBlobBuilder !== 'undefined' ? MSBlobBuilder : typeof MozBlobBuilder !== 'undefined' ? MozBlobBuilder : WebKitBlobBuilder;
        var builder = new Builder();
        for (var i = 0; i < parts.length; i += 1) {
            builder.append(parts[i]);
        }
        return builder.getBlob(properties.type);
    }
}

// This is CommonJS because lie is an external dependency, so Rollup
// can just ignore it.
if (typeof Promise === 'undefined') {
    // In the "nopromises" build this will just throw if you don't have
    // a global promise object, but it would throw anyway later.
    _dereq_(3);
}
var Promise$1 = Promise;

function executeCallback(promise, callback) {
    if (callback) {
        promise.then(function (result) {
            callback(null, result);
        }, function (error) {
            callback(error);
        });
    }
}

function executeTwoCallbacks(promise, callback, errorCallback) {
    if (typeof callback === 'function') {
        promise.then(callback);
    }

    if (typeof errorCallback === 'function') {
        promise["catch"](errorCallback);
    }
}

function normalizeKey(key) {
    // Cast the key to a string, as that's all we can set as a key.
    if (typeof key !== 'string') {
        console.warn(key + ' used as a key, but it is not a string.');
        key = String(key);
    }

    return key;
}

function getCallback() {
    if (arguments.length && typeof arguments[arguments.length - 1] === 'function') {
        return arguments[arguments.length - 1];
    }
}

// Some code originally from async_storage.js in
// [Gaia](https://github.com/mozilla-b2g/gaia).

var DETECT_BLOB_SUPPORT_STORE = 'local-forage-detect-blob-support';
var supportsBlobs = void 0;
var dbContexts = {};
var toString = Object.prototype.toString;

// Transaction Modes
var READ_ONLY = 'readonly';
var READ_WRITE = 'readwrite';

// Transform a binary string to an array buffer, because otherwise
// weird stuff happens when you try to work with the binary string directly.
// It is known.
// From http://stackoverflow.com/questions/14967647/ (continues on next line)
// encode-decode-image-with-base64-breaks-image (2013-04-21)
function _binStringToArrayBuffer(bin) {
    var length = bin.length;
    var buf = new ArrayBuffer(length);
    var arr = new Uint8Array(buf);
    for (var i = 0; i < length; i++) {
        arr[i] = bin.charCodeAt(i);
    }
    return buf;
}

//
// Blobs are not supported in all versions of IndexedDB, notably
// Chrome <37 and Android <5. In those versions, storing a blob will throw.
//
// Various other blob bugs exist in Chrome v37-42 (inclusive).
// Detecting them is expensive and confusing to users, and Chrome 37-42
// is at very low usage worldwide, so we do a hacky userAgent check instead.
//
// content-type bug: https://code.google.com/p/chromium/issues/detail?id=408120
// 404 bug: https://code.google.com/p/chromium/issues/detail?id=447916
// FileReader bug: https://code.google.com/p/chromium/issues/detail?id=447836
//
// Code borrowed from PouchDB. See:
// https://github.com/pouchdb/pouchdb/blob/master/packages/node_modules/pouchdb-adapter-idb/src/blobSupport.js
//
function _checkBlobSupportWithoutCaching(idb) {
    return new Promise$1(function (resolve) {
        var txn = idb.transaction(DETECT_BLOB_SUPPORT_STORE, READ_WRITE);
        var blob = createBlob(['']);
        txn.objectStore(DETECT_BLOB_SUPPORT_STORE).put(blob, 'key');

        txn.onabort = function (e) {
            // If the transaction aborts now its due to not being able to
            // write to the database, likely due to the disk being full
            e.preventDefault();
            e.stopPropagation();
            resolve(false);
        };

        txn.oncomplete = function () {
            var matchedChrome = navigator.userAgent.match(/Chrome\/(\d+)/);
            var matchedEdge = navigator.userAgent.match(/Edge\//);
            // MS Edge pretends to be Chrome 42:
            // https://msdn.microsoft.com/en-us/library/hh869301%28v=vs.85%29.aspx
            resolve(matchedEdge || !matchedChrome || parseInt(matchedChrome[1], 10) >= 43);
        };
    })["catch"](function () {
        return false; // error, so assume unsupported
    });
}

function _checkBlobSupport(idb) {
    if (typeof supportsBlobs === 'boolean') {
        return Promise$1.resolve(supportsBlobs);
    }
    return _checkBlobSupportWithoutCaching(idb).then(function (value) {
        supportsBlobs = value;
        return supportsBlobs;
    });
}

function _deferReadiness(dbInfo) {
    var dbContext = dbContexts[dbInfo.name];

    // Create a deferred object representing the current database operation.
    var deferredOperation = {};

    deferredOperation.promise = new Promise$1(function (resolve, reject) {
        deferredOperation.resolve = resolve;
        deferredOperation.reject = reject;
    });

    // Enqueue the deferred operation.
    dbContext.deferredOperations.push(deferredOperation);

    // Chain its promise to the database readiness.
    if (!dbContext.dbReady) {
        dbContext.dbReady = deferredOperation.promise;
    } else {
        dbContext.dbReady = dbContext.dbReady.then(function () {
            return deferredOperation.promise;
        });
    }
}

function _advanceReadiness(dbInfo) {
    var dbContext = dbContexts[dbInfo.name];

    // Dequeue a deferred operation.
    var deferredOperation = dbContext.deferredOperations.pop();

    // Resolve its promise (which is part of the database readiness
    // chain of promises).
    if (deferredOperation) {
        deferredOperation.resolve();
        return deferredOperation.promise;
    }
}

function _rejectReadiness(dbInfo, err) {
    var dbContext = dbContexts[dbInfo.name];

    // Dequeue a deferred operation.
    var deferredOperation = dbContext.deferredOperations.pop();

    // Reject its promise (which is part of the database readiness
    // chain of promises).
    if (deferredOperation) {
        deferredOperation.reject(err);
        return deferredOperation.promise;
    }
}

function _getConnection(dbInfo, upgradeNeeded) {
    return new Promise$1(function (resolve, reject) {
        dbContexts[dbInfo.name] = dbContexts[dbInfo.name] || createDbContext();

        if (dbInfo.db) {
            if (upgradeNeeded) {
                _deferReadiness(dbInfo);
                dbInfo.db.close();
            } else {
                return resolve(dbInfo.db);
            }
        }

        var dbArgs = [dbInfo.name];

        if (upgradeNeeded) {
            dbArgs.push(dbInfo.version);
        }

        var openreq = idb.open.apply(idb, dbArgs);

        if (upgradeNeeded) {
            openreq.onupgradeneeded = function (e) {
                var db = openreq.result;
                try {
                    db.createObjectStore(dbInfo.storeName);
                    if (e.oldVersion <= 1) {
                        // Added when support for blob shims was added
                        db.createObjectStore(DETECT_BLOB_SUPPORT_STORE);
                    }
                } catch (ex) {
                    if (ex.name === 'ConstraintError') {
                        console.warn('The database "' + dbInfo.name + '"' + ' has been upgraded from version ' + e.oldVersion + ' to version ' + e.newVersion + ', but the storage "' + dbInfo.storeName + '" already exists.');
                    } else {
                        throw ex;
                    }
                }
            };
        }

        openreq.onerror = function (e) {
            e.preventDefault();
            reject(openreq.error);
        };

        openreq.onsuccess = function () {
            var db = openreq.result;
            db.onversionchange = function (e) {
                // Triggered when the database is modified (e.g. adding an objectStore) or
                // deleted (even when initiated by other sessions in different tabs).
                // Closing the connection here prevents those operations from being blocked.
                // If the database is accessed again later by this instance, the connection
                // will be reopened or the database recreated as needed.
                e.target.close();
            };
            resolve(db);
            _advanceReadiness(dbInfo);
        };
    });
}

function _getOriginalConnection(dbInfo) {
    return _getConnection(dbInfo, false);
}

function _getUpgradedConnection(dbInfo) {
    return _getConnection(dbInfo, true);
}

function _isUpgradeNeeded(dbInfo, defaultVersion) {
    if (!dbInfo.db) {
        return true;
    }

    var isNewStore = !dbInfo.db.objectStoreNames.contains(dbInfo.storeName);
    var isDowngrade = dbInfo.version < dbInfo.db.version;
    var isUpgrade = dbInfo.version > dbInfo.db.version;

    if (isDowngrade) {
        // If the version is not the default one
        // then warn for impossible downgrade.
        if (dbInfo.version !== defaultVersion) {
            console.warn('The database "' + dbInfo.name + '"' + " can't be downgraded from version " + dbInfo.db.version + ' to version ' + dbInfo.version + '.');
        }
        // Align the versions to prevent errors.
        dbInfo.version = dbInfo.db.version;
    }

    if (isUpgrade || isNewStore) {
        // If the store is new then increment the version (if needed).
        // This will trigger an "upgradeneeded" event which is required
        // for creating a store.
        if (isNewStore) {
            var incVersion = dbInfo.db.version + 1;
            if (incVersion > dbInfo.version) {
                dbInfo.version = incVersion;
            }
        }

        return true;
    }

    return false;
}

// encode a blob for indexeddb engines that don't support blobs
function _encodeBlob(blob) {
    return new Promise$1(function (resolve, reject) {
        var reader = new FileReader();
        reader.onerror = reject;
        reader.onloadend = function (e) {
            var base64 = btoa(e.target.result || '');
            resolve({
                __local_forage_encoded_blob: true,
                data: base64,
                type: blob.type
            });
        };
        reader.readAsBinaryString(blob);
    });
}

// decode an encoded blob
function _decodeBlob(encodedBlob) {
    var arrayBuff = _binStringToArrayBuffer(atob(encodedBlob.data));
    return createBlob([arrayBuff], { type: encodedBlob.type });
}

// is this one of our fancy encoded blobs?
function _isEncodedBlob(value) {
    return value && value.__local_forage_encoded_blob;
}

// Specialize the default `ready()` function by making it dependent
// on the current database operations. Thus, the driver will be actually
// ready when it's been initialized (default) *and* there are no pending
// operations on the database (initiated by some other instances).
function _fullyReady(callback) {
    var self = this;

    var promise = self._initReady().then(function () {
        var dbContext = dbContexts[self._dbInfo.name];

        if (dbContext && dbContext.dbReady) {
            return dbContext.dbReady;
        }
    });

    executeTwoCallbacks(promise, callback, callback);
    return promise;
}

// Try to establish a new db connection to replace the
// current one which is broken (i.e. experiencing
// InvalidStateError while creating a transaction).
function _tryReconnect(dbInfo) {
    _deferReadiness(dbInfo);

    var dbContext = dbContexts[dbInfo.name];
    var forages = dbContext.forages;

    for (var i = 0; i < forages.length; i++) {
        var forage = forages[i];
        if (forage._dbInfo.db) {
            forage._dbInfo.db.close();
            forage._dbInfo.db = null;
        }
    }
    dbInfo.db = null;

    return _getOriginalConnection(dbInfo).then(function (db) {
        dbInfo.db = db;
        if (_isUpgradeNeeded(dbInfo)) {
            // Reopen the database for upgrading.
            return _getUpgradedConnection(dbInfo);
        }
        return db;
    }).then(function (db) {
        // store the latest db reference
        // in case the db was upgraded
        dbInfo.db = dbContext.db = db;
        for (var i = 0; i < forages.length; i++) {
            forages[i]._dbInfo.db = db;
        }
    })["catch"](function (err) {
        _rejectReadiness(dbInfo, err);
        throw err;
    });
}

// FF doesn't like Promises (micro-tasks) and IDDB store operations,
// so we have to do it with callbacks
function createTransaction(dbInfo, mode, callback, retries) {
    if (retries === undefined) {
        retries = 1;
    }

    try {
        var tx = dbInfo.db.transaction(dbInfo.storeName, mode);
        callback(null, tx);
    } catch (err) {
        if (retries > 0 && (!dbInfo.db || err.name === 'InvalidStateError' || err.name === 'NotFoundError')) {
            return Promise$1.resolve().then(function () {
                if (!dbInfo.db || err.name === 'NotFoundError' && !dbInfo.db.objectStoreNames.contains(dbInfo.storeName) && dbInfo.version <= dbInfo.db.version) {
                    // increase the db version, to create the new ObjectStore
                    if (dbInfo.db) {
                        dbInfo.version = dbInfo.db.version + 1;
                    }
                    // Reopen the database for upgrading.
                    return _getUpgradedConnection(dbInfo);
                }
            }).then(function () {
                return _tryReconnect(dbInfo).then(function () {
                    createTransaction(dbInfo, mode, callback, retries - 1);
                });
            })["catch"](callback);
        }

        callback(err);
    }
}

function createDbContext() {
    return {
        // Running localForages sharing a database.
        forages: [],
        // Shared database.
        db: null,
        // Database readiness (promise).
        dbReady: null,
        // Deferred operations on the database.
        deferredOperations: []
    };
}

// Open the IndexedDB database (automatically creates one if one didn't
// previously exist), using any options set in the config.
function _initStorage(options) {
    var self = this;
    var dbInfo = {
        db: null
    };

    if (options) {
        for (var i in options) {
            dbInfo[i] = options[i];
        }
    }

    // Get the current context of the database;
    var dbContext = dbContexts[dbInfo.name];

    // ...or create a new context.
    if (!dbContext) {
        dbContext = createDbContext();
        // Register the new context in the global container.
        dbContexts[dbInfo.name] = dbContext;
    }

    // Register itself as a running localForage in the current context.
    dbContext.forages.push(self);

    // Replace the default `ready()` function with the specialized one.
    if (!self._initReady) {
        self._initReady = self.ready;
        self.ready = _fullyReady;
    }

    // Create an array of initialization states of the related localForages.
    var initPromises = [];

    function ignoreErrors() {
        // Don't handle errors here,
        // just makes sure related localForages aren't pending.
        return Promise$1.resolve();
    }

    for (var j = 0; j < dbContext.forages.length; j++) {
        var forage = dbContext.forages[j];
        if (forage !== self) {
            // Don't wait for itself...
            initPromises.push(forage._initReady()["catch"](ignoreErrors));
        }
    }

    // Take a snapshot of the related localForages.
    var forages = dbContext.forages.slice(0);

    // Initialize the connection process only when
    // all the related localForages aren't pending.
    return Promise$1.all(initPromises).then(function () {
        dbInfo.db = dbContext.db;
        // Get the connection or open a new one without upgrade.
        return _getOriginalConnection(dbInfo);
    }).then(function (db) {
        dbInfo.db = db;
        if (_isUpgradeNeeded(dbInfo, self._defaultConfig.version)) {
            // Reopen the database for upgrading.
            return _getUpgradedConnection(dbInfo);
        }
        return db;
    }).then(function (db) {
        dbInfo.db = dbContext.db = db;
        self._dbInfo = dbInfo;
        // Share the final connection amongst related localForages.
        for (var k = 0; k < forages.length; k++) {
            var forage = forages[k];
            if (forage !== self) {
                // Self is already up-to-date.
                forage._dbInfo.db = dbInfo.db;
                forage._dbInfo.version = dbInfo.version;
            }
        }
    });
}

function getItem(key, callback) {
    var self = this;

    key = normalizeKey(key);

    var promise = new Promise$1(function (resolve, reject) {
        self.ready().then(function () {
            createTransaction(self._dbInfo, READ_ONLY, function (err, transaction) {
                if (err) {
                    return reject(err);
                }

                try {
                    var store = transaction.objectStore(self._dbInfo.storeName);
                    var req = store.get(key);

                    req.onsuccess = function () {
                        var value = req.result;
                        if (value === undefined) {
                            value = null;
                        }
                        if (_isEncodedBlob(value)) {
                            value = _decodeBlob(value);
                        }
                        resolve(value);
                    };

                    req.onerror = function () {
                        reject(req.error);
                    };
                } catch (e) {
                    reject(e);
                }
            });
        })["catch"](reject);
    });

    executeCallback(promise, callback);
    return promise;
}

// Iterate over all items stored in database.
function iterate(iterator, callback) {
    var self = this;

    var promise = new Promise$1(function (resolve, reject) {
        self.ready().then(function () {
            createTransaction(self._dbInfo, READ_ONLY, function (err, transaction) {
                if (err) {
                    return reject(err);
                }

                try {
                    var store = transaction.objectStore(self._dbInfo.storeName);
                    var req = store.openCursor();
                    var iterationNumber = 1;

                    req.onsuccess = function () {
                        var cursor = req.result;

                        if (cursor) {
                            var value = cursor.value;
                            if (_isEncodedBlob(value)) {
                                value = _decodeBlob(value);
                            }
                            var result = iterator(value, cursor.key, iterationNumber++);

                            // when the iterator callback returns any
                            // (non-`undefined`) value, then we stop
                            // the iteration immediately
                            if (result !== void 0) {
                                resolve(result);
                            } else {
                                cursor["continue"]();
                            }
                        } else {
                            resolve();
                        }
                    };

                    req.onerror = function () {
                        reject(req.error);
                    };
                } catch (e) {
                    reject(e);
                }
            });
        })["catch"](reject);
    });

    executeCallback(promise, callback);

    return promise;
}

function setItem(key, value, callback) {
    var self = this;

    key = normalizeKey(key);

    var promise = new Promise$1(function (resolve, reject) {
        var dbInfo;
        self.ready().then(function () {
            dbInfo = self._dbInfo;
            if (toString.call(value) === '[object Blob]') {
                return _checkBlobSupport(dbInfo.db).then(function (blobSupport) {
                    if (blobSupport) {
                        return value;
                    }
                    return _encodeBlob(value);
                });
            }
            return value;
        }).then(function (value) {
            createTransaction(self._dbInfo, READ_WRITE, function (err, transaction) {
                if (err) {
                    return reject(err);
                }

                try {
                    var store = transaction.objectStore(self._dbInfo.storeName);

                    // The reason we don't _save_ null is because IE 10 does
                    // not support saving the `null` type in IndexedDB. How
                    // ironic, given the bug below!
                    // See: https://github.com/mozilla/localForage/issues/161
                    if (value === null) {
                        value = undefined;
                    }

                    var req = store.put(value, key);

                    transaction.oncomplete = function () {
                        // Cast to undefined so the value passed to
                        // callback/promise is the same as what one would get out
                        // of `getItem()` later. This leads to some weirdness
                        // (setItem('foo', undefined) will return `null`), but
                        // it's not my fault localStorage is our baseline and that
                        // it's weird.
                        if (value === undefined) {
                            value = null;
                        }

                        resolve(value);
                    };
                    transaction.onabort = transaction.onerror = function () {
                        var err = req.error ? req.error : req.transaction.error;
                        reject(err);
                    };
                } catch (e) {
                    reject(e);
                }
            });
        })["catch"](reject);
    });

    executeCallback(promise, callback);
    return promise;
}

function removeItem(key, callback) {
    var self = this;

    key = normalizeKey(key);

    var promise = new Promise$1(function (resolve, reject) {
        self.ready().then(function () {
            createTransaction(self._dbInfo, READ_WRITE, function (err, transaction) {
                if (err) {
                    return reject(err);
                }

                try {
                    var store = transaction.objectStore(self._dbInfo.storeName);
                    // We use a Grunt task to make this safe for IE and some
                    // versions of Android (including those used by Cordova).
                    // Normally IE won't like `.delete()` and will insist on
                    // using `['delete']()`, but we have a build step that
                    // fixes this for us now.
                    var req = store["delete"](key);
                    transaction.oncomplete = function () {
                        resolve();
                    };

                    transaction.onerror = function () {
                        reject(req.error);
                    };

                    // The request will be also be aborted if we've exceeded our storage
                    // space.
                    transaction.onabort = function () {
                        var err = req.error ? req.error : req.transaction.error;
                        reject(err);
                    };
                } catch (e) {
                    reject(e);
                }
            });
        })["catch"](reject);
    });

    executeCallback(promise, callback);
    return promise;
}

function clear(callback) {
    var self = this;

    var promise = new Promise$1(function (resolve, reject) {
        self.ready().then(function () {
            createTransaction(self._dbInfo, READ_WRITE, function (err, transaction) {
                if (err) {
                    return reject(err);
                }

                try {
                    var store = transaction.objectStore(self._dbInfo.storeName);
                    var req = store.clear();

                    transaction.oncomplete = function () {
                        resolve();
                    };

                    transaction.onabort = transaction.onerror = function () {
                        var err = req.error ? req.error : req.transaction.error;
                        reject(err);
                    };
                } catch (e) {
                    reject(e);
                }
            });
        })["catch"](reject);
    });

    executeCallback(promise, callback);
    return promise;
}

function length(callback) {
    var self = this;

    var promise = new Promise$1(function (resolve, reject) {
        self.ready().then(function () {
            createTransaction(self._dbInfo, READ_ONLY, function (err, transaction) {
                if (err) {
                    return reject(err);
                }

                try {
                    var store = transaction.objectStore(self._dbInfo.storeName);
                    var req = store.count();

                    req.onsuccess = function () {
                        resolve(req.result);
                    };

                    req.onerror = function () {
                        reject(req.error);
                    };
                } catch (e) {
                    reject(e);
                }
            });
        })["catch"](reject);
    });

    executeCallback(promise, callback);
    return promise;
}

function key(n, callback) {
    var self = this;

    var promise = new Promise$1(function (resolve, reject) {
        if (n < 0) {
            resolve(null);

            return;
        }

        self.ready().then(function () {
            createTransaction(self._dbInfo, READ_ONLY, function (err, transaction) {
                if (err) {
                    return reject(err);
                }

                try {
                    var store = transaction.objectStore(self._dbInfo.storeName);
                    var advanced = false;
                    var req = store.openKeyCursor();

                    req.onsuccess = function () {
                        var cursor = req.result;
                        if (!cursor) {
                            // this means there weren't enough keys
                            resolve(null);

                            return;
                        }

                        if (n === 0) {
                            // We have the first key, return it if that's what they
                            // wanted.
                            resolve(cursor.key);
                        } else {
                            if (!advanced) {
                                // Otherwise, ask the cursor to skip ahead n
                                // records.
                                advanced = true;
                                cursor.advance(n);
                            } else {
                                // When we get here, we've got the nth key.
                                resolve(cursor.key);
                            }
                        }
                    };

                    req.onerror = function () {
                        reject(req.error);
                    };
                } catch (e) {
                    reject(e);
                }
            });
        })["catch"](reject);
    });

    executeCallback(promise, callback);
    return promise;
}

function keys(callback) {
    var self = this;

    var promise = new Promise$1(function (resolve, reject) {
        self.ready().then(function () {
            createTransaction(self._dbInfo, READ_ONLY, function (err, transaction) {
                if (err) {
                    return reject(err);
                }

                try {
                    var store = transaction.objectStore(self._dbInfo.storeName);
                    var req = store.openKeyCursor();
                    var keys = [];

                    req.onsuccess = function () {
                        var cursor = req.result;

                        if (!cursor) {
                            resolve(keys);
                            return;
                        }

                        keys.push(cursor.key);
                        cursor["continue"]();
                    };

                    req.onerror = function () {
                        reject(req.error);
                    };
                } catch (e) {
                    reject(e);
                }
            });
        })["catch"](reject);
    });

    executeCallback(promise, callback);
    return promise;
}

function dropInstance(options, callback) {
    callback = getCallback.apply(this, arguments);

    var currentConfig = this.config();
    options = typeof options !== 'function' && options || {};
    if (!options.name) {
        options.name = options.name || currentConfig.name;
        options.storeName = options.storeName || currentConfig.storeName;
    }

    var self = this;
    var promise;
    if (!options.name) {
        promise = Promise$1.reject('Invalid arguments');
    } else {
        var isCurrentDb = options.name === currentConfig.name && self._dbInfo.db;

        var dbPromise = isCurrentDb ? Promise$1.resolve(self._dbInfo.db) : _getOriginalConnection(options).then(function (db) {
            var dbContext = dbContexts[options.name];
            var forages = dbContext.forages;
            dbContext.db = db;
            for (var i = 0; i < forages.length; i++) {
                forages[i]._dbInfo.db = db;
            }
            return db;
        });

        if (!options.storeName) {
            promise = dbPromise.then(function (db) {
                _deferReadiness(options);

                var dbContext = dbContexts[options.name];
                var forages = dbContext.forages;

                db.close();
                for (var i = 0; i < forages.length; i++) {
                    var forage = forages[i];
                    forage._dbInfo.db = null;
                }

                var dropDBPromise = new Promise$1(function (resolve, reject) {
                    var req = idb.deleteDatabase(options.name);

                    req.onerror = function () {
                        var db = req.result;
                        if (db) {
                            db.close();
                        }
                        reject(req.error);
                    };

                    req.onblocked = function () {
                        // Closing all open connections in onversionchange handler should prevent this situation, but if
                        // we do get here, it just means the request remains pending - eventually it will succeed or error
                        console.warn('dropInstance blocked for database "' + options.name + '" until all open connections are closed');
                    };

                    req.onsuccess = function () {
                        var db = req.result;
                        if (db) {
                            db.close();
                        }
                        resolve(db);
                    };
                });

                return dropDBPromise.then(function (db) {
                    dbContext.db = db;
                    for (var i = 0; i < forages.length; i++) {
                        var _forage = forages[i];
                        _advanceReadiness(_forage._dbInfo);
                    }
                })["catch"](function (err) {
                    (_rejectReadiness(options, err) || Promise$1.resolve())["catch"](function () {});
                    throw err;
                });
            });
        } else {
            promise = dbPromise.then(function (db) {
                if (!db.objectStoreNames.contains(options.storeName)) {
                    return;
                }

                var newVersion = db.version + 1;

                _deferReadiness(options);

                var dbContext = dbContexts[options.name];
                var forages = dbContext.forages;

                db.close();
                for (var i = 0; i < forages.length; i++) {
                    var forage = forages[i];
                    forage._dbInfo.db = null;
                    forage._dbInfo.version = newVersion;
                }

                var dropObjectPromise = new Promise$1(function (resolve, reject) {
                    var req = idb.open(options.name, newVersion);

                    req.onerror = function (err) {
                        var db = req.result;
                        db.close();
                        reject(err);
                    };

                    req.onupgradeneeded = function () {
                        var db = req.result;
                        db.deleteObjectStore(options.storeName);
                    };

                    req.onsuccess = function () {
                        var db = req.result;
                        db.close();
                        resolve(db);
                    };
                });

                return dropObjectPromise.then(function (db) {
                    dbContext.db = db;
                    for (var j = 0; j < forages.length; j++) {
                        var _forage2 = forages[j];
                        _forage2._dbInfo.db = db;
                        _advanceReadiness(_forage2._dbInfo);
                    }
                })["catch"](function (err) {
                    (_rejectReadiness(options, err) || Promise$1.resolve())["catch"](function () {});
                    throw err;
                });
            });
        }
    }

    executeCallback(promise, callback);
    return promise;
}

var asyncStorage = {
    _driver: 'asyncStorage',
    _initStorage: _initStorage,
    _support: isIndexedDBValid(),
    iterate: iterate,
    getItem: getItem,
    setItem: setItem,
    removeItem: removeItem,
    clear: clear,
    length: length,
    key: key,
    keys: keys,
    dropInstance: dropInstance
};

function isWebSQLValid() {
    return typeof openDatabase === 'function';
}

// Sadly, the best way to save binary data in WebSQL/localStorage is serializing
// it to Base64, so this is how we store it to prevent very strange errors with less
// verbose ways of binary <-> string data storage.
var BASE_CHARS = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/';

var BLOB_TYPE_PREFIX = '~~local_forage_type~';
var BLOB_TYPE_PREFIX_REGEX = /^~~local_forage_type~([^~]+)~/;

var SERIALIZED_MARKER = '__lfsc__:';
var SERIALIZED_MARKER_LENGTH = SERIALIZED_MARKER.length;

// OMG the serializations!
var TYPE_ARRAYBUFFER = 'arbf';
var TYPE_BLOB = 'blob';
var TYPE_INT8ARRAY = 'si08';
var TYPE_UINT8ARRAY = 'ui08';
var TYPE_UINT8CLAMPEDARRAY = 'uic8';
var TYPE_INT16ARRAY = 'si16';
var TYPE_INT32ARRAY = 'si32';
var TYPE_UINT16ARRAY = 'ur16';
var TYPE_UINT32ARRAY = 'ui32';
var TYPE_FLOAT32ARRAY = 'fl32';
var TYPE_FLOAT64ARRAY = 'fl64';
var TYPE_SERIALIZED_MARKER_LENGTH = SERIALIZED_MARKER_LENGTH + TYPE_ARRAYBUFFER.length;

var toString$1 = Object.prototype.toString;

function stringToBuffer(serializedString) {
    // Fill the string into a ArrayBuffer.
    var bufferLength = serializedString.length * 0.75;
    var len = serializedString.length;
    var i;
    var p = 0;
    var encoded1, encoded2, encoded3, encoded4;

    if (serializedString[serializedString.length - 1] === '=') {
        bufferLength--;
        if (serializedString[serializedString.length - 2] === '=') {
            bufferLength--;
        }
    }

    var buffer = new ArrayBuffer(bufferLength);
    var bytes = new Uint8Array(buffer);

    for (i = 0; i < len; i += 4) {
        encoded1 = BASE_CHARS.indexOf(serializedString[i]);
        encoded2 = BASE_CHARS.indexOf(serializedString[i + 1]);
        encoded3 = BASE_CHARS.indexOf(serializedString[i + 2]);
        encoded4 = BASE_CHARS.indexOf(serializedString[i + 3]);

        /*jslint bitwise: true */
        bytes[p++] = encoded1 << 2 | encoded2 >> 4;
        bytes[p++] = (encoded2 & 15) << 4 | encoded3 >> 2;
        bytes[p++] = (encoded3 & 3) << 6 | encoded4 & 63;
    }
    return buffer;
}

// Converts a buffer to a string to store, serialized, in the backend
// storage library.
function bufferToString(buffer) {
    // base64-arraybuffer
    var bytes = new Uint8Array(buffer);
    var base64String = '';
    var i;

    for (i = 0; i < bytes.length; i += 3) {
        /*jslint bitwise: true */
        base64String += BASE_CHARS[bytes[i] >> 2];
        base64String += BASE_CHARS[(bytes[i] & 3) << 4 | bytes[i + 1] >> 4];
        base64String += BASE_CHARS[(bytes[i + 1] & 15) << 2 | bytes[i + 2] >> 6];
        base64String += BASE_CHARS[bytes[i + 2] & 63];
    }

    if (bytes.length % 3 === 2) {
        base64String = base64String.substring(0, base64String.length - 1) + '=';
    } else if (bytes.length % 3 === 1) {
        base64String = base64String.substring(0, base64String.length - 2) + '==';
    }

    return base64String;
}

// Serialize a value, afterwards executing a callback (which usually
// instructs the `setItem()` callback/promise to be executed). This is how
// we store binary data with localStorage.
function serialize(value, callback) {
    var valueType = '';
    if (value) {
        valueType = toString$1.call(value);
    }

    // Cannot use `value instanceof ArrayBuffer` or such here, as these
    // checks fail when running the tests using casper.js...
    //
    // TODO: See why those tests fail and use a better solution.
    if (value && (valueType === '[object ArrayBuffer]' || value.buffer && toString$1.call(value.buffer) === '[object ArrayBuffer]')) {
        // Convert binary arrays to a string and prefix the string with
        // a special marker.
        var buffer;
        var marker = SERIALIZED_MARKER;

        if (value instanceof ArrayBuffer) {
            buffer = value;
            marker += TYPE_ARRAYBUFFER;
        } else {
            buffer = value.buffer;

            if (valueType === '[object Int8Array]') {
                marker += TYPE_INT8ARRAY;
            } else if (valueType === '[object Uint8Array]') {
                marker += TYPE_UINT8ARRAY;
            } else if (valueType === '[object Uint8ClampedArray]') {
                marker += TYPE_UINT8CLAMPEDARRAY;
            } else if (valueType === '[object Int16Array]') {
                marker += TYPE_INT16ARRAY;
            } else if (valueType === '[object Uint16Array]') {
                marker += TYPE_UINT16ARRAY;
            } else if (valueType === '[object Int32Array]') {
                marker += TYPE_INT32ARRAY;
            } else if (valueType === '[object Uint32Array]') {
                marker += TYPE_UINT32ARRAY;
            } else if (valueType === '[object Float32Array]') {
                marker += TYPE_FLOAT32ARRAY;
            } else if (valueType === '[object Float64Array]') {
                marker += TYPE_FLOAT64ARRAY;
            } else {
                callback(new Error('Failed to get type for BinaryArray'));
            }
        }

        callback(marker + bufferToString(buffer));
    } else if (valueType === '[object Blob]') {
        // Conver the blob to a binaryArray and then to a string.
        var fileReader = new FileReader();

        fileReader.onload = function () {
            // Backwards-compatible prefix for the blob type.
            var str = BLOB_TYPE_PREFIX + value.type + '~' + bufferToString(this.result);

            callback(SERIALIZED_MARKER + TYPE_BLOB + str);
        };

        fileReader.readAsArrayBuffer(value);
    } else {
        try {
            callback(JSON.stringify(value));
        } catch (e) {
            console.error("Couldn't convert value into a JSON string: ", value);

            callback(null, e);
        }
    }
}

// Deserialize data we've inserted into a value column/field. We place
// special markers into our strings to mark them as encoded; this isn't
// as nice as a meta field, but it's the only sane thing we can do whilst
// keeping localStorage support intact.
//
// Oftentimes this will just deserialize JSON content, but if we have a
// special marker (SERIALIZED_MARKER, defined above), we will extract
// some kind of arraybuffer/binary data/typed array out of the string.
function deserialize(value) {
    // If we haven't marked this string as being specially serialized (i.e.
    // something other than serialized JSON), we can just return it and be
    // done with it.
    if (value.substring(0, SERIALIZED_MARKER_LENGTH) !== SERIALIZED_MARKER) {
        return JSON.parse(value);
    }

    // The following code deals with deserializing some kind of Blob or
    // TypedArray. First we separate out the type of data we're dealing
    // with from the data itself.
    var serializedString = value.substring(TYPE_SERIALIZED_MARKER_LENGTH);
    var type = value.substring(SERIALIZED_MARKER_LENGTH, TYPE_SERIALIZED_MARKER_LENGTH);

    var blobType;
    // Backwards-compatible blob type serialization strategy.
    // DBs created with older versions of localForage will simply not have the blob type.
    if (type === TYPE_BLOB && BLOB_TYPE_PREFIX_REGEX.test(serializedString)) {
        var matcher = serializedString.match(BLOB_TYPE_PREFIX_REGEX);
        blobType = matcher[1];
        serializedString = serializedString.substring(matcher[0].length);
    }
    var buffer = stringToBuffer(serializedString);

    // Return the right type based on the code/type set during
    // serialization.
    switch (type) {
        case TYPE_ARRAYBUFFER:
            return buffer;
        case TYPE_BLOB:
            return createBlob([buffer], { type: blobType });
        case TYPE_INT8ARRAY:
            return new Int8Array(buffer);
        case TYPE_UINT8ARRAY:
            return new Uint8Array(buffer);
        case TYPE_UINT8CLAMPEDARRAY:
            return new Uint8ClampedArray(buffer);
        case TYPE_INT16ARRAY:
            return new Int16Array(buffer);
        case TYPE_UINT16ARRAY:
            return new Uint16Array(buffer);
        case TYPE_INT32ARRAY:
            return new Int32Array(buffer);
        case TYPE_UINT32ARRAY:
            return new Uint32Array(buffer);
        case TYPE_FLOAT32ARRAY:
            return new Float32Array(buffer);
        case TYPE_FLOAT64ARRAY:
            return new Float64Array(buffer);
        default:
            throw new Error('Unkown type: ' + type);
    }
}

var localforageSerializer = {
    serialize: serialize,
    deserialize: deserialize,
    stringToBuffer: stringToBuffer,
    bufferToString: bufferToString
};

/*
 * Includes code from:
 *
 * base64-arraybuffer
 * https://github.com/niklasvh/base64-arraybuffer
 *
 * Copyright (c) 2012 Niklas von Hertzen
 * Licensed under the MIT license.
 */

function createDbTable(t, dbInfo, callback, errorCallback) {
    t.executeSql('CREATE TABLE IF NOT EXISTS ' + dbInfo.storeName + ' ' + '(id INTEGER PRIMARY KEY, key unique, value)', [], callback, errorCallback);
}

// Open the WebSQL database (automatically creates one if one didn't
// previously exist), using any options set in the config.
function _initStorage$1(options) {
    var self = this;
    var dbInfo = {
        db: null
    };

    if (options) {
        for (var i in options) {
            dbInfo[i] = typeof options[i] !== 'string' ? options[i].toString() : options[i];
        }
    }

    var dbInfoPromise = new Promise$1(function (resolve, reject) {
        // Open the database; the openDatabase API will automatically
        // create it for us if it doesn't exist.
        try {
            dbInfo.db = openDatabase(dbInfo.name, String(dbInfo.version), dbInfo.description, dbInfo.size);
        } catch (e) {
            return reject(e);
        }

        // Create our key/value table if it doesn't exist.
        dbInfo.db.transaction(function (t) {
            createDbTable(t, dbInfo, function () {
                self._dbInfo = dbInfo;
                resolve();
            }, function (t, error) {
                reject(error);
            });
        }, reject);
    });

    dbInfo.serializer = localforageSerializer;
    return dbInfoPromise;
}

function tryExecuteSql(t, dbInfo, sqlStatement, args, callback, errorCallback) {
    t.executeSql(sqlStatement, args, callback, function (t, error) {
        if (error.code === error.SYNTAX_ERR) {
            t.executeSql('SELECT name FROM sqlite_master ' + "WHERE type='table' AND name = ?", [dbInfo.storeName], function (t, results) {
                if (!results.rows.length) {
                    // if the table is missing (was deleted)
                    // re-create it table and retry
                    createDbTable(t, dbInfo, function () {
                        t.executeSql(sqlStatement, args, callback, errorCallback);
                    }, errorCallback);
                } else {
                    errorCallback(t, error);
                }
            }, errorCallback);
        } else {
            errorCallback(t, error);
        }
    }, errorCallback);
}

function getItem$1(key, callback) {
    var self = this;

    key = normalizeKey(key);

    var promise = new Promise$1(function (resolve, reject) {
        self.ready().then(function () {
            var dbInfo = self._dbInfo;
            dbInfo.db.transaction(function (t) {
                tryExecuteSql(t, dbInfo, 'SELECT * FROM ' + dbInfo.storeName + ' WHERE key = ? LIMIT 1', [key], function (t, results) {
                    var result = results.rows.length ? results.rows.item(0).value : null;

                    // Check to see if this is serialized content we need to
                    // unpack.
                    if (result) {
                        result = dbInfo.serializer.deserialize(result);
                    }

                    resolve(result);
                }, function (t, error) {
                    reject(error);
                });
            });
        })["catch"](reject);
    });

    executeCallback(promise, callback);
    return promise;
}

function iterate$1(iterator, callback) {
    var self = this;

    var promise = new Promise$1(function (resolve, reject) {
        self.ready().then(function () {
            var dbInfo = self._dbInfo;

            dbInfo.db.transaction(function (t) {
                tryExecuteSql(t, dbInfo, 'SELECT * FROM ' + dbInfo.storeName, [], function (t, results) {
                    var rows = results.rows;
                    var length = rows.length;

                    for (var i = 0; i < length; i++) {
                        var item = rows.item(i);
                        var result = item.value;

                        // Check to see if this is serialized content
                        // we need to unpack.
                        if (result) {
                            result = dbInfo.serializer.deserialize(result);
                        }

                        result = iterator(result, item.key, i + 1);

                        // void(0) prevents problems with redefinition
                        // of `undefined`.
                        if (result !== void 0) {
                            resolve(result);
                            return;
                        }
                    }

                    resolve();
                }, function (t, error) {
                    reject(error);
                });
            });
        })["catch"](reject);
    });

    executeCallback(promise, callback);
    return promise;
}

function _setItem(key, value, callback, retriesLeft) {
    var self = this;

    key = normalizeKey(key);

    var promise = new Promise$1(function (resolve, reject) {
        self.ready().then(function () {
            // The localStorage API doesn't return undefined values in an
            // "expected" way, so undefined is always cast to null in all
            // drivers. See: https://github.com/mozilla/localForage/pull/42
            if (value === undefined) {
                value = null;
            }

            // Save the original value to pass to the callback.
            var originalValue = value;

            var dbInfo = self._dbInfo;
            dbInfo.serializer.serialize(value, function (value, error) {
                if (error) {
                    reject(error);
                } else {
                    dbInfo.db.transaction(function (t) {
                        tryExecuteSql(t, dbInfo, 'INSERT OR REPLACE INTO ' + dbInfo.storeName + ' ' + '(key, value) VALUES (?, ?)', [key, value], function () {
                            resolve(originalValue);
                        }, function (t, error) {
                            reject(error);
                        });
                    }, function (sqlError) {
                        // The transaction failed; check
                        // to see if it's a quota error.
                        if (sqlError.code === sqlError.QUOTA_ERR) {
                            // We reject the callback outright for now, but
                            // it's worth trying to re-run the transaction.
                            // Even if the user accepts the prompt to use
                            // more storage on Safari, this error will
                            // be called.
                            //
                            // Try to re-run the transaction.
                            if (retriesLeft > 0) {
                                resolve(_setItem.apply(self, [key, originalValue, callback, retriesLeft - 1]));
                                return;
                            }
                            reject(sqlError);
                        }
                    });
                }
            });
        })["catch"](reject);
    });

    executeCallback(promise, callback);
    return promise;
}

function setItem$1(key, value, callback) {
    return _setItem.apply(this, [key, value, callback, 1]);
}

function removeItem$1(key, callback) {
    var self = this;

    key = normalizeKey(key);

    var promise = new Promise$1(function (resolve, reject) {
        self.ready().then(function () {
            var dbInfo = self._dbInfo;
            dbInfo.db.transaction(function (t) {
                tryExecuteSql(t, dbInfo, 'DELETE FROM ' + dbInfo.storeName + ' WHERE key = ?', [key], function () {
                    resolve();
                }, function (t, error) {
                    reject(error);
                });
            });
        })["catch"](reject);
    });

    executeCallback(promise, callback);
    return promise;
}

// Deletes every item in the table.
// TODO: Find out if this resets the AUTO_INCREMENT number.
function clear$1(callback) {
    var self = this;

    var promise = new Promise$1(function (resolve, reject) {
        self.ready().then(function () {
            var dbInfo = self._dbInfo;
            dbInfo.db.transaction(function (t) {
                tryExecuteSql(t, dbInfo, 'DELETE FROM ' + dbInfo.storeName, [], function () {
                    resolve();
                }, function (t, error) {
                    reject(error);
                });
            });
        })["catch"](reject);
    });

    executeCallback(promise, callback);
    return promise;
}

// Does a simple `COUNT(key)` to get the number of items stored in
// localForage.
function length$1(callback) {
    var self = this;

    var promise = new Promise$1(function (resolve, reject) {
        self.ready().then(function () {
            var dbInfo = self._dbInfo;
            dbInfo.db.transaction(function (t) {
                // Ahhh, SQL makes this one soooooo easy.
                tryExecuteSql(t, dbInfo, 'SELECT COUNT(key) as c FROM ' + dbInfo.storeName, [], function (t, results) {
                    var result = results.rows.item(0).c;
                    resolve(result);
                }, function (t, error) {
                    reject(error);
                });
            });
        })["catch"](reject);
    });

    executeCallback(promise, callback);
    return promise;
}

// Return the key located at key index X; essentially gets the key from a
// `WHERE id = ?`. This is the most efficient way I can think to implement
// this rarely-used (in my experience) part of the API, but it can seem
// inconsistent, because we do `INSERT OR REPLACE INTO` on `setItem()`, so
// the ID of each key will change every time it's updated. Perhaps a stored
// procedure for the `setItem()` SQL would solve this problem?
// TODO: Don't change ID on `setItem()`.
function key$1(n, callback) {
    var self = this;

    var promise = new Promise$1(function (resolve, reject) {
        self.ready().then(function () {
            var dbInfo = self._dbInfo;
            dbInfo.db.transaction(function (t) {
                tryExecuteSql(t, dbInfo, 'SELECT key FROM ' + dbInfo.storeName + ' WHERE id = ? LIMIT 1', [n + 1], function (t, results) {
                    var result = results.rows.length ? results.rows.item(0).key : null;
                    resolve(result);
                }, function (t, error) {
                    reject(error);
                });
            });
        })["catch"](reject);
    });

    executeCallback(promise, callback);
    return promise;
}

function keys$1(callback) {
    var self = this;

    var promise = new Promise$1(function (resolve, reject) {
        self.ready().then(function () {
            var dbInfo = self._dbInfo;
            dbInfo.db.transaction(function (t) {
                tryExecuteSql(t, dbInfo, 'SELECT key FROM ' + dbInfo.storeName, [], function (t, results) {
                    var keys = [];

                    for (var i = 0; i < results.rows.length; i++) {
                        keys.push(results.rows.item(i).key);
                    }

                    resolve(keys);
                }, function (t, error) {
                    reject(error);
                });
            });
        })["catch"](reject);
    });

    executeCallback(promise, callback);
    return promise;
}

// https://www.w3.org/TR/webdatabase/#databases
// > There is no way to enumerate or delete the databases available for an origin from this API.
function getAllStoreNames(db) {
    return new Promise$1(function (resolve, reject) {
        db.transaction(function (t) {
            t.executeSql('SELECT name FROM sqlite_master ' + "WHERE type='table' AND name <> '__WebKitDatabaseInfoTable__'", [], function (t, results) {
                var storeNames = [];

                for (var i = 0; i < results.rows.length; i++) {
                    storeNames.push(results.rows.item(i).name);
                }

                resolve({
                    db: db,
                    storeNames: storeNames
                });
            }, function (t, error) {
                reject(error);
            });
        }, function (sqlError) {
            reject(sqlError);
        });
    });
}

function dropInstance$1(options, callback) {
    callback = getCallback.apply(this, arguments);

    var currentConfig = this.config();
    options = typeof options !== 'function' && options || {};
    if (!options.name) {
        options.name = options.name || currentConfig.name;
        options.storeName = options.storeName || currentConfig.storeName;
    }

    var self = this;
    var promise;
    if (!options.name) {
        promise = Promise$1.reject('Invalid arguments');
    } else {
        promise = new Promise$1(function (resolve) {
            var db;
            if (options.name === currentConfig.name) {
                // use the db reference of the current instance
                db = self._dbInfo.db;
            } else {
                db = openDatabase(options.name, '', '', 0);
            }

            if (!options.storeName) {
                // drop all database tables
                resolve(getAllStoreNames(db));
            } else {
                resolve({
                    db: db,
                    storeNames: [options.storeName]
                });
            }
        }).then(function (operationInfo) {
            return new Promise$1(function (resolve, reject) {
                operationInfo.db.transaction(function (t) {
                    function dropTable(storeName) {
                        return new Promise$1(function (resolve, reject) {
                            t.executeSql('DROP TABLE IF EXISTS ' + storeName, [], function () {
                                resolve();
                            }, function (t, error) {
                                reject(error);
                            });
                        });
                    }

                    var operations = [];
                    for (var i = 0, len = operationInfo.storeNames.length; i < len; i++) {
                        operations.push(dropTable(operationInfo.storeNames[i]));
                    }

                    Promise$1.all(operations).then(function () {
                        resolve();
                    })["catch"](function (e) {
                        reject(e);
                    });
                }, function (sqlError) {
                    reject(sqlError);
                });
            });
        });
    }

    executeCallback(promise, callback);
    return promise;
}

var webSQLStorage = {
    _driver: 'webSQLStorage',
    _initStorage: _initStorage$1,
    _support: isWebSQLValid(),
    iterate: iterate$1,
    getItem: getItem$1,
    setItem: setItem$1,
    removeItem: removeItem$1,
    clear: clear$1,
    length: length$1,
    key: key$1,
    keys: keys$1,
    dropInstance: dropInstance$1
};

function isLocalStorageValid() {
    try {
        return typeof localStorage !== 'undefined' && 'setItem' in localStorage &&
        // in IE8 typeof localStorage.setItem === 'object'
        !!localStorage.setItem;
    } catch (e) {
        return false;
    }
}

function _getKeyPrefix(options, defaultConfig) {
    var keyPrefix = options.name + '/';

    if (options.storeName !== defaultConfig.storeName) {
        keyPrefix += options.storeName + '/';
    }
    return keyPrefix;
}

// Check if localStorage throws when saving an item
function checkIfLocalStorageThrows() {
    var localStorageTestKey = '_localforage_support_test';

    try {
        localStorage.setItem(localStorageTestKey, true);
        localStorage.removeItem(localStorageTestKey);

        return false;
    } catch (e) {
        return true;
    }
}

// Check if localStorage is usable and allows to save an item
// This method checks if localStorage is usable in Safari Private Browsing
// mode, or in any other case where the available quota for localStorage
// is 0 and there wasn't any saved items yet.
function _isLocalStorageUsable() {
    return !checkIfLocalStorageThrows() || localStorage.length > 0;
}

// Config the localStorage backend, using options set in the config.
function _initStorage$2(options) {
    var self = this;
    var dbInfo = {};
    if (options) {
        for (var i in options) {
            dbInfo[i] = options[i];
        }
    }

    dbInfo.keyPrefix = _getKeyPrefix(options, self._defaultConfig);

    if (!_isLocalStorageUsable()) {
        return Promise$1.reject();
    }

    self._dbInfo = dbInfo;
    dbInfo.serializer = localforageSerializer;

    return Promise$1.resolve();
}

// Remove all keys from the datastore, effectively destroying all data in
// the app's key/value store!
function clear$2(callback) {
    var self = this;
    var promise = self.ready().then(function () {
        var keyPrefix = self._dbInfo.keyPrefix;

        for (var i = localStorage.length - 1; i >= 0; i--) {
            var key = localStorage.key(i);

            if (key.indexOf(keyPrefix) === 0) {
                localStorage.removeItem(key);
            }
        }
    });

    executeCallback(promise, callback);
    return promise;
}

// Retrieve an item from the store. Unlike the original async_storage
// library in Gaia, we don't modify return values at all. If a key's value
// is `undefined`, we pass that value to the callback function.
function getItem$2(key, callback) {
    var self = this;

    key = normalizeKey(key);

    var promise = self.ready().then(function () {
        var dbInfo = self._dbInfo;
        var result = localStorage.getItem(dbInfo.keyPrefix + key);

        // If a result was found, parse it from the serialized
        // string into a JS object. If result isn't truthy, the key
        // is likely undefined and we'll pass it straight to the
        // callback.
        if (result) {
            result = dbInfo.serializer.deserialize(result);
        }

        return result;
    });

    executeCallback(promise, callback);
    return promise;
}

// Iterate over all items in the store.
function iterate$2(iterator, callback) {
    var self = this;

    var promise = self.ready().then(function () {
        var dbInfo = self._dbInfo;
        var keyPrefix = dbInfo.keyPrefix;
        var keyPrefixLength = keyPrefix.length;
        var length = localStorage.length;

        // We use a dedicated iterator instead of the `i` variable below
        // so other keys we fetch in localStorage aren't counted in
        // the `iterationNumber` argument passed to the `iterate()`
        // callback.
        //
        // See: github.com/mozilla/localForage/pull/435#discussion_r38061530
        var iterationNumber = 1;

        for (var i = 0; i < length; i++) {
            var key = localStorage.key(i);
            if (key.indexOf(keyPrefix) !== 0) {
                continue;
            }
            var value = localStorage.getItem(key);

            // If a result was found, parse it from the serialized
            // string into a JS object. If result isn't truthy, the
            // key is likely undefined and we'll pass it straight
            // to the iterator.
            if (value) {
                value = dbInfo.serializer.deserialize(value);
            }

            value = iterator(value, key.substring(keyPrefixLength), iterationNumber++);

            if (value !== void 0) {
                return value;
            }
        }
    });

    executeCallback(promise, callback);
    return promise;
}

// Same as localStorage's key() method, except takes a callback.
function key$2(n, callback) {
    var self = this;
    var promise = self.ready().then(function () {
        var dbInfo = self._dbInfo;
        var result;
        try {
            result = localStorage.key(n);
        } catch (error) {
            result = null;
        }

        // Remove the prefix from the key, if a key is found.
        if (result) {
            result = result.substring(dbInfo.keyPrefix.length);
        }

        return result;
    });

    executeCallback(promise, callback);
    return promise;
}

function keys$2(callback) {
    var self = this;
    var promise = self.ready().then(function () {
        var dbInfo = self._dbInfo;
        var length = localStorage.length;
        var keys = [];

        for (var i = 0; i < length; i++) {
            var itemKey = localStorage.key(i);
            if (itemKey.indexOf(dbInfo.keyPrefix) === 0) {
                keys.push(itemKey.substring(dbInfo.keyPrefix.length));
            }
        }

        return keys;
    });

    executeCallback(promise, callback);
    return promise;
}

// Supply the number of keys in the datastore to the callback function.
function length$2(callback) {
    var self = this;
    var promise = self.keys().then(function (keys) {
        return keys.length;
    });

    executeCallback(promise, callback);
    return promise;
}

// Remove an item from the store, nice and simple.
function removeItem$2(key, callback) {
    var self = this;

    key = normalizeKey(key);

    var promise = self.ready().then(function () {
        var dbInfo = self._dbInfo;
        localStorage.removeItem(dbInfo.keyPrefix + key);
    });

    executeCallback(promise, callback);
    return promise;
}

// Set a key's value and run an optional callback once the value is set.
// Unlike Gaia's implementation, the callback function is passed the value,
// in case you want to operate on that value only after you're sure it
// saved, or something like that.
function setItem$2(key, value, callback) {
    var self = this;

    key = normalizeKey(key);

    var promise = self.ready().then(function () {
        // Convert undefined values to null.
        // https://github.com/mozilla/localForage/pull/42
        if (value === undefined) {
            value = null;
        }

        // Save the original value to pass to the callback.
        var originalValue = value;

        return new Promise$1(function (resolve, reject) {
            var dbInfo = self._dbInfo;
            dbInfo.serializer.serialize(value, function (value, error) {
                if (error) {
                    reject(error);
                } else {
                    try {
                        localStorage.setItem(dbInfo.keyPrefix + key, value);
                        resolve(originalValue);
                    } catch (e) {
                        // localStorage capacity exceeded.
                        // TODO: Make this a specific error/event.
                        if (e.name === 'QuotaExceededError' || e.name === 'NS_ERROR_DOM_QUOTA_REACHED') {
                            reject(e);
                        }
                        reject(e);
                    }
                }
            });
        });
    });

    executeCallback(promise, callback);
    return promise;
}

function dropInstance$2(options, callback) {
    callback = getCallback.apply(this, arguments);

    options = typeof options !== 'function' && options || {};
    if (!options.name) {
        var currentConfig = this.config();
        options.name = options.name || currentConfig.name;
        options.storeName = options.storeName || currentConfig.storeName;
    }

    var self = this;
    var promise;
    if (!options.name) {
        promise = Promise$1.reject('Invalid arguments');
    } else {
        promise = new Promise$1(function (resolve) {
            if (!options.storeName) {
                resolve(options.name + '/');
            } else {
                resolve(_getKeyPrefix(options, self._defaultConfig));
            }
        }).then(function (keyPrefix) {
            for (var i = localStorage.length - 1; i >= 0; i--) {
                var key = localStorage.key(i);

                if (key.indexOf(keyPrefix) === 0) {
                    localStorage.removeItem(key);
                }
            }
        });
    }

    executeCallback(promise, callback);
    return promise;
}

var localStorageWrapper = {
    _driver: 'localStorageWrapper',
    _initStorage: _initStorage$2,
    _support: isLocalStorageValid(),
    iterate: iterate$2,
    getItem: getItem$2,
    setItem: setItem$2,
    removeItem: removeItem$2,
    clear: clear$2,
    length: length$2,
    key: key$2,
    keys: keys$2,
    dropInstance: dropInstance$2
};

var sameValue = function sameValue(x, y) {
    return x === y || typeof x === 'number' && typeof y === 'number' && isNaN(x) && isNaN(y);
};

var includes = function includes(array, searchElement) {
    var len = array.length;
    var i = 0;
    while (i < len) {
        if (sameValue(array[i], searchElement)) {
            return true;
        }
        i++;
    }

    return false;
};

var isArray = Array.isArray || function (arg) {
    return Object.prototype.toString.call(arg) === '[object Array]';
};

// Drivers are stored here when `defineDriver()` is called.
// They are shared across all instances of localForage.
var DefinedDrivers = {};

var DriverSupport = {};

var DefaultDrivers = {
    INDEXEDDB: asyncStorage,
    WEBSQL: webSQLStorage,
    LOCALSTORAGE: localStorageWrapper
};

var DefaultDriverOrder = [DefaultDrivers.INDEXEDDB._driver, DefaultDrivers.WEBSQL._driver, DefaultDrivers.LOCALSTORAGE._driver];

var OptionalDriverMethods = ['dropInstance'];

var LibraryMethods = ['clear', 'getItem', 'iterate', 'key', 'keys', 'length', 'removeItem', 'setItem'].concat(OptionalDriverMethods);

var DefaultConfig = {
    description: '',
    driver: DefaultDriverOrder.slice(),
    name: 'localforage',
    // Default DB size is _JUST UNDER_ 5MB, as it's the highest size
    // we can use without a prompt.
    size: 4980736,
    storeName: 'keyvaluepairs',
    version: 1.0
};

function callWhenReady(localForageInstance, libraryMethod) {
    localForageInstance[libraryMethod] = function () {
        var _args = arguments;
        return localForageInstance.ready().then(function () {
            return localForageInstance[libraryMethod].apply(localForageInstance, _args);
        });
    };
}

function extend() {
    for (var i = 1; i < arguments.length; i++) {
        var arg = arguments[i];

        if (arg) {
            for (var _key in arg) {
                if (arg.hasOwnProperty(_key)) {
                    if (isArray(arg[_key])) {
                        arguments[0][_key] = arg[_key].slice();
                    } else {
                        arguments[0][_key] = arg[_key];
                    }
                }
            }
        }
    }

    return arguments[0];
}

var LocalForage = function () {
    function LocalForage(options) {
        _classCallCheck(this, LocalForage);

        for (var driverTypeKey in DefaultDrivers) {
            if (DefaultDrivers.hasOwnProperty(driverTypeKey)) {
                var driver = DefaultDrivers[driverTypeKey];
                var driverName = driver._driver;
                this[driverTypeKey] = driverName;

                if (!DefinedDrivers[driverName]) {
                    // we don't need to wait for the promise,
                    // since the default drivers can be defined
                    // in a blocking manner
                    this.defineDriver(driver);
                }
            }
        }

        this._defaultConfig = extend({}, DefaultConfig);
        this._config = extend({}, this._defaultConfig, options);
        this._driverSet = null;
        this._initDriver = null;
        this._ready = false;
        this._dbInfo = null;

        this._wrapLibraryMethodsWithReady();
        this.setDriver(this._config.driver)["catch"](function () {});
    }

    // Set any config values for localForage; can be called anytime before
    // the first API call (e.g. `getItem`, `setItem`).
    // We loop through options so we don't overwrite existing config
    // values.


    LocalForage.prototype.config = function config(options) {
        // If the options argument is an object, we use it to set values.
        // Otherwise, we return either a specified config value or all
        // config values.
        if ((typeof options === 'undefined' ? 'undefined' : _typeof(options)) === 'object') {
            // If localforage is ready and fully initialized, we can't set
            // any new configuration values. Instead, we return an error.
            if (this._ready) {
                return new Error("Can't call config() after localforage " + 'has been used.');
            }

            for (var i in options) {
                if (i === 'storeName') {
                    options[i] = options[i].replace(/\W/g, '_');
                }

                if (i === 'version' && typeof options[i] !== 'number') {
                    return new Error('Database version must be a number.');
                }

                this._config[i] = options[i];
            }

            // after all config options are set and
            // the driver option is used, try setting it
            if ('driver' in options && options.driver) {
                return this.setDriver(this._config.driver);
            }

            return true;
        } else if (typeof options === 'string') {
            return this._config[options];
        } else {
            return this._config;
        }
    };

    // Used to define a custom driver, shared across all instances of
    // localForage.


    LocalForage.prototype.defineDriver = function defineDriver(driverObject, callback, errorCallback) {
        var promise = new Promise$1(function (resolve, reject) {
            try {
                var driverName = driverObject._driver;
                var complianceError = new Error('Custom driver not compliant; see ' + 'https://mozilla.github.io/localForage/#definedriver');

                // A driver name should be defined and not overlap with the
                // library-defined, default drivers.
                if (!driverObject._driver) {
                    reject(complianceError);
                    return;
                }

                var driverMethods = LibraryMethods.concat('_initStorage');
                for (var i = 0, len = driverMethods.length; i < len; i++) {
                    var driverMethodName = driverMethods[i];

                    // when the property is there,
                    // it should be a method even when optional
                    var isRequired = !includes(OptionalDriverMethods, driverMethodName);
                    if ((isRequired || driverObject[driverMethodName]) && typeof driverObject[driverMethodName] !== 'function') {
                        reject(complianceError);
                        return;
                    }
                }

                var configureMissingMethods = function configureMissingMethods() {
                    var methodNotImplementedFactory = function methodNotImplementedFactory(methodName) {
                        return function () {
                            var error = new Error('Method ' + methodName + ' is not implemented by the current driver');
                            var promise = Promise$1.reject(error);
                            executeCallback(promise, arguments[arguments.length - 1]);
                            return promise;
                        };
                    };

                    for (var _i = 0, _len = OptionalDriverMethods.length; _i < _len; _i++) {
                        var optionalDriverMethod = OptionalDriverMethods[_i];
                        if (!driverObject[optionalDriverMethod]) {
                            driverObject[optionalDriverMethod] = methodNotImplementedFactory(optionalDriverMethod);
                        }
                    }
                };

                configureMissingMethods();

                var setDriverSupport = function setDriverSupport(support) {
                    if (DefinedDrivers[driverName]) {
                        console.info('Redefining LocalForage driver: ' + driverName);
                    }
                    DefinedDrivers[driverName] = driverObject;
                    DriverSupport[driverName] = support;
                    // don't use a then, so that we can define
                    // drivers that have simple _support methods
                    // in a blocking manner
                    resolve();
                };

                if ('_support' in driverObject) {
                    if (driverObject._support && typeof driverObject._support === 'function') {
                        driverObject._support().then(setDriverSupport, reject);
                    } else {
                        setDriverSupport(!!driverObject._support);
                    }
                } else {
                    setDriverSupport(true);
                }
            } catch (e) {
                reject(e);
            }
        });

        executeTwoCallbacks(promise, callback, errorCallback);
        return promise;
    };

    LocalForage.prototype.driver = function driver() {
        return this._driver || null;
    };

    LocalForage.prototype.getDriver = function getDriver(driverName, callback, errorCallback) {
        var getDriverPromise = DefinedDrivers[driverName] ? Promise$1.resolve(DefinedDrivers[driverName]) : Promise$1.reject(new Error('Driver not found.'));

        executeTwoCallbacks(getDriverPromise, callback, errorCallback);
        return getDriverPromise;
    };

    LocalForage.prototype.getSerializer = function getSerializer(callback) {
        var serializerPromise = Promise$1.resolve(localforageSerializer);
        executeTwoCallbacks(serializerPromise, callback);
        return serializerPromise;
    };

    LocalForage.prototype.ready = function ready(callback) {
        var self = this;

        var promise = self._driverSet.then(function () {
            if (self._ready === null) {
                self._ready = self._initDriver();
            }

            return self._ready;
        });

        executeTwoCallbacks(promise, callback, callback);
        return promise;
    };

    LocalForage.prototype.setDriver = function setDriver(drivers, callback, errorCallback) {
        var self = this;

        if (!isArray(drivers)) {
            drivers = [drivers];
        }

        var supportedDrivers = this._getSupportedDrivers(drivers);

        function setDriverToConfig() {
            self._config.driver = self.driver();
        }

        function extendSelfWithDriver(driver) {
            self._extend(driver);
            setDriverToConfig();

            self._ready = self._initStorage(self._config);
            return self._ready;
        }

        function initDriver(supportedDrivers) {
            return function () {
                var currentDriverIndex = 0;

                function driverPromiseLoop() {
                    while (currentDriverIndex < supportedDrivers.length) {
                        var driverName = supportedDrivers[currentDriverIndex];
                        currentDriverIndex++;

                        self._dbInfo = null;
                        self._ready = null;

                        return self.getDriver(driverName).then(extendSelfWithDriver)["catch"](driverPromiseLoop);
                    }

                    setDriverToConfig();
                    var error = new Error('No available storage method found.');
                    self._driverSet = Promise$1.reject(error);
                    return self._driverSet;
                }

                return driverPromiseLoop();
            };
        }

        // There might be a driver initialization in progress
        // so wait for it to finish in order to avoid a possible
        // race condition to set _dbInfo
        var oldDriverSetDone = this._driverSet !== null ? this._driverSet["catch"](function () {
            return Promise$1.resolve();
        }) : Promise$1.resolve();

        this._driverSet = oldDriverSetDone.then(function () {
            var driverName = supportedDrivers[0];
            self._dbInfo = null;
            self._ready = null;

            return self.getDriver(driverName).then(function (driver) {
                self._driver = driver._driver;
                setDriverToConfig();
                self._wrapLibraryMethodsWithReady();
                self._initDriver = initDriver(supportedDrivers);
            });
        })["catch"](function () {
            setDriverToConfig();
            var error = new Error('No available storage method found.');
            self._driverSet = Promise$1.reject(error);
            return self._driverSet;
        });

        executeTwoCallbacks(this._driverSet, callback, errorCallback);
        return this._driverSet;
    };

    LocalForage.prototype.supports = function supports(driverName) {
        return !!DriverSupport[driverName];
    };

    LocalForage.prototype._extend = function _extend(libraryMethodsAndProperties) {
        extend(this, libraryMethodsAndProperties);
    };

    LocalForage.prototype._getSupportedDrivers = function _getSupportedDrivers(drivers) {
        var supportedDrivers = [];
        for (var i = 0, len = drivers.length; i < len; i++) {
            var driverName = drivers[i];
            if (this.supports(driverName)) {
                supportedDrivers.push(driverName);
            }
        }
        return supportedDrivers;
    };

    LocalForage.prototype._wrapLibraryMethodsWithReady = function _wrapLibraryMethodsWithReady() {
        // Add a stub for each driver API method that delays the call to the
        // corresponding driver method until localForage is ready. These stubs
        // will be replaced by the driver methods as soon as the driver is
        // loaded, so there is no performance impact.
        for (var i = 0, len = LibraryMethods.length; i < len; i++) {
            callWhenReady(this, LibraryMethods[i]);
        }
    };

    LocalForage.prototype.createInstance = function createInstance(options) {
        return new LocalForage(options);
    };

    return LocalForage;
}();

// The actual localForage object that we expose as a module or via a
// global. It's extended by pulling in one of our other libraries.


var localforage_js = new LocalForage();

module.exports = localforage_js;

},{"3":3}]},{},[4])(4)
});
}(localforage$1));

var localforage = localforage$1.exports;

/** Simpler wrapper for a file-backed cache for arbitrary metadata. */
class LocalStorageCache {
    constructor(appId, version) {
        this.appId = appId;
        this.version = version;
        this.persister = localforage.createInstance({
            name: "dataview/cache/" + appId,
            driver: [localforage.INDEXEDDB],
            description: "Cache metadata about files and sections in the dataview index.",
        });
    }
    /** Drop the entire cache instance and re-create a new fresh instance. */
    async recreate() {
        await localforage.dropInstance({ name: "dataview/cache/" + this.appId });
        this.persister = localforage.createInstance({
            name: "dataview/cache/" + this.appId,
            driver: [localforage.INDEXEDDB],
            description: "Cache metadata about files and sections in the dataview index.",
        });
    }
    /** Load file metadata by path. */
    async loadFile(path) {
        return this.persister.getItem(this.fileKey(path)).then(raw => {
            let result = raw;
            if (result)
                result.data = Transferable.value(result.data);
            return result;
        });
    }
    /** Store file metadata by path. */
    async storeFile(path, data) {
        await this.persister.setItem(this.fileKey(path), {
            version: this.version,
            time: Date.now(),
            data: Transferable.transferable(data),
        });
    }
    /** Drop old file keys that no longer exist. */
    async synchronize(existing) {
        let keys = new Set(await this.allFiles());
        for (let exist of existing)
            keys.delete(exist);
        // Any keys remaining after deleting existing keys are non-existent keys that should be cleared from cache.
        for (let key of keys)
            await this.persister.removeItem(this.fileKey(key));
        return keys;
    }
    /** Obtain a list of all metadata keys. */
    async allKeys() {
        return this.persister.keys();
    }
    /** Obtain a list of all persisted files. */
    async allFiles() {
        let keys = await this.allKeys();
        return keys.filter(k => k.startsWith("file:")).map(k => k.substring(5));
    }
    fileKey(path) {
        return "file:" + path;
    }
}

function decodeBase64(base64, enableUnicode) {
    var binaryString = atob(base64);
    if (enableUnicode) {
        var binaryView = new Uint8Array(binaryString.length);
        for (var i = 0, n = binaryString.length; i < n; ++i) {
            binaryView[i] = binaryString.charCodeAt(i);
        }
        return String.fromCharCode.apply(null, new Uint16Array(binaryView.buffer));
    }
    return binaryString;
}

function createURL(base64, sourcemapArg, enableUnicodeArg) {
    var sourcemap = sourcemapArg === undefined ? null : sourcemapArg;
    var enableUnicode = enableUnicodeArg === undefined ? false : enableUnicodeArg;
    var source = decodeBase64(base64, enableUnicode);
    var start = source.indexOf('\n', 10) + 1;
    var body = source.substring(start) + (sourcemap ? '\/\/# sourceMappingURL=' + sourcemap : '');
    var blob = new Blob([body], { type: 'application/javascript' });
    return URL.createObjectURL(blob);
}

function createBase64WorkerFactory(base64, sourcemapArg, enableUnicodeArg) {
    var url;
    return function WorkerFactory(options) {
        url = url || createURL(base64, sourcemapArg, enableUnicodeArg);
        return new Worker(url, options);
    };
}

var WorkerFactory = createBase64WorkerFactory('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